/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizComboboxModel;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBoxMultiColumnItem;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeComboBoxUI;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialLeadTimeTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.project.biz.mrp.IPMRPPlannedOrderMappingFacade;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderMappingFacadeFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.client.AbstractPMRPPlannedOrderReleaseUI;
import com.kingdee.eas.industry.emm.project.biz.schedule.PlannedOrderScheduleEntryInfo;
import com.kingdee.eas.industry.update8.Material8FacadeFactory;
import com.kingdee.eas.mm.basedata.FactoryCalendarFactory;
import com.kingdee.eas.mm.basedata.ProductLineCollection;
import com.kingdee.eas.mm.basedata.ProductLineFactory;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.planning.PlannedOrderTypeEnum;
import com.kingdee.eas.mm.planning.TargetBillTypeEnum;
import com.kingdee.eas.mm.planning.client.PlannedOrderFilterUI;
import com.kingdee.eas.mm.planning.util.PLSUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.helper.FormattedEditorFactory;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComboBoxUI;

public class PMRPPlannedOrderReleaseUI
extends AbstractPMRPPlannedOrderReleaseUI {
    private static final long serialVersionUID = 5646345656564563464L;
    private String Resource_Name = "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource";
    private String QXZBOTPGZ_NAME = EASResource.getString((String)this.Resource_Name, (String)"QXZBOTPGZ_NAME");
    private String TFSB_NAME = EASResource.getString((String)this.Resource_Name, (String)"TFSB_NAME");
    private static final String PLANNING_RESOURCE = "com.kingdee.eas.mm.planning.client.PlanningResource";
    private static final String PLANNING_EXCEPTION = "com.kingdee.eas.mm.planning.PlanOrderException";
    private static final String REL_MATERIAL_NUM = "material.number";
    private static final String REL_MATERIAL_NAME = "material.name";
    private static final String REL_MATERIAL_ATTR = "materialPlan.materialAttr";
    private static final String REL_UNIT = "unit.name";
    private static final String REL_START_DATE = "startDate";
    private static final String REL_END_DATE = "endDate";
    private static final String REL_STORAGE_ORG_UNIT = "storageOrgUnit.name";
    private static final String REL_SUPPLY_STORAGE_ORG_UNIT = "productionOrgUnit.name";
    private static final String REL_IS_SELECT = "isSelect";
    private static final String REL_IS_CLOSE = "isClose";
    private static final String REL_TARGET_BILL_TYPE = "targetBillType";
    private static final String REL_RELEASE_QTY = "releaseQty";
    private static final String REL_BASE_RELEASE_QTY = "baseReleaseQty";
    private static final String REL_QTY = "qty";
    private static final String REL_BASE_QTY = "baseQty";
    private static final String REL_TOTAL_RELEASE_QTY = "totalReleaseQty";
    private static final String REL_BASE_TOTAL_RELEASE_QTY = "baseTotalReleaseQty";
    private boolean isReleased = false;
    private int selectRowCount = 0;
    private EventListener listeners;
    String[] lockColumnNames = new String[]{"material.number", "material.name", "materialPlan.materialAttr", "storageOrgUnit.name", "targetBillType", "number", "material.model", "baseStatus", "orderType", "releaseDate", "projectNumber", "trackNumber"};
    protected Action actionEnterTable = null;
    private Map materialPlanMap = null;
    private Map productLineMap = new HashMap();
    private Map isSelectMap = new HashMap();
    private KDBizPromptBox prmtProductLine = null;
    private KDTSortManager sm = null;

    public PMRPPlannedOrderReleaseUI() throws Exception {
        this.listeners = new EventListener();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void addListiners() {
        this.tblMain.addKDTEditListener((KDTEditListener)this.listeners);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    PMRPPlannedOrderReleaseUI.this.initData();
                    PMRPPlannedOrderReleaseUI.this.updateMaterialAttr();
                    PMRPPlannedOrderReleaseUI.this.setProductLine();
                }
                catch (BOSException e1) {
                    PMRPPlannedOrderReleaseUI.this.handUIException(e1);
                }
            }
        });
    }

    private void removeListiners() {
        this.tblMain.removeKDTEditListener((KDTEditListener)this.listeners);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            if (this.sm == null) {
                this.sm = new KDTSortManager(this.tblMain);
                this.sm.setEnableSortable(true);
                this.sm.setSortAuto(true);
                this.tblMain.setRefresh(true);
            }
            this.tblMain.getColumn(e.getColIndex()).setSortable(true);
            this.sm.sort(e.getColIndex());
            this.tblMain.repaint();
            return;
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblMain.getRowCount();
        boolean isSelect = true;
        int length = rowCount;
        for (int i = 0; i < length; ++i) {
            IRow curRow = this.tblMain.getRow(i);
            String baseStatus = curRow.getCell("baseStatus").getValue().toString();
            boolean status = baseStatus.equals(BillBaseStatusEnum.CLOSED.getAlias());
            if (status) continue;
            Boolean obj = isSelect;
            curRow.getCell(REL_IS_SELECT).setValue((Object)obj);
            this.isSelectMap.put(curRow.getCell("id").getValue(), Boolean.TRUE);
        }
        if (rowCount > 0) {
            this.btnRelease.setEnabled(true);
        }
        this.selectRowCount = this.getRowCount();
        if (rowCount < this.selectRowCount) {
            this.selectRowCount = rowCount;
        }
        if (this.selectRowCount == -1) {
            this.selectRowCount = rowCount;
        }
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblMain.getRowCount();
        boolean isSelect = false;
        int length = rowCount;
        for (int i = 0; i < length; ++i) {
            IRow curRow = this.tblMain.getRow(i);
            String baseStatus = curRow.getCell("baseStatus").getValue().toString();
            boolean status = baseStatus.equals(BillBaseStatusEnum.CLOSED.getAlias());
            if (status) continue;
            Boolean obj = isSelect;
            curRow.getCell(REL_IS_SELECT).setValue((Object)obj);
        }
        this.btnRelease.setEnabled(false);
        this.selectRowCount = 0;
        this.isSelectMap.clear();
    }

    @Override
    public void actionRelease_actionPerformed(ActionEvent e) throws Exception {
        if (this.comboBOTP.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.QXZBOTPGZ_NAME);
            SysUtil.abort();
        } else {
            this.released();
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PMRPPlannedOrderFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected void initData() throws BOSException {
        IRow curRow;
        int num = 0;
        String[] storageOrgUnitIds = new String[this.tblMain.getRowCount()];
        String[] supplyStorageOrgUnits = new String[this.tblMain.getRowCount()];
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            String storageOrgUnitID;
            TargetBillTypeEnum targetBillType;
            curRow = this.tblMain.getRow(i);
            int qtyPrecision = this.setQtyPrecision(curRow);
            BigDecimal releaseQty = this.setQtyRelease(curRow);
            curRow.getCell(REL_RELEASE_QTY).setValue((Object)releaseQty.setScale(qtyPrecision, 4));
            BigDecimal baseReleaseQty = this.setBaseQtyRelease(curRow);
            curRow.getCell(REL_BASE_RELEASE_QTY).setValue((Object)baseReleaseQty);
            boolean isSelect = false;
            Boolean select = isSelect;
            curRow.getCell(REL_IS_SELECT).setValue((Object)select);
            boolean isClose = false;
            Boolean close = isClose;
            curRow.getCell(REL_IS_CLOSE).setValue((Object)close);
            String orderType = curRow.getCell("orderType").getValue().toString();
            if (orderType.equals(PlannedOrderTypeEnum.FABRICATED.getAlias())) {
                targetBillType = TargetBillTypeEnum.REQUIREMENT_ORDER;
                curRow.getCell(REL_TARGET_BILL_TYPE).setValue((Object)targetBillType);
            } else if (orderType.equals(PlannedOrderTypeEnum.PURCHASE.getAlias())) {
                targetBillType = TargetBillTypeEnum.PURCHASE_REQUIREMENT;
                curRow.getCell(REL_TARGET_BILL_TYPE).setValue((Object)targetBillType);
            } else if (orderType.equals(PlannedOrderTypeEnum.STOCKTRANSFER.getAlias())) {
                String supplyStorageOrgUnit;
                supplyStorageOrgUnits[num] = supplyStorageOrgUnit = curRow.getCell("productionOrgUnit.id").getValue().toString();
                ++num;
            }
            storageOrgUnitIds[i] = storageOrgUnitID = curRow.getCell("storageOrgUnit.id").getValue().toString();
        }
        HashMap mapUnit = null;
        try {
            try {
                String[] unit = new String[storageOrgUnitIds.length + num];
                for (int i = 0; i < storageOrgUnitIds.length; ++i) {
                    unit[i] = storageOrgUnitIds[i];
                }
                int len = storageOrgUnitIds.length;
                for (int i = 0; i < num; ++i) {
                    if (supplyStorageOrgUnits[i] == null) continue;
                    unit[len + i] = supplyStorageOrgUnits[i];
                }
                mapUnit = this.getCouOrgUnit(unit);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        int size2 = this.tblMain.getRowCount();
        for (int i = 0; i < size2; ++i) {
            TargetBillTypeEnum targetBillType = null;
            curRow = this.tblMain.getRow(i);
            String storageOrgUnitID = curRow.getCell("storageOrgUnit.id").getValue().toString();
            String supplyStorageOrgUnit = curRow.getCell("productionOrgUnit.id").getValue().toString();
            String orderType = curRow.getCell("orderType").getValue().toString();
            if (!orderType.equals(PlannedOrderTypeEnum.STOCKTRANSFER.getAlias())) continue;
            targetBillType = this.checkOrgUnit(mapUnit, storageOrgUnitID, supplyStorageOrgUnit) ? TargetBillTypeEnum.SROCK_TRANSFER_BILL : TargetBillTypeEnum.TRANSFER_ORDER_BILL;
            if (storageOrgUnitID.equals(supplyStorageOrgUnit)) {
                targetBillType = TargetBillTypeEnum.OUTPURCHASE_REQUIREMENT;
            }
            curRow.getCell(REL_TARGET_BILL_TYPE).setValue((Object)targetBillType);
        }
        storageOrgUnitIds = null;
    }

    private Set getMaterialIdSet() {
        HashSet<String> matSet = new HashSet<String>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            String materialId = this.tblMain.getRow(i).getCell("material.id").getValue().toString();
            matSet.add(materialId);
        }
        return matSet;
    }

    private MaterialPlanCollection getPlanInfo() throws BOSException {
        MaterialPlanCollection colls = null;
        if (this.tblMain.getRowCount() > 0) {
            String storageOrgUnitId = this.tblMain.getRow(0).getCell("storageOrgUnit.id").getValue().toString();
            Set matIdSet = this.getMaterialIdSet();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)matIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageOrgUnitId));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("material.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("materialAttr"));
            viewInfo.getSelector().add(new SelectorItemInfo("produceLeadTime"));
            viewInfo.getSelector().add(new SelectorItemInfo("forwardProcessTime"));
            viewInfo.getSelector().add(new SelectorItemInfo("backwardProcessTime"));
            viewInfo.getSelector().add(new SelectorItemInfo("throwMode"));
            viewInfo.getSelector().add(new SelectorItemInfo("productLine.number"));
            viewInfo.getSelector().add(new SelectorItemInfo("productLine.name"));
            viewInfo.getSelector().add(new SelectorItemInfo("productLine.workshop.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("productLine.lineStatus"));
            viewInfo.getSelector().add(new SelectorItemInfo("productLine.status"));
            viewInfo.getSelector().add("leadTimeType");
            viewInfo.getSelector().add("changeBatch");
            viewInfo.getSelector().add("changeLeadTime");
            viewInfo.getSelector().add("recevingLeadTime");
            viewInfo.getSelector().add("orgUnit.id");
            viewInfo.setFilter(filter);
            colls = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(viewInfo);
        }
        return colls;
    }

    private void updateMaterialAttr() throws BOSException {
        MaterialPlanCollection mats = this.getPlanInfo();
        if (mats == null) {
            return;
        }
        this.materialPlanMap = new HashMap();
        for (MaterialPlanInfo info : mats) {
            this.materialPlanMap.put(info.getMaterial().getId().toString(), info);
        }
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            String materialId = row.getCell("material.id").getValue().toString();
            MaterialPlanInfo info = (MaterialPlanInfo)this.materialPlanMap.get(materialId);
            if (info == null) continue;
            row.getCell(REL_MATERIAL_ATTR).setValue((Object)info.getMaterialAttr());
        }
    }

    private String getProductLineSql(String fmaterialid, String forgunitid) {
        StringBuffer sql = new StringBuffer();
        sql.append("select h.Cfproductlineid from CT_SCH_PRODUCTASSIGNMENT h ");
        sql.append(" Inner Join Ct_Sch_Productassignmententry d on h.fid = d.fparentid ");
        sql.append(" where h.Cfstorageorgunitid = '").append(forgunitid).append("' ");
        sql.append(" and d.Cfmaterialid = '").append(fmaterialid).append("' ");
        sql.append(" and Exists(Select 1 from t_mm_productline p where p.fid = h.Cfproductlineid and p.flinestatus = 10 and p.fstatus = 20)  ");
        sql.append(" And h.Cfbasestatus = ").append(4).append(" ");
        return sql.toString();
    }

    private ProductLineInfo getProductLine(String fmaterialid, String forgunitid) {
        ProductLineInfo info = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.getProductLineSql(fmaterialid, forgunitid), CompareType.INNER));
        entityViewInfo.setFilter(filterInfo);
        ProductLineCollection pcoll = null;
        try {
            pcoll = ProductLineFactory.getRemoteInstance().getProductLineCollection(entityViewInfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.handleException((Exception)((Object)e));
        }
        if (pcoll != null && pcoll.size() > 0) {
            info = pcoll.get(0);
        }
        return info;
    }

    private void setProductLine() {
        IRow row = null;
        String materialId = null;
        String orgUnitID = null;
        Object info = null;
        ProductLineInfo productLineInfo = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            materialId = row.getCell("material.id").getValue().toString();
            orgUnitID = row.getCell("storageOrgUnit.id").getValue().toString();
            if (this.productLineMap != null && this.productLineMap.containsKey(materialId + orgUnitID)) {
                productLineInfo = (ProductLineInfo)this.productLineMap.get(materialId + orgUnitID);
            } else {
                productLineInfo = this.getProductLine(materialId, orgUnitID);
                this.productLineMap.put(materialId + orgUnitID, productLineInfo);
            }
            PlannedOrderTypeEnum orderType = this.getPlannedOrderType(row);
            if (productLineInfo == null || !PlannedOrderTypeEnum.FABRICATED.equals((Object)orderType)) continue;
            row.getCell("productLine").getStyleAttributes().setLocked(false);
            this.setProductLine2Cell(row, productLineInfo);
        }
    }

    private void setProductLine2Cell(IRow row, ProductLineInfo productLineInfo) {
        row.getCell("productLine").setValue((Object)productLineInfo);
    }

    private void initProductLineF7() {
        this.prmtProductLine = new KDBizPromptBox();
        this.prmtProductLine.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7ProductLineQuery");
        this.prmtProductLine.setEditFormat("$number$");
        this.prmtProductLine.setDisplayFormat("$name$");
        this.prmtProductLine.setCommitFormat("$number$");
        this.prmtProductLine.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                PMRPPlannedOrderReleaseUI.this.setProductLineViewInfo();
            }
        });
        this.prmtProductLine.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                PMRPPlannedOrderReleaseUI.this.setProductLineViewInfo();
            }
        });
    }

    private void setProductLineViewInfo() {
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String storageOrgUnitId = null;
        String fmaterialid = null;
        if (this.tblMain.getRowCount() > 0 && this.tblMain.getSelectManager() != null && this.tblMain.getSelectManager().getActiveRowIndex() >= 0) {
            fmaterialid = this.tblMain.getRow(0).getCell("material.id").getValue().toString();
            storageOrgUnitId = this.tblMain.getRow(0).getCell("storageOrgUnit.id").getValue().toString();
        } else if (this.tblMain.getRowCount() > 0) {
            storageOrgUnitId = this.tblMain.getRow(0).getCell("storageOrgUnit.id").getValue().toString();
        }
        if (storageOrgUnitId != null && fmaterialid != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.getProductLineSql(fmaterialid, storageOrgUnitId), CompareType.INNER));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("lineStatus", (Object)new Integer(10), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20), CompareType.EQUALS));
        }
        entityView.setFilter(filterInfo);
        this.prmtProductLine.setEntityViewInfo(entityView);
        this.prmtProductLine.getQueryAgent().resetRuntimeEntityView();
    }

    private BigDecimal setQtyRelease(IRow curRow) {
        this.setQtyPrecision(curRow);
        BigDecimal totalReleaseQty = (BigDecimal)curRow.getCell(REL_TOTAL_RELEASE_QTY).getValue();
        totalReleaseQty = totalReleaseQty == null ? new BigDecimal("0.00") : totalReleaseQty;
        BigDecimal qty = (BigDecimal)curRow.getCell(REL_QTY).getValue();
        qty = qty == null ? new BigDecimal("0.00") : qty;
        BigDecimal releaseQty = qty.subtract(totalReleaseQty);
        return releaseQty;
    }

    private BigDecimal setBaseQtyRelease(IRow curRow) {
        BigDecimal baseTotalReleaseQty = (BigDecimal)curRow.getCell(REL_BASE_TOTAL_RELEASE_QTY).getValue();
        baseTotalReleaseQty = baseTotalReleaseQty == null ? new BigDecimal("0.00") : baseTotalReleaseQty;
        BigDecimal baseQty = (BigDecimal)curRow.getCell(REL_BASE_QTY).getValue();
        baseQty = baseQty == null ? new BigDecimal("0.00") : baseQty;
        BigDecimal baseReleaseQty = baseQty.subtract(baseTotalReleaseQty);
        return baseReleaseQty;
    }

    protected int[] verifyBeforeRelease() {
        int[] curRowIndex = new int[this.selectRowCount];
        int j = 0;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow curRow = this.tblMain.getRow(i);
            Date startDate = (Date)curRow.getCell(REL_START_DATE).getValue();
            Date endDate = (Date)curRow.getCell(REL_END_DATE).getValue();
            BigDecimal releaseQty = (BigDecimal)curRow.getCell(REL_RELEASE_QTY).getValue();
            Object isSelect = curRow.getCell(REL_IS_SELECT).getValue();
            if (isSelect == null) {
                isSelect = Boolean.toString(false);
            }
            boolean select = Boolean.valueOf(isSelect.toString());
            int startDateIndex = curRow.getCell(REL_START_DATE).getColumnIndex();
            int endDateIndex = curRow.getCell(REL_END_DATE).getColumnIndex();
            int releaseQtyIndex = curRow.getCell(REL_RELEASE_QTY).getColumnIndex();
            String baseStatus = this.tblMain.getCell(i, "baseStatus").getValue().toString();
            boolean status = baseStatus.equals(BillBaseStatusEnum.CLOSED.getAlias());
            if (!select || status) continue;
            String message = "";
            if (startDate == null || endDate == null || releaseQty == null) {
                if (startDate == null) {
                    message = message + com.kingdee.eas.util.client.EASResource.getString((String)PLANNING_RESOURCE, (String)"START_DATE");
                    this.tblMain.getEditManager().editCellAt(i, startDateIndex);
                }
                if (endDate == null) {
                    message = message + com.kingdee.eas.util.client.EASResource.getString((String)PLANNING_RESOURCE, (String)"END_DATE");
                    this.tblMain.getEditManager().editCellAt(i, endDateIndex);
                }
                if (releaseQty == null) {
                    message = message + com.kingdee.eas.util.client.EASResource.getString((String)PLANNING_RESOURCE, (String)"RELEASED_QTY");
                    this.tblMain.getEditManager().editCellAt(i, releaseQtyIndex);
                }
                String msg = com.kingdee.eas.util.client.EASResource.getString((String)PLANNING_RESOURCE, (String)"CAN_NOT_BE_NULL");
                MessageFormat msgFmt = new MessageFormat(msg);
                MsgBox.showInfo((String)msgFmt.format(new String[]{message}));
                SysUtil.abort();
            }
            if (endDate.before(this.setCalendar(startDate))) {
                MsgBox.showInfo((Component)((Object)this), (String)com.kingdee.eas.util.client.EASResource.getString((String)PLANNING_RESOURCE, (String)"MSG_FINISHEDDATELESSTHANBEGINDATE"));
                this.tblMain.getEditManager().editCellAt(i, endDateIndex);
                SysUtil.abort();
            }
            if (releaseQty.compareTo(new BigDecimal("0")) <= 0) {
                MsgBox.showInfo((Component)((Object)this), (String)com.kingdee.eas.util.client.EASResource.getString((String)PLANNING_RESOURCE, (String)"Release_Qty_Must_Be_Positive"));
                this.tblMain.getEditManager().editCellAt(i, releaseQtyIndex);
                SysUtil.abort();
                continue;
            }
            curRowIndex[j] = i;
            ++j;
        }
        return curRowIndex;
    }

    private Date setCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        return date;
    }

    public void onLoad() throws Exception {
        String botpSQL = null;
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        BOTMappingCollection c = null;
        for (int loop = 1; loop < 10 && cuInfo != null; ++loop) {
            if ("OutSourcing".equals(this.getUIContext().get("BillType"))) {
                botpSQL = "SELECT ID,ALIAS,NAME WHERE srcEntityName='46D6DB79' AND (destEntityName='3171BFAD' or destEntityName='25428F2E' )  And extRule.isEffected = 1 and CU.id = '" + cuInfo.getId() + "'";
            } else if ("SelfProduct".equals(this.getUIContext().get("BillType"))) {
                botpSQL = "SELECT ID,ALIAS,NAME WHERE srcEntityName='46D6DB79' AND destEntityName='1D0D80DD' And extRule.isEffected = 1 and CU.id = '" + cuInfo.getId() + "' ";
            } else if ("WW".equals(this.getUIContext().get("BillType"))) {
                botpSQL = "SELECT ID,ALIAS,NAME WHERE srcEntityName='46D6DB79' AND destEntityName='F99EE589' And extRule.isEffected = 1 and CU.id = '" + cuInfo.getId() + "' ";
            }
            c = BOTMappingFactory.getRemoteInstance().getBOTMappingCollection(botpSQL);
            if (c != null && c.size() > 0 || cuInfo == null || cuInfo.getParent() == null) break;
            cuInfo = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(cuInfo.getParent().getId()));
        }
        if (c != null) {
            Object[] botpRules = new Object[c.size()];
            for (int i = 0; i < c.size(); ++i) {
                botpRules[i] = new BOTRuleItem(c.get(i).getId(), c.get(i).getName(), c.get(i).getAlias());
            }
            this.comboBOTP.addItems(botpRules);
        }
        this.comboBOTP.setUI((ComboBoxUI)new KingdeeComboBoxUI(){

            public void setCanSearch(boolean canSearch) {
            }
        });
        KDBizComboboxModel model = (KDBizComboboxModel)this.comboBOTP.getModel();
        model.setNeedReQuery(false);
        super.onLoad();
        this.contRunnerClassName.setVisible(false);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getActionMap().remove("Paste");
        this.tblMain.getActionMap().remove("Delete");
        this.tblMain.getActionMap().remove("Copy");
        this.tblMain.getActionMap().remove("Cut");
        this.btnAttachment.setVisible(false);
        this.btnRelease.setEnabled(false);
        this.tblMain.getStyleAttributes().setLocked(false);
        String[] lockColNames = new String[]{REL_MATERIAL_NUM, REL_MATERIAL_NAME, REL_MATERIAL_ATTR, REL_STORAGE_ORG_UNIT, "number", REL_QTY, REL_TOTAL_RELEASE_QTY, REL_UNIT, REL_SUPPLY_STORAGE_ORG_UNIT, REL_STORAGE_ORG_UNIT, "baseStatus", "orderType", REL_MATERIAL_ATTR, REL_TARGET_BILL_TYPE, "material.model", "productLine"};
        SCMClientUtils.lockColumns((KDTable)this.tblMain, (String[])lockColNames, (boolean)true);
        KDDatePicker startDate = new KDDatePicker();
        KDDatePicker endDate = new KDDatePicker();
        startDate.setBackground(SCMClientUtils.necessaryColor);
        endDate.setBackground(SCMClientUtils.necessaryColor);
        this.tblMain.getColumn(REL_START_DATE).setEditor((ICellEditor)new KDTDefaultCellEditor(startDate));
        this.tblMain.getColumn(REL_END_DATE).setEditor((ICellEditor)new KDTDefaultCellEditor(endDate));
        this.tblMain.getColumn(REL_START_DATE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn(REL_END_DATE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("avilableDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        KDCheckBox isSelect = new KDCheckBox();
        this.tblMain.getColumn(REL_IS_SELECT).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)isSelect));
        KDCheckBox isClose = new KDCheckBox();
        this.tblMain.getColumn(REL_IS_CLOSE).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)isClose));
        this.tblMain.getColumn(REL_RELEASE_QTY).getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
        KDTextField targetBillNumber = new KDTextField();
        this.tblMain.getColumn("targetBillNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)targetBillNumber));
        this.initProductLineF7();
        this.tblMain.getColumn("productLine").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtProductLine));
        this.tblMain.getActionMap().remove("Delete");
        this.loadFields();
        if (this.getUIContext().get("scheduleData") == null) {
            this.refreshList();
        }
        this.setSize(1000, 600);
        this.setPreferredSize(this.getSize());
        this.getMenuManager(this.tblMain).getMenu().remove(1);
    }

    protected void initTableParams() {
    }

    @Override
    public void loadFields() {
        this.removeListiners();
        super.loadFields();
        this.initScheduleData();
        this.addListiners();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setIcon(com.kingdee.eas.util.client.EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnDeleteAll.setIcon(com.kingdee.eas.util.client.EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnRelease.setIcon(com.kingdee.eas.util.client.EASResource.getIcon((String)"imgTbtn_makeknown"));
    }

    private void released() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        LongTimeDialog dialog = parent instanceof KDFrame ? new LongTimeDialog((Frame)((KDFrame)parent)) : new LongTimeDialog((Dialog)((KDDialog)parent));
        dialog.setLongTimeTask(new ILongTimeTask(){

            public void afterExec(Object result) throws Exception {
            }

            public Object exec() throws Exception {
                if (PMRPPlannedOrderReleaseUI.this.isReleased) {
                    // empty if block
                }
                String[] colNames = new String[]{PMRPPlannedOrderReleaseUI.REL_MATERIAL_NAME, "orderType", PMRPPlannedOrderReleaseUI.REL_UNIT, PMRPPlannedOrderReleaseUI.REL_STORAGE_ORG_UNIT, PMRPPlannedOrderReleaseUI.REL_SUPPLY_STORAGE_ORG_UNIT, PMRPPlannedOrderReleaseUI.REL_START_DATE, PMRPPlannedOrderReleaseUI.REL_END_DATE, PMRPPlannedOrderReleaseUI.REL_BASE_TOTAL_RELEASE_QTY, PMRPPlannedOrderReleaseUI.REL_BASE_RELEASE_QTY, PMRPPlannedOrderReleaseUI.REL_QTY, PMRPPlannedOrderReleaseUI.REL_RELEASE_QTY, PMRPPlannedOrderReleaseUI.REL_BASE_QTY, PMRPPlannedOrderReleaseUI.REL_TOTAL_RELEASE_QTY, "id", "targetBillNumber", PMRPPlannedOrderReleaseUI.REL_TARGET_BILL_TYPE, "productionOrgUnit.id", "material.id", "unit.id", "number", "bizType.id", "avilableDate", "baseUnit.id", "assistUnit.id", "scheme.id", "scheme.number", "storageOrgUnit.id", "materialGroup.name", "baseStatus", PMRPPlannedOrderReleaseUI.REL_IS_CLOSE, "produceUnit", "produceUnit.id", "material.model", PMRPPlannedOrderReleaseUI.REL_MATERIAL_NUM, "sourceType", "planner.id", "projectid", "trackNumberid", "productLine"};
                Map[] m = new Map[PMRPPlannedOrderReleaseUI.this.selectRowCount];
                int[] rowCount = PMRPPlannedOrderReleaseUI.this.verifyBeforeRelease();
                int size = rowCount.length;
                for (int i = 0; i < size; ++i) {
                    m[i] = PMRPPlannedOrderReleaseUI.this.getCellValue(colNames, rowCount[i], i);
                    m[i].put("BillID", m[i].get("id"));
                    m[i].put(PMRPPlannedOrderReleaseUI.REL_QTY, m[i].get(PMRPPlannedOrderReleaseUI.REL_RELEASE_QTY));
                    m[i].put(PMRPPlannedOrderReleaseUI.REL_BASE_RELEASE_QTY, m[i].get(PMRPPlannedOrderReleaseUI.REL_BASE_RELEASE_QTY));
                    m[i].put("planQty", m[i].get(PMRPPlannedOrderReleaseUI.REL_QTY));
                    m[i].put(PMRPPlannedOrderReleaseUI.REL_START_DATE, m[i].get(PMRPPlannedOrderReleaseUI.REL_START_DATE));
                    m[i].put(PMRPPlannedOrderReleaseUI.REL_END_DATE, m[i].get(PMRPPlannedOrderReleaseUI.REL_END_DATE));
                    m[i].put("schemeid", m[i].get("scheme.id"));
                    m[i].put("productLine", m[i].get("productLine"));
                }
                IPMRPPlannedOrderMappingFacade facade = PMRPPlannedOrderMappingFacadeFactory.getRemoteInstance();
                try {
                    HashMap errorMap;
                    PMRPPlannedOrderReleaseUI.this.isReleased = true;
                    Map returnMap = facade.mapping(((BOTRuleItem)((Object)PMRPPlannedOrderReleaseUI.this.comboBOTP.getSelectedItem())).getID(), m, PMRPPlannedOrderReleaseUI.this.txtRunnerClassName.getText());
                    if (returnMap != null && (returnMap.get("result") == null || !"ok".equals(returnMap.get("result").toString())) && returnMap.get("result") != null && "error".equals(returnMap.get("result").toString()) && returnMap.get("errorPlannedOrderResult") != null && (errorMap = (HashMap)returnMap.get("errorPlannedOrderResult")) != null && errorMap.size() > 0) {
                        Set set = errorMap.keySet();
                        Iterator it = set.iterator();
                        String ferrorStrAll = "";
                        while (it.hasNext()) {
                            String key = String.valueOf(it.next());
                            String ferrorStr = errorMap.get(key).toString();
                            ferrorStrAll = ferrorStrAll + " " + ferrorStr + "\r\n";
                        }
                        if (ferrorStrAll != null && !"".equals(ferrorStrAll)) {
                            MsgBox.showDetailAndOK((Component)((Object)PMRPPlannedOrderReleaseUI.this), (String)((errorMap.size() == m.length ? "\u5168\u90e8" : "\u90e8\u5206") + "\u6295\u653e\u5931\u8d25"), (String)ferrorStrAll, (int)0);
                            for (int i = 0; i < PMRPPlannedOrderReleaseUI.this.tblMain.getRowCount(); ++i) {
                                if (errorMap.containsKey(PMRPPlannedOrderReleaseUI.this.tblMain.getCell(i, "id").getValue().toString())) continue;
                                PMRPPlannedOrderReleaseUI.this.tblMain.removeRow(i);
                                i = 0;
                            }
                            if (PMRPPlannedOrderReleaseUI.this.tblMain.getRowCount() < 1) {
                                PMRPPlannedOrderReleaseUI.this.btnRelease.setEnabled(false);
                            }
                            return null;
                        }
                    }
                }
                catch (Exception e) {
                    MsgBox.showDetailAndOK((Component)((Object)PMRPPlannedOrderReleaseUI.this), (String)PMRPPlannedOrderReleaseUI.this.TFSB_NAME, (String)e.getMessage(), (int)0);
                    return null;
                }
                PMRPPlannedOrderReleaseUI.this.destroyWindow();
                return null;
            }
        });
        dialog.show();
    }

    private Map getCellValue(String[] colNames, int rowIndex, int j) {
        IRow curRow = this.tblMain.getRow(rowIndex);
        int length = colNames.length;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < length; ++i) {
            Object curObj = curRow.getCell(colNames[i]).getValue();
            map.put(colNames[i], curObj);
        }
        return map;
    }

    private int setQtyPrecision(IRow curRow) {
        int qtyPrecision = Integer.parseInt(curRow.getCell("qtyPrecision").getValue().toString());
        String formatString = PrecisionUtil.getFormatString((int)qtyPrecision);
        curRow.getCell(REL_RELEASE_QTY).setEditor((ICellEditor)FormattedEditorFactory.getBigDecimalCellEditor((int)qtyPrecision, (boolean)false));
        curRow.getCell(REL_RELEASE_QTY).getStyleAttributes().setNumberFormat(formatString);
        BigDecimal releaseQty = BigDecimal.ZERO;
        if (curRow.getCell(REL_RELEASE_QTY).getValue() != null && !"".equals(curRow.getCell(REL_RELEASE_QTY).getValue().toString())) {
            releaseQty = new BigDecimal(curRow.getCell(REL_RELEASE_QTY).getValue().toString());
        }
        if (releaseQty != null) {
            curRow.getCell(REL_RELEASE_QTY).setValue((Object)releaseQty.setScale(qtyPrecision, 4));
        }
        curRow.getCell(REL_QTY).setEditor((ICellEditor)FormattedEditorFactory.getBigDecimalCellEditor((int)qtyPrecision, (boolean)false));
        curRow.getCell(REL_QTY).getStyleAttributes().setNumberFormat(formatString);
        BigDecimal qty = (BigDecimal)curRow.getCell(REL_QTY).getValue();
        if (qty != null) {
            curRow.getCell(REL_QTY).setValue((Object)qty.setScale(qtyPrecision, 4));
        }
        curRow.getCell(REL_TOTAL_RELEASE_QTY).setEditor((ICellEditor)FormattedEditorFactory.getBigDecimalCellEditor((int)qtyPrecision, (boolean)false));
        curRow.getCell(REL_TOTAL_RELEASE_QTY).getStyleAttributes().setNumberFormat(formatString);
        BigDecimal totalReleaseQty = (BigDecimal)curRow.getCell(REL_TOTAL_RELEASE_QTY).getValue();
        BigDecimal bigDecimal = totalReleaseQty = totalReleaseQty == null ? new BigDecimal("0.00") : totalReleaseQty;
        if (totalReleaseQty != null) {
            curRow.getCell(REL_TOTAL_RELEASE_QTY).setValue((Object)totalReleaseQty.setScale(qtyPrecision, 4));
        }
        return qtyPrecision;
    }

    private void tableValueChanged(KDTEditEvent e) throws BOSException, EASBizException {
        int selectedRow = e.getRowIndex();
        int selectedCol = e.getColIndex();
        Object newValue = e.getValue();
        if (newValue != null && newValue.equals(e.getOldValue())) {
            return;
        }
        IRow curRow = this.tblMain.getRow(selectedRow);
        int colReleaseQty = this.tblMain.getColumnIndex(REL_RELEASE_QTY);
        int colstartDate = this.tblMain.getColumnIndex(REL_START_DATE);
        int colendDate = this.tblMain.getColumnIndex(REL_END_DATE);
        int productLine = this.tblMain.getColumnIndex("productLine");
        if (selectedCol == colReleaseQty) {
            boolean isReleaseMore = this.releaseQtyChanged(curRow, newValue);
            if (isReleaseMore) {
                BigDecimal qtyRelease = (BigDecimal)e.getOldValue();
                this.tblMain.getCell(selectedRow, selectedCol).setValue(e.getOldValue());
                this.tblMain.getEditManager().editCellAt(selectedRow, selectedCol);
                if (qtyRelease != null) {
                    BigDecimal coefficient = (BigDecimal)curRow.getCell("unit.coefficient").getValue();
                    coefficient = coefficient == null ? new BigDecimal("1") : coefficient;
                    BigDecimal baseQtyRelease = qtyRelease.multiply(coefficient);
                    baseQtyRelease = baseQtyRelease == null ? new BigDecimal("0.00") : baseQtyRelease;
                    curRow.getCell(REL_BASE_RELEASE_QTY).setValue((Object)baseQtyRelease);
                } else {
                    curRow.getCell(REL_BASE_RELEASE_QTY).setValue((Object)new BigDecimal("0.00"));
                }
            } else {
                Date startDate = (Date)curRow.getCell(REL_START_DATE).getValue();
                this.calcEndDate(curRow, startDate, (BigDecimal)newValue, true);
            }
        } else if (selectedCol == colendDate) {
            Date old = (Date)e.getOldValue();
            Date oldDate = this.setCalendar(old);
            boolean endDate = this.endDateChanged(curRow, newValue);
            if (endDate) {
                if (newValue != null && newValue.equals(oldDate)) {
                    return;
                }
                this.tblMain.getCell(selectedRow, selectedCol).setValue(e.getOldValue());
                this.tblMain.getEditManager().editCellAt(selectedRow, selectedCol);
            }
        } else if (selectedCol == colstartDate) {
            Date old = (Date)e.getOldValue();
            Date oldDate = this.setCalendar(old);
            boolean starte = this.startDateChanged(curRow, newValue);
            if (starte) {
                if (newValue != null && newValue.equals(oldDate)) {
                    return;
                }
                this.tblMain.getCell(selectedRow, selectedCol).setValue(e.getOldValue());
                this.tblMain.getEditManager().editCellAt(selectedRow, selectedCol);
            } else {
                BigDecimal qty = (BigDecimal)curRow.getCell(REL_RELEASE_QTY).getValue();
                this.calcEndDate(curRow, (Date)newValue, qty, false);
            }
        } else if (selectedCol == productLine) {
            // empty if block
        }
    }

    private void isSelectChanged(KDTEditEvent e) {
        int selectedCol = e.getColIndex();
        Object newValue = e.getValue();
        if (newValue != null && newValue.equals(e.getOldValue())) {
            return;
        }
        int colIsSelect = this.tblMain.getColumnIndex(REL_IS_SELECT);
        if (selectedCol == colIsSelect) {
            newValue = newValue == null ? Boolean.valueOf(false) : newValue;
            boolean select = Boolean.valueOf(newValue.toString());
            IRow row = this.tblMain.getRow(e.getRowIndex());
            if (select) {
                ++this.selectRowCount;
                if (this.selectRowCount > 0) {
                    this.btnRelease.setEnabled(true);
                } else {
                    this.btnRelease.setEnabled(false);
                }
                this.isSelectMap.put(row.getCell("id").getValue(), Boolean.TRUE);
            } else {
                --this.selectRowCount;
                if (this.selectRowCount > 0) {
                    this.btnRelease.setEnabled(true);
                } else {
                    this.btnRelease.setEnabled(false);
                }
                this.isSelectMap.remove(row.getCell("id").getValue());
            }
        }
    }

    private boolean releaseQtyChanged(IRow curRow, Object newValue) {
        this.setQtyPrecision(curRow);
        boolean isReleaseMore = false;
        if (newValue == null || "".equals(newValue.toString())) {
            curRow.getCell(REL_BASE_RELEASE_QTY).setValue((Object)new BigDecimal("0.00"));
        } else {
            BigDecimal coefficient = (BigDecimal)curRow.getCell("unit.coefficient").getValue();
            coefficient = coefficient == null ? new BigDecimal("1") : coefficient;
            BigDecimal qtyRelease = new BigDecimal(newValue.toString());
            BigDecimal baseQtyRelease = qtyRelease.multiply(coefficient);
            baseQtyRelease = baseQtyRelease == null ? new BigDecimal("0.00") : baseQtyRelease;
            curRow.getCell(REL_BASE_RELEASE_QTY).setValue((Object)baseQtyRelease);
            BigDecimal baseReleaseQty = (BigDecimal)curRow.getCell(REL_RELEASE_QTY).getValue();
            BigDecimal baseQty = (BigDecimal)curRow.getCell(REL_QTY).getValue();
            BigDecimal baseTotalQty = (BigDecimal)curRow.getCell(REL_TOTAL_RELEASE_QTY).getValue();
            baseQty = baseQty == null ? new BigDecimal("0.00") : baseQty;
            boolean bl = isReleaseMore = baseReleaseQty.compareTo(baseQty.subtract(baseTotalQty)) > 0;
            if (isReleaseMore) {
                MsgBox.showError((Component)((Object)this), (String)com.kingdee.eas.util.client.EASResource.getString((String)PLANNING_RESOURCE, (String)"ReleaseQty_should_less_than_qty_sub_totalQty"));
            }
        }
        return isReleaseMore;
    }

    private boolean endDateChanged(IRow curRow, Object newValue) {
        boolean endDateChanged = false;
        Date endDate = (Date)newValue;
        Date startDate = (Date)curRow.getCell(REL_START_DATE).getValue();
        if (endDate == null) {
            MsgBox.showInfo((Component)((Object)this), (String)com.kingdee.eas.util.client.EASResource.getString((String)PLANNING_RESOURCE, (String)"MSG_EXISTSITEMTOINPUT"));
            return true;
        }
        if (endDate.before(this.setCalendar(startDate))) {
            MsgBox.showInfo((Component)((Object)this), (String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.mm.planning.PlannedOrderResource", (String)"ENDDATE_CANNOT_LT_STARTDATE"));
            return true;
        }
        String storageOrgUnitId = curRow.getCell("storageOrgUnit.id").getValue().toString();
        boolean isWorkDay = true;
        try {
            isWorkDay = FactoryCalendarFactory.getRemoteInstance().isWorkDay(storageOrgUnitId, endDate);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (!isWorkDay) {
            MsgBox.showInfo((Component)((Object)this), (String)com.kingdee.eas.util.client.EASResource.getString((String)PLANNING_EXCEPTION, (String)"ENDDATE_NOTWORK_EXCEPTION"));
            return true;
        }
        return endDateChanged;
    }

    private boolean startDateChanged(IRow curRow, Object newValue) {
        boolean starteDateChanged = false;
        Date startDate = (Date)newValue;
        int startDateIndex = curRow.getCell(REL_START_DATE).getColumnIndex();
        int row = curRow.getRowIndex();
        Date now = new Date();
        if (newValue == null) {
            MsgBox.showInfo((Component)((Object)this), (String)com.kingdee.eas.util.client.EASResource.getString((String)PLANNING_RESOURCE, (String)"MSG_EXISTSITEMTOINPUT"));
            this.tblMain.getEditManager().editCellAt(row, startDateIndex);
            return true;
        }
        if (startDate.before(this.setCalendar(now))) {
            MsgBox.showInfo((Component)((Object)this), (String)com.kingdee.eas.util.client.EASResource.getString((String)PLANNING_RESOURCE, (String)"START_DATE_CAN_NOT_BE_BEFORE_CUR_DATE"));
            this.tblMain.getEditManager().editCellAt(row, startDateIndex);
            return true;
        }
        String storageOrgUnitId = curRow.getCell("storageOrgUnit.id").getValue().toString();
        boolean isWorkDay = true;
        try {
            isWorkDay = FactoryCalendarFactory.getRemoteInstance().isWorkDay(storageOrgUnitId, startDate);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (!isWorkDay) {
            MsgBox.showInfo((Component)((Object)this), (String)com.kingdee.eas.util.client.EASResource.getString((String)PLANNING_EXCEPTION, (String)"STARTDATE_NOTWORK_EXCEPTION"));
            this.tblMain.getEditManager().editCellAt(row, startDateIndex);
            return true;
        }
        return starteDateChanged;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Storage)) {
            return "storageOrgUnit.id";
        }
        return null;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exc = super.getQueryExecutor(queryPK, viewInfo);
        SorterItemCollection sorters = viewInfo.getSorter();
        int size = sorters.size();
        for (int i = 0; i < size; ++i) {
            SorterItemInfo itemInfo = (SorterItemInfo)viewInfo.getSorter().getObject(i);
            if (!itemInfo.getPropertyName().equalsIgnoreCase("entries.seq")) continue;
            viewInfo.getSorter().remove(itemInfo);
        }
        return exc;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected boolean initDefaultFilter() {
        return false;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        return new PlannedOrderFilterUI();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo2 = super.getDefaultFilterForQuery();
        FilterInfo filterInfo = new FilterInfo();
        Set idSet = (Set)this.getUIContext().get("selectedId");
        idSet = idSet == null ? new HashSet() : idSet;
        Set baseStatusSet = (Set)this.getUIContext().get("baseStatus");
        baseStatusSet = baseStatusSet == null ? new HashSet() : baseStatusSet;
        HashSet<Integer> statusSet = new HashSet<Integer>();
        int size = baseStatusSet.size();
        for (int i = 0; i < size; ++i) {
            Object status = baseStatusSet.toArray()[i];
            if (!status.equals(BillBaseStatusEnum.AUDITED.getAlias())) continue;
            statusSet.add(new Integer(4));
        }
        if (idSet != null && idSet.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        }
        if (statusSet.size() != 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", statusSet, CompareType.EQUALS));
        }
        if (this.getUIContext().get("scheduleData") != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", null, CompareType.EQUALS));
        }
        if (filterInfo2 != null) {
            try {
                filterInfo.mergeFilter(filterInfo2, "and");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return filterInfo;
    }

    protected boolean isOrderForClickTableHead() {
        return true;
    }

    private boolean checkOrgUnit(HashMap map, String storageOrgUnitId, String supplyUnitId) {
        String s = (String)map.get(storageOrgUnitId);
        String su = (String)map.get(supplyUnitId);
        if (s == null || su == null) {
            return false;
        }
        return s.equalsIgnoreCase(su);
    }

    private HashMap getCouOrgUnit(String[] unit) throws EASBizException, BOSException {
        return (HashMap)PMRPPlannedOrderMappingFacadeFactory.getRemoteInstance().getCouOrgUnit(unit);
    }

    private PlannedOrderTypeEnum getPlannedOrderType(IRow row) {
        String orderTypeAlias = row.getCell("orderType").getValue().toString();
        List orderTypeList = PlannedOrderTypeEnum.getEnumList();
        PlannedOrderTypeEnum orderType = null;
        Iterator it = orderTypeList.iterator();
        while (it.hasNext() && !(orderType = (PlannedOrderTypeEnum)it.next()).getAlias().equals(orderTypeAlias)) {
        }
        return orderType;
    }

    private void calcEndDate(IRow curRow, Date startDate, BigDecimal qty, boolean isChangeQty) throws EASBizException, BOSException {
        String materialId = curRow.getCell("material.id").getValue().toString();
        if (this.materialPlanMap == null) {
            this.updateMaterialAttr();
        }
        MaterialPlanInfo materialPlanInfo = (MaterialPlanInfo)this.materialPlanMap.get(materialId);
        if (isChangeQty && MaterialLeadTimeTypeEnum.FIXBATCHTYPE.equals((Object)materialPlanInfo.getLeadTimeType())) {
            return;
        }
        PlannedOrderTypeEnum orderType = this.getPlannedOrderType(curRow);
        if (PlannedOrderTypeEnum.PURCHASE.equals((Object)orderType) || PlannedOrderTypeEnum.STOCKTRANSFER.equals((Object)orderType)) {
            return;
        }
        Date endDate = PLSUtil.getPlannedEndDate((PlannedOrderTypeEnum)orderType, (MaterialPlanInfo)materialPlanInfo, (Date)startDate, (BigDecimal)qty);
        curRow.getCell(REL_END_DATE).setValue((Object)endDate);
    }

    protected String getEditUIName() {
        return null;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected MaterialAttributeEnum getMaterialAttr(String fmaterialid, String forgid) {
        MaterialPlanInfo mpInfo = null;
        try {
            mpInfo = Material8FacadeFactory.getRemoteInstance().getPlanInfo(fmaterialid, forgid);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.handleException((Exception)((Object)e));
        }
        if (mpInfo != null) {
            return mpInfo.getMaterialAttr();
        }
        return null;
    }

    protected void initScheduleData() {
        if (this.getUIContext().get("scheduleData") == null) {
            return;
        }
        ArrayList dataList = (ArrayList)this.getUIContext().get("scheduleData");
        HashMap dataMap = new HashMap();
        for (int i = 0; i < dataList.size(); ++i) {
            dataMap = (HashMap)dataList.get(i);
            PMRPPlannedOrderInfo pdInfo = (PMRPPlannedOrderInfo)dataMap.get("plannedOrderInfo");
            PlannedOrderScheduleEntryInfo scheduleEntryInfo = (PlannedOrderScheduleEntryInfo)dataMap.get("scheduleEntryInfo");
            IRow addrow = this.tblMain.addRow();
            addrow.getCell(REL_IS_SELECT).setValue((Object)false);
            addrow.getCell("number").setValue((Object)pdInfo.getNumber());
            addrow.getCell(REL_MATERIAL_NUM).setValue((Object)pdInfo.getMaterial().getNumber());
            addrow.getCell(REL_MATERIAL_NAME).setValue((Object)pdInfo.getMaterial().getName());
            addrow.getCell("material.model").setValue((Object)pdInfo.getMaterial().getModel());
            addrow.getCell(REL_STORAGE_ORG_UNIT).setValue((Object)pdInfo.getStorageOrgUnit().getName());
            addrow.getCell(REL_START_DATE).setValue((Object)scheduleEntryInfo.getNewBeginDate());
            addrow.getCell(REL_END_DATE).setValue((Object)scheduleEntryInfo.getNewEndDate());
            addrow.getCell("baseStatus").setValue((Object)pdInfo.getBaseStatus());
            addrow.getCell(REL_RELEASE_QTY).setValue((Object)scheduleEntryInfo.getNewQty().subtract(scheduleEntryInfo.getReleaseQty()));
            addrow.getCell(REL_QTY).setValue((Object)scheduleEntryInfo.getNewQty());
            addrow.getCell(REL_TOTAL_RELEASE_QTY).setValue((Object)scheduleEntryInfo.getReleaseQty());
            addrow.getCell("orderType").setValue((Object)pdInfo.getOrderType());
            addrow.getCell(REL_SUPPLY_STORAGE_ORG_UNIT).setValue((Object)pdInfo.getProductionOrgUnit().getName());
            addrow.getCell(REL_IS_CLOSE).setValue((Object)false);
            addrow.getCell(REL_BASE_QTY).setValue((Object)scheduleEntryInfo.getNewQty());
            addrow.getCell(REL_BASE_TOTAL_RELEASE_QTY).setValue((Object)scheduleEntryInfo.getReleaseQty());
            addrow.getCell("id").setValue((Object)pdInfo.getId());
            addrow.getCell("qtyPrecision").setValue((Object)pdInfo.getUnit().getQtyPrecision());
            addrow.getCell("material.id").setValue((Object)pdInfo.getMaterial().getId());
            addrow.getCell(REL_BASE_RELEASE_QTY).setValue((Object)BigDecimal.ZERO);
            addrow.getCell("productionOrgUnit.id").setValue((Object)pdInfo.getProductionOrgUnit().getId());
            addrow.getCell("storageOrgUnit.id").setValue((Object)pdInfo.getStorageOrgUnit().getId());
            if (pdInfo.getUnit() != null) {
                addrow.getCell("unit.coefficient").setValue((Object)pdInfo.getUnit().getCoefficient());
                addrow.getCell("unit.id").setValue((Object)pdInfo.getUnit().getId());
                addrow.getCell(REL_UNIT).setValue((Object)pdInfo.getUnit().getName());
            }
            addrow.getCell("avilableDate").setValue((Object)pdInfo.getAvilableDate());
            if (pdInfo.getBizType() != null) {
                addrow.getCell("bizType.id").setValue((Object)pdInfo.getBizType().getId());
            }
            addrow.getCell("baseUnit.id").setValue(null);
            addrow.getCell("assistUnit.id").setValue(null);
            addrow.getCell("scheme.id").setValue((Object)scheduleEntryInfo.getId());
            addrow.getCell("scheme.number").setValue((Object)scheduleEntryInfo.getParent().getNumber());
            if (pdInfo.getMaterial() != null && pdInfo.getMaterial().getMaterialGroup() != null) {
                addrow.getCell("materialGroup.name").setValue((Object)pdInfo.getMaterial().getMaterialGroup().getName());
            }
            if (pdInfo.getProductUnit() != null) {
                addrow.getCell("produceUnit").setValue((Object)pdInfo.getProductUnit());
                addrow.getCell("produceUnit.id").setValue((Object)pdInfo.getProductUnit().getId());
            }
            addrow.getCell(REL_BASE_RELEASE_QTY).setValue((Object)scheduleEntryInfo.getNewQty().subtract(scheduleEntryInfo.getReleaseQty()));
            addrow.getCell("sourceType").setValue(null);
            addrow.getCell("planner.id").setValue(null);
            addrow.getCell("targetBillNumber").setValue(null);
            addrow.getCell(REL_TARGET_BILL_TYPE).setValue(null);
            addrow.getCell("isOuter").setValue((Object)false);
            if (pdInfo.getProject() != null) {
                addrow.getCell("projectid").setValue((Object)pdInfo.getProject().getId());
                addrow.getCell("projectNumber").setValue((Object)pdInfo.getProject().getNumber());
            }
            if (pdInfo.getTrackNumber() != null) {
                addrow.getCell("trackNumberid").setValue((Object)pdInfo.getTrackNumber().getId());
                addrow.getCell("trackNumber").setValue((Object)pdInfo.getTrackNumber().getNumber());
            }
            addrow.getCell("productLine").setValue((Object)scheduleEntryInfo.getProductLine());
        }
        try {
            this.initData();
            this.updateMaterialAttr();
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    private class BOTRuleItem
    extends KDComboBoxMultiColumnItem {
        private BOSUuid id;
        private String number;
        private String name;

        BOTRuleItem(BOSUuid id, String number, String name) {
            super(new String[]{name, number});
            this.id = id;
            this.number = number;
            this.name = name;
        }

        public BOSUuid getID() {
            return this.id;
        }

        public String toString() {
            return super.toString();
        }
    }

    private class EventListener
    implements KDTEditListener {
        private EventListener() {
        }

        public void editStopped(KDTEditEvent e) {
            try {
                PMRPPlannedOrderReleaseUI.this.tableValueChanged(e);
            }
            catch (BOSException e1) {
                PMRPPlannedOrderReleaseUI.this.handleException((Exception)((Object)e1));
            }
            catch (EASBizException e1) {
                PMRPPlannedOrderReleaseUI.this.handleException((Exception)((Object)e1));
            }
        }

        public void editStopping(KDTEditEvent e) {
        }

        public void editValueChanged(KDTEditEvent e) {
            PMRPPlannedOrderReleaseUI.this.isSelectChanged(e);
        }

        public void editCanceled(KDTEditEvent e) {
        }

        public void editStarted(KDTEditEvent e) {
        }

        public void editStarting(KDTEditEvent e) {
        }
    }
}

