/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.client;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedFactory;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRequirementTypeEnum;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPSummaryDimensionEnum;
import com.kingdee.eas.industry.emm.project.biz.mrp.client.AbstractPMRPRequirementPlanFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Date;

public class PMRPRequirementPlanFilterUI
extends AbstractPMRPRequirementPlanFilterUI {
    private static final long serialVersionUID = 1L;

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtPlanOrg.setValue((Object)SysContext.getSysContext().getCurrentStorageUnit());
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = new FilterInfo();
        StringBuilder mask = new StringBuilder();
        StorageOrgUnitInfo planOrg = (StorageOrgUnitInfo)this.prmtPlanOrg.getValue();
        PlanDefinedInfo pd = (PlanDefinedInfo)this.prmtPlanDefined.getValue();
        MaterialInfo material = (MaterialInfo)this.prmtMaterial.getValue();
        Date from = this.dpFrom.getSqlDate();
        Date to = this.dpTo.getSqlDate();
        PMRPRequirementTypeEnum rt = (PMRPRequirementTypeEnum)((Object)this.comboRequirementType.getSelectedItem());
        this.filterInfo.getFilterItems().add(new FilterItemInfo("planOrg.id", (Object)planOrg.getId().toString()));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("planDefined.id", (Object)pd.getId().toString()));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("sourceType", (Object)rt.getValue()));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("requireDate", (Object)from, CompareType.GREATER_EQUALS));
        this.filterInfo.getFilterItems().add(new FilterItemInfo("requireDate", (Object)to, CompareType.LESS_EQUALS));
        mask.append("#0 and #1 and #2 and #3 and #4");
        if (material != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString()));
            mask.append(" and #5");
        }
        this.filterInfo.setMaskString(mask.toString());
        return super.getFilterInfo();
    }

    public boolean verify() {
        StringBuilder tips = new StringBuilder();
        StorageOrgUnitInfo planOrg = (StorageOrgUnitInfo)this.prmtPlanOrg.getValue();
        PlanDefinedInfo pd = (PlanDefinedInfo)this.prmtPlanDefined.getValue();
        Date from = this.dpFrom.getSqlDate();
        Date to = this.dpTo.getSqlDate();
        if (planOrg == null) {
            tips.append("[").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"0EMMPROJECTBizMrp-0031")).append("]");
        }
        if (pd == null) {
            if (tips.length() > 0) {
                tips.append(",");
            }
            tips.append("[").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"0EMMPROJECTBizMrp-0032")).append("]");
        }
        if (from == null) {
            if (tips.length() > 0) {
                tips.append(",");
            }
            tips.append("[").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"0EMMPROJECTBizMrp-0033")).append("]");
        }
        if (to == null) {
            if (tips.length() > 0) {
                tips.append(",");
            }
            tips.append("[").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"0EMMPROJECTBizMrp-0034")).append("]");
        }
        if (tips.length() > 0) {
            tips.insert(0, EASResource.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"0EMMPROJECTBizMrp-0035"));
            MsgBox.showInfo((Component)((Object)this), (String)tips.toString());
        }
        return planOrg != null && pd != null && from != null && to != null;
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            java.util.Date to;
            String planOrgID = cp.getCustomerParam("planOrgID");
            if (!StringUtil.isEmptyString((String)planOrgID)) {
                this.prmtPlanOrg.setValue((Object)StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)planOrgID))));
            } else {
                this.prmtPlanOrg.setValue(null);
            }
            String planDefinedID = cp.getCustomerParam("planDefinedID");
            if (!StringUtil.isEmptyString((String)planDefinedID)) {
                this.prmtPlanDefined.setValue((Object)PlanDefinedFactory.getRemoteInstance().getPlanDefinedInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)planDefinedID))));
            } else {
                this.prmtPlanDefined.setValue(null);
            }
            String materialID = cp.getCustomerParam("materialID");
            if (!StringUtil.isEmptyString((String)materialID)) {
                this.prmtMaterial.setValue((Object)MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)materialID))));
            } else {
                this.prmtMaterial.setValue(null);
            }
            String sourceType = cp.getCustomerParam("sourceType");
            this.comboRequirementType.setSelectedItem((Object)PMRPRequirementTypeEnum.getEnum(sourceType));
            java.util.Date from = cp.getDate("dateFrom");
            if (from != null) {
                this.dpFrom.setValue((Object)from);
            }
            if ((to = cp.getDate("dateTo")) != null) {
                this.dpTo.setValue((Object)to);
            }
            String sumType = cp.getCustomerParam("sumType");
            this.comboSumType.setSelectedItem((Object)PMRPSummaryDimensionEnum.getEnum(sumType));
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"0EMMPROJECTBizMrp-0036"));
        }
        super.setCustomerParams(cp);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams customerParams = new CustomerParams();
        customerParams.putDate("dateFrom", (java.util.Date)this.dpFrom.getSqlDate());
        customerParams.putDate("dateTo", (java.util.Date)this.dpTo.getSqlDate());
        customerParams.addCustomerParam("sumType", ((PMRPSummaryDimensionEnum)((Object)this.comboSumType.getSelectedItem())).getValue());
        customerParams.addCustomerParam("sourceType", ((PMRPRequirementTypeEnum)((Object)this.comboRequirementType.getSelectedItem())).getValue());
        StorageOrgUnitInfo planOrg = (StorageOrgUnitInfo)this.prmtPlanOrg.getValue();
        PlanDefinedInfo pd = (PlanDefinedInfo)this.prmtPlanDefined.getValue();
        MaterialInfo material = (MaterialInfo)this.prmtMaterial.getValue();
        if (material != null) {
            customerParams.addCustomerParam("materialID", material.getId().toString());
        }
        if (pd != null) {
            customerParams.addCustomerParam("planDefinedID", pd.getId().toString());
        }
        if (planOrg != null) {
            customerParams.addCustomerParam("planOrgID", planOrg.getId().toString());
        }
        return customerParams;
    }

    public Object getFilterParam(String paramName) {
        if ("sumType".equals(paramName)) {
            return this.comboSumType.getSelectedItem();
        }
        if ("dateFrom".equals(paramName)) {
            return this.dpFrom.getSqlDate();
        }
        if ("dateTo".equals(paramName)) {
            return this.dpFrom.getSqlDate();
        }
        if ("planOrg".equals(paramName)) {
            return this.prmtPlanOrg.getValue();
        }
        throw new IllegalArgumentException(EASResource.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"0EMMPROJECTBizMrp-0037"));
    }
}

