/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunFacadeFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunLogEntryCollection;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunLogEntryInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunLogFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPStepStatusEnum;
import com.kingdee.eas.industry.emm.project.biz.mrp.client.AbstractPMRPRunLogDetailUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.AdvMsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.swing.SwingUtilities;

public class PMRPRunLogDetailUI
extends AbstractPMRPRunLogDetailUI {
    private static final long serialVersionUID = 1L;
    private static final int REFRESH_INTERVAL = 2000;
    private MRPRunThread refresher;
    private boolean isStop = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"0EMMPROJECTBizMrp-0040"));
        if (PMRPStepStatusEnum.RUNNING.equals((Object)this.editData.getStatus()) || PMRPStepStatusEnum.NULL.equals((Object)this.editData.getStatus())) {
            this.dpEndTime.setValue(null);
            this.txtDuration.setText(null);
        } else {
            this.txtDuration.setText(this.calcDuration());
        }
        if (this.getUIContext() != null && this.getUIContext().get("isPMRPTraceSQL") != null && this.getUIContext().get("isPMRPTraceSQL").toString().equals("true")) {
            this.editData.put("isPMRPTraceSQL", true);
        }
        this.refresher = new MRPRunThread();
        this.refresher.start();
    }

    private String calcDuration() {
        long duration = this.editData.getLastUpdateTime().getTime() - this.editData.getCreateTime().getTime();
        BigDecimal time = new BigDecimal(duration);
        return String.valueOf(time.divide(new BigDecimal(60000), 2, RoundingMode.HALF_UP));
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PMRPRunLogFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add(new SelectorItemInfo("*"));
        return selectors;
    }

    @Override
    public void actionStop_actionPerformed(ActionEvent e) throws Exception {
        PMRPRunFacadeFactory.getRemoteInstance().stopMRP(this.editData.getId());
    }

    public boolean destroyWindow() {
        this.refresher.destroy();
        return super.destroyWindow();
    }

    private class EDTUIReloader
    implements Runnable {
        private EDTUIReloader() {
        }

        @Override
        public void run() {
            if (PMRPRunLogDetailUI.this.isStop) {
                return;
            }
            try {
                PMRPRunLogDetailUI.this.loadData();
            }
            catch (Exception e) {
                PMRPRunLogDetailUI.this.isStop = true;
                e.printStackTrace();
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                AdvMsgBox.createAdvMsgBox((Component)((Object)PMRPRunLogDetailUI.this), (String)"\u4fe1\u606f\u63d0\u793a", (String)"\u9879\u76eeMRP\u8fd0\u7b97\u5931\u8d25", (String)writer.toString(), (int)0, (int)8188).show();
                SysUtil.abort();
            }
            PMRPRunLogEntryCollection steps = PMRPRunLogDetailUI.this.editData.getEntrys();
            PMRPRunLogDetailUI.this.kdtDetail.removeRows();
            for (int i = 0; i < steps.size(); ++i) {
                IRow row = PMRPRunLogDetailUI.this.kdtDetail.addRow();
                PMRPRunLogEntryInfo entry = steps.get(i);
                row.getCell("stepNum").setValue((Object)entry.getStepNum());
                row.getCell("name").setValue((Object)entry.getName());
                row.getCell("dataAmount").setValue((Object)entry.getDataAmount());
                row.getCell("time").setValue((Object)entry.getTime());
                row.getCell("status").setValue((Object)(entry.getStatus() == null ? "" : entry.getStatus().getAlias()));
                row.getCell("exception").setValue((Object)"");
                row.getCell("seq").setValue((Object)entry.getSeq());
            }
            if (PMRPRunLogDetailUI.this.kdtDetail.getRowCount() > 5) {
                PMRPRunLogDetailUI.this.kdtDetail.getLayoutManager().scrollRowToShow(PMRPRunLogDetailUI.this.kdtDetail.getRowCount() - 1);
            }
            PMRPRunLogDetailUI.this.pgMRPProgress.setValue(PMRPRunLogDetailUI.this.editData.getPercent());
        }
    }

    private class UIRefreshThread
    extends Thread {
        private boolean interrupted = false;
        private int last5RefreshCount = 5;

        private UIRefreshThread() {
        }

        @Override
        public void run() {
            while (!this.interrupted) {
                try {
                    Thread.sleep(2000L);
                    SwingUtilities.invokeLater(new EDTUIReloader());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PMRPRunLogDetailUI.this.handleException(e);
                }
                if (PMRPStepStatusEnum.RUNNING.equals((Object)PMRPRunLogDetailUI.this.editData.getStatus()) || PMRPStepStatusEnum.NULL.equals((Object)PMRPRunLogDetailUI.this.editData.getStatus())) continue;
                PMRPRunLogDetailUI.this.dpEndTime.setValue((Object)PMRPRunLogDetailUI.this.editData.getLastUpdateTime());
                PMRPRunLogDetailUI.this.txtDuration.setText(PMRPRunLogDetailUI.this.calcDuration());
                if (this.last5RefreshCount-- >= 0) continue;
                break;
            }
        }
    }

    private class MRPRunThread
    extends Thread {
        private UIRefreshThread uiThread;

        private MRPRunThread() {
        }

        @Override
        public void run() {
            this.uiThread = new UIRefreshThread();
            this.uiThread.start();
            try {
                PMRPRunFacadeFactory.getRemoteInstance().runPMRP(PMRPRunLogDetailUI.this.editData);
            }
            catch (Exception e) {
                if (e instanceof PMRPException && PMRPException.LOCK_ERROR.getCode().equals(((PMRPException)((Object)e)).getSubCode())) {
                    String sql = "SELECT top 1 FStatus,FID FROM T_MRP_PMRPRunLog WHERE FStatus = 40 AND FPlanDefinedID = '" + PMRPRunLogDetailUI.this.editData.getPlanDefined().getId() + "' AND FID <> '" + PMRPRunLogDetailUI.this.editData.getId() + "' ORDER BY FCreateTime DESC";
                    try {
                        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
                        if (rs.next()) {
                            PMRPRunLogDetailUI.this.getUIContext().put("ID", rs.getString("FID"));
                            MsgBox.showInfo((Component)((Object)PMRPRunLogDetailUI.this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"0EMMPROJECTBizMrp-0041"));
                        } else {
                            MsgBox.showInfo((Component)((Object)PMRPRunLogDetailUI.this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"0EMMPROJECTBizMrp-0042"));
                        }
                    }
                    catch (Exception e2) {
                        PMRPRunLogDetailUI.this.handleException(e2);
                    }
                    return;
                }
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                try {
                    PMRPRunLogFactory.getRemoteInstance().updateExceptionInfo(PMRPRunLogDetailUI.this.editData.getId().toString(), writer.toString());
                }
                catch (EASBizException e1) {
                    e1.printStackTrace();
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
                AdvMsgBox.createAdvMsgBox((Component)((Object)PMRPRunLogDetailUI.this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"0EMMPROJECTBizMrp-0043"), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", (String)"0EMMPROJECTBizMrp-0044"), (String)writer.toString(), (int)0, (int)8188).show();
                this.uiThread.interrupted = true;
            }
        }

        public void destroy() {
            this.uiThread.interrupted = true;
        }
    }
}

