/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.CellCheckBoxRenderer;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunExceptionCollection;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPRunExceptionFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.client.AbstractPMRPSignalLampUI;
import com.kingdee.eas.mm.planning.MRPRunExceptionColorEnum;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;

public class PMRPSignalLampUI
extends AbstractPMRPSignalLampUI {
    private static final long serialVersionUID = 1564654141L;
    private PMRPRunExceptionCollection numberCol = null;
    private EventListener listeners = new EventListener();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.loadFields();
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getColumn("id").getStyleAttributes().setHided(true);
    }

    protected void initListener() {
        this.tblMain.removeKDTEditListener((KDTEditListener)this.listeners);
        this.tblMain.addKDTEditListener((KDTEditListener)this.listeners);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.loadData();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void loadData() throws BOSException {
        try {
            String storageOrgUnit = (String)this.getUIContext().get("storageOrgUnit");
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemInfo storageItemInfo = new FilterItemInfo("storageOrgUnit.number", (Object)storageOrgUnit, CompareType.EQUALS);
            filter.getFilterItems().add(storageItemInfo);
            viewInfo.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("mrpRunExceptionGroup.*"));
            selector.add(new SelectorItemInfo("storageOrgUnit.*"));
            viewInfo.setSelector(selector);
            SorterItemCollection sortColl = new SorterItemCollection();
            SorterItemInfo item = new SorterItemInfo("mrpRunExceptionGroup.number");
            item.setSortType(SortType.ASCEND);
            sortColl.add(item);
            item = new SorterItemInfo("number");
            item.setSortType(SortType.ASCEND);
            sortColl.add(item);
            viewInfo.setSorter(sortColl);
            this.numberCol = PMRPRunExceptionFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).getPMRPRunExceptionCollection(viewInfo);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        IRow row = null;
        this.tblMain.getColumn("mrpRunExceptionGroup.name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("desciption").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("red").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("yellow").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("green").getStyleAttributes().setLocked(true);
        KDCheckBox chkBox = new KDCheckBox();
        chkBox.setSelected(true);
        this.tblMain.getColumn("red").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)chkBox));
        this.tblMain.getColumn("yellow").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)chkBox));
        this.tblMain.getColumn("green").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)chkBox));
        CellCheckBoxRenderer chkRender = new CellCheckBoxRenderer();
        chkRender.setBlackWhite(true);
        this.tblMain.getColumn("red").setRenderer((IBasicRender)chkRender);
        this.tblMain.getColumn("yellow").setRenderer((IBasicRender)chkRender);
        this.tblMain.getColumn("green").setRenderer((IBasicRender)chkRender);
        this.tblMain.removeRows();
        for (int i = 0; i < this.numberCol.size(); ++i) {
            row = this.tblMain.addRow();
            row.getCell("mrpRunExceptionGroup.name").setValue((Object)this.numberCol.get(i).getMrpRunExceptionGroup().getName());
            row.getCell("number").setValue((Object)this.numberCol.get(i).getNumber());
            row.getCell("desciption").setValue((Object)this.numberCol.get(i).getDescription());
            row.getCell("red").setValue((Object)Boolean.valueOf("false"));
            row.getCell("yellow").setValue((Object)Boolean.valueOf("false"));
            row.getCell("green").setValue((Object)Boolean.valueOf("false"));
            MRPRunExceptionColorEnum color = this.numberCol.get(i).getColor();
            row.getCell("color").setValue((Object)color);
            if (color == null) continue;
            if (color == MRPRunExceptionColorEnum.red) {
                row.getCell("red").setValue((Object)Boolean.valueOf("true"));
                continue;
            }
            if (color == MRPRunExceptionColorEnum.yellow) {
                row.getCell("yellow").setValue((Object)Boolean.valueOf("true"));
                continue;
            }
            if (color != MRPRunExceptionColorEnum.green) continue;
            row.getCell("green").setValue((Object)Boolean.valueOf("true"));
        }
        this.tblMain.getGroupManager().group();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("mrpRunExceptionGroup.name").setGroup(true);
        this.tblMain.getColumn("mrpRunExceptionGroup.name").setMergeable(true);
        this.tblMain.repaint();
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    private void tableValueChanged(KDTEditEvent e) throws BOSException {
        int selectedRow = e.getRowIndex();
        int selectedCol = e.getColIndex();
        Object newValue = e.getValue();
        IRow curRow = this.tblMain.getRow(selectedRow);
        if (newValue != null && newValue.equals(e.getOldValue())) {
            return;
        }
        int colRed = this.tblMain.getColumnIndex("red");
        int colGreen = this.tblMain.getColumnIndex("green");
        int colYellow = this.tblMain.getColumnIndex("yellow");
        if (selectedCol == colRed) {
            this.redChanged(curRow, newValue);
        }
        if (selectedCol == colGreen) {
            this.greenChanged(curRow, newValue);
        }
        if (selectedCol == colYellow) {
            this.yellowChanged(curRow, newValue);
        }
    }

    private void redChanged(IRow curRow, Object newValue) {
        String color = newValue.toString();
        if (color.equals("true")) {
            curRow.getCell("yellow").setValue((Object)Boolean.valueOf("false"));
            curRow.getCell("green").setValue((Object)Boolean.valueOf("false"));
        }
    }

    private void yellowChanged(IRow curRow, Object newValue) {
        String color = newValue.toString();
        if (color.equals("true")) {
            curRow.getCell("red").setValue((Object)Boolean.valueOf("false"));
            curRow.getCell("green").setValue((Object)Boolean.valueOf("false"));
        }
    }

    private void greenChanged(IRow curRow, Object newValue) {
        String color = newValue.toString();
        if (color.equals("true")) {
            curRow.getCell("yellow").setValue((Object)Boolean.valueOf("false"));
            curRow.getCell("red").setValue((Object)Boolean.valueOf("false"));
        }
    }

    private class EventListener
    implements KDTEditListener {
        private EventListener() {
        }

        public void editStopped(KDTEditEvent e) {
        }

        public void editStopping(KDTEditEvent e) {
        }

        public void editValueChanged(KDTEditEvent e) {
            try {
                PMRPSignalLampUI.this.tableValueChanged(e);
            }
            catch (BOSException e1) {
                PMRPSignalLampUI.this.handUIException(e1);
            }
        }

        public void editCanceled(KDTEditEvent e) {
        }

        public void editStarted(KDTEditEvent e) {
        }

        public void editStarting(KDTEditEvent e) {
        }
    }
}

