/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.batch.impl;

import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.batch.IPMRPBatchPolicy;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.batch.PMRPBatchPolicyFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPBatchPolicyResult;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPBatchPolicyVO;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.vo.PMRPDetailInfo;
import java.math.BigDecimal;

public abstract class AbstractPMRPPeriodBatchPolicy
implements IPMRPBatchPolicy {
    private String materialID = null;
    protected int counter = 0;
    private BigDecimal totalQty = null;
    private int startPeroid = -1;
    private int lastPeroid = -1;
    private boolean isEndDay = false;
    private BigDecimal netRequirementQty = null;
    private BigDecimal lastNetRequirementQty = null;
    protected BigDecimal dayReqQty = null;
    private BigDecimal dayNetReqQty = null;
    protected BigDecimal ZERO = new BigDecimal("0.00");
    private PMRPDetailInfo orderLine = null;
    private PMRPCalcParam runParam;
    private boolean isCaculated = false;

    public boolean isCaculated() {
        return this.isCaculated;
    }

    public void setCaculated(boolean isCaculated) {
        this.isCaculated = isCaculated;
    }

    public String getMaterialID() {
        return this.materialID;
    }

    public void setMaterialID(String materialID) {
        this.materialID = materialID;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public BigDecimal getTotalQty() {
        return this.totalQty;
    }

    public void setTotalQty(BigDecimal totalQty) {
        this.totalQty = totalQty;
    }

    public int getStartPeroid() {
        return this.startPeroid;
    }

    public void setStartPeroid(int startPeroid) {
        this.startPeroid = startPeroid;
    }

    public BigDecimal getNetRequirementQty() {
        return this.netRequirementQty;
    }

    public void setNetRequirementQty(BigDecimal netRequirementQty) {
        this.netRequirementQty = netRequirementQty;
    }

    public BigDecimal getLastNetRequirementQty() {
        return this.lastNetRequirementQty;
    }

    public void setLastNetRequirementQty(BigDecimal lastNetRequirementQty) {
        this.lastNetRequirementQty = lastNetRequirementQty;
    }

    public PMRPDetailInfo getOrderLine() {
        return this.orderLine;
    }

    public void setOrderLine(PMRPDetailInfo orderLine) {
        this.orderLine = orderLine;
    }

    public boolean isEndDay() {
        return this.isEndDay;
    }

    public void setEndDay(boolean isEndDay) {
        this.isEndDay = isEndDay;
    }

    public int getLastPeroid() {
        return this.lastPeroid;
    }

    public void setLastPeroid(int lastPeroid) {
        this.lastPeroid = lastPeroid;
    }

    public PMRPCalcParam getRunParam() {
        return this.runParam;
    }

    public void setRunParam(PMRPCalcParam runParam) {
        this.runParam = runParam;
    }

    @Override
    public void initRunParam(PMRPCalcParam runParam) {
        this.setRunParam(runParam);
    }

    @Override
    public PMRPBatchPolicyResult[] batchComputing(PMRPBatchPolicyVO batchPolocyVO) throws PMRPException {
        this.setCaculated(false);
        this.netRequirementQty = batchPolocyVO.getNetRequirementQty();
        this.dayNetReqQty = batchPolocyVO.getSurPlusQty();
        this.dayReqQty = batchPolocyVO.getDayReqQty();
        this.isEndDay = batchPolocyVO.isEndDay();
        if (this.startPeroid == -1 && this.netRequirementQty.compareTo(this.ZERO) < 0) {
            this.startPeroid = batchPolocyVO.getCurrentPeriod();
        }
        if (batchPolocyVO.getOrderLine() != null) {
            this.orderLine = batchPolocyVO.getOrderLine();
        } else {
            batchPolocyVO.setOrderLine(this.orderLine);
        }
        if (this.ZERO.compareTo(this.dayNetReqQty) < 0) {
            if (this.counter > 0) {
                return this.calBatchQty(batchPolocyVO, this.lastNetRequirementQty);
            }
            this.lastNetRequirementQty = this.netRequirementQty;
        } else {
            if (!this.isNeedCouner()) {
                this.lastNetRequirementQty = this.netRequirementQty;
                this.lastPeroid = batchPolocyVO.getCurrentPeriod();
                return null;
            }
            this.updateCounter(batchPolocyVO);
            if (this.counter == batchPolocyVO.getCycle() || this.isEndDay) {
                BigDecimal tempQty = this.netRequirementQty;
                if (this.isEndDay) {
                    tempQty = this.lastNetRequirementQty;
                }
                return this.calBatchQty(batchPolocyVO, tempQty);
            }
            this.lastNetRequirementQty = this.netRequirementQty;
        }
        this.lastPeroid = batchPolocyVO.getCurrentPeriod();
        return null;
    }

    protected PMRPBatchPolicyResult[] calBatchQty(PMRPBatchPolicyVO batchPolocyVO, BigDecimal netQty) throws PMRPException {
        batchPolocyVO.setNetRequirementQty(netQty);
        batchPolocyVO.setCurrentPeriod(this.startPeroid);
        IPMRPBatchPolicy direct = PMRPBatchPolicyFactory.createInstance(2, this.runParam);
        this.reset();
        this.setCaculated(true);
        return direct.batchComputing(batchPolocyVO);
    }

    protected abstract boolean updateCounter(PMRPBatchPolicyVO var1);

    protected boolean isNeedUpdateCounter() {
        return !this.isEndDay;
    }

    private boolean isNeedCouner() {
        return !this.isEndDay || this.counter > 0;
    }

    protected void reset() {
        this.counter = 0;
        this.totalQty = null;
        this.startPeroid = -1;
        this.lastPeroid = -1;
        this.isEndDay = false;
        this.netRequirementQty = null;
        this.dayReqQty = null;
        this.dayNetReqQty = null;
        this.lastNetRequirementQty = null;
    }
}

