/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.rf.step.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.AbstractPlanDefinedInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.PlanDefinedFactory;
import com.kingdee.eas.industry.emm.project.biz.basedata.PurRelationshipDefinitionEntryInfo;
import com.kingdee.eas.industry.emm.project.biz.basedata.PurRelationshipDefinitionInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderMappingFacadeFactory;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.rf.step.IReleaseStep;
import com.kingdee.eas.industry.update8.Material8FacadeFactory;
import com.kingdee.eas.scm.sm.sc.DosingTypeEnum;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryInfo;
import com.kingdee.eas.scm.sm.sc.SubContractOrderFactory;
import com.kingdee.eas.scm.sm.sc.SubContractOrderInfo;
import com.kingdee.eas.scm.sm.sc.SubMaterialListCollection;
import java.math.BigDecimal;
import java.util.Map;

public class SubContractOrderInfoReleaseStep
implements IReleaseStep {
    @Override
    public void action(Context ctx, CoreBillBaseInfo targetInfo, PMRPPlannedOrderInfo plannedOrderInfo, BigDecimal fReleaseQty) throws BOSException, EASBizException {
        this.subContractOrderDeal(ctx, (SubContractOrderInfo)targetInfo, plannedOrderInfo, fReleaseQty);
    }

    @Override
    public void action(Context ctx, CoreBillBaseInfo targetInfo, CoreBillBaseCollection plannedOrderCollection, Map ReleaseQtyMap) throws BOSException, EASBizException {
        for (int i = 0; i < plannedOrderCollection.size(); ++i) {
            PMRPPlannedOrderInfo plannedOrderInfo = (PMRPPlannedOrderInfo)plannedOrderCollection.get(i);
            BigDecimal fReleaseQty = new BigDecimal(ReleaseQtyMap.get(plannedOrderInfo.getId().toString()).toString());
            this.subContractOrderDeal(ctx, (SubContractOrderInfo)targetInfo, plannedOrderInfo, fReleaseQty);
        }
        if (targetInfo != null) {
            this.genSubMaterialListInfo(ctx, (SubContractOrderInfo)targetInfo);
        }
        SubContractOrderFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)targetInfo);
    }

    protected void genSubMaterialListInfo(Context ctx, SubContractOrderInfo info) throws BOSException, EASBizException {
        if (info.getEntries() != null && info.getEntries().size() > 0) {
            for (int i = 0; i < info.getEntries().size(); ++i) {
                SubMaterialListCollection subMLCollection = SubContractOrderFactory.getLocalInstance((Context)ctx).getSubMaterialListByBOM(info, info.getEntries().get(i));
                if (subMLCollection == null) continue;
                info.getEntries().get(i).getEntries1().clear();
                info.getEntries().get(i).getEntries1().addCollection(subMLCollection);
            }
        }
    }

    @Override
    public void afterResolved(Context ctx) throws BOSException, EASBizException {
    }

    protected void subContractOrderDeal(Context ctx, SubContractOrderInfo subContractOrderInfo, PMRPPlannedOrderInfo plannedOrderInfo, BigDecimal fReleaseQty) throws BOSException, EASBizException {
        if (subContractOrderInfo == null) {
            return;
        }
        if (subContractOrderInfo.getSourceBillId() == null) {
            subContractOrderInfo.setSourceBillId(plannedOrderInfo.getId().toString());
        }
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)Constants.PRMPPlannedOrderBizTypeID));
        if (subContractOrderInfo.getSourceBillType() == null) {
            subContractOrderInfo.setSourceBillType(billTypeInfo);
        }
        StorageOrgUnitInfo storageOrgUnitInfo = plannedOrderInfo.getStorageOrgUnit();
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        if (subContractOrderInfo.getCompanyOrgUnit() == null) {
            String[] s = new String[]{storageOrgUnitInfo.getId().toString()};
            Map companyOrgmap = PMRPPlannedOrderMappingFacadeFactory.getLocalInstance(ctx).getCouOrgUnit(s);
            if (companyOrgmap != null) {
                CompanyOrgUnitInfo companyOrgUnitInfo = null;
                String fcompID = companyOrgmap.get(storageOrgUnitInfo.getId().toString()).toString();
                companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(fcompID));
                subContractOrderInfo.setCompanyOrgUnit(companyOrgUnitInfo);
            }
        }
        if (subContractOrderInfo.getAdminOrgUnit() == null) {
            subContractOrderInfo.setAdminOrgUnit(plannedOrderInfo.getAdminOrgUnit());
        }
        AbstractPlanDefinedInfo pdinfo = null;
        if (subContractOrderInfo.getPurchaseOrgUnit() == null) {
            if (purchaseOrgUnitInfo == null) {
                if (plannedOrderInfo.getScheme() != null) {
                    sic.add(new SelectorItemInfo("*"));
                    sic.add(new SelectorItemInfo("PurchaseRelation.id"));
                    sic.add(new SelectorItemInfo("PurchaseRelation.Entry.*"));
                    pdinfo = PlanDefinedFactory.getLocalInstance(ctx).getPlanDefinedInfo((IObjectPK)new ObjectUuidPK(plannedOrderInfo.getScheme().getId()), sic);
                }
                if (pdinfo != null && pdinfo.getPurchaseRelation() != null) {
                    PurRelationshipDefinitionInfo purRelInto = pdinfo.getPurchaseRelation();
                    for (int j = 0; j < purRelInto.getEntry().size(); ++j) {
                        PurRelationshipDefinitionEntryInfo purRelEntryInto = purRelInto.getEntry().get(j);
                        if (purRelEntryInto.getProductOrgUnit() == null || purRelEntryInto.getPurchaseOrgUnit() == null || !purRelEntryInto.getProductOrgUnit().getId().toString().equals(storageOrgUnitInfo.getId().toString())) continue;
                        purchaseOrgUnitInfo = new PurchaseOrgUnitInfo();
                        purchaseOrgUnitInfo.setId(BOSUuid.read((String)purRelEntryInto.getPurchaseOrgUnit().getId().toString()));
                        subContractOrderInfo.setPurchaseOrgUnit(purchaseOrgUnitInfo);
                    }
                }
            } else {
                subContractOrderInfo.setPurchaseOrgUnit(purchaseOrgUnitInfo);
            }
        } else {
            purchaseOrgUnitInfo = subContractOrderInfo.getPurchaseOrgUnit();
        }
        for (int i = 0; i < subContractOrderInfo.getEntries().size(); ++i) {
            MaterialPlanInfo mpInfo;
            MaterialPurchasingInfo mp;
            SubContractOrderEntryInfo entryInfo = subContractOrderInfo.getEntries().get(i);
            if (entryInfo.getSourceBillId() == null || !entryInfo.getSourceBillId().equals(plannedOrderInfo.getId().toString())) continue;
            if (entryInfo.getReceiveCompanyOrgUnit() == null && subContractOrderInfo.getCompanyOrgUnit() != null) {
                entryInfo.setReceiveCompanyOrgUnit(subContractOrderInfo.getCompanyOrgUnit());
            }
            entryInfo.setQty(fReleaseQty);
            entryInfo.setBaseQty(fReleaseQty);
            entryInfo.setUnReceiptBaseQty(fReleaseQty);
            entryInfo.setUnReceiptQty(fReleaseQty);
            entryInfo.setUnReceiveBaseQty(fReleaseQty);
            entryInfo.setUnReceiveQty(fReleaseQty);
            if (entryInfo.getReceiveOrgUnit() == null) {
                entryInfo.setReceiveOrgUnit(plannedOrderInfo.getStorageOrgUnit());
            }
            if (entryInfo.getSourceBillNumber() == null) {
                entryInfo.setSourceBillNumber(plannedOrderInfo.getNumber());
            }
            if (entryInfo.getSourceBillId() == null) {
                entryInfo.setSourceBillId(plannedOrderInfo.getId().toString());
            }
            if (entryInfo.getSourceBillType() == null) {
                entryInfo.setSourceBillType(billTypeInfo);
            }
            if (entryInfo.getMaterial() != null && purchaseOrgUnitInfo != null && (subContractOrderInfo.getPurchaseGroup() == null || subContractOrderInfo.getPurchasePerson() == null) && (mp = Material8FacadeFactory.getLocalInstance((Context)ctx).getPurchasingInfo(entryInfo.getMaterial().getId().toString(), purchaseOrgUnitInfo.getId().toString())) != null) {
                subContractOrderInfo.setPurchaseGroup(mp.getPurGroup());
                subContractOrderInfo.setPurchasePerson(mp.getPurPerson());
            }
            if (entryInfo.getDosingType() == null) {
                entryInfo.setDosingType(DosingTypeEnum.BOM);
            }
            if (entryInfo.getRequestOrgUnit() == null) {
                entryInfo.setRequestOrgUnit(entryInfo.getReceiveOrgUnit());
                entryInfo.setRequestCompanyOrgUnit(entryInfo.getReceiveCompanyOrgUnit());
            }
            if (entryInfo.getBom() == null) {
                entryInfo.setBom(plannedOrderInfo.getBom());
            }
            if (entryInfo.getAdminOrgUnit() == null && (mpInfo = Material8FacadeFactory.getLocalInstance((Context)ctx).getPlanInfo(entryInfo.getMaterial().getId().toString(), entryInfo.getReceiveOrgUnit().getId().toString())) != null) {
                entryInfo.setAdminOrgUnit(mpInfo.getDutyDepartment());
            }
            if (entryInfo.getDeliveryDate() == null) {
                entryInfo.setDeliveryDate(plannedOrderInfo.getAvilableDate());
            }
            if (entryInfo.getUnit() != null) continue;
            entryInfo.setUnit(plannedOrderInfo.getUnit());
        }
    }
}

