/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPResource;
import com.kingdee.eas.industry.emm.project.biz.mrp.app.PMRPBomMatch;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPRunTableManager;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IConfigurableStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IPMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.PMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand.PMRPAjustResult;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand.PMRPCalcNoSubMaterials;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand.PMRPCalcSurplusDivertMaterials;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.sec.netdemand.PMRPDependentReqGenerator;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.IPMRPTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.BOMExpandTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.BOMLLCTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.CalcDetailTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.InventoryDetailTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.OrgUnitStatisticsTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.StatisticsTableDefine;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.planning.app.mrp.MRPPlanStrategyUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPSeqUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class PMRPCalcNetDemand
extends PMRPStep
implements IConfigurableStep {
    private int progressPrecent = 90;

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    @Override
    protected int getProgressPercent() {
        return this.progressPrecent;
    }

    @Override
    public String getStepDesc(Locale locale) {
        return PMRPResource.getString(locale, "SP_CALCNETDEMAND");
    }

    @Override
    protected void logBegin() throws BOSException, PMRPException {
        super.logBegin();
        String msg = "60.00:" + this.getStepDesc(this.runParam.getEasCtx().getLocale()) + PMRPResource.getString(this.runParam.getEasCtx().getLocale(), "SYM_BEGIN");
        if (logger.isInfoEnabled()) {
            logger.info((Object)(this.runParam.getRunLog().getNumber() + ":" + msg));
        }
    }

    @Override
    protected Object innerExecute(PMRPCalcParam runParam) throws PMRPException, BOSException {
        List<Integer> lowerLevelCodeLst = PMRPCalcNetDemand.getAllLevelCode(runParam);
        if (!lowerLevelCodeLst.contains(99)) {
            lowerLevelCodeLst.add(99);
        }
        PMRPCalcNoSubMaterials netCalcLevel = new PMRPCalcNoSubMaterials();
        PMRPDependentReqGenerator depReqGen = new PMRPDependentReqGenerator();
        PMRPCalcSurplusDivertMaterials netCalcLevelForSurplusDivert = new PMRPCalcSurplusDivertMaterials();
        int stepSepIndex = 1;
        int levelPercent = this.getProgressPercent() / lowerLevelCodeLst.size();
        for (int index = 0; index < lowerLevelCodeLst.size(); ++index) {
            int level = lowerLevelCodeLst.get(index);
            runParam.setLevel(level);
            String logMessage = "LLC\uff1a" + level;
            logger.info((Object)("1:release previous data: " + logMessage));
            runParam.getTableManager().realeaseTempTableDefine(runParam.getEasCtx(), StatisticsTableDefine.class);
            runParam.getTableManager().realeaseTempTableDefine(runParam.getEasCtx(), OrgUnitStatisticsTableDefine.class);
            logger.info((Object)("2:daysStatistics: " + logMessage));
            int cnt = this.daysStatistics(runParam);
            logger.info((Object)("3:searchBom: " + logMessage));
            if (cnt > 0) {
                this.searchBom(runParam);
            }
            logger.info((Object)("4:netCalcLevel: " + logMessage));
            netCalcLevel.createLogInfo(runParam, this.getLogInfo(), stepSepIndex++);
            netCalcLevel.setProgressPercent((int)((double)levelPercent * 0.33));
            PMRPAjustResult result = (PMRPAjustResult)netCalcLevel.execute(runParam);
            if (cnt == 0) continue;
            boolean hasSurplusMaterials = false;
            Vector<Object[]> materialFristPeriodList = new Vector<Object[]>();
            if (runParam.getAdvanceType() == 0) {
                netCalcLevelForSurplusDivert.setSqlList(materialFristPeriodList);
                List<List<String>> materials = netCalcLevelForSurplusDivert.distrubteMaterials(runParam);
                boolean bl = hasSurplusMaterials = materials != null && materials.size() > 0;
                if (hasSurplusMaterials) {
                    logger.info((Object)("5:surplusDivert: " + logMessage));
                    netCalcLevelForSurplusDivert.createLogInfo(runParam, this.getLogInfo(), stepSepIndex++);
                    netCalcLevelForSurplusDivert.setProgressPercent((int)((double)levelPercent * 0.1));
                    PMRPAjustResult divertResult = (PMRPAjustResult)netCalcLevelForSurplusDivert.execute(runParam);
                    this.dataAmount += divertResult.getDataAmount();
                }
            }
            logger.info((Object)("6:depReqGen: " + logMessage));
            depReqGen.createLogInfo(runParam, this.getLogInfo(), stepSepIndex++);
            depReqGen.execute(runParam);
            logger.info((Object)("7:inventoryStatistics: " + logMessage));
            this.inventoryStatistics();
            logger.info((Object)("8:insertNullInv: " + logMessage));
            if (hasSurplusMaterials) {
                this.insertNullInv(materialFristPeriodList);
            }
            this.dataAmount += result.getDataAmount();
        }
        logger.info((Object)"9:undistributeInvStatistics ");
        this.undistributeInvStatistics();
        logger.info((Object)"10:releaseTable ");
        runParam.getTableManager().realeaseTempTableDefine(runParam.getEasCtx(), StatisticsTableDefine.class);
        runParam.getTableManager().realeaseTempTableDefine(runParam.getEasCtx(), OrgUnitStatisticsTableDefine.class);
        return null;
    }

    private void searchBom(PMRPCalcParam runParam) throws BOSException, PMRPException {
        PMRPRunTableManager manager = runParam.getTableManager();
        try {
            String retTable;
            IPMRPTableDefine tableDefine = manager.getTempTableDefine(BOMExpandTableDefine.class);
            tableDefine.createTable(runParam.getEasCtx());
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append(" insert into ").append(tableDefine.getTableName()).append(" (FID,FMaterialID,fTrackId,FProjectID,FStorageOrgUnitID,fManufactureStrategyId,").append(" FExpandTraceId,fLevel,fMaterialAttr,fIsolatedRule,fbomType,ftrackNumber) ").append(" select Distinct t1.FID,t1.FMaterialID,").append(" t1.FTRACKID FTrackID,").append(" t1.FPROJECTID FProjectID,").append(" t1.FSupplyOrgUnitID As FStorageOrgUnitID ,").append(" mp.fplanstrategy,t1.FID,0,t1.FMaterialAttr,mp.fisolatedrule,").append(45).append(" ,t1.FTrackNumber ").append(" from ").append(manager.getTempTableDefine(CalcDetailTableDefine.class).getTableName()).append(" t1 inner join t_bd_materialPlan mp on mp.forgunit = t1.FSupplyOrgUnitID ").append(" and mp.FMaterialID = t1.FMaterialID ").append(" where t1.FBOMID is null and t1.FMRPClassify in (30,10) ").append(" AND t1.FLowsetCode = ?");
            Object[] params = new Object[]{runParam.getLevel()};
            int count = MRPUtil.executeUpdate((Context)runParam.getEasCtx(), (String)sqlBuf.toString(), (Object[])params);
            if (count > 0 && (retTable = new PMRPBomMatch().matchBomForMRP(runParam, tableDefine.getTableName())) != null) {
                sqlBuf.setLength(0);
                sqlBuf.append("update ").append(manager.getTempTableDefine(CalcDetailTableDefine.class).getTableName()).append(" as t0 set (fbomid,FYield,fbomtype )= ( select t1.fbomid ,t1.FYield ,t1.fbomtype from ").append(retTable).append(" t1  where t1.fid = t0.fid and  t1.fbomid  is not null )");
                MRPUtil.executeUpdate((Context)runParam.getEasCtx(), (String)sqlBuf.toString());
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            manager.realeaseTempTableDefine(runParam.getEasCtx(), BOMExpandTableDefine.class);
        }
    }

    private int daysStatistics(PMRPCalcParam runParam) throws PMRPException, BOSException {
        PMRPRunTableManager manager = runParam.getTableManager();
        StringBuffer sql = new StringBuffer();
        IPMRPTableDefine tableDefine = manager.getTempTableDefine(StatisticsTableDefine.class);
        String tableName = tableDefine.createTable(runParam.getEasCtx()).getTableName();
        sql.setLength(0);
        sql.append("Insert into ").append(tableName).append("(").append("KSQL_SEQ").append(",FID").append(",FMaterialId").append(",FPlanStrategy").append(",FPeriod").append(",FProjectNumber").append(",FTrackNumber").append(",FSQty").append(",FRQty").append(",FDetailcount").append(",FSubstituteGroup").append(",FCalcSeq").append(",FMaterialNumber").append(",FSurplusQty").append(",FSupplyOrgUnitID").append(",FOrgUnitID").append(",FProjectId").append(",FTrackNumberId").append(",FMaterialAttr").append(") \r\n");
        sql.append("select ").append("newbosid('").append(Constants.BosType.MRP_RUN_lOG).append("') FID").append(", FMaterialID,FPlanStrategy,FPeriod,FProjectNumber,FTrackNumber,sum(FSQty),sum(FRQty),sum(FDetailcount),FSubstituteGroup,FCalcSeq,FMaterialNumber,sum(FSurplusQty),FSupplyOrgUnitID,FOrgUnitID,FProjectID,FTrackID,FMaterialAttr ").append(" from (").append("select d.FMaterialId FMaterialID").append(",mp.FManufactureStrategyID FPlanStrategy").append(",d.FPeriod FPeriod").append(",isnull(d.FProjectNumber,'*') FProjectNumber").append(",isnull(d.FTrackNumber,'*') FTrackNumber").append(",sum(d.fsr) FSQty").append(",sum(case when ISNULL(mp.FIsMargin, 0) = 1 and d.fmrpitem=120 then 0 else d.FIndependent+ d.FDependent end) FRQty").append(",count(1) FDetailcount").append(",0 As FSubstituteGroup").append(",0 As FCalcSeq").append(",Null As FMaterialNumber").append(",(sum(d.fsr) + sum(case when ISNULL(mp.FIsMargin, 0) =1 and d.fmrpitem=120 then 0 else d.FIndependent + d.FDependent end)) FSurplusQty").append(",d.FSupplyOrgUnitID FSupplyOrgUnitID").append(",null As  FOrgUnitID").append(",isnull(d.FPROJECTID,'*') FProjectID").append(",isnull(d.FTRACKID,'*') FTrackID").append(",d.FMaterialAttr FMaterialAttr").append(" from ").append(manager.getTempTableDefine(CalcDetailTableDefine.class).getTableName()).append(" d").append(" inner join t_bd_materialplan mp on mp.fmaterialid = d.FMaterialId and mp.forgunit = d.FSupplyOrgUnitID").append(" where Isnull(d.FLowsetCode,99) = ").append(runParam.getLevel()).append(" and d.FMRPItem<>").append(110).append(" group by d.FPeriod").append(",d.FMaterialId").append(",mp.FManufactureStrategyID").append(",d.FProjectNumber").append(",d.FTrackNumber").append(",d.FSupplyOrgUnitID").append(",d.FPROJECTID").append(",d.FTRACKID").append(",d.FMaterialAttr").append(" order by d.FPeriod,d.FMaterialId,d.FSupplyOrgUnitID,d.FProjectNumber,d.FTrackNumber").append(") ").append(" group by FMaterialID,FPlanStrategy,FPeriod,FProjectNumber,FTrackNumber,FSubstituteGroup,FCalcSeq,FMaterialNumber,FSupplyOrgUnitID,FOrgUnitID,FProjectID,FTrackID,FMaterialAttr ").append(" order by FPeriod,FMaterialId,FSupplyOrgUnitID,FProjectNumber,FTrackNumber");
        int rowsize = MRPUtil.executeUpdate((Context)runParam.getEasCtx(), (String)sql.toString());
        IPMRPTableDefine OrgUnittableDefine = manager.getTempTableDefine(OrgUnitStatisticsTableDefine.class);
        String OrgUnittableName = OrgUnittableDefine.createTable(runParam.getEasCtx()).getTableName();
        sql.setLength(0);
        sql.append("Insert into ").append(OrgUnittableName).append("(").append("FID").append(",FPID").append(",FOrgUnitID").append(",FSQty").append(",FRQty").append(") \r\n");
        sql.append("select ").append("newbosid('").append(Constants.BosType.MRP_RUN_lOG).append("') FID").append(",ss.fid  FPID").append(",d.FOrgUnitID FOrgUnitID").append(",sum(d.fsr) FSQty").append(",sum(case when ISNULL(mp.FIsMargin, 0) =1 and d.fmrpitem=120 then 0 else d.FIndependent+ d.FDependent end) FRQty ").append(" from ").append(manager.getTempTableDefine(CalcDetailTableDefine.class).getTableName()).append(" d").append(" inner join t_bd_materialplan mp on mp.fmaterialid = d.FMaterialId and mp.forgunit = d.FSupplyOrgUnitID").append(" inner join  ").append(tableName).append(" ss on d.FPeriod = ss.FPeriod").append(" and d.FMaterialId = ss.FMaterialId").append(" and mp.FManufactureStrategyID = ss.FPlanStrategy").append(" and isnull(d.FProjectNumber, '*') = isnull(ss.FProjectNumber, '*')").append(" and isnull(d.FTrackNumber, '*') = isnull(ss.FTrackNumber, '*')").append(" and d.FSupplyOrgUnitID = ss.FSupplyOrgUnitID").append(" and isnull(d.FPROJECTID, '*') = isnull(ss.FProjectId, '*')").append(" and isnull(d.FTRACKID, '*') = isnull(ss.FTrackNumberId, '*')").append(" and d.FMaterialAttr = ss.FMaterialAttr").append(" where Isnull(d.FLowsetCode,99) = ").append(runParam.getLevel()).append(" and d.FMRPItem<>").append(110).append(" and d.FOrgUnitID is not null ").append(" group by d.FPeriod").append(",d.FMaterialId").append(",mp.FManufactureStrategyID").append(",d.FProjectNumber").append(",d.FTrackNumber").append(",d.FSupplyOrgUnitID").append(",d.FOrgUnitID").append(",d.FPROJECTID").append(",d.FTRACKID").append(",d.FMaterialAttr").append(",ss.fid");
        MRPUtil.executeUpdate((Context)runParam.getEasCtx(), (String)sql.toString());
        return rowsize;
    }

    private void inventoryStatistics() throws BOSException, PMRPException {
        PMRPRunTableManager manager = this.runParam.getTableManager();
        IPMRPTableDefine tableDefine = manager.getTempTableDefine(StatisticsTableDefine.class);
        String statisticsTbl = tableDefine.getTableName();
        StringBuffer sql = new StringBuffer();
        IPMRPTableDefine lldwm = this.runParam.getTableManager().getTempTableDefine(BOMLLCTableDefine.class);
        sql.setLength(0);
        sql.append("insert into ").append(manager.getTempTableDefine(CalcDetailTableDefine.class).getTableName()).append(" ( FID ,FMRPItem").append(",FMRPClassify").append(",FMaterialID,FAvaliable,FPLANVERSIONID,FRUNLOGID").append(",FBILLDATE").append(",FPeriod").append(",FMrpSeq").append(",FProjectID").append(",FTrackID").append(",FProjectNumber").append(",FTrackNumber").append(",FBProjectID").append(",FBTrackID").append(",FBProjectNumber").append(",FBTrackNumber").append(",FIsDefaultTNO").append(",FMaterialAttr").append(",FPurChaseOrgUnitID").append(",ForgUnitID").append(",FLowsetCode").append(",FIsSurplusDivert").append(",FSupplyOrgUnitID").append(",FPlanStrategy").append(",FIsolatedRule").append(")\r\n").append(" select newbosid('").append(Constants.BosType.MRP_RUN_lOG).append("'), ").append(132).append(",").append(10).append(" ,FMaterialID ,FAvaliable").append(",'").append(this.runParam.getRunLog().getPlanDefined().getId()).append("'").append(",'").append(this.runParam.getRunLog().getId()).append("'").append(",TO_DATE('").append(new SimpleDateFormat("yyyy-MM-dd").format(this.runParam.getDateManager().getPlanDate(this.runParam.getStorageOrgUnitID()).getDate().getTime())).append("'),").append(this.runParam.getDateManager().getPlanDate(this.runParam.getStorageOrgUnitID()).getPeriod()).append(",'").append(MRPSeqUtil.DISTRIBUTE_INV_SEQ).append("' ").append(",FProjectId").append(",FTrackNumberId").append(",FProjectNumber").append(",FTrackNumber").append(",FProjectId").append(",FTrackNumberId").append(",FProjectNumber").append(",FTrackNumber").append(",FIsDefaultTNO").append(",FMaterialAttr").append(",Null As FPurChaseOrgUnitID").append(",FOrgUnitID").append(",FLowsetCode As FLowsetCode").append(",1 as FIsSurplusDivert").append(",FSupplyOrgUnitID As FSupplyOrgUnitID").append(",FManufactureStrategyID As FPlanStrategy").append(",FIsolatedRule As FIsolatedRule").append(" from ( select distinct ").append(" s.FMaterialID,s.FProjectNumber,s.FTrackNumber ,sum(s.FOnHand) as FAvaliable ,max(FIsDefaultTNO) as FIsDefaultTNO, ").append(" s.FMaterialAttr,s.FTrackNumberId,s.FProjectId,MP.FManufactureStrategyID,s.FSupplyOrgUnitID,s.FOrgUnitID ").append(" ,mp.FIsolatedRule,Isnull(lc.CFLowCode,").append(this.runParam.getLevel()).append(") As FLowsetCode").append(" from  ").append(statisticsTbl).append(" s  ").append(" left outer join t_bd_materialplan mp on mp.fmaterialid = s.FMaterialID and mp.forgunit = s.FSupplyOrgUnitID  ").append(" left outer join ").append(lldwm.getTableName()).append(" lc on lc.CFMaterialID = s.FMaterialID And lc.CFMaterialATTR = s.FMaterialAttr and isnull(lc.CFProjectID,'*') = isnull(s.FProjectId,'*') ").append(" where s.FOnHand >= 0 ").append(" group by s.FMaterialID,s.FProjectNumber,s.FTrackNumber, ").append(" s.FMaterialAttr,s.FTrackNumberId,s.FProjectId,MP.FManufactureStrategyID,s.FSupplyOrgUnitID,s.FOrgUnitID, ").append(" mp.FIsolatedRule,Isnull(lc.CFLowCode,").append(this.runParam.getLevel()).append(")").append(" ) as t");
        SQLUtils.execute((Context)this.runParam.getEasCtx(), (String)sql.toString());
    }

    private void undistributeInvStatistics() throws BOSException, PMRPException {
        PMRPRunTableManager manager = this.runParam.getTableManager();
        String calcTable = manager.getTempTableDefine(CalcDetailTableDefine.class).getTableName();
        String invTable = manager.getTempTableDefine(InventoryDetailTableDefine.class).getTableName();
        if (invTable == null || "".equals(invTable)) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        IPMRPTableDefine lldwm = this.runParam.getTableManager().getTempTableDefine(BOMLLCTableDefine.class);
        sql.append("insert into ").append(calcTable).append(" (FID ,FMRPClassify, FMRPItem,FMaterialID,FAvaliable,").append("FPLANVERSIONID,FRUNLOGID").append(",FBILLDATE").append(",FPeriod").append(",FMrpSeq").append(",FProjectID").append(",FTrackID").append(",FProjectNumber").append(",FTrackNumber").append(",FBProjectID").append(",FBTrackID").append(",FBProjectNumber").append(",FBTrackNumber").append(",FIsDefaultTNO").append(",FMaterialAttr").append(",FPurChaseOrgUnitID").append(",ForgUnitID").append(",FLowsetCode").append(",FIsSurplusDivert").append(",FSupplyOrgUnitID").append(",FPlanStrategy").append(",FIsolatedRule").append(")\r\n").append(" select newbosid('").append(Constants.BosType.MRP_RUN_lOG).append("'), ").append(10).append(",").append(131).append(" ,inv.FMaterialID ,inv.FAvaliable").append(",'").append(this.runParam.getRunLog().getPlanDefined().getId()).append("'").append(",'").append(this.runParam.getRunLog().getId()).append("'").append(",TO_DATE('").append(new SimpleDateFormat("yyyy-MM-dd").format(this.runParam.getDateManager().getPlanDate(this.runParam.getStorageOrgUnitID()).getDate().getTime())).append("'),").append(this.runParam.getDateManager().getPlanDate(this.runParam.getStorageOrgUnitID()).getPeriod()).append(",'").append(MRPSeqUtil.DISTRIBUTE_INV_SEQ).append("' ").append(",inv.FProjectId").append(",inv.FTrackID").append(",inv.FProjectNumber").append(",inv.FTrackNumber").append(",inv.FProjectId").append(",inv.FTrackID").append(",inv.FProjectNumber").append(",inv.FTrackNumber").append(",0 As FIsDefaultTNO").append(",mp.FMaterialAttr").append(",Null As FPurChaseOrgUnitID").append(",inv.FStorageOrgUnitID ").append(",Isnull(lc.CFLowCode, 99) As FLowsetCode").append(",1 as FIsSurplusDivert").append(",inv.FStorageOrgUnitID As FSupplyOrgUnitID").append(",mp.FManufactureStrategyID As FPlanStrategy").append(",mp.FIsolatedRule As FIsolatedRule").append(" from (select distinct FMaterialID,FStorageOrgUnitID,Sum(FBaseQty) As FAVALIABLE,FProjectID,FTrackID,FProjectNumber,FTrackNumber from ").append(invTable).append("  ").append(" where FBaseQty >= 0 ").append(" group by FMaterialID,FStorageOrgUnitID,FProjectID,FTrackID,FProjectNumber,FTrackNumber ) inv ").append(" left outer join t_bd_materialplan mp on mp.fmaterialid = inv.FMaterialID and mp.forgunit = inv.FStorageOrgUnitID  ").append(" left outer join ").append(lldwm.getTableName()).append(" lc on lc.CFMaterialID = inv.FMaterialID And lc.CFMaterialATTR = mp.FMaterialAttr and isnull(lc.CFProjectID,'*') = isnull(inv.FProjectId,'*') ");
        sql.append(" where mp.FMaterialAttr is not null ");
        SQLUtils.execute((Context)this.runParam.getEasCtx(), (String)sql.toString());
    }

    private void insertNullInv(List<Object[]> materialFristPeriodList) throws BOSException, PMRPException {
        PMRPRunTableManager manager = this.runParam.getTableManager();
        String calcTable = manager.getTempTableDefine(CalcDetailTableDefine.class).getTableName();
        String inventoryTable = manager.getTempTableDefine(InventoryDetailTableDefine.class).getTableName();
        String statisticsTable = manager.getTempTableDefine(StatisticsTableDefine.class).getTableName();
        StringBuffer sql = new StringBuffer();
        if (MMUtils.isEmptyString((String)inventoryTable)) {
            sql.append("insert into ").append(calcTable).append(" ( FID ,FMRPItem,FMaterialID,FProjectNumber,FTrackNumber,FBProjectNumber,FBTrackNumber,FAvaliable ").append(",FPLANVERSIONID,FRUNLOGID").append(",FBILLDATE").append(",FPeriod").append(",FIsDefaultTNO,FMrpSeq,FMaterialAttr)").append(" select newbosid('").append(Constants.BosType.MRP_RUN_lOG).append("'), ").append(110).append(" ,sta.FMaterialID ,sta.FProjectNumber,sta.FTrackNumber,sta.FProjectNumber,").append(" sta.FTrackNumber,0").append(",'").append(this.runParam.getRunLog().getPlanDefined().getId()).append("'").append(",'").append(this.runParam.getRunLog().getId()).append("'").append(",TO_DATE('").append(new SimpleDateFormat("yyyy-MM-dd").format(this.runParam.getDateManager().getPlanDate(this.runParam.getStorageOrgUnitID()).getDate().getTime())).append("'),").append(this.runParam.getDateManager().getPlanDate(this.runParam.getStorageOrgUnitID()).getPeriod()).append(",FIsDefaultTNO,'").append(MRPSeqUtil.INV_SEQ).append("',sta.FMaterialAttr ").append(" from ").append(statisticsTable).append(" sta  ").append(" where sta.FPlanStrategy in(").append(MRPPlanStrategyUtil.getInvPlanStrategyStr((boolean)true)).append(")").append(" group by sta.FMaterialID ,sta.FProjectNumber,sta.FTrackNumber,FIsDefaultTNO,sta.FMaterialAttr");
        } else {
            sql.append("insert into ").append(calcTable).append(" ( FID ,FMRPItem,FMaterialID,FProjectNumber,FTrackNumber,FBProjectNumber,FBTrackNumber,FAvaliable ").append(",FPLANVERSIONID,FRUNLOGID,FBILLDATE,FPeriod,FIsDefaultTNO,FMrpSeq,FMaterialAttr)").append(" select newbosid('").append(Constants.BosType.MRP_RUN_lOG).append("'), ").append(110).append(" ,sta.FMaterialID ,sta.FProjectNumber,sta.FTrackNumber,sta.FProjectNumber,").append(" sta.FTrackNumber,0").append(",'").append(this.runParam.getRunLog().getPlanDefined().getId()).append("'").append(",'").append(this.runParam.getRunLog().getId()).append("'").append(",TO_DATE('").append(new SimpleDateFormat("yyyy-MM-dd").format(this.runParam.getDateManager().getPlanDate(this.runParam.getStorageOrgUnitID()).getDate().getTime())).append("'),").append(this.runParam.getDateManager().getPlanDate(this.runParam.getStorageOrgUnitID()).getPeriod()).append(",FIsDefaultTNO,'").append(MRPSeqUtil.INV_SEQ).append("',sta.FMaterialAttr ").append(" from ").append(statisticsTable).append(" sta left join ").append(inventoryTable).append(" inv on sta.fmaterialid = inv.fmaterialid ").append(" and isnull(sta.fprojectNumber,'*')=isnull(inv.fprojectNumber,'*') and isnull(sta.ftrackNumber,'*')=isnull(inv.ftrackNumber,'*') ").append(" where inv.fid is null and sta.FPlanStrategy in(").append(MRPPlanStrategyUtil.getInvPlanStrategyStr((boolean)true)).append(")").append(" group by sta.FMaterialID ,sta.FProjectNumber,sta.FTrackNumber,FIsDefaultTNO,sta.FMaterialAttr");
        }
        SQLUtils.execute((Context)this.runParam.getEasCtx(), (String)sql.toString());
        if (materialFristPeriodList.size() != 0) {
            StringBuffer str = new StringBuffer();
            str.append("update ").append(calcTable).append(" set FPeriod=?").append(" ,FBILLDATE=?").append(" ,FSR=FAvaliable").append(" ,FPAB=FAvaliable").append(" where (FMRPItem = ").append(110).append(" OR FMRPItem =").append(120).append(")").append(" AND FMaterialID =?");
            SQLUtils.executeBatch((Context)this.runParam.getEasCtx(), (String)str.toString(), materialFristPeriodList);
        }
    }

    private static List<Integer> getAllLevelCode(PMRPCalcParam runParam) throws BOSException, PMRPException {
        ArrayList<Integer> lowerLevelCodeLst = new ArrayList<Integer>(10);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT CFLowCode FROM ");
        sql.append(runParam.getTableManager().getTempTableDefine(BOMLLCTableDefine.class).getTableName());
        sql.append(" ORDER BY CFLowCode ASC");
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString());
        try {
            while (rs.next()) {
                lowerLevelCodeLst.add(new Integer(rs.getInt(1)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return lowerLevelCodeLst;
    }

    @Override
    public IPMRPStep[] getSubs() {
        return new IPMRPStep[]{new PMRPCalcNoSubMaterials(), new PMRPDependentReqGenerator(), new PMRPCalcSurplusDivertMaterials()};
    }

    public static void checkMaterialPlan(PMRPCalcParam runParam) throws BOSException, PMRPException {
        StringBuilder sql = new StringBuilder();
        StringBuilder sqlerrtext = new StringBuilder();
        sql.append("SELECT DISTINCT ");
        sql.append(" m.fnumber as fmaterialNumber");
        sql.append(" ,m.fname_l2 as fmaterialName");
        sql.append(" ,mpc.fnumber as fpurchaseUnitNumber");
        sql.append(" ,mpc.fname_l2 as fpurchaseUnitName");
        sql.append(" ,ms.fnumber as fStorageOrgUnitNumber");
        sql.append(" ,ms.fname_l2 as fStorageOrgUnitame");
        sql.append(" ,mp.fid as fmpid");
        sql.append(" ,mp.fstatus as fmpstatus");
        sql.append(" ,a.FMaterialAttr as FMaterialAttr");
        sql.append(" FROM ");
        sql.append(runParam.getTableManager().getTempTableDefine(CalcDetailTableDefine.class).getTableName());
        sql.append(" a left outer join t_bd_material m on m.fid = a.FMaterialID ");
        sql.append(" left outer join t_org_purchase mpc on mpc.fid = a.FPurChaseOrgUnitID ");
        sql.append(" left outer join t_org_storage ms on ms.fid = a.FSupplyOrgUnitID ");
        sql.append(" left outer join t_bd_materialplan mp on mp.Fmaterialid = m.fid and mp.Forgunit = a.FSupplyOrgUnitID ");
        sql.append(" where (a.FSupplyOrgUnitID is null or ");
        sql.append(" mp.fid is null or ");
        sql.append(" mp.fstatus <> 1 )");
        sql.append(" and a.FMRPItem<>").append(110);
        sql.append(" and a.FMRPItem<>").append(120);
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString());
        logger.info((Object)(" materialPlan Data check,data rows = " + rs.size()));
        try {
            while (rs.next()) {
                String fmaterialNumber = rs.getString("fmaterialNumber");
                String fmaterialName = rs.getString("fmaterialName");
                String fpurchaseUnitNumber = rs.getString("fpurchaseUnitNumber");
                String fpurchaseUnitName = rs.getString("fpurchaseUnitName");
                String fStorageOrgUnitNumber = rs.getString("fStorageOrgUnitNumber");
                String fStorageOrgUnitame = rs.getString("fStorageOrgUnitame");
                String fmpid = rs.getString("fmpid");
                String fmpstatus = rs.getString("fmpstatus");
                if (sqlerrtext == null || sqlerrtext.length() < 1) {
                    sqlerrtext.append(PMRPCalcNetDemand.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0010")).append("[" + fmaterialNumber + "]" + fmaterialName + "");
                } else {
                    sqlerrtext.append("\r\n").append(PMRPCalcNetDemand.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0010")).append("[" + fmaterialNumber + "]" + fmaterialName + "");
                }
                if (fStorageOrgUnitNumber == null || "".equals(fStorageOrgUnitNumber)) {
                    if (fpurchaseUnitNumber != null && !"".equals(fpurchaseUnitNumber)) {
                        sqlerrtext.append(",").append(PMRPCalcNetDemand.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0126")).append("[" + fpurchaseUnitNumber + "]" + fpurchaseUnitName + "");
                    }
                    sqlerrtext.append(",").append(PMRPCalcNetDemand.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0127"));
                    continue;
                }
                if (fmpid == null || "".equals(fmpid)) {
                    sqlerrtext.append(",").append(PMRPCalcNetDemand.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0011")).append("[" + fStorageOrgUnitNumber + "]" + fStorageOrgUnitame + "");
                    continue;
                }
                sqlerrtext.append(",").append(PMRPCalcNetDemand.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0100"));
                if (fmpstatus != null && "1".equals(fmpstatus)) continue;
                sqlerrtext.append(",").append(PMRPCalcNetDemand.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0011")).append("[" + fStorageOrgUnitNumber + "]" + fStorageOrgUnitame + "");
                sqlerrtext.append(",").append(PMRPCalcNetDemand.getResourceString(runParam.getEasCtx(), "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0101"));
            }
            if (sqlerrtext != null && sqlerrtext.length() > 0) {
                logger.info((Object)(" materialPlan Data check,err result = " + sqlerrtext));
                throw new PMRPException(new NumericExceptionSubItem("", sqlerrtext.toString()));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private static String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }
}

