/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.concurrent.Callable;
import com.kingdee.bos.util.backport.concurrent.ExecutionException;
import com.kingdee.bos.util.backport.concurrent.Executor;
import com.kingdee.bos.util.backport.concurrent.ExecutorCompletionService;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonFactory;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPResource;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IConfigurableStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.IPMRPStep;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.PMRPStep;
import com.kingdee.eas.industry.emm.project.biz.psp.IStockingPlanDetail;
import com.kingdee.eas.industry.emm.project.biz.psp.PspStockingDemandInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanDetailFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanDetailInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanStatus;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanType;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PSPMatePurDatas
extends PMRPStep
implements IConfigurableStep {
    @Override
    protected Object innerExecute(PMRPCalcParam runParam) throws BOSException, PMRPException {
        List<String> materialIDList = this.getAllMaterialIDList(runParam);
        if (materialIDList == null || materialIDList.size() < 1) {
            return null;
        }
        int splitCount = 200;
        int times = materialIDList.size() / splitCount;
        if (materialIDList.size() % splitCount > 0) {
            ++times;
        }
        List<Object> subList = new ArrayList();
        ExecutorCompletionService ecs = new ExecutorCompletionService((Executor)runParam.getService());
        for (int i = 1; i <= times; ++i) {
            subList = i < times ? materialIDList.subList(splitCount * (i - 1), splitCount * i) : materialIDList.subList(splitCount * (i - 1), materialIDList.size());
            UpdateWorker worker = new UpdateWorker(runParam, subList);
            try {
                ecs.submit((Callable)worker);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        StringBuffer sql = new StringBuffer();
        try {
            for (int i = 1; i <= times; ++i) {
                this.dataAmount += ((Integer)ecs.take().get()).intValue();
                if (this.logInfo == null) continue;
                sql.setLength(0);
                sql.append("update ");
                sql.append(Constants.TableName.MRP_STEP_LOG_TABLE);
                sql.append(" set FDataAmount=? where FID = ?");
                DbUtil.execute((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new Object[]{new BigDecimal(this.getDataAmount()), this.logInfo.getId().toString()});
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new BOSException(e.getCause());
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            throw new BOSException(e.getCause());
        }
        return null;
    }

    private static StockingPlanDetailInfo addStockingPlanDetailInFo(Context ctx, String fentryID, BigDecimal updateQty, String fproductOrgUnitID, String FIssolateRule, String demandID, java.util.Date fLeadTime, String fpurChaseOrgUnitID, String fsupplyOrgUnitID, String fprojectID, String ftrackID, String materialID, java.util.Date FDemandTime) throws EASBizException, BOSException {
        SelectorItemCollection sic;
        IStockingPlanDetail ispd = StockingPlanDetailFactory.getLocalInstance(ctx);
        StockingPlanDetailInfo spdInfo = new StockingPlanDetailInfo();
        if (fentryID == null || "".equals(fentryID)) {
            if (fpurChaseOrgUnitID != null) {
                PurchaseOrgUnitInfo purChaseOrgUnitInfo = new PurchaseOrgUnitInfo();
                purChaseOrgUnitInfo.setId(BOSUuid.read((String)fpurChaseOrgUnitID));
                spdInfo.setPurchaseOrg(purChaseOrgUnitInfo);
            }
            if (fpurChaseOrgUnitID != null) {
                StorageOrgUnitInfo supplyOrgUnitInfo = new StorageOrgUnitInfo();
                supplyOrgUnitInfo.setId(BOSUuid.read((String)fsupplyOrgUnitID));
                spdInfo.setSupplyOrgUnit(supplyOrgUnitInfo);
            }
            if (fprojectID != null) {
                ProjectInfo projectInfo = new ProjectInfo();
                projectInfo.setId(BOSUuid.read((String)fprojectID));
                spdInfo.setProject(projectInfo);
            }
            if (ftrackID != null) {
                TrackNumberInfo trackNumberInfo = new TrackNumberInfo();
                trackNumberInfo.setId(BOSUuid.read((String)ftrackID));
                spdInfo.setTrackNo(trackNumberInfo);
            }
            if (materialID != null) {
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("model"));
                sic.add(new SelectorItemInfo("baseUnit.id"));
                sic.add(new SelectorItemInfo("baseUnit.name"));
                MaterialInfo materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID), sic);
                spdInfo.setMaterial(materialInfo);
                spdInfo.setMaterialName(materialInfo.getName());
                spdInfo.setModel(materialInfo.getModel());
                spdInfo.setUnit(materialInfo.getBaseUnit().getName());
            }
        } else {
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("material.id"));
            sic.add(new SelectorItemInfo("material.number"));
            sic.add(new SelectorItemInfo("material.name"));
            sic.add(new SelectorItemInfo("material.model"));
            sic.add(new SelectorItemInfo("material.baseUnit.id"));
            sic.add(new SelectorItemInfo("material.baseUnit.name"));
            sic.add(new SelectorItemInfo("parent.*"));
            PurOrderEntryInfo entryInfo = PurOrderEntryFactory.getLocalInstance((Context)ctx).getPurOrderEntryInfo((IObjectPK)new ObjectUuidPK(fentryID), sic);
            spdInfo.setPurchaseOrg(entryInfo.getParent().getPurchaseOrgUnit());
            spdInfo.setSupplyOrgUnit(entryInfo.getStorageOrgUnit());
            spdInfo.setProject(entryInfo.getProject());
            spdInfo.setTrackNo(entryInfo.getTrackNo());
            spdInfo.setMaterial(entryInfo.getMaterial());
            spdInfo.setMaterialName(entryInfo.getMaterial().getName());
            spdInfo.setModel(entryInfo.getMaterial().getModel());
            spdInfo.setUnit(entryInfo.getMaterial().getBaseUnit().getName());
            spdInfo.setSupplier(entryInfo.getParent().getSupplier());
            if (entryInfo.getParent().getPurchasePerson() != null) {
                PurchasePersonInfo personInfo = new PurchasePersonInfo();
                personInfo = PurchasePersonFactory.getLocalInstance((Context)ctx).getPurchasePersonInfo(" where person.id = '" + entryInfo.getParent().getPurchasePerson().getId() + "' ");
                spdInfo.setPurPerson(personInfo);
            }
            spdInfo.setPurOrderEntryID(entryInfo.getId().toString());
            spdInfo.setPurchaseGroup(entryInfo.getParent().getPurchaseGroup());
        }
        spdInfo.setId(BOSUuid.create((BOSObjectType)spdInfo.getBOSType()));
        StorageOrgUnitInfo productOrgUnitInfo = new StorageOrgUnitInfo();
        productOrgUnitInfo.setId(BOSUuid.read((String)fproductOrgUnitID));
        spdInfo.setProductOrgUnit(productOrgUnitInfo);
        IsolatedRuleEnum isEm = IsolatedRuleEnum.getEnum((String)FIssolateRule);
        spdInfo.setIsolationRules(isEm);
        PspStockingDemandInfo psdInfo = new PspStockingDemandInfo();
        psdInfo.setId(BOSUuid.read((String)demandID));
        spdInfo.setDemand(psdInfo);
        spdInfo.setSpQty(updateQty);
        spdInfo.setSpTime(fLeadTime);
        spdInfo.setBizDate(FDemandTime);
        spdInfo.setPurQty(updateQty);
        spdInfo.setOnWayQty(updateQty);
        spdInfo.setInStorageQty(BigDecimal.ZERO);
        spdInfo.setBaseStatus(StockingPlanStatus.SAVE);
        spdInfo.setStockingplanType(StockingPlanType.HOST);
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        Timestamp now = new Timestamp(new java.util.Date().getTime());
        spdInfo.setCreateTime(now);
        spdInfo.setCreator(userInfo);
        spdInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        AutoNumberUtil.initNumber((Context)ctx, (IObjectValue)spdInfo);
        return spdInfo;
    }

    public static Map<String, List<Map>> getPurDatasMap(PMRPCalcParam runParam, List<String> materialIDList) throws BOSException, PMRPException {
        ArrayList<String> paramList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select  h.fid , d.fid as entryid \n");
        sql.append(" ,d.fmaterialid As fmaterialid \n");
        sql.append(" ,d.fstorageorgunitid As fstorageorgunitid \n");
        sql.append(" ,d.fprojectid As fprojectid \n");
        sql.append(" ,d.ftracknoid As ftrackid \n");
        sql.append(" ,d.fqty - isnull(d.ftotalreceiveqty,0) As fpurqty \n");
        sql.append(" ,mp.fmanufacturestrategyid,mp.fisolatedrule \n");
        sql.append(" from t_sm_purorder h  \n");
        sql.append(" inner join  t_sm_purorderentry d on h.fid = d.fparentid  \n");
        sql.append(" left outer join t_bd_materialplan mp on mp.fmaterialid = d.FMaterialID and mp.forgunit = d.fstorageorgunitid \n");
        sql.append(" where ( \n");
        for (int i = 0; i < materialIDList.size(); ++i) {
            sql.append(" d.FMaterialID = ? ");
            if (i == materialIDList.size() - 1) continue;
            sql.append(" OR ");
        }
        sql.append(" )  \n");
        paramList.addAll(materialIDList);
        sql.append(" and exists(Select 1 from t_psp_pspstockingdemand a ");
        sql.append(" where a.fpurorgid = ? ");
        sql.append(" and a.fmaterialid = d.FMaterialID and a.fsupplystorageorgunitid = d.fstorageorgunitid ) ");
        paramList.add(runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString());
        sql.append(" And h.fsupplierid is not null ");
        sql.append(" And h.fpurchaseorgunitid = ? ");
        paramList.add(runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString());
        sql.append(" and  d.fqty - isnull(d.ftotalreceiveqty,0)  > 0 and h.FBASESTATUS = 4 And d.fbasestatus <> 7 ");
        sql.append(" order by d.fmaterialid,d.fstorageorgunitid,d.fprojectid,d.ftracknoid,h.fbizdate  \n");
        IRowSet irs = DbUtil.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])paramList.toArray());
        HashMap<String, List<Map>> returnMap = new HashMap<String, List<Map>>();
        try {
            while (irs.next()) {
                String fid = irs.getString("fid");
                String entryid = irs.getString("entryid");
                String fmaterialid = irs.getString("fmaterialid");
                String fstorageorgunitid = irs.getString("fstorageorgunitid");
                String fprojectid = irs.getString("fprojectid");
                String ftrackid = irs.getString("ftrackid");
                BigDecimal fpurqty = irs.getBigDecimal("fpurqty");
                String fmanufacturestrategyid = irs.getString("fmanufacturestrategyid");
                String fisolatedrule = irs.getString("fisolatedrule");
                String key = fmaterialid + fstorageorgunitid;
                if (fmanufacturestrategyid != null && fmanufacturestrategyid.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
                    if (fisolatedrule == null || !fisolatedrule.equals("ITEM_TRACKNO")) {
                        ftrackid = "";
                    }
                } else {
                    fprojectid = "";
                    ftrackid = "";
                }
                if (fprojectid == null) {
                    fprojectid = "";
                }
                if (ftrackid == null) {
                    ftrackid = "";
                }
                key = key + fprojectid + ftrackid;
                HashMap<String, Object> purMap = new HashMap<String, Object>();
                purMap.put("purentryid", entryid);
                purMap.put("qty", fpurqty);
                List<HashMap<String, Object>> aList = null;
                aList = returnMap != null && returnMap.containsKey(key) ? (List)returnMap.get(key) : new ArrayList<HashMap<String, Object>>();
                aList.add(purMap);
                returnMap.put(key, aList);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return returnMap;
    }

    protected List<String> getAllMaterialIDList(PMRPCalcParam runParam) throws BOSException, PMRPException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select fmaterialid  \n");
        sql.append(" from t_psp_pspstockingdemand   \n");
        sql.append(" where fpurorgid = ? \n");
        sql.append(" group by fmaterialid   \n");
        IRowSet irs = DbUtil.executeQuery((Context)runParam.getEasCtx(), (String)sql.toString(), (Object[])new String[]{runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString()});
        ArrayList<String> aList = new ArrayList<String>();
        try {
            while (irs.next()) {
                aList.add(irs.getString("fmaterialid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return aList;
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    @Override
    public IPMRPStep[] getSubs() {
        return null;
    }

    @Override
    public String getStepDesc(Locale locale) {
        return PMRPResource.getString(locale, "SP_PSP_MATEPUR");
    }

    private static class UpdateWorker
    implements Callable {
        private List<String> materialIDList;
        private PMRPCalcParam runParam;
        private int dataAmount;

        public UpdateWorker(PMRPCalcParam runParam, List<String> materialidList) {
            this.runParam = runParam;
            this.materialIDList = materialidList;
        }

        public Object call() throws Exception {
            if (this.materialIDList.size() > 0) {
                Map<String, List<Map>> purDataList = PSPMatePurDatas.getPurDatasMap(this.runParam, this.materialIDList);
                StringBuffer sql = new StringBuffer();
                ArrayList<String> paramList = new ArrayList<String>();
                CoreBaseCollection detailColl = new CoreBaseCollection();
                sql.setLength(0);
                sql.append(" select a.fid,a.fallocateqty,a.fproductorgunitid,a.FMaterialID,a.fsupplystorageorgunitid,a.fprojectid,a.ftracknumberid \n");
                sql.append(" ,mp.fmanufacturestrategyid,mp.fisolatedrule,a.fleadtime As fleadTime,a.fpurorgid,a.CFDemandTime As FDemandTime \n");
                sql.append(" from t_psp_pspstockingdemand a \n");
                sql.append(" left outer join t_bd_materialplan mp on mp.fmaterialid = a.FMaterialID and mp.forgunit = a.fsupplystorageorgunitid \n");
                sql.append(" where ( \n");
                for (int i = 0; i < this.materialIDList.size(); ++i) {
                    sql.append(" a.FMaterialID = ? ");
                    if (i == this.materialIDList.size() - 1) continue;
                    sql.append(" OR ");
                }
                sql.append(" ) and  a.fpurorgid = ?  \n");
                sql.append(" and a.fallocateqty > 0");
                sql.append(" order by a.FMaterialID,a.fsupplystorageorgunitid,a.fprojectid,a.ftracknumberid,a.fleadtime \n");
                paramList.addAll(this.materialIDList);
                paramList.add(this.runParam.getRunLog().getPspPurChaseOrgUnit().getId().toString());
                IRowSet rs = DbUtil.executeQuery((Context)this.runParam.getEasCtx(), (String)sql.toString(), (Object[])paramList.toArray());
                this.dataAmount = rs.size();
                while (rs.next()) {
                    List<Map> aList;
                    BigDecimal demandQty;
                    String fproductorgunitid = rs.getString("fproductorgunitid");
                    String fsupplystorageorgunitid = rs.getString("fsupplystorageorgunitid");
                    String fprojectid = rs.getString("fprojectid") == null ? "" : rs.getString("fprojectid");
                    String ftracknumberid = rs.getString("ftracknumberid") == null ? "" : rs.getString("ftracknumberid");
                    String FMaterialID = rs.getString("FMaterialID");
                    String fmanufacturestrategyid = rs.getString("fmanufacturestrategyid");
                    String fisolatedrule = rs.getString("fisolatedrule");
                    BigDecimal initDemandQty = demandQty = rs.getBigDecimal("fallocateqty");
                    Date fleadTime = rs.getDate("fleadTime");
                    Date FDemandTime = rs.getDate("FDemandTime");
                    if (fmanufacturestrategyid != null && fmanufacturestrategyid.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
                        if (fisolatedrule == null || !fisolatedrule.equals("ITEM_TRACKNO")) {
                            ftracknumberid = "";
                        }
                    } else {
                        fprojectid = "";
                        ftracknumberid = "";
                    }
                    String key = FMaterialID + fsupplystorageorgunitid;
                    if (fprojectid == null) {
                        fprojectid = "";
                    }
                    if (ftracknumberid == null) {
                        ftracknumberid = "";
                    }
                    key = key + fprojectid + ftracknumberid;
                    BigDecimal purQty = null;
                    BigDecimal updatePurQty = BigDecimal.ZERO;
                    BigDecimal updateAllPurQty = BigDecimal.ZERO;
                    if (purDataList != null && purDataList.containsKey(key) && (aList = purDataList.get(key)) != null && aList.size() > 0) {
                        for (int i = 0; i < aList.size(); ++i) {
                            Map purMap = aList.get(i);
                            String purentryid = purMap.get("purentryid").toString();
                            purQty = new BigDecimal(purMap.get("qty").toString());
                            if (purQty.compareTo(BigDecimal.ZERO) <= 0 || demandQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                            if (purQty.compareTo(demandQty) >= 0) {
                                updatePurQty = demandQty;
                                purQty = purQty.subtract(demandQty);
                                demandQty = BigDecimal.ZERO;
                                purMap.put("qty", purQty);
                            } else {
                                updatePurQty = purQty;
                                demandQty = demandQty.subtract(purQty);
                                purQty = BigDecimal.ZERO;
                                purMap.put("qty", purQty);
                            }
                            if (updatePurQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                            updateAllPurQty = updateAllPurQty.add(updatePurQty);
                            StockingPlanDetailInfo spdInfp = PSPMatePurDatas.addStockingPlanDetailInFo(this.runParam.getEasCtx(), purentryid, updatePurQty, fproductorgunitid, fisolatedrule, rs.getString("fid"), rs.getDate("fleadTime"), null, null, null, null, null, FDemandTime);
                            detailColl.add((CoreBaseInfo)spdInfp);
                            if (detailColl.size() <= 1000) continue;
                            StockingPlanDetailFactory.getLocalInstance(this.runParam.getEasCtx()).addnewBatchData(detailColl);
                            detailColl.clear();
                        }
                    }
                    if (updateAllPurQty.compareTo(BigDecimal.ZERO) != 0) continue;
                    StockingPlanDetailInfo spdInfp = PSPMatePurDatas.addStockingPlanDetailInFo(this.runParam.getEasCtx(), null, updatePurQty, fproductorgunitid, fisolatedrule, rs.getString("fid"), rs.getDate("fleadTime"), rs.getString("fpurorgid"), fsupplystorageorgunitid, rs.getString("fprojectid"), rs.getString("ftracknumberid"), FMaterialID, FDemandTime);
                    detailColl.add((CoreBaseInfo)spdInfp);
                    if (detailColl.size() <= 1000) continue;
                    StockingPlanDetailFactory.getLocalInstance(this.runParam.getEasCtx()).addnewBatchData(detailColl);
                    detailColl.clear();
                }
                if (detailColl.size() > 0) {
                    StockingPlanDetailFactory.getLocalInstance(this.runParam.getEasCtx()).addnewBatchData(detailColl);
                    detailColl.clear();
                }
            }
            return this.dataAmount;
        }
    }
}

