/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.llc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPException;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.Constants;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.PMRPCalcParam;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.step.impl.llc.ILLCComputer;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.IPMRPTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.BOMLLCTableDefine;
import com.kingdee.eas.industry.emm.project.biz.mrp.framework.table.impl.ProcessBOMExpandTableDefine;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;

public class ProcessBomLLCComputer
implements ILLCComputer {
    private String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILLCComputer calcLLC(PMRPCalcParam runParam, String fprojectID, String ftopMaterialid, String ftrackNumberID) throws PMRPException, BOSException {
        ArrayList<String> ProjectIDList;
        Context ctx = runParam.getEasCtx();
        StringBuffer sql = new StringBuffer();
        TrackNumberInfo trackNumberInfo = null;
        if (ftrackNumberID != null && !"".equals(ftrackNumberID)) {
            try {
                trackNumberInfo = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(ftrackNumberID));
            }
            catch (EASBizException e) {
                throw new PMRPException(PMRPException.LLC_WRONG_TRACKNUMBER, e);
            }
        }
        if ((ProjectIDList = new ArrayList<String>()).size() > 0) {
            ProjectIDList.add(fprojectID);
        }
        try {
            IPMRPTableDefine table;
            if (ProjectIDList.size() > 0) {
                MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(ProjectIDList);
            }
            if ((table = runParam.getTableManager().getTempTableDefine(ProcessBOMExpandTableDefine.class)).getTableName() == null) {
                table.createTable(ctx);
            }
            String expandPBBTempTable = table.getTableName();
            int effectedRows1 = 0;
            boolean effectedRows2 = false;
            int row = 0;
            for (int level = 0; level < Constants.MAX_BOM_LEVEL; ++level) {
                if (level >= Constants.MAX_BOM_LEVEL - 2) {
                    if (fprojectID == null) {
                        fprojectID = "";
                    }
                    PMRPException exp = new PMRPException(new NumericExceptionSubItem(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0097"), this.getResourceString(ctx, "com.kingdee.eas.industry.emm.project.biz.mrp.EMMPROJECTBizMrpResource", "0EMMPROJECTBizMrp-0098") + "=" + fprojectID));
                    throw exp;
                }
                sql.setLength(0);
                sql.append(this.getInsertExpandPBBTempTableSQL(expandPBBTempTable));
                sql.append("Select\r\n");
                sql.append("NewBOSID('").append(Constants.BosType.MRP_TMP_BOSTYPE).append("') FID,\r\n");
                sql.append(level).append(" FLevel,\r\n");
                sql.append("FStorageOrgUnitID, FsupplyOrgid, FProjectID, FTrackNumberID, FMaterialID, FMaterialAttribute, CFRATION, CFPARENTID, FMainTenanceLevelID,FManufactureStrategyID FROM (SELECT DISTINCT \r\n");
                if (level == 0) {
                    sql.append(" a.CFStorageOrgUnitID FStorageOrgUnitID,\r\n");
                    sql.append(" a.CFStorageOrgUnitID FsupplyOrgid,\r\n");
                    if (fprojectID == null || "".equals(fprojectID)) {
                        sql.append(" null As FProjectID, ");
                    } else {
                        sql.append(" '").append(fprojectID).append("' As FProjectID, ");
                    }
                    if (ftrackNumberID == null || "".equals(ftrackNumberID)) {
                        sql.append(" Null As  FTrackNumberID,\r\n");
                    } else {
                        sql.append("'").append(ftrackNumberID).append("' As FTrackNumberID,\r\n");
                    }
                    sql.append(" a.cfparentid As FMaterialID,\r\n");
                    sql.append(" mp.fmaterialattr As FMaterialAttribute, \r\n");
                    sql.append(" 0 as CFRATION,null as CFPARENTID,a.FMainTenanceLevelID , mp.FManufactureStrategyID as FManufactureStrategyID");
                    sql.append(" From CT_ZJB_PROCESSBOMBILL a \r\n");
                    sql.append(" left outer Join t_mm_trackNumber bt on a.CFBEGINCARNOID = bt.fid \r\n");
                    sql.append(" left outer Join t_mm_trackNumber et on a.CFENDCARNOID = et.fid \r\n");
                    sql.append(" left outer join t_bd_materialplan mp on mp.Fmaterialid = a.cfparentid and mp.Forgunit = a.CFStorageOrgUnitID \r\n");
                    sql.append(" WHERE a.CFRATION > 0 \r\n");
                    sql.append(" And a.CFState = 4 \r\n");
                    if (fprojectID == null || "".equals(fprojectID)) {
                        sql.append(" AND a.CFPROJECTID is null ");
                    } else {
                        sql.append(" AND (a.CFPROJECTID = '").append(fprojectID).append("' or a.CFPROJECTID is null )\r\n");
                    }
                    if (ftopMaterialid != null && !"".equals(ftopMaterialid)) {
                        sql.append(" AND a.cfparentid = '").append(ftopMaterialid).append("'\r\n");
                    } else {
                        sql.append(" AND Not Exists ( select 1 from CT_ZJB_PROCESSBOMBILL b ");
                        sql.append(" where b.CFMATERIALID = a.cfparentid And b.CFDrawBillOrgID = a.CFStorageOrgUnitID \r\n");
                        sql.append(" and isnull(b.FMainTenanceLevelID,'*') = isnull(a.FMainTenanceLevelID,'*')  ");
                        sql.append(" and (isnull(b.cfprojectid,'*') = isnull(a.cfprojectid,'*')  or a.cfprojectid is null ) ");
                        sql.append(" ) ");
                    }
                    if (trackNumberInfo != null) {
                        sql.append(" AND (bt.fnumber <= '").append(trackNumberInfo.getNumber()).append("' or a.CFBEGINCARNOID is null) \r\n");
                        sql.append(" AND (et.fnumber >= '").append(trackNumberInfo.getNumber()).append("' or a.CFENDCARNOID is null) \r\n");
                    }
                } else {
                    sql.append("a.CFStorageOrgUnitID FStorageOrgUnitID,\r\n");
                    sql.append("a.CFDrawBillOrgID FsupplyOrgid,\r\n");
                    if (fprojectID == null || "".equals(fprojectID)) {
                        sql.append(" null As FProjectID, ");
                    } else {
                        sql.append(" '").append(fprojectID).append("' As FProjectID, ");
                    }
                    if (ftrackNumberID == null || "".equals(ftrackNumberID)) {
                        sql.append(" Null As  FTrackNumberID,\r\n");
                    } else {
                        sql.append("'").append(ftrackNumberID).append("' As FTrackNumberID,\r\n");
                    }
                    sql.append("a.CFMaterialID FMaterialID,\r\n");
                    sql.append("mp.fmaterialattr FMaterialAttribute, \r\n");
                    sql.append("a.CFRATION as CFRATION,a.CFPARENTID as CFPARENTID,a.FMainTenanceLevelID ,mp.FManufactureStrategyID as FManufactureStrategyID \r\n");
                    sql.append("From ").append(expandPBBTempTable).append(" T \r\n");
                    sql.append("Inner Join CT_ZJB_ProcessBomBill a On \r\n");
                    sql.append("a.CFPARENTID=T.FMaterialID\r\n");
                    sql.append(" And a.CFStorageOrgUnitID=T.FSupplyStorageOrgUnitID\r\n");
                    sql.append(" and (isnull(a.cfprojectid,'*') = isnull(T.FProjectID,'*') or a.cfprojectid is null )");
                    sql.append(" and isnull(a.FMainTenanceLevelID,'*') = isnull(T.FMainTenanceLevelID,'*') ");
                    sql.append("And a.CFState=").append(4).append("\r\n");
                    sql.append("And a.CFRATION > 0\r\n");
                    sql.append("left outer Join t_mm_trackNumber bt on a.CFBEGINCARNOID = bt.fid \r\n");
                    sql.append("left outer Join t_mm_trackNumber et on a.CFENDCARNOID = et.fid \r\n");
                    sql.append("left outer join t_bd_materialplan mp on mp.Fmaterialid = a.CFMaterialID and mp.Forgunit = a.CFDrawBillOrgID \r\n");
                    sql.append("Where\r\n");
                    sql.append("T.FLevel=").append(level - 1).append("\r\n");
                    if (trackNumberInfo != null) {
                        sql.append(" AND (bt.fnumber <= '").append(trackNumberInfo.getNumber()).append("' or a.CFBEGINCARNOID is null) \r\n");
                        sql.append(" AND (et.fnumber >= '").append(trackNumberInfo.getNumber()).append("' or a.CFENDCARNOID is null)\r\n");
                    }
                }
                sql.append(")");
                effectedRows1 = this.executeSQL(ctx, sql.toString());
                row += effectedRows1;
                if (effectedRows1 <= 0) break;
            }
            UserInfo curUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
            String fcuid = "";
            fcuid = curUserInfo.getCU() != null ? curUserInfo.getCU().getId().toString() : "00000000-0000-0000-0000-000000000000CCE7AED4";
            table = runParam.getTableManager().getTempTableDefine(BOMLLCTableDefine.class);
            if (table.getTableName() == null) {
                table.createTable(ctx);
            }
            sql.setLength(0);
            sql.append(" Insert Into ").append(table.getTableName()).append("  \r\n");
            sql.append(" (");
            sql.append(table.getTableCols());
            sql.append(" ) \r\n");
            sql.append(" Select newbosid('").append(Constants.BosType.MRP_TMP_LLC).append("'),'");
            sql.append(curUserInfo.getId());
            sql.append("',sysdate,'");
            sql.append(fcuid);
            sql.append("','").append(fcuid).append("',  \r\n");
            sql.append(" temp.FProjectID,  \r\n");
            sql.append(" temp.FMaterialID,temp.FLevel,temp.FMaterialAttribute,null,null From  \r\n");
            sql.append(" (Select a.FMaterialID,a.FMaterialAttribute,a.FProjectID,Max(a.FLevel) as FLevel From ");
            sql.append(expandPBBTempTable);
            sql.append(" a  group by a.FMaterialID,a.FMaterialAttribute,a.FProjectID ) temp \r\n");
            sql.append(" where not exists(Select 1 from ").append(table.getTableName()).append(" b  \r\n");
            sql.append(" where b.CFMaterialID = temp.FMaterialID  \r\n");
            sql.append(" And b.CFMaterialATTR = temp.FMaterialAttribute  \r\n");
            sql.append(" And isnull(b.CFProjectID,'*') = isnull(temp.FProjectID,'*') ) \r\n");
            this.executeSQL(ctx, sql.toString());
            if (!runParam.isWithinMRPEnv()) {
                ProcessBomLLCComputer processBomLLCComputer = this;
                return processBomLLCComputer;
            }
        }
        finally {
            if (ProjectIDList.size() > 0) {
                MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(ProjectIDList);
            }
        }
        return this;
    }

    @Override
    public void reset(PMRPCalcParam runParam) throws BOSException, PMRPException {
        String tbl = runParam.getTableManager().getTempTableDefine(ProcessBOMExpandTableDefine.class).getTableName();
        this.executeSQL(runParam.getEasCtx(), "DELETE " + tbl);
    }

    protected int executeSQL(Context ctx, String sql) throws BOSException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            statement = connection.createStatement();
            long startTime = System.currentTimeMillis();
            int effectedRows = statement.executeUpdate(sql);
            long endTime = System.currentTimeMillis();
            long duration = (endTime - startTime) / 1000L;
            System.out.println("Execute SQL Effected Rows " + effectedRows + " Duration " + duration + " Sec:\r\n" + sql.toString());
            int n = effectedRows;
            return n;
        }
        catch (SQLException e) {
            throw new BOSException(sql, (Throwable)e);
        }
        finally {
            if (connection != null && connection != null) {
                SQLUtils.cleanup((Statement)statement, (Connection)connection);
            }
        }
    }

    protected String getInsertExpandPBBTempTableSQL(String expandPPBTempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(expandPPBTempTableName).append("(\r\n");
        sql.append("FID,\r\n");
        sql.append("FLevel,\r\n");
        sql.append("FStorageOrgUnitID,\r\n");
        sql.append("FSupplyStorageOrgUnitID,\r\n");
        sql.append("FProjectID,\r\n");
        sql.append("FTrackNumberID,\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("FMaterialAttribute,\r\n");
        sql.append("FQty,\r\n");
        sql.append("FParentMaterialID,\r\n");
        sql.append("FMainTenanceLevelID,\r\n");
        sql.append("FManufactureStrategyID\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }
}

