/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.psp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.industry.emm.pm.SqlExecuteFacadeFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.PspChangeState;
import com.kingdee.eas.industry.emm.project.biz.psp.PspChangeType;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanDetailFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanDetailInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.client.AbstractStockingPlanSpannedListUI;
import com.kingdee.eas.industry.emm.project.biz.psp.client.StockingPlanFilterUI;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class StockingPlanSpannedListUI
extends AbstractStockingPlanSpannedListUI {
    private static final Logger logger = CoreUIObject.getLogger(StockingPlanSpannedListUI.class);
    static final String COL_KDTablePur_id = "purOrder.id";
    static final String COL_KDTablePur_number = "purOrder";
    static final String COL_KDTablePur_purOty = "purOty";
    static final String COL_KDTablePur_usedQty = "usedQty";
    static final String COL_KDTableChange_pspChangeID = "pspChange.id";
    static final String COL_KDTableChange_pspChange = "pspChange";
    static final String COL_KDTableChange_oldQty = "oldQty";
    static final String COL_KDTableChange_oldTime = "oldTime";
    static final String COL_KDTableChange_changeQty = "changeQty";
    static final String COL_KDTableChange_changeTime = "changeTime";
    static final String COL_KDTableChange_changeType = "changeType";
    static final String COL_KDTableChange_status = "status";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    StockingPlanSpannedListUI.this.kdTableMain_Selected(e);
                }
                catch (Exception exc) {
                    StockingPlanSpannedListUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void kdTableMain_Selected(KDTSelectEvent e) {
        String spId;
        if (e == null) {
            return;
        }
        int selectRow = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (selectRow < 0) {
            return;
        }
        ICell StockingPlanIdCell = this.tblMain.getCell(selectRow, "id");
        String string = StockingPlanIdCell == null ? null : (spId = StockingPlanIdCell.getValue() == null ? null : StockingPlanIdCell.getValue().toString());
        if (IndustryUtils.isEmptyString(spId)) {
            return;
        }
        try {
            this.refreshOtherEntry(spId);
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
    }

    protected void refreshOtherEntry(String spID) throws EASBizException, BOSException, SQLException {
        if (IndustryUtils.isEmptyString((String)spID)) {
            return;
        }
        this.clearOtherEntry();
        this.refreshPurOrderEntry(spID);
        this.refreshChangeEntry(spID);
    }

    protected void clearOtherEntry() {
        this.kDTable1.removeRows();
        this.kDTable2.removeRows();
        this.kDTable3.removeRows();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int index = e.getRowIndex();
        IRow ir = this.tblMain.getRow(index);
    }

    public void onShow() throws Exception {
        super.onShow();
        int height = this.kDSplitPane1.getHeight();
        BigDecimal heightDecimal = new BigDecimal(height);
        this.kDSplitPane1.setDividerLocation(heightDecimal.divide(new BigDecimal(2)).intValue());
        int w1 = this.kDSplitPane1.getWidth();
        BigDecimal w1Decimal = new BigDecimal(w1);
        this.kDSplitPane2.setDividerLocation(w1Decimal.divide(new BigDecimal(2)).intValue());
        BigDecimal w3Decimal = new BigDecimal(w1);
        this.kDSplitPane3.setDividerLocation(w3Decimal.divide(new BigDecimal(4)).intValue());
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        try {
            CommonQueryDialog dialog = super.initCommonQueryDialog();
            dialog.setShowFilter(true);
            dialog.setShowSorter(true);
            StockingPlanFilterUI fiterUi = new StockingPlanFilterUI();
            dialog.addUserPanel((KDPanel)fiterUi);
            dialog.setWidth(420);
            dialog.setHeight(350);
            dialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
            return dialog;
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
            return null;
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected void refreshPurOrderEntry(String spID) throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("  ");
        sql.append(" select psd.fid ,pr.fnumber,psd.fpurqty ,pre.fbaseqty ,psd.fpurorderentryid from t_psp_stockingplandetail psd ");
        sql.append(" left join t_sm_purorderentry pre on pre.fid = psd.fpurorderentryid ");
        sql.append(" left join t_sm_purorder pr on pre.fparentid = pr.fid ");
        sql.append(" where psd.fstockingplanid = '");
        sql.append(spID);
        sql.append("'");
        IRowSet setPur = SqlExecuteFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
        if (!IndustryUtils.isEmptyRowSet((IRowSet)setPur)) {
            while (setPur.next()) {
                String spdId = setPur.getString("fid");
                String purid = setPur.getString("fpurorderentryid");
                BigDecimal qty = setPur.getBigDecimal("fbaseqty");
                String purnumber = setPur.getString("fnumber");
                BigDecimal usedqty = setPur.getBigDecimal("fpurqty");
                this.setDetailTable(spdId);
                if (IndustryUtils.isEmptyString((String)purid)) continue;
                IRow row = this.kDTable1.addRow();
                row.getCell(COL_KDTablePur_id).setValue((Object)(IndustryUtils.isEmptyString((String)purid) ? "" : purid));
                row.getCell(COL_KDTablePur_number).setValue((Object)(IndustryUtils.isEmptyString((String)purnumber) ? "" : purnumber));
                row.getCell(COL_KDTablePur_purOty).setValue(qty == null ? "" : qty);
                row.getCell(COL_KDTablePur_usedQty).setValue(usedqty == null ? "" : usedqty);
            }
        }
    }

    private void setDetailTable(String spdId) throws EASBizException, BOSException {
        if (IndustryUtils.isEmptyString((String)spdId)) {
            return;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("material.*"));
        selector.add(new SelectorItemInfo("supplier.*"));
        StockingPlanDetailInfo spDtailInfo = StockingPlanDetailFactory.getRemoteInstance().getStockingPlanDetailInfo((IObjectPK)new ObjectUuidPK(spdId), selector);
        IRow row = this.kDTable3.addRow();
        row.getCell("id").setValue((Object)spDtailInfo.getId());
        row.getCell("number").setValue((Object)spDtailInfo.getNumber());
        row.getCell("baseStatus").setValue((Object)spDtailInfo.getBaseStatus().getAlias());
        row.getCell("material.number").setValue((Object)spDtailInfo.getMaterial().getNumber());
        row.getCell("materialName").setValue((Object)spDtailInfo.getMaterial().getName());
        row.getCell("spQty").setValue((Object)spDtailInfo.getSpQty());
        row.getCell("spTime").setValue((Object)spDtailInfo.getSpTime());
        row.getCell("onWayQty").setValue((Object)spDtailInfo.getOnWayQty());
        row.getCell("purQty").setValue((Object)spDtailInfo.getPurQty());
        row.getCell("inStorageQty").setValue((Object)spDtailInfo.getInStorageQty());
        row.getCell("supplier.name").setValue((Object)(spDtailInfo.getSupplier() == null ? "" : spDtailInfo.getSupplier().getName()));
    }

    protected void refreshChangeEntry(String spID) throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("  ");
        sql.append(" select fid , fleadqty,fleaddate,fchangeqty,fchangeleaddate,fchangetype  ");
        sql.append(" ,fchangestatus from t_psp_stockingplanchange where fstockingplanid = '");
        sql.append(spID);
        sql.append("'");
        IRowSet setChange = SqlExecuteFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
        if (!IndustryUtils.isEmptyRowSet((IRowSet)setChange)) {
            while (setChange.next()) {
                String spcId = setChange.getString("fid");
                BigDecimal spcOldQty = setChange.getBigDecimal("fleadqty");
                Date spcOldTime = setChange.getDate("fleaddate");
                BigDecimal spcChangeQty = setChange.getBigDecimal("fchangeqty");
                Date spcChangeTime = setChange.getDate("fchangeleaddate");
                String spcChangeType = setChange.getString("fchangetype");
                String spcStatus = setChange.getString("fchangestatus");
                IRow row = this.kDTable2.addRow();
                row.getCell(COL_KDTableChange_pspChangeID).setValue((Object)(IndustryUtils.isEmptyString((String)spcId) ? "" : spcId));
                row.getCell(COL_KDTableChange_oldQty).setValue(spcOldQty == null ? "" : spcOldQty);
                row.getCell(COL_KDTableChange_oldTime).setValue(spcOldTime == null ? "" : spcOldTime);
                row.getCell(COL_KDTableChange_changeQty).setValue(spcChangeQty == null ? "" : spcChangeQty);
                row.getCell(COL_KDTableChange_changeTime).setValue(spcChangeTime == null ? "" : spcChangeTime);
                row.getCell(COL_KDTableChange_changeType).setValue(IndustryUtils.isEmptyString((String)spcChangeType) ? "" : PspChangeType.getEnum(spcChangeType));
                row.getCell(COL_KDTableChange_status).setValue(IndustryUtils.isEmptyString((String)spcStatus) ? "" : PspChangeState.getEnum(spcStatus));
            }
        }
    }
}

