/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.psp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.industry.emm.pm.SqlExecuteFacadeFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.PspChangeState;
import com.kingdee.eas.industry.emm.project.biz.psp.PspChangeType;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanCollection;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanFactory;
import com.kingdee.eas.industry.emm.project.biz.psp.StockingPlanInfo;
import com.kingdee.eas.industry.emm.project.biz.psp.client.AbstractStockingPlanSpannedRecordUI;
import com.kingdee.eas.industry.emm.project.biz.psp.client.StockingPlanSpannedRecordFilterUI;
import com.kingdee.eas.scm.common.client.ISCMFilter;
import com.kingdee.eas.scm.common.client.SCMCommonProcessor;
import com.kingdee.eas.scm.common.client.SCMPromptBoxFactory;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class StockingPlanSpannedRecordUI
extends AbstractStockingPlanSpannedRecordUI {
    private static final Logger logger = CoreUIObject.getLogger(StockingPlanSpannedRecordUI.class);
    final CommonQueryDialog dialog = new CommonQueryDialog();
    final MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.industry.emm.project.biz.psp.app", "StockingPlanQuery");
    final CustomerQueryPanel cqp = new StockingPlanSpannedRecordFilterUI();
    static final String COL_KDTableMain_ID = "id";
    static final String COL_KDTableMain_Number = "number";
    static final String COL_KDTableMain_PurOrg = "purChaseOrgUnit";
    static final String COL_KDTableMain_StorageOrg = "storageOrgUnit.name";
    static final String COL_KDTableMain_Material_Name = "Material.name";
    static final String COL_KDTableMain_Material_Number = "materialNumber";
    static final String COL_KDTableMain_Unit = "Unit";
    static final String COL_KDTableMain_Mode = "Mode";
    static final String COL_KDTableMain_Project_Number = "Project.number";
    static final String COL_KDTableMain_TrackNo_Number = "TrackNo.number";
    static final String COL_KDTableMain_RequirementDate = "RequirementDate";
    static final String COL_KDTableMain_Qty = "Qty";
    static final String COL_KDTableMain_Status = "status";
    static final String COL_KDTableMain_InStorageQty = "inStorageQty";
    static final String COL_KDTableMain_WayQty = "wayQty";
    static final String COL_KDTableMain_Supplier = "supplier";
    static final String COL_KDTableMain_SupplyQty = "supplyQty";
    static final String COL_KDTableMain_SupplierFeedback = "supplierFeedback";
    static final String COL_KDTableChange_pspChangeID = "pspChange.id";
    static final String COL_KDTableChange_pspChange = "pspChange";
    static final String COL_KDTableChange_oldQty = "oldQty";
    static final String COL_KDTableChange_oldTime = "oldTime";
    static final String COL_KDTableChange_changeQty = "changeQty";
    static final String COL_KDTableChange_changeTime = "changeTime";
    static final String COL_KDTableChange_changeType = "changeType";
    static final String COL_KDTableChange_status = "status";
    static final String COL_KDTablePur_id = "purOrder.id";
    static final String COL_KDTablePur_number = "purOrder";
    static final String COL_KDTablePur_purOty = "purOty";
    static final String COL_KDTablePur_usedQty = "usedQty";
    static final String COL_KDTableInv_material = "material";
    static final String COL_KDTableInv_storageOrgUnit = "storageOrgUnit";
    static final String COL_KDTableInv_qty = "qty";
    static final String COL_KDTableInv_usedQty = "usedQty";
    static final String COL_KDTableSpd_Id = "pspStockingDemand.id";
    static final String COL_KDTableSpd_pspStockingDemand = "pspStockingDemand";
    static final String COL_KDTableSpd_demandQty = "demandQty";
    static final String COL_KDTableSpd_demandTime = "demandTime";
    static final String COL_KDTableSpd_purChaseOrgunit = "purChaseOrgunit";
    StockingPlanCollection spCol = new StockingPlanCollection();
    final Map filterMap = new HashMap();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionQuery_actionPerformed(null);
        this.kDBQuery.setEnabled(true);
        this.kDBQuery.setText("");
        this.addListener();
    }

    public void onShow() throws Exception {
        super.onShow();
        if (IndustryUtils.isEmptyMap((Map)this.filterMap)) {
            this.getUIWindow().close();
            return;
        }
        this.refreshMainTable();
        int height = this.kDSplitPane1.getHeight();
        BigDecimal heightDecimal = new BigDecimal(height);
        this.kDSplitPane1.setDividerLocation(heightDecimal.divide(new BigDecimal(2)).intValue());
        int w1 = this.kDSplitPane1.getWidth();
        BigDecimal w1Decimal = new BigDecimal(w1);
        this.kDSplitPane2.setDividerLocation(w1Decimal.divide(new BigDecimal(2)).intValue());
        BigDecimal w2Decimal = new BigDecimal(w1);
        this.kDSplitPane3.setDividerLocation(w2Decimal.divide(new BigDecimal(4)).intValue());
        BigDecimal w3Decimal = new BigDecimal(w1);
        this.kDSplitPane4.setDividerLocation(w3Decimal.divide(new BigDecimal(4)).intValue());
    }

    protected void addListener() {
        this.kDTableMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    StockingPlanSpannedRecordUI.this.kdTableMain_Selected(e);
                }
                catch (Exception exc) {
                    StockingPlanSpannedRecordUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void kdTableMain_Selected(KDTSelectEvent e) {
        String spId;
        if (e == null) {
            return;
        }
        int selectRow = KDTableUtil.getSelectedRow((KDTable)this.kDTableMain);
        if (selectRow < 0) {
            return;
        }
        ICell StockingPlanIdCell = this.kDTableMain.getCell(selectRow, COL_KDTableMain_ID);
        String string = StockingPlanIdCell == null ? null : (spId = StockingPlanIdCell.getValue() == null ? null : StockingPlanIdCell.getValue().toString());
        if (IndustryUtils.isEmptyString(spId)) {
            return;
        }
        this.filterMap.put("StockingPlanId", spId);
        try {
            this.refreshOtherEntry();
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (e == null) {
            this.dialog.setOwner((Component)(this.getUIWindow() == null ? (Component)this.getUIContext().get("OwnerWindow") : this));
            this.dialog.setUiObject((IUIObject)this);
            this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.dialog.setQueryObjectPK((IMetaDataPK)this.mainQueryPK);
            this.dialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
            if (this.orgContextManager != null) {
                if (this.orgContextManager.getOwner() != null && this.orgContextManager.getOwner() instanceof CustomerQueryPanel) {
                    this.dialog.addUserPanel((KDPanel)((CustomerQueryPanel)this.orgContextManager.getOwner()));
                }
                this.orgContextManager.init(this.getUIContext());
            }
            this.dialog.setMaxReturnCountVisible(true);
            this.dialog.setWidth(450);
            this.dialog.setHeight(320);
            SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory(this.cqp, this.getMainBizOrgType());
            this.dialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
            this.dialog.setProcessor((IProcessor)new SCMCommonProcessor());
            ISCMFilter iFilter = (ISCMFilter)this.cqp;
            if (this.getBOTPViewStatus() == 1) {
                iFilter.setBOTPFilter((Map)((HashMap)this.getUIContext().get("BTPEDITPARAMETER")));
            }
            iFilter.setIsSupportMultiOrgs(false);
            iFilter.setContextObject(null);
            iFilter.setAuthorizedMainOrgs(null);
            this.dialog.addUserPanel((KDPanel)this.cqp);
        }
        if (this.dialog.show()) {
            FilterInfo fi = this.cqp.getFilterInfo();
            int maxCount = this.dialog.getMaxReturnRowCount();
            this.filterMap.put("maxCount", maxCount);
            if (fi != null) {
                this.filterMap.put("QueryString", fi.toString());
            } else {
                this.filterMap.put("IsQuery", true);
            }
            if (e != null) {
                try {
                    this.refreshMainTable();
                }
                catch (Exception e2) {
                    MsgBox.showError((String)e2.toString());
                    SysUtil.abort();
                }
            }
        }
    }

    protected void refreshMainTable() throws BOSException, EASBizException, SQLException {
        this.kDTableMain.removeRows();
        this.clearOtherEntry();
        String queryString = IndustryUtils.getMapStringData((Map)this.filterMap, (Object)"QueryString");
        int maxCount = IndustryUtils.getMapIntegerData((Map)this.filterMap, (Object)"maxCount");
        if (IndustryUtils.isEmptyString((String)queryString)) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("  select top ").append(maxCount).append(" ps.fid as fid ");
        sql.append("  from t_psp_stockingplan  ps ");
        sql.append("  left join t_org_purchase pur on ps.fpurchaseorgunitid = pur.fid  ");
        sql.append("  left join t_mm_project pj on ps.fprojectid = pj.fid  where ");
        sql.append(queryString);
        sql.append("");
        IRowSet set = SqlExecuteFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
        if (IndustryUtils.isEmptyRowSet((IRowSet)set)) {
            return;
        }
        while (set.next()) {
            idList.add(set.getString("fid"));
        }
        if (IndustryUtils.isEmptyList(idList)) {
            return;
        }
        this.spCol.clear();
        for (int i = 0; i < idList.size(); ++i) {
            String fid = idList.get(i).toString();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("Material.*"));
            selector.add(new SelectorItemInfo("Project.*"));
            selector.add(new SelectorItemInfo("TraceNo.*"));
            selector.add(new SelectorItemInfo("storageOrgUnit.*"));
            selector.add(new SelectorItemInfo("purChaseOrgUnit.*"));
            StockingPlanInfo info = StockingPlanFactory.getRemoteInstance().getStockingPlanInfo((IObjectPK)new ObjectUuidPK(fid), selector);
            this.spCol.add(info);
            if (info == null) continue;
            IRow row = this.kDTableMain.addRow();
            row.getCell(COL_KDTableMain_ID).setValue((Object)info.getId().toString());
            row.getCell(COL_KDTableMain_InStorageQty).setValue(info.getInStorageQty() == null ? "" : info.getInStorageQty());
            row.getCell(COL_KDTableMain_Material_Name).setValue((Object)(info.getMaterial() == null ? "" : info.getMaterial().getName()));
            row.getCell(COL_KDTableMain_Material_Number).setValue((Object)(info.getMaterial() == null ? "" : info.getMaterial().getNumber()));
            row.getCell(COL_KDTableMain_Mode).setValue((Object)(IndustryUtils.isEmptyString((String)info.getMode()) ? "" : info.getMode()));
            row.getCell(COL_KDTableMain_Number).setValue((Object)(IndustryUtils.isEmptyString((String)info.getNumber()) ? "" : info.getNumber()));
            row.getCell(COL_KDTableMain_Project_Number).setValue((Object)(info.getProject() == null ? "" : info.getProject().getName()));
            row.getCell(COL_KDTableMain_PurOrg).setValue((Object)(info.getPurChaseOrgUnit() == null ? "" : info.getPurChaseOrgUnit().getName()));
            row.getCell(COL_KDTableMain_Qty).setValue(info.getQty() == null ? "" : info.getQty());
            row.getCell(COL_KDTableMain_RequirementDate).setValue(info.getRequirementDate() == null ? "" : info.getRequirementDate());
            row.getCell("status").setValue((Object)info.getBaseStatus());
            row.getCell(COL_KDTableMain_StorageOrg).setValue((Object)(info.getStorageOrgUnit() == null ? "" : info.getStorageOrgUnit().getName()));
            row.getCell(COL_KDTableMain_Supplier).setValue((Object)(info.getSupplier() == null ? "" : info.getSupplier().getName()));
            row.getCell(COL_KDTableMain_SupplierFeedback).setValue((Object)false);
            row.getCell(COL_KDTableMain_SupplyQty).setValue(info.getSupplierInv() == null ? "" : info.getSupplierInv());
            row.getCell(COL_KDTableMain_TrackNo_Number).setValue((Object)(info.getTraceNo() == null ? "" : info.getTraceNo().getName()));
            row.getCell(COL_KDTableMain_Unit).setValue((Object)(info.getUnit() == null ? "" : info.getUnit()));
            row.getCell(COL_KDTableMain_WayQty).setValue(info.getWayQty() == null ? "" : info.getWayQty());
        }
        this.kDTableMain.getSelectManager().setSelectMode(2);
        this.kDTableMain.setEditable(false);
    }

    protected void refreshOtherEntry() throws EASBizException, BOSException, SQLException {
        String spID;
        String string = spID = this.filterMap.get("StockingPlanId") == null ? null : this.filterMap.get("StockingPlanId").toString();
        if (IndustryUtils.isEmptyString(spID)) {
            return;
        }
        this.clearOtherEntry();
        this.refreshDemandEntry(spID);
        this.refreshInvEntry(spID);
        this.refreshPurOrderEntry(spID);
        this.refreshChangeEntry(spID);
    }

    protected void refreshDemandEntry(String spID) throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("  ");
        sql.append(" select psd.fid as demanid, psd.fnumber as demandnumber ,po.fname_l2 as purname  ,   ");
        sql.append(" psd.fdemandqty as demandqty ,psd.fleadtime as demandtime     ");
        sql.append(" from t_psp_pspstockingdemand psd  ");
        sql.append(" left join t_org_purchase po on po.fid = psd.fpurorgid  ");
        sql.append(" where psd.FTEMPID in (  ");
        sql.append(" select FTEMPID from T_PSP_StockingPlan  ");
        sql.append(" where fid = '");
        sql.append(spID);
        sql.append("')  ");
        IRowSet setdemand = SqlExecuteFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
        if (!IndustryUtils.isEmptyRowSet((IRowSet)setdemand)) {
            while (setdemand.next()) {
                String demanid = setdemand.getString("demanid");
                String demandnumber = setdemand.getString("demandnumber");
                String purname = setdemand.getString("purname");
                BigDecimal demandqty = setdemand.getBigDecimal("demandqty");
                Date demandtime = setdemand.getDate("demandtime");
                IRow row = this.kDTableDemand.addRow();
                row.getCell(COL_KDTableSpd_Id).setValue((Object)(IndustryUtils.isEmptyString((String)demanid) ? "" : demanid));
                row.getCell(COL_KDTableSpd_pspStockingDemand).setValue((Object)(IndustryUtils.isEmptyString((String)demandnumber) ? "" : demandnumber));
                row.getCell(COL_KDTableSpd_purChaseOrgunit).setValue((Object)(IndustryUtils.isEmptyString((String)purname) ? "" : purname));
                row.getCell(COL_KDTableSpd_demandQty).setValue(demandqty == null ? "" : demandqty);
                row.getCell(COL_KDTableSpd_demandTime).setValue(demandtime == null ? "" : demandtime);
            }
        }
    }

    protected void refreshInvEntry(String spID) throws EASBizException, BOSException, SQLException {
        int selectRow = KDTableUtil.getSelectedRow((KDTable)this.kDTableMain);
        ICell materialCell = this.kDTableMain.getCell(selectRow, COL_KDTableMain_Material_Name);
        String materialname = materialCell == null ? "" : (materialCell.getValue() == null ? "" : materialCell.getValue().toString());
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" select   sg.fname_l2 as storagename   ,   ");
        sql.append(" inv.fbaseqty as baseqty , inv.fusedqty as usedqty    ");
        sql.append(" from t_psp_invertoryqty inv      ");
        sql.append(" left join t_org_storage sg on sg.fid = inv.fstorageorgunitid    ");
        sql.append(" where inv.fpspstockdemandid in (  ");
        sql.append(" select fdemandid from t_psp_demandidtoplanid  ");
        sql.append(" where fstockplanid = '");
        sql.append(spID);
        sql.append("')  ");
        sql.append(" and inv.fusedqty > 0   ");
        IRowSet setInv = SqlExecuteFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
        if (!IndustryUtils.isEmptyRowSet((IRowSet)setInv)) {
            while (setInv.next()) {
                BigDecimal baseqty = setInv.getBigDecimal("baseqty");
                String storagename = setInv.getString("storagename");
                BigDecimal usedqty = setInv.getBigDecimal("usedqty");
                IRow row = this.kDTableStore.addRow();
                row.getCell(COL_KDTableInv_material).setValue((Object)(IndustryUtils.isEmptyString((String)materialname) ? "" : materialname));
                row.getCell(COL_KDTableInv_storageOrgUnit).setValue((Object)(IndustryUtils.isEmptyString((String)storagename) ? "" : storagename));
                row.getCell(COL_KDTableInv_qty).setValue(baseqty == null ? "" : baseqty);
                row.getCell("usedQty").setValue(usedqty == null ? "" : usedqty);
            }
        }
    }

    protected void refreshPurOrderEntry(String spID) throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("  ");
        sql.append(" select sp.fpurorder as purid, sp.fpurorderqty as qty, sp.fusedpurqty ");
        sql.append(" as usedqty ,pr.fnumber as purnumber from t_psp_stockplanmatchingpur sp ");
        sql.append(" left join t_sm_purorder pr on sp.fpurorder = pr.fid ");
        sql.append(" where sp.fstockplanid = '");
        sql.append(spID);
        sql.append("'");
        IRowSet setPur = SqlExecuteFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
        if (!IndustryUtils.isEmptyRowSet((IRowSet)setPur)) {
            while (setPur.next()) {
                String purid = setPur.getString("purid");
                BigDecimal qty = setPur.getBigDecimal(COL_KDTableInv_qty);
                String purnumber = setPur.getString("purnumber");
                BigDecimal usedqty = setPur.getBigDecimal("usedqty");
                IRow row = this.kDTablePur.addRow();
                row.getCell(COL_KDTablePur_id).setValue((Object)(IndustryUtils.isEmptyString((String)purid) ? "" : purid));
                row.getCell(COL_KDTablePur_number).setValue((Object)(IndustryUtils.isEmptyString((String)purnumber) ? "" : purnumber));
                row.getCell(COL_KDTablePur_purOty).setValue(qty == null ? "" : qty);
                row.getCell("usedQty").setValue(usedqty == null ? "" : usedqty);
            }
        }
    }

    protected void refreshChangeEntry(String spID) throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("  ");
        sql.append(" select fid , fleadqty,fleaddate,fchangeqty,fchangeleaddate,fchangetype  ");
        sql.append(" ,fchangestatus from t_psp_stockingplanchange where fstockingplanid = '");
        sql.append(spID);
        sql.append("'");
        IRowSet setChange = SqlExecuteFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
        if (!IndustryUtils.isEmptyRowSet((IRowSet)setChange)) {
            while (setChange.next()) {
                String spcId = setChange.getString("fid");
                BigDecimal spcOldQty = setChange.getBigDecimal("fleadqty");
                Date spcOldTime = setChange.getDate("fleaddate");
                BigDecimal spcChangeQty = setChange.getBigDecimal("fchangeqty");
                Date spcChangeTime = setChange.getDate("fchangeleaddate");
                String spcChangeType = setChange.getString("fchangetype");
                String spcStatus = setChange.getString("fchangestatus");
                IRow row = this.kDTableChange.addRow();
                row.getCell(COL_KDTableChange_pspChangeID).setValue((Object)(IndustryUtils.isEmptyString((String)spcId) ? "" : spcId));
                row.getCell(COL_KDTableChange_oldQty).setValue(spcOldQty == null ? "" : spcOldQty);
                row.getCell(COL_KDTableChange_oldTime).setValue(spcOldTime == null ? "" : spcOldTime);
                row.getCell(COL_KDTableChange_changeQty).setValue(spcChangeQty == null ? "" : spcChangeQty);
                row.getCell(COL_KDTableChange_changeTime).setValue(spcChangeTime == null ? "" : spcChangeTime);
                row.getCell(COL_KDTableChange_changeType).setValue(IndustryUtils.isEmptyString((String)spcChangeType) ? "" : PspChangeType.getEnum(spcChangeType));
                row.getCell("status").setValue(IndustryUtils.isEmptyString((String)spcStatus) ? "" : PspChangeState.getEnum(spcStatus));
            }
        }
    }

    protected void clearOtherEntry() {
        this.kDTableDemand.removeRows();
        this.kDTableStore.removeRows();
        this.kDTablePur.removeRows();
        this.kDTableChange.removeRows();
    }
}

