/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.biz.schedule.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.project.biz.basedata.PermissionCheckFacadeFactory;
import com.kingdee.eas.industry.emm.project.biz.schedule.client.AbstractScheduleGanttQueryUI;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiF7FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;

public class ScheduleGanttQueryUI
extends AbstractScheduleGanttQueryUI {
    private static final long serialVersionUID = -9036132817049051994L;
    protected static final String COL_STARTTIME = "newBeginDate";
    protected static final String COL_FINISHTIME = "newEndDate";
    public static final String COL_PROJECTNUMBER = "project.number";
    public static final String COL_MATERIALNUMBER = "material.number";
    protected static final String COL_STORAGEORGUNITNUMBER = "parent.storageOrgUnit.number";
    protected static final String COL_TRACKNUMBERNUMBER = "trackNumber.number";

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public void clear() {
        super.clear();
        this.prmtStorageOrgUnit.setEnabledMultiSelection(false);
        this.prmtStorageOrgUnit.setDisplayFormat("$name$");
        this.prmtMaterial.setValue(null);
        this.prmtProject.setValue(null);
        this.prmtTrackNumber.setValue(null);
        this.pkDateFrom.setValue((Object)new Date());
        this.pkDateTo.setValue((Object)new Date());
        try {
            StorageOrgUnitInfo storageOrgUnitInfo = PermissionCheckFacadeFactory.getRemoteInstance().getFirstOrgPermission(this.getViewPermission());
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(PermissionCheckFacadeFactory.getRemoteInstance().getOrgIdPermission(this.getViewPermission())), CompareType.INCLUDE));
            view.setFilter(filter);
            this.prmtStorageOrgUnit.setEntityViewInfo(view);
            this.prmtStorageOrgUnit.setValue((Object)storageOrgUnitInfo);
        }
        catch (EASBizException e) {
            MsgBox.showWarning((String)e.getMessage());
        }
        catch (BOSException e) {
            MsgBox.showWarning((String)e.getMessage());
        }
    }

    protected String getViewPermission() {
        return "emm_scheduleGantt_view";
    }

    public void onLoad() throws Exception {
        super.onLoad();
        UIHelper.registerProjectF7ForEdit((KDBizPromptBox)this.prmtStorageOrgUnit, null, (KDBizPromptBox)this.prmtProject);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.prmtStorageOrgUnit, (KDBizPromptBox)this.prmtProject, (KDBizPromptBox)this.prmtTrackNumber, (boolean)false);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new SingleFilterElement(COL_STORAGEORGUNITNUMBER, (Component)this.prmtStorageOrgUnit){

            public void setElementValue(CustomerParams cp) {
                if (cp != null && cp.getCustomerParam("prmtStorageOrgUnit") != null) {
                    try {
                        ScheduleGanttQueryUI.this.prmtStorageOrgUnit.setValue((Object)StorageOrgUnitFactory.getRemoteInstance().getValue("SELECT * Where number ='" + cp.getCustomerParam("prmtStorageOrgUnit") + "'"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        MultiF7FilterElement m = new MultiF7FilterElement(COL_MATERIALNUMBER, this.prmtMaterial){

            public void setElementValue(CustomerParams cp) {
                if (cp != null && cp.getCustomerParam(this.getId()) != null) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    HashSet<String> ids = new HashSet<String>();
                    String[] all = cp.getCustomerParam(this.getId()).split(";");
                    for (int i = 0; i < all.length; ++i) {
                        ids.add(all[i].trim());
                    }
                    filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                    view.setFilter(filter);
                    try {
                        MaterialCollection c = MaterialFactory.getRemoteInstance().getMaterialCollection(view);
                        Object[] values = new Object[c.size()];
                        for (int i = 0; i < c.size(); ++i) {
                            values[i] = c.getObject(i);
                        }
                        ScheduleGanttQueryUI.this.prmtMaterial.setValue((Object)values);
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        elements.add((FilterElement)m);
        m = new MultiF7FilterElement("project.id", this.prmtProject){

            public void setElementValue(CustomerParams cp) {
                if (cp != null && cp.getCustomerParam(this.getId()) != null) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    HashSet<String> ids = new HashSet<String>();
                    String[] all = cp.getCustomerParam(this.getId()).split(";");
                    for (int i = 0; i < all.length; ++i) {
                        ids.add(all[i].trim());
                    }
                    filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                    view.setFilter(filter);
                    try {
                        ProjectCollection c = ProjectFactory.getRemoteInstance().getProjectCollection(view);
                        Object[] values = new Object[c.size()];
                        for (int i = 0; i < c.size(); ++i) {
                            values[i] = c.getObject(i);
                        }
                        ScheduleGanttQueryUI.this.prmtProject.setValue((Object)values);
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        elements.add((FilterElement)m);
        m = new MultiF7FilterElement("trackNumber.id", this.prmtTrackNumber){

            public void setElementValue(CustomerParams cp) {
                if (cp != null && cp.getCustomerParam(this.getId()) != null) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    HashSet<String> ids = new HashSet<String>();
                    String[] all = cp.getCustomerParam(this.getId()).split(";");
                    for (int i = 0; i < all.length; ++i) {
                        ids.add(all[i].trim());
                    }
                    filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                    view.setFilter(filter);
                    try {
                        TrackNumberCollection c = TrackNumberFactory.getRemoteInstance().getTrackNumberCollection(view);
                        Object[] values = new Object[c.size()];
                        for (int i = 0; i < c.size(); ++i) {
                            values[i] = c.getObject(i);
                        }
                        ScheduleGanttQueryUI.this.prmtTrackNumber.setValue((Object)values);
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        elements.add((FilterElement)m);
        SingleFilterElement e = new SingleFilterElement(COL_STARTTIME, (Component)this.pkDateFrom);
        e.setCompareType(CompareType.GREATER_EQUALS);
        e.setDateType(0);
        elements.add((FilterElement)e);
        e = new SingleFilterElement(COL_FINISHTIME, (Component)this.pkDateTo);
        e.setCompareType(CompareType.LESS_EQUALS);
        e.setDateType(1);
        elements.add((FilterElement)e);
        this.getFilterManager().setElement((FilterElement)elements);
        this.prmtMaterial.setEnabledMultiSelection(true);
        this.prmtProject.setEnabledMultiSelection(true);
        this.prmtTrackNumber.setEnabledMultiSelection(true);
        SelectorListener l = new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (e.getSource() == ScheduleGanttQueryUI.this.prmtStorageOrgUnit) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)1));
                    ((KDBizPromptBox)e.getSource()).getQueryAgent().setDefaultFilterInfo(filter);
                }
                if (e.getSource() instanceof KDBizPromptBox) {
                    KDBizPromptBox source = (KDBizPromptBox)e.getSource();
                    source.getQueryAgent().setHasCUDefaultFilter(true);
                    source.getQueryAgent().resetRuntimeEntityView();
                }
            }
        };
        this.prmtStorageOrgUnit.addSelectorListener(l);
        this.prmtMaterial.addSelectorListener(l);
        this.prmtProject.addSelectorListener(l);
        this.prmtTrackNumber.addSelectorListener(l);
        this.prmtMaterial.setValue(null);
        this.prmtProject.setValue(null);
        this.prmtTrackNumber.setValue(null);
        this.prmtStorageOrgUnit.setRequired(true);
        this.prmtMaterial.setRequired(true);
        this.pkDateFrom.setRequired(true);
        this.pkDateTo.setRequired(true);
    }

    public boolean verify() {
        boolean result = super.verify();
        Object org = this.prmtStorageOrgUnit.getValue();
        Object dateFrom = this.pkDateFrom.getValue();
        Object dateTo = this.pkDateTo.getValue();
        Object material = this.prmtMaterial.getValue();
        if (org == null || material == null || dateFrom == null || dateTo == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.project.biz.schedule.EMMPROJECTProjectBizScheduleResource", (String)"0EMMPROJECTSchedule-0082"));
            return false;
        }
        return result;
    }

    public StorageOrgUnitInfo getOrg() {
        return (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
    }

    public HashMap<String, MaterialInfo> getMaterials() {
        Object[] materials = (Object[])this.prmtMaterial.getValue();
        HashMap<String, MaterialInfo> ret = new HashMap<String, MaterialInfo>();
        for (int i = 0; i < materials.length; ++i) {
            MaterialInfo m = (MaterialInfo)materials[i];
            ret.put(m.getId().toString(), m);
        }
        return ret;
    }

    public HashMap<String, ProjectInfo> getProjects() {
        Object[] projects = (Object[])this.prmtProject.getValue();
        HashMap<String, ProjectInfo> ret = new HashMap<String, ProjectInfo>();
        if (projects == null) {
            return ret;
        }
        for (int i = 0; i < projects.length; ++i) {
            ProjectInfo p = (ProjectInfo)projects[i];
            ret.put(p.getId().toString(), p);
        }
        return ret;
    }

    public HashMap<String, TrackNumberInfo> getTracks() {
        Object[] tracks = (Object[])this.prmtTrackNumber.getValue();
        HashMap<String, TrackNumberInfo> ret = new HashMap<String, TrackNumberInfo>();
        if (tracks == null) {
            return ret;
        }
        for (int i = 0; i < tracks.length; ++i) {
            TrackNumberInfo t = (TrackNumberInfo)tracks[i];
            ret.put(t.getId().toString(), t);
        }
        return ret;
    }

    public Date getDateFrom() {
        return this.pkDateFrom.getSqlDate();
    }

    public Date getDateTo() {
        return this.pkDateTo.getSqlDate();
    }
}

