/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.directDeliveryPlan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanInfo;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanSPurEntryCollection;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanSPurEntryInfo;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanStockEntryCollection;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanStockEntryInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseCollection;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SonMftOrderSingleton {
    private Map<String, List<SonDirectDeliveryPlanStockEntryInfo>> mftMap = new HashMap<String, List<SonDirectDeliveryPlanStockEntryInfo>>();
    private static SonMftOrderSingleton instance;
    private Context ctx;

    private SonMftOrderSingleton(Context _ctx) throws BOSException, EASBizException {
        this.ctx = _ctx;
        this.initSonMftOrderSingleton();
    }

    private void initSonMftOrderSingleton() throws BOSException, EASBizException {
        Object[] params = (Object[])this.ctx.get((Object)"PARAM");
        this.getMftOrderGroupByCondition(this.ctx, params);
    }

    public static synchronized SonMftOrderSingleton getInstance(Context ctx) throws BOSException, EASBizException {
        if (instance == null) {
            instance = new SonMftOrderSingleton(ctx);
        }
        return instance;
    }

    public void clear() {
        instance = null;
    }

    public void matchMftOrderQty(SonDirectDeliveryPlanInfo coreinfo) throws BOSException, EASBizException {
        SonDirectDeliveryPlanSPurEntryCollection colls = coreinfo.getSPurEntrys();
        for (int n = 0; n < colls.size(); ++n) {
            SonDirectDeliveryPlanSPurEntryInfo entryinfo = colls.get(n);
            String materialid = entryinfo.getMaterial().getId().toString();
            String projectid = entryinfo.getProject() == null ? "" : entryinfo.getProject().getId().toString();
            String tracknumberid = entryinfo.getTracknumber() == null ? "" : entryinfo.getTracknumber().getId().toString();
            String storageid = entryinfo.getStorage().getId().toString();
            String key = materialid + "@" + projectid + "@" + tracknumberid + "@" + storageid;
            List<SonDirectDeliveryPlanStockEntryInfo> entrys = this.mftMap.get(key);
            SonDirectDeliveryPlanStockEntryCollection stockEntrycolls = new SonDirectDeliveryPlanStockEntryCollection();
            if (entrys != null) {
                for (int m = 0; m < entrys.size(); ++m) {
                    stockEntrycolls.add(entrys.get(m));
                }
            }
            coreinfo.put("stockEntrys", (Object)stockEntrycolls);
        }
    }

    public SonDirectDeliveryPlanStockEntryCollection backWriteMftEntrySingleton(SonDirectDeliveryPlanInfo coreinfo, BigDecimal qty) {
        SonDirectDeliveryPlanSPurEntryCollection colls = coreinfo.getSPurEntrys();
        SonDirectDeliveryPlanStockEntryCollection stockEntrycolls = new SonDirectDeliveryPlanStockEntryCollection();
        for (int n = 0; n < colls.size(); ++n) {
            SonDirectDeliveryPlanSPurEntryInfo entryinfo = colls.get(n);
            String materialid = entryinfo.getMaterial().getId().toString();
            String projectid = entryinfo.getProject() == null ? "" : entryinfo.getProject().getId().toString();
            String tracknumberid = entryinfo.getTracknumber() == null ? "" : entryinfo.getTracknumber().getId().toString();
            String storageid = entryinfo.getStorage().getId().toString();
            String key = materialid + "@" + projectid + "@" + tracknumberid + "@" + storageid;
            List<SonDirectDeliveryPlanStockEntryInfo> entrys = this.mftMap.get(key);
            for (int m = 0; m < entrys.size(); ++m) {
                SonDirectDeliveryPlanStockEntryInfo info = entrys.get(m);
                info.setId(null);
                BigDecimal remainQty = info.getRemainqty();
                if (qty.compareTo(BigDecimal.ZERO) > 0) {
                    if (qty.compareTo(remainQty) >= 0) {
                        info.setRemainqty(BigDecimal.ZERO);
                        info.setQty(remainQty);
                        stockEntrycolls.add(info);
                        qty = qty.subtract(remainQty);
                    } else {
                        remainQty = remainQty.subtract(qty);
                        info.setRemainqty(remainQty);
                        info.setQty(qty);
                        stockEntrycolls.add(info);
                    }
                }
                entrys.set(m, info);
            }
            this.mftMap.put(key, entrys);
            coreinfo.put("stockEntrys", (Object)stockEntrycolls);
        }
        return stockEntrycolls;
    }

    private void getMftOrderGroupByCondition(Context ctx, Object[] params) throws BOSException, EASBizException {
        HashSet materialList = (HashSet)params[0];
        HashSet projectList = (HashSet)params[1];
        HashSet trackList = (HashSet)params[2];
        HashSet storageList = (HashSet)params[3];
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialList, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("parent.project.id", (Object)projectList, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("parent.trackNumber.id", (Object)trackList, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageList, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("parent.baseStatus", (Object)4, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("*"));
        coll.add(new SelectorItemInfo("parent.*"));
        view.setSelector(coll);
        SCMBillEntryBaseCollection stocks = ManufactureOrderStockFactory.getLocalInstance((Context)ctx).getSCMBillEntryBaseCollection(view);
        StringBuffer mftkey = new StringBuffer();
        for (int m = 0; m < stocks.size(); ++m) {
            List<Object> objList;
            ManufactureOrderStockInfo stock = (ManufactureOrderStockInfo)stocks.get(m);
            SonDirectDeliveryPlanStockEntryInfo sondirectinfo = new SonDirectDeliveryPlanStockEntryInfo();
            String materialid = stock.getMaterial().getId().toString();
            String projectid = stock.getParent().getProject() == null ? "" : stock.getParent().getProject().getId().toString();
            String tracknumberid = stock.getParent().getTrackNumber() == null ? "" : stock.getParent().getTrackNumber().getId().toString();
            String storageid = stock.getStorageOrgUnit().getId().toString();
            BigDecimal qty = stock.getPlannedQty().subtract(stock.getTotalReceiptQty()).add(stock.getRejectedQty());
            sondirectinfo.setMaterial(stock.getMaterial());
            sondirectinfo.setOrderno(stock.getParent().getNumber());
            sondirectinfo.setSeq(stock.getSeq());
            sondirectinfo.setProject(stock.getParent().getProject());
            sondirectinfo.setTracknumber(stock.getParent().getTrackNumber());
            sondirectinfo.setUnit(stock.getUnit());
            sondirectinfo.setQty(qty);
            sondirectinfo.setRemainqty(qty);
            sondirectinfo.setStockid(stock.getId().toString());
            mftkey.append(materialid).append("@").append(projectid).append("@").append(tracknumberid).append("@").append(storageid);
            if (this.mftMap.get(mftkey) != null) {
                objList = this.mftMap.get(mftkey);
                objList.add(sondirectinfo);
                continue;
            }
            objList = new ArrayList<SonDirectDeliveryPlanStockEntryInfo>();
            objList.add(sondirectinfo);
            this.mftMap.put(mftkey.toString(), objList);
        }
    }
}

