/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.industry.emm.GetMaterialFromBOMFacadeFactory;
import com.kingdee.eas.industry.emm.client.AbstractGetMaterialFromBOMUI;
import com.kingdee.eas.industry.emm.client.SelectMaterialFromBOM;
import com.kingdee.eas.industry.emm.pm.SqlExecuteFacadeFactory;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.zjbom.convert.bomConvertToPBomFacadeFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GetMaterialFromBOMUI
extends AbstractGetMaterialFromBOMUI {
    private static final Logger logger = CoreUIObject.getLogger(GetMaterialFromBOMUI.class);
    private String RESOURCE_NAME = "com.kingdee.eas.industry.emm.EMMSCMEMMBaseResource";
    private String SCM_QXZBOMSJ = EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_QXZBOMSJ");
    private String SCM_QXZJLH = EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_QXZJLH");
    private String BOMID = "";
    static final String COL_KDTableMain_materialid = "material.id";
    static final String COL_KDTableMain_materialnumber = "material.number";
    static final String COL_KDTableMain_materialname = "material.name";
    static final String COL_KDTableMain_materialmodel = "material.model";
    static final String COL_KDTableMain_materialqty = "materialqty";
    static final String COL_KDTableMain_materialunit = "material.unit";
    static final String COL_KDTableMain_materialStorageOrgUnitName = "storageOrgUnitname";
    static final String COL_KDTableMain_materialStorageOrgUnitID = "storageOrgUnitid";

    public void onLoad() throws Exception {
        super.onLoad();
        String fmaterialid = null;
        String fprojectid = null;
        String tracknumberid = null;
        String storageOrgunitid = null;
        if (this.getUIContext().get("mid") != null) {
            fmaterialid = this.getUIContext().get("mid").toString();
        }
        if (this.getUIContext().get("projectid") != null && !(fprojectid = this.getUIContext().get("projectid").toString()).equals("")) {
            ProjectInfo projectInfo = ProjectFactory.getRemoteInstance().getProjectInfo((IObjectPK)new ObjectUuidPK(fprojectid));
            this.prmtProject.setValue((Object)projectInfo);
        }
        if (this.getUIContext().get("tracknumberid") != null) {
            tracknumberid = this.getUIContext().get("tracknumberid").toString();
            if (fprojectid != null && !fprojectid.equals("")) {
                TrackNumberInfo trackInfo = TrackNumberFactory.getRemoteInstance().getTrackNumberInfo((IObjectPK)new ObjectUuidPK(tracknumberid));
                this.prmtTrackNum.setValue((Object)trackInfo);
            }
        }
        if (this.getUIContext().get("storageOrgunitid") != null && fmaterialid != null) {
            storageOrgunitid = this.getUIContext().get("storageOrgunitid").toString();
            BomInfo bomInfo = bomConvertToPBomFacadeFactory.getRemoteInstance().getBomInfo(fmaterialid, storageOrgunitid, fprojectid, null, true, true, 0, null);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.txtBOM.setRequired(true);
        this.txtBOM.setEditable(false);
        this.btnBOMTree.setEnabled(true);
        EntityViewInfo evi_project = this.prmtProject.getEntityViewInfo();
        if (evi_project == null) {
            evi_project = new EntityViewInfo();
        }
        if (evi_project.getFilter() == null) {
            evi_project.setFilter(new FilterInfo());
        }
        evi_project.getFilter().getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentOrgUnit().getCU().getId().toString(), CompareType.EQUALS));
        this.prmtProject.setEntityViewInfo(evi_project);
        this.prmtProject.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
            }
        });
    }

    private void updateTrackFilter() {
        if (this.prmtProject.getValue() != null) {
            ProjectInfo projectInfo = (ProjectInfo)this.prmtProject.getValue();
            EntityViewInfo evi_track = this.prmtTrackNum.getEntityViewInfo();
            if (evi_track == null) {
                evi_track = new EntityViewInfo();
            }
            if (evi_track.getFilter() == null) {
                evi_track.setFilter(new FilterInfo());
            }
            evi_track.getFilter().getFilterItems().add(new FilterItemInfo("parent.id", (Object)projectInfo.getId().toString(), CompareType.EQUALS));
            this.prmtTrackNum.setEntityViewInfo(evi_track);
            this.prmtTrackNum.getQueryAgent().resetRuntimeEntityView();
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnQuery.setEnabled(true);
        this.btnSelect.setEnabled(true);
    }

    @Override
    public void actionBomTreeSe_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        String uiClass = "com.kingdee.eas.industry.emm.mm.ps.client.BomSelectUI";
        uiContext.put((Object)"mid", (Object)"");
        uiContext.put((Object)"isSelectBOM", (Object)true);
        if (this.prmtProject.getValue() != null) {
            ProjectInfo projectInfo = (ProjectInfo)this.prmtProject.getValue();
            uiContext.put((Object)"projectID", (Object)projectInfo.getId().toString());
        }
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.industry.emm.mm.ps.client.BomSelectUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        Map parmContext = uiWindow.getUIObject().getUIContext();
        if (parmContext.get("mid") != null && !parmContext.get("mid").toString().equals("")) {
            String fbomID = parmContext.get("bomid").toString();
            if (fbomID != "null") {
                BomInfo Bominfo = BomFactory.getRemoteInstance().getBomInfo((IObjectPK)new ObjectUuidPK(fbomID));
                if (Bominfo != null) {
                    this.BOMID = Bominfo.getId().toString();
                    this.txtBOM.setText(Bominfo.getNumber());
                    if (Bominfo.getProject() != null) {
                        ProjectInfo pinfo = ProjectFactory.getRemoteInstance().getProjectInfo((IObjectPK)new ObjectUuidPK(Bominfo.getProject().getId()));
                        this.prmtProject.setValue((Object)pinfo);
                        this.prmtTrackNum.setValue(null);
                    }
                }
            } else {
                this.txtBOM.setText("");
            }
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.txtBOM.getText() == null || "".equals(this.txtBOM.getText()) || this.BOMID == null || "".equals(this.BOMID)) {
            MsgBox.showWarning((String)this.SCM_QXZBOMSJ);
            SysUtil.abort();
        }
        this.kDTable.removeRows();
        String bomid = this.txtBOM.getText();
        String ProjectID = null;
        if (this.prmtProject.getValue() != null) {
            ProjectInfo projectInfo = (ProjectInfo)this.prmtProject.getValue();
            ProjectID = projectInfo.getId().toString();
        }
        String TrackNumID = null;
        if (this.prmtTrackNum.getValue() != null) {
            TrackNumberInfo info = (TrackNumberInfo)this.prmtTrackNum.getValue();
            TrackNumID = info.getId().toString();
        }
        String tablename = GetMaterialFromBOMFacadeFactory.getRemoteInstance().expandBOM4Material(this.BOMID, ProjectID, TrackNumID, this.rbOne.isSelected() ? "0" : (this.rbTwo.isSelected() ? "1" : (this.rbThree.isSelected() ? "2" : "3")));
        this.showFilterList(tablename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showFilterList(String tablename) throws EASBizException, BOSException {
        if (IndustryUtils.isEmptyString((String)tablename)) {
            return;
        }
        String filterMaterialID = this.prmtMaterial.getValue() == null ? "" : ((MaterialInfo)this.prmtMaterial.getValue()).getId().toString();
        StringBuffer sql = new StringBuffer();
        Locale locale = this.getLocale();
        String language = "l2";
        language = "zh".equals(locale.getLanguage()) ? "l2" : "l1";
        sql.append(" select t1.fmaterialid ,t.fname_").append(language).append(" as fmaterialname,t.fnumber as fmaterialnumber,t.fmodel as fmaterialmodel,tu.fname_").append(language).append(" as fmaterialunit,t1.fqty as fqty,s.fid as forgid,s.fname_").append(language).append(" as forgname \n");
        sql.append(" from (select FSupplyStorageOrgUnitID,fmaterialid,max(fqty) as fqty from " + tablename + " where 1=1\n");
        if (!IndustryUtils.isEmptyString((String)filterMaterialID)) {
            sql.append(" and fmaterialid =  '" + filterMaterialID + "'");
        }
        sql.append(" group by FSupplyStorageOrgUnitID,fmaterialid ) t1 \n");
        sql.append(" left join t_bd_material t on t.fid = t1.fmaterialid \n");
        sql.append(" left join t_org_storage s on s.fid = t1.FSupplyStorageOrgUnitID \n");
        sql.append(" left join t_bd_measureunit tu on tu.fid = t.fbaseunit  \n");
        sql.append(" where 1=1  \n");
        try {
            IRowSet set = SqlExecuteFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
            while (set.next()) {
                IRow row = this.kDTable.addRow();
                String fmaterialid = set.getString("fmaterialid");
                row.getCell(COL_KDTableMain_materialid).setValue((Object)(IndustryUtils.isEmptyString((String)fmaterialid) ? "" : fmaterialid));
                String fmaterialname = set.getString("fmaterialname");
                row.getCell(COL_KDTableMain_materialname).setValue((Object)(IndustryUtils.isEmptyString((String)fmaterialname) ? "" : fmaterialname));
                String fmaterialnumber = set.getString("fmaterialnumber");
                row.getCell(COL_KDTableMain_materialnumber).setValue((Object)(IndustryUtils.isEmptyString((String)fmaterialnumber) ? "" : fmaterialnumber));
                String fmaterialmodel = set.getString("fmaterialmodel");
                row.getCell(COL_KDTableMain_materialmodel).setValue((Object)(IndustryUtils.isEmptyString((String)fmaterialmodel) ? "" : fmaterialmodel));
                String fmaterialunit = set.getString("fmaterialunit");
                row.getCell(COL_KDTableMain_materialunit).setValue((Object)(IndustryUtils.isEmptyString((String)fmaterialunit) ? "" : fmaterialunit));
                BigDecimal fqty = set.getBigDecimal("fqty");
                row.getCell(COL_KDTableMain_materialqty).setValue((Object)(fqty == null ? Integer.valueOf(0) : fqty));
                String forgname = set.getString("forgname");
                row.getCell(COL_KDTableMain_materialStorageOrgUnitName).setValue((Object)(IndustryUtils.isEmptyString((String)forgname) ? "" : forgname));
                String forgid = set.getString("forgid");
                row.getCell(COL_KDTableMain_materialStorageOrgUnitID).setValue((Object)(IndustryUtils.isEmptyString((String)forgid) ? "" : forgid));
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.handleException((Exception)((Object)e));
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.handleException(e);
        }
        finally {
            GetMaterialFromBOMFacadeFactory.getRemoteInstance().releaseTable(tablename);
        }
    }

    @Override
    public void actionSaveSelect_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<SelectMaterialFromBOM> materialIDList = new ArrayList<SelectMaterialFromBOM>();
        int[] selectList = KDTableUtil.getSelectedRows((KDTable)this.kDTable);
        if (selectList.length <= 0) {
            MsgBox.showInfo((String)this.SCM_QXZJLH);
            SysUtil.abort();
        }
        for (int i = 0; i < selectList.length; ++i) {
            SelectMaterialFromBOM info = new SelectMaterialFromBOM();
            IRow ir = this.kDTable.getRow(selectList[i]);
            if (ir.getCell(COL_KDTableMain_materialid).getValue() == null) continue;
            info.setMaterialid(ir.getCell(COL_KDTableMain_materialid).getValue().toString());
            if (ir.getCell(COL_KDTableMain_materialqty).getValue() != null) {
                info.setMaterialqty(ir.getCell(COL_KDTableMain_materialqty).getValue().toString());
            }
            if (ir.getCell(COL_KDTableMain_materialStorageOrgUnitID).getValue() == null) continue;
            info.setStorageoegunitid(ir.getCell(COL_KDTableMain_materialStorageOrgUnitID).getValue().toString());
            materialIDList.add(info);
        }
        if (materialIDList.size() > 0) {
            this.getUIContext().put("materialList", materialIDList);
        }
        this.getUIWindow().close();
    }
}

