/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.qm.qc.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.emp.client.EmployeePhoto;
import com.kingdee.eas.industry.emm.qm.qc.client.NCRPhotoFileFilter;
import com.kingdee.eas.industry.emm.qm.qc.client.PhotoFileNameFilter;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;

public class NCRPhotoPanel
extends KDPanel {
    public BufferedImage selectImage = null;
    private File selectFile = null;
    private boolean isDelete = false;
    private String oprtStat = null;

    public NCRPhotoPanel() {
        this.initial();
    }

    public void setOprtStat(String oprtStat) {
        this.oprtStat = oprtStat;
        this.isDelete = false;
    }

    private void initial() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    NCRPhotoPanel.this.photePanel_mouseClicked(e);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });
    }

    protected void photePanel_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.showZoomPhotoDialog();
        } else if (e.getButton() == 3) {
            KDPopupMenu popupMenu = this.CreatePopuMenu();
            this.add((Component)popupMenu);
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private KDPopupMenu CreatePopuMenu() {
        KDPopupMenu popuMenu = new KDPopupMenu();
        if (this.oprtStat != null && !this.oprtStat.equals(OprtState.VIEW)) {
            KDMenuItem mItemAdd = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.ADD_NEW_IMAGE"));
            ActionListener lstAdd = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        NCRPhotoPanel.this.showAddImageDialog();
                        NCRPhotoPanel.this.isDelete = false;
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            };
            mItemAdd.addActionListener(lstAdd);
            popuMenu.add((JMenuItem)mItemAdd);
            KDMenuItem mItemDelete = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.DELETE_IMAGE"));
            ActionListener lstDelete = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NCRPhotoPanel.this.selectImage = null;
                    NCRPhotoPanel.this.isDelete = true;
                    NCRPhotoPanel.this.repaint();
                }
            };
            mItemDelete.addActionListener(lstDelete);
            popuMenu.add((JMenuItem)mItemDelete);
        }
        KDMenuItem mItemSave = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.SAVE_IMAGE"));
        ActionListener lstSave = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NCRPhotoPanel.this.selectImage != null) {
                    NCRPhotoPanel.this.showSaveDialog();
                }
            }
        };
        mItemSave.addActionListener(lstSave);
        popuMenu.add((JMenuItem)mItemSave);
        return popuMenu;
    }

    private void showSaveDialog() {
        KDFileChooser m_chooserSave = new KDFileChooser();
        m_chooserSave.setAcceptAllFileFilterUsed(false);
        m_chooserSave.setFileFilter((FileFilter)new NCRPhotoFileFilter());
        int result = m_chooserSave.showSaveDialog((Component)((Object)this));
        if (result != 0) {
            return;
        }
        File f = m_chooserSave.getSelectedFile();
        this.saveComponentToJPEG(f.getAbsolutePath() + ".jpg");
    }

    private void saveComponentToJPEG(String fileName) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileName));
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showAddImageDialog() throws Exception {
        FileDialog fd = new FileDialog(new Frame(), "", 0);
        fd.setFilenameFilter(new PhotoFileNameFilter());
        fd.setVisible(true);
        this.selectFile = new File(fd.getDirectory(), fd.getFile());
        this.selectImage = ImageIO.read(this.selectFile);
        this.repaint();
    }

    private void showZoomPhotoDialog() {
        UIContext map = new UIContext((Object)this);
        if (this.selectImage == null) {
            return;
        }
        map.put((Object)"selectImage", (Object)this.selectImage);
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow curDialog = uiFactory.create(EmployeePhoto.class.getName(), (Map)map);
            curDialog.show();
        }
        catch (UIException ex1) {
            ex1.printStackTrace();
        }
    }

    public void paint(Graphics arg0) {
        super.paint(arg0);
        if (!this.isDelete && this.selectImage != null) {
            int imgWidth = this.selectImage.getWidth();
            int imgHeight = this.selectImage.getHeight();
            if (imgWidth > this.getWidth() && imgHeight < this.getHeight()) {
                int pWidth = this.getWidth() * imgHeight / this.getHeight();
                arg0.drawImage(this.selectImage, (this.getWidth() - pWidth) / 2, (this.getHeight() - imgHeight) / 2, pWidth, imgHeight, null, null);
            } else if (imgWidth < this.getWidth() && imgHeight > this.getHeight()) {
                int pHeight = this.getHeight() * imgWidth / this.getWidth();
                arg0.drawImage(this.selectImage, (this.getWidth() - imgWidth) / 2, (this.getHeight() - pHeight) / 2, imgWidth, pHeight, null, null);
            } else if (imgWidth < this.getWidth() && imgHeight < this.getHeight()) {
                arg0.drawImage(this.selectImage, (this.getWidth() - imgWidth) / 2, (this.getHeight() - imgHeight) / 2, imgWidth, imgHeight, null, null);
            } else {
                arg0.drawImage(this.selectImage, 0, 0, this.getWidth(), this.getHeight(), null, null);
            }
        } else if (this.oprtStat != null && !this.oprtStat.equals(OprtState.VIEW)) {
            arg0.drawString(EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"267_PhotoPanel"), 6, 75);
        }
    }

    public int getWidth() {
        return super.getWidth();
    }

    public int getHeight() {
        return super.getHeight();
    }

    public BufferedImage getSelectImage() {
        return this.selectImage;
    }

    public void setSelectImage(BufferedImage image) {
        this.selectImage = image;
        this.repaint();
    }

    public File getSelectFile() {
        return this.selectFile;
    }

    public byte[] getSelectImageBytes() {
        try {
            int w = this.getWidth();
            int h = this.getHeight();
            BufferedImage image = (BufferedImage)this.createImage(w, h);
            Graphics2D g2 = image.createGraphics();
            this.print(g2);
            ByteArrayOutputStream outs = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(outs);
            bos.close();
            return outs.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

