/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.scm.sm.directdelivery.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.scm.sm.directdelivery.DDPMergeRuleEntryInfo;
import com.kingdee.eas.industry.emm.scm.sm.directdelivery.DDPMergeRuleFactory;
import com.kingdee.eas.industry.emm.scm.sm.directdelivery.DDPMergeRuleInfo;
import com.kingdee.eas.industry.emm.scm.sm.directdelivery.client.AbstractDDPMergeRuleEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class DDPMergeRuleEditUI
extends AbstractDDPMergeRuleEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DDPMergeRuleEditUI.class);

    private void verifyEntryTime() {
        int count = this.editData.getEntrys().size();
        StringBuffer sbStr = new StringBuffer();
        boolean isFailed = false;
        for (int n = 0; n < count; ++n) {
            Time factendDate;
            DDPMergeRuleEntryInfo entry = this.editData.getEntrys().get(n);
            Time factbeginDate = entry.getStarttime();
            if (UIRuleUtil.isNull((Date)factbeginDate)) {
                isFailed = true;
                String tmp = "\u7b2c" + (n + 1) + "\u884c\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\n";
                sbStr.append(tmp);
            }
            if (UIRuleUtil.isNull((Date)(factendDate = entry.getEndtime()))) {
                isFailed = true;
                String tmp = "\u7b2c" + (n + 1) + "\u884c\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\n";
                sbStr.append(tmp);
            }
            try {
                int dayBetween;
                if (UIRuleUtil.isNull((Date)factbeginDate) || UIRuleUtil.isNull((Date)factendDate) || (dayBetween = DDPMergeRuleEditUI.daysBetween(factbeginDate, factendDate)) >= 0) continue;
                isFailed = true;
                String tmp = "\u7b2c" + (n + 1) + "\u884c\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u8d77\u59cb\u65f6\u95f4\n";
                sbStr.append(tmp);
                continue;
            }
            catch (ParseException e) {
                MsgBox.showInfo((String)e.getMessage());
                return;
            }
        }
        if (isFailed) {
            MsgBox.showInfo((String)sbStr.toString());
            this.abort();
        }
    }

    public static int daysBetween(Date smdate, Date bdate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        smdate = sdf.parse(sdf.format(smdate));
        bdate = sdf.parse(sdf.format(bdate));
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public void verifyInput(ActionEvent e) throws Exception {
        if (e.getSource() == this.btnSave || e.getSource() == this.btnCancelCancel) {
            boolean isExist;
            if (UIRuleUtil.isNull((Object)this.prmtorg.getValue())) {
                MsgBox.showInfo((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.abort();
            }
            if (UIRuleUtil.isNull((Object)this.prmtsupplierorg.getValue())) {
                MsgBox.showInfo((String)"\u4f9b\u5e94\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.abort();
            }
            if (UIRuleUtil.isNull((String)this.txtNumber.getText())) {
                MsgBox.showInfo((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.abort();
            }
            if (this.editData.getEntrys().size() == 0) {
                MsgBox.showInfo((String)"\u76f4\u9001\u8ba1\u5212\u5408\u5e76\u89c4\u5219\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.abort();
            } else {
                this.verifyEntryTime();
            }
            String org = this.prmtorg.getData() == null ? "" : ((StorageOrgUnitInfo)this.prmtorg.getData()).getId().toString();
            String supporg = this.prmtsupplierorg.getData() == null ? "" : ((StorageOrgUnitInfo)this.prmtsupplierorg.getData()).getId().toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("org.id", (Object)org, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("supplierorg.id", (Object)supporg, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)"1", CompareType.EQUALS));
            if (this.editData.getId() != null) {
                String id = this.editData.getId().toString();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
            }
            if (isExist = DDPMergeRuleFactory.getRemoteInstance().exists(filter)) {
                MsgBox.showWarning((String)"\u5df2\u7ecf\u5b58\u5728\u5df2\u542f\u52a8\u7684\u751f\u4ea7\u7ec4\u7ec7\u548c\u4f9b\u8d27\u5e93\u5b58\u7ec4\u7ec7\u7ec4\u5408\u7684\u5408\u5e76\u89c4\u5219");
                SysUtil.abort();
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnCancelCancel.setVisible(true);
        this.btnCancelCancel.setEnabled(true);
        this.btnCancel.setVisible(true);
        this.btnCancel.setEnabled(true);
        this.deletedStatus.setEnabled(false);
        this.btnAttachment.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        int count = this.toolBar.getComponentCount();
        for (int n = 0; n < count; ++n) {
            Component component = this.toolBar.getComponent(n);
            if (!"btnUserScheme".equals(component.getName())) continue;
            this.toolBar.remove(component);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DDPMergeRuleFactory.getRemoteInstance();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    @Override
    protected IObjectValue createNewData() {
        DDPMergeRuleInfo objectValue = new DDPMergeRuleInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        StorageOrgUnitInfo info = (StorageOrgUnitInfo)this.getDefaultMainBizOrg();
        objectValue.setSupplierorg(info);
        objectValue.setOrg(info);
        return objectValue;
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        OrgUnitInfo currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        return currentMainOrg;
    }

    protected void doAfterSave(IObjectPK pk) throws Exception {
        super.doAfterSave(pk);
        this.editData.setAvailable(false);
    }
}

