/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.scm.sm.directdelivery.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonFactory;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.industry.emm.scm.sm.directdelivery.client.AbstractDirectDeliverySituationFilterUI;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DirectDeliverySituationFilterUI
extends AbstractDirectDeliverySituationFilterUI {
    private static final long serialVersionUID = 7321645980962780260L;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initView();
        this.setMaterialF7(this.prmtMaterial, null);
        this.setSupplierF7();
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.prmtStorageOrgUnit, (KDBizPromptBox)this.prmtProjectFrom, (KDBizPromptBox)this.prmtTrackNumerFrom, (boolean)false);
        UIHelper.registerTrackNumberF7ForFilter((KDBizPromptBox)this.prmtStorageOrgUnit, (KDBizPromptBox)this.prmtProjectTo, (KDBizPromptBox)this.prmtTrackNumerTo, (boolean)false);
    }

    public void prmtPurPersonFrom_dataChanged(DataChangeEvent e) throws Exception {
        Object newValue = e.getNewValue();
        Object oldValue = e.getOldValue();
        if (newValue == null || newValue != null && oldValue != null && newValue.equals(oldValue)) {
            return;
        }
        PurchasePersonInfo purPersonInfo = (PurchasePersonInfo)newValue;
        SelectorItemCollection select = new SelectorItemCollection();
        select.add(new SelectorItemInfo("person.number"));
        select.add(new SelectorItemInfo("id"));
        select.add(new SelectorItemInfo("person.name"));
        purPersonInfo = PurchasePersonFactory.getRemoteInstance().getPurchasePersonInfo((IObjectPK)new ObjectUuidPK(purPersonInfo.getId().toString()), select);
        purPersonInfo.setName(purPersonInfo.getPerson().getName());
        purPersonInfo.setNumber(purPersonInfo.getPerson().getNumber());
    }

    private void setSupplierF7() {
        this.prmtSupplier.addCommonF7KDTableListener((CommonF7KDTableListener)new CommonF7KDTableListenerImpl("\u4f9b\u5e94\u5546", this.prmtSupplier));
    }

    private void setMaterialF7(KDBizPromptBox materialBox, OrgUnitInfo storageOrgUnitInfo) {
        String queryInfo = "com.kingdee.eas.basedata.master.material.app.F7MaterialBaseInfoQuery";
        this.f7Manager.registerBizMaterialF7(materialBox, null, queryInfo, null, OrgType.Storage, false, true);
    }

    public boolean verify() {
        boolean v = super.verify();
        if (!v) {
            return v;
        }
        Date factbeginDate = null;
        Date factendDate = null;
        if (this.pkDeDateFrom.getValue() != null) {
            factbeginDate = (Date)this.pkDeDateFrom.getValue();
        }
        if (this.pkDeDateTO.getValue() != null) {
            factendDate = (Date)this.pkDeDateTO.getValue();
        }
        try {
            int dayBetween = DirectDeliverySituationFilterUI.daysBetween(factbeginDate, factendDate);
            if (dayBetween < 0) {
                MsgBox.showInfo((String)"\u9700\u6c42\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u9700\u6c42\u5f00\u59cb\u65f6\u95f4");
                return false;
            }
        }
        catch (ParseException e) {
            MsgBox.showInfo((String)e.getMessage());
            return false;
        }
        return true;
    }

    private void initView() {
        this.pkDeDateFrom.setRequired(true);
        this.pkDeDateTO.setRequired(true);
        this.pkDeDateFrom.setValue((Object)new Date());
        EntityViewInfo evi_storage = this.prmtPurchaseOrgUnit.getEntityViewInfo();
        if (evi_storage == null) {
            evi_storage = new EntityViewInfo();
        }
        if (evi_storage.getFilter() == null) {
            evi_storage.setFilter(new FilterInfo());
        }
        evi_storage.getFilter().getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentOrgUnit().getCU().getId().toString(), CompareType.EQUALS));
        this.prmtPurchaseOrgUnit.setEntityViewInfo(evi_storage);
        EntityViewInfo evi_project = this.prmtProjectFrom.getEntityViewInfo();
        if (evi_project == null) {
            evi_project = new EntityViewInfo();
        }
        if (evi_project.getFilter() == null) {
            evi_project.setFilter(new FilterInfo());
        }
        evi_project.getFilter().getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        this.prmtProjectFrom.setEntityViewInfo(evi_project);
        this.prmtProjectTo.setEntityViewInfo(evi_project);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new SingleFilterElement("tb.fnumber", (Component)this.prmtPurchaseOrgUnit));
        elements.add((FilterElement)new SingleFilterElement("ts.fnumber", (Component)this.prmtSupplier));
        elements.add((FilterElement)new SingleFilterElement("tsg.fnumber", (Component)this.prmtStorageOrgUnit));
        elements.add((FilterElement)new SingleFilterElement("tm.fnumber", (Component)this.prmtMaterial));
        elements.add((FilterElement)new MMRangeFilterElement("tp.fnumber", (Component)this.prmtProjectFrom, (Component)this.prmtProjectTo));
        elements.add((FilterElement)new MMRangeFilterElement("tn.fnumber", (Component)this.prmtTrackNumerFrom, (Component)this.prmtTrackNumerTo));
        MMRangeFilterElement element = new MMRangeFilterElement("dp.cfdemanddate", (Component)this.pkDeDateFrom, (Component)this.pkDeDateTO);
        element.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, "\u9700\u6c42\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        Timestamp[] dates = DirectDeliverySituationFilterUI.getDefaultDateRange(SCMClientUtils.getServerDate2());
        element.setDefaultValue((Object)dates);
        elements.add((FilterElement)element);
        this.getFilterManager().setElement((FilterElement)elements);
    }

    public static Timestamp[] getDefaultDateRange(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        Timestamp currDate = new Timestamp(calendar.getTimeInMillis());
        calendar.add(2, 1);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Timestamp[]{currDate, new Timestamp(calendar.getTimeInMillis())};
    }

    public static int daysBetween(Date smdate, Date bdate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd ");
        smdate = sdf.parse(sdf.format(smdate));
        bdate = sdf.parse(sdf.format(bdate));
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    class CommonF7KDTableListenerImpl
    implements CommonF7KDTableListener {
        private KDBizPromptBox prmtBox;
        private String title;

        private CommonF7KDTableListenerImpl(String title, KDBizPromptBox prmtBox) {
            this.prmtBox = prmtBox;
            this.title = title;
        }

        public void onTableStructureCreated(KDTable arg0) {
            arg0.getColumn(3).getStyleAttributes().setHided(true);
            arg0.getColumn(4).getStyleAttributes().setHided(true);
            arg0.getColumn(5).getStyleAttributes().setHided(true);
            arg0.getColumn(6).getStyleAttributes().setHided(true);
            arg0.getColumn(7).getStyleAttributes().setHided(true);
            arg0.getColumn(8).getStyleAttributes().setHided(true);
            arg0.getColumn(9).getStyleAttributes().setHided(true);
            arg0.getColumn(10).getStyleAttributes().setHided(true);
            arg0.getColumn(11).getStyleAttributes().setHided(true);
            arg0.getColumn(12).getStyleAttributes().setHided(true);
            arg0.getColumn(13).getStyleAttributes().setHided(true);
            ((KDCommonPromptDialog)this.prmtBox.getSelector()).setTitle(this.title);
        }
    }
}

