/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.mm.pm.YearRollingPlanEntryCollection;
import com.kingdee.eas.industry.emm.mm.pm.YearRollingPlanEntryInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sm.pur.BOMPurRequestBySumFactory;
import com.kingdee.eas.scm.sm.pur.BOMPurRequestBySumInfo;
import com.kingdee.eas.scm.sm.pur.IBOMPurRequestBySum;
import com.kingdee.eas.scm.sm.pur.client.AbstractBOMPurRequestBySumEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class BOMPurRequestBySumEditUI
extends AbstractBOMPurRequestBySumEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BOMPurRequestBySumEditUI.class);
    protected DataChangeListener dataChangeListener;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.dataChangeListener == null) {
            this.dataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    if (e.getSource().equals(BOMPurRequestBySumEditUI.this.txtgdzq)) {
                        BOMPurRequestBySumEditUI.this.dataChanged_gdzq(e);
                    } else if (e.getSource().equals(BOMPurRequestBySumEditUI.this.txttqqj)) {
                        BOMPurRequestBySumEditUI.this.dataChanged_tqqj(e);
                    }
                }
            };
            this.txtgdzq.addDataChangeListener(this.dataChangeListener);
            this.txttqqj.addDataChangeListener(this.dataChangeListener);
        }
        if (this.getOprtState() == "ADDNEW") {
            this.baseStatus.setSelectedItem((Object)BillBaseStatusEnum.ADD);
            this.pkBizDate.setValue((Object)new Date());
            this.pkfrom.setValue((Object)new Date());
            this.pkto.setValue((Object)new Date());
            this.pkplanTime.setValue((Object)new Date());
        }
    }

    protected void dataChanged_gdzq(DataChangeEvent e) {
        String gdzq = this.txtgdzq.getText();
        if (gdzq == null || !gdzq.trim().matches("[0-9]{1,}")) {
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.add(2, Integer.parseInt(gdzq.trim()));
        this.pkto.setValue((Object)cal.getTime());
        try {
            this.dataChanged_entrys();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void dataChanged_tqqj(DataChangeEvent e) {
        String tqqj = this.txttqqj.getText();
        if (tqqj == null || !tqqj.trim().matches("[0-9]{1,}")) {
            return;
        }
        Calendar cal = Calendar.getInstance();
        if (!tqqj.trim().equals("0")) {
            cal.add(2, -1 * Integer.parseInt(tqqj.trim()) + 1);
        }
        this.pkfrom.setValue((Object)cal.getTime());
        try {
            this.dataChanged_entrys();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void dataChanged_entrys() throws EASBizException, BOSException {
        Date from = (Date)this.pkfrom.getValue();
        Date to = (Date)this.pkto.getValue();
        if (from == null || to == null) {
            return;
        }
        this.kdtEntrys.removeRows();
        YearRollingPlanEntryCollection yrpes = BOMPurRequestBySumFactory.getRemoteInstance().getYearRollingPlan(from, to);
        OrgUnitCollection cols = null;
        if (this.prmtpurchaseOrg.getValue() != null) {
            PurchaseOrgUnitInfo purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)this.prmtpurchaseOrg.getValue();
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            cols = iUnitRel.getToUnit(purchaseOrgUnitInfo.getId().toString(), 3, 1);
        }
        int size = yrpes.size();
        for (int i = 0; i < size; ++i) {
            IRow row;
            ICell cell;
            YearRollingPlanEntryInfo entry = yrpes.get(i);
            if (entry.get("isdistinct") != null && "true".equals(entry.get("isdistinct").toString())) continue;
            if (cols != null && cols.size() > 0 && entry.get("companyOrgUnitID") != null) {
                boolean issameCompanyOrgUnit = false;
                for (int jj = 0; jj < cols.size(); ++jj) {
                    if (!cols.get(jj).getId().toString().equals(entry.get("companyOrgUnitID").toString())) continue;
                    issameCompanyOrgUnit = true;
                }
                if (!issameCompanyOrgUnit) continue;
            }
            if ((cell = (row = this.kdtEntrys.addRow()).getCell("project")) != null) {
                cell.setValue((Object)entry.getParent().getProject());
            }
            if ((cell = row.getCell("tracknumber")) != null) {
                cell.setValue((Object)entry.getTrackNumber());
            }
            if ((cell = row.getCell("batch")) != null) {
                cell.setValue(entry.get("batch"));
            }
            if ((cell = row.getCell("material")) != null) {
                cell.setValue(entry.get("material"));
            }
            if ((cell = row.getCell("materialName")) == null) continue;
            cell.setValue(entry.get("materialName"));
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.baseStatus.setSelectedItem((Object)BillBaseStatusEnum.TEMPORARILYSAVED);
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        int count;
        if (this.prmtpurchaseOrg.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource ", (String)"0EMMSCMPur-0038"));
            SysUtil.abort();
        }
        if (this.pkfrom.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource ", (String)"0EMMSCMPur-0039"));
            SysUtil.abort();
        }
        if (this.pkto.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource ", (String)"0EMMSCMPur-0040"));
            SysUtil.abort();
        }
        if (this.pkplanTime.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource ", (String)"0EMMSCMPur-0041"));
            SysUtil.abort();
        }
        if ((count = this.kdtEntrys.getRowCount()) <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource ", (String)"0EMMSCMPur-0042"));
            SysUtil.abort();
        }
        StringBuilder error = new StringBuilder();
        StringBuilder error_row = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            error_row.setLength(0);
            ICell cell = row.getCell("project");
            if (cell != null && cell.getValue() == null) {
                error_row.append("\u3001").append(EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource ", (String)"0EMMSCMPur-0043"));
            }
            if ((cell = row.getCell("tracknumber")) != null && cell.getValue() == null) {
                error_row.append("\u3001").append(EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource ", (String)"0EMMSCMPur-0044"));
            }
            if ((cell = row.getCell("batch")) != null && cell.getValue() == null) {
                error_row.append("\u3001").append(EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource ", (String)"0EMMSCMPur-0045"));
            }
            if ((cell = row.getCell("material")) != null && cell.getValue() == null) {
                error_row.append("\u3001").append(EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource ", (String)"0EMMSCMPur-0046"));
            }
            if (error_row.length() <= 0) continue;
            String strInfo = EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"DHBT", (Object[])new Object[]{i + 1, error_row.substring(1)});
            error.append(strInfo);
        }
        if (error.length() > 0) {
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource ", (String)"0EMMSCMPur-0047") + error.toString()));
            SysUtil.abort();
        }
        this.baseStatus.setSelectedItem((Object)BillBaseStatusEnum.SUBMITED);
        super.actionSubmit_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        IBOMPurRequestBySum ibpr = (IBOMPurRequestBySum)this.getBizInterface();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)90));
        if (ibpr.exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource ", (String)"0EMMSCMPur-0048"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        IBOMPurRequestBySum ibpr = (IBOMPurRequestBySum)this.getBizInterface();
        FilterInfo _filter = new FilterInfo();
        _filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        _filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)BillBaseStatusEnum.SUBMITED));
        if (ibpr.exists(_filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource ", (String)"0EMMSCMPur-0049"));
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)90));
        if (ibpr.exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource ", (String)"0EMMSCMPur-0050"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BOMPurRequestBySumFactory.getRemoteInstance();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        BOMPurRequestBySumInfo objectValue = new BOMPurRequestBySumInfo();
        if (SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Purchase")) != null && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Purchase")).getBoolean("isBizUnit")) {
            objectValue.put("purchaseOrg", SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Purchase")));
        }
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setBaseStatus(BillBaseStatusEnum.ADD);
        return objectValue;
    }
}

