/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupCollection;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupFactory;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.common.ExcelDate;
import com.kingdee.eas.industry.emm.pm.SqlExecuteFacadeFactory;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.UISettingFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sm.pur.IPurInventoryBill;
import com.kingdee.eas.scm.sm.pur.PurInventoryBillFactory;
import com.kingdee.eas.scm.sm.pur.PurInventoryBillInfo;
import com.kingdee.eas.scm.sm.pur.PurInventoryBillMinMaxTrackFactory;
import com.kingdee.eas.scm.sm.pur.PurInventoryBillMinMaxTrackInfo;
import com.kingdee.eas.scm.sm.pur.PurReTypeFactory;
import com.kingdee.eas.scm.sm.pur.PurReTypeInfo;
import com.kingdee.eas.scm.sm.pur.client.AbstractPurInventoryBillEditUI;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JFileChooser;
import org.apache.log4j.Logger;

public class PurInventoryBillEditUI
extends AbstractPurInventoryBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PurInventoryBillEditUI.class);
    private static final String COL_PURORGUNIT = "purOrgUnit";
    private static boolean IsLoadField;

    public PurInventoryBillEditUI() throws Exception {
        this.filterTrackNumber();
    }

    @Override
    public void loadFields() {
        IsLoadField = true;
        super.loadFields();
        this.txtDescription.setVisible(false);
        this.contDescription.setVisible(false);
        this.txtDescription.setEnabled(false);
        this.contDescription.setEnabled(false);
        if (this.editData.getPurchaseOrg() == null) {
            try {
                CoreBaseCollection temporgcol = PurchaseOrgUnitFactory.getRemoteInstance().getCollection("select * where number='1.70.00'");
                if (temporgcol != null && temporgcol.size() > 0) {
                    this.editData.setPurchaseOrg((PurchaseOrgUnitInfo)temporgcol.get(0));
                    this.prmtpurchaseOrg.setValue((Object)temporgcol.get(0));
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
                this.handleException((Exception)((Object)e));
            }
        }
        if (this.editData.getBaseStatus().getValue() != 0 && this.editData.getBaseStatus().getValue() != 1 && this.editData.getBaseStatus().getValue() != 2) {
            this.kdtEntrys.getColumn("craftRemark").getStyleAttributes().setLocked(true);
        } else {
            this.kdtEntrys.getColumn("craftRemark").getStyleAttributes().setLocked(false);
        }
        IsLoadField = false;
        this.prmtprojectNo.setQueryInfo("com.kingdee.eas.mm.project.app.F7ProjectQuery");
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo flter = new FilterInfo();
        flter.getFilterItems().add(new FilterItemInfo("CU.id", SysContext.getSysContext().getCurrentCtrlUnit() == null ? null : SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        flter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4), CompareType.EQUALS));
        ev.setFilter(flter);
        this.prmtprojectNo.setEntityViewInfo(ev);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        BillBaseStatusEnum status;
        super.onLoad();
        this.jbinit();
        this.btnStatus();
        this.setControls();
        this.setPurGroup();
        this.contpurchaseOrg.setVisible(false);
        if (this.getUIContext().get("isEditPur") != null && Boolean.TRUE.equals(this.getUIContext().get("isEditPur"))) {
            this.actionAudit.setVisible(false);
            this.actionUnAudit.setVisible(false);
        }
        if (this.getOprtState().equalsIgnoreCase(OprtState.ADDNEW)) {
            this.kdtEntrys.addRow();
        }
        if ((status = this.editData.getBaseStatus()).equals((Object)BillBaseStatusEnum.ADD)) {
            this.kdtEntrys.getColumn(COL_PURORGUNIT).getStyleAttributes().setLocked(false);
            this.kdtEntrys.getColumn("standardNumber").getStyleAttributes().setLocked(false);
        }
    }

    private void setPurGroup() throws BOSException {
        String status = this.getOprtState();
        if ("EDIT".equals(status) && BillBaseStatusEnum.AUDITED.equals((Object)this.editData.getBaseStatus())) {
            int i;
            PurchaseOrgUnitInfo orgInfo = (PurchaseOrgUnitInfo)this.kdtEntrys.getCell(0, COL_PURORGUNIT).getValue();
            this.kdtEntrys.getColumn(COL_PURORGUNIT).getStyleAttributes().setLocked(true);
            if (null == orgInfo) {
                return;
            }
            String orgID = orgInfo.getId().toString();
            HashSet<String> materialIdset = new HashSet<String>();
            int count = this.kdtEntrys.getRowCount();
            for (int i2 = 0; i2 < count; ++i2) {
                MaterialInfo material = (MaterialInfo)this.kdtEntrys.getCell(i2, "material").getValue();
                if (null == material) continue;
                String materialId = material.getId().toString();
                materialIdset.add(materialId);
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("material"));
            sic.add(new SelectorItemInfo("purGroup"));
            sic.add(new SelectorItemInfo("purGroup.name"));
            FilterInfo filter = new FilterInfo();
            EntityViewInfo view = new EntityViewInfo();
            filter.getFilterItems().add(new FilterItemInfo("material", materialIdset, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgID, CompareType.EQUALS));
            view.setSelector(sic);
            view.setFilter(filter);
            MaterialPurchasingCollection materialCollection = MaterialPurchasingFactory.getRemoteInstance().getMaterialPurchasingCollection(view);
            HashMap<String, PurchaseGroupInfo> materPurGroup = new HashMap<String, PurchaseGroupInfo>();
            for (i = 0; i < materialCollection.size(); ++i) {
                MaterialPurchasingInfo mateInfo = materialCollection.get(i);
                String materId = mateInfo.getMaterial().getId().toString();
                PurchaseGroupInfo purGroup = mateInfo.getPurGroup();
                materPurGroup.put(materId, purGroup);
            }
            for (i = 0; i < count; ++i) {
                MaterialInfo material = (MaterialInfo)this.kdtEntrys.getCell(i, "material").getValue();
                PurchaseGroupInfo purGroup = (PurchaseGroupInfo)this.kdtEntrys.getCell(i, "purGroup").getValue();
                if (null == material || null != purGroup) continue;
                String materialId = material.getId().toString();
                purGroup = (PurchaseGroupInfo)materPurGroup.get(materialId);
                this.kdtEntrys.getCell(i, "purGroup").setValue((Object)purGroup);
            }
        }
    }

    public Map setEntryMap() throws EASBizException, BOSException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int count = this.kdtEntrys.getRowCount();
        if (count == 0) {
            MsgBox.showError((String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0095"));
            SysUtil.abort();
        }
        for (int i = 0; i < count; ++i) {
            MaterialInfo material = (MaterialInfo)this.kdtEntrys.getCell(i, "material").getValue();
            map.put(material.getNumber(), i);
        }
        return map;
    }

    @Override
    protected void kdtEntrys_editStopped(KDTEditEvent e) throws Exception {
        BigDecimal qty;
        if (IsLoadField) {
            return;
        }
        BigDecimal tcQty = qty = new BigDecimal(0);
        BigDecimal tlQty = qty;
        if (e.getColIndex() == this.kdtEntrys.getColumn("qty").getColumnIndex() && this.kdtEntrys.getCell(e.getRowIndex(), "qty").getValue() != null && e.getValue() != null && !e.getValue().toString().equals(e.getOldValue()) || e.getColIndex() == this.kdtEntrys.getColumn("taOut").getColumnIndex() && this.kdtEntrys.getCell(e.getRowIndex(), "taOut").getValue() != null && e.getValue() != null && !e.getValue().toString().equals(e.getOldValue())) {
            if (this.kdtEntrys.getCell(e.getRowIndex(), "qty").getValue() != null) {
                tcQty = (BigDecimal)this.kdtEntrys.getCell(e.getRowIndex(), "qty").getValue();
            }
            if (this.kdtEntrys.getCell(e.getRowIndex(), "taOut").getValue() != null) {
                tlQty = (BigDecimal)this.kdtEntrys.getCell(e.getRowIndex(), "taOut").getValue();
            }
            this.kdtEntrys.getCell(e.getRowIndex(), "purQty").setValue((Object)tcQty.multiply(tlQty));
        }
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        String colName_purGroup = "";
        String colName_taOut = "";
        String colName_planPurTime = "";
        String colName_material = "";
        try {
            colName_purGroup = this.kdtEntrys.getHead().getRow(0).getCell(this.kdtEntrys.getColumn("purGroup").getColumnIndex()).getValue().toString();
            colName_taOut = this.kdtEntrys.getHead().getRow(0).getCell(this.kdtEntrys.getColumn("taOut").getColumnIndex()).getValue().toString();
            colName_planPurTime = this.kdtEntrys.getHead().getRow(0).getCell(this.kdtEntrys.getColumn("planPurTime").getColumnIndex()).getValue().toString();
            colName_material = this.kdtEntrys.getHead().getRow(0).getCell(this.kdtEntrys.getColumn("material").getColumnIndex()).getValue().toString();
        }
        catch (Exception ex) {
            MsgBox.showWarning((String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0096"));
            SysUtil.abort();
        }
        super.actionImport_actionPerformed(e);
        JFileChooser chooser = new JFileChooser();
        File pictureFile = null;
        int returnVal = chooser.showOpenDialog((Component)((Object)this));
        Map map = this.setEntryMap();
        if (returnVal == 0) {
            pictureFile = chooser.getSelectedFile();
            ExcelDate excelHandle = new ExcelDate();
            excelHandle.setFileName(pictureFile.getAbsolutePath());
            String[][] execlData = excelHandle.getData2(0, 0, 16);
            String[] titles = execlData[0];
            int colIndex_taOut = 4;
            int colIndex_purGroup = 6;
            int colIndex_planPurTime = 7;
            int colIndex_material = 0;
            int length = titles.length;
            for (int i = 0; i < length; ++i) {
                String ti = titles[i];
                if (colName_purGroup.equals(ti)) {
                    colIndex_purGroup = i;
                    continue;
                }
                if (colName_taOut.equals(ti)) {
                    colIndex_taOut = i;
                    continue;
                }
                if (colName_planPurTime.equals(ti)) {
                    colIndex_planPurTime = i;
                    continue;
                }
                if (!colName_material.equals(ti)) continue;
                colIndex_material = i;
            }
            PurchaseGroupInfo groupinfo = null;
            PurchaseOrgUnitInfo unitInfo = (PurchaseOrgUnitInfo)this.prmtpurchaseOrg.getValue();
            int b = 0;
            for (int i = 1; i < execlData.length; ++i) {
                if (execlData[i][colIndex_purGroup] != null || execlData[i][colIndex_purGroup].trim() != "") {
                    FilterInfo filter = new FilterInfo();
                    EntityViewInfo view = new EntityViewInfo();
                    filter.getFilterItems().add(new FilterItemInfo("name", (Object)execlData[i][colIndex_purGroup].trim(), CompareType.EQUALS));
                    if (unitInfo != null) {
                        filter.getFilterItems().add(new FilterItemInfo("purOrg", (Object)unitInfo.getId().toString(), CompareType.EQUALS));
                        filter.setMaskString("#0 and #1");
                    }
                    view.setFilter(filter);
                    PurchaseGroupCollection purcol = PurchaseGroupFactory.getRemoteInstance().getPurchaseGroupCollection(view);
                    groupinfo = purcol.get(0);
                }
                SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd");
                Date date = format1.parse(execlData[i][colIndex_planPurTime]);
                BigDecimal taOutQty = SysConstant.BIGZERO;
                try {
                    taOutQty = new BigDecimal(execlData[i][colIndex_taOut]);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    MsgBox.showWarning((String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0097"));
                    SysUtil.abort();
                }
                int rowindex = Integer.parseInt(map.get(execlData[i][colIndex_material]).toString());
                this.kdtEntrys.getCell(rowindex, "taOut").setValue((Object)taOutQty);
                this.kdtEntrys.getCell(rowindex, "purGroup").setValue((Object)groupinfo);
                this.kdtEntrys.getCell(rowindex, "planPurTime").setValue((Object)date);
                if (this.kdtEntrys.getCell(rowindex, "qty").getValue() != null) {
                    BigDecimal qty = (BigDecimal)this.kdtEntrys.getCell(rowindex, "qty").getValue();
                    this.kdtEntrys.getCell(rowindex, "purQty").setValue((Object)qty.multiply(taOutQty));
                }
                ++b;
            }
            String strInfo = com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"CGDRSJ", (Object[])new Object[]{b});
            MsgBox.showWarning((String)strInfo);
        }
    }

    @Override
    public void actionUpdatePur_actionPerformed(ActionEvent e) throws Exception {
        super.actionUpdatePur_actionPerformed(e);
        Object object = this.prmtprojectNo.getValue();
        ProjectInfo project = object instanceof ProjectInfo ? (ProjectInfo)object : null;
        if (project == null) {
            MsgBox.showError((String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0098"));
            return;
        }
        AdminOrgUnitInfo admininfo = (AdminOrgUnitInfo)this.prmtadminOrgUnit.getValue();
        if (admininfo == null) {
            MsgBox.showError((String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0099"));
            return;
        }
        int count = this.kdtEntrys.getRowCount();
        if (count == 0) {
            MsgBox.showError((String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0100"));
            return;
        }
        for (int i = 0; i < count; ++i) {
            MaterialInfo material = (MaterialInfo)this.kdtEntrys.getCell(i, "material").getValue();
            if (material == null) {
                MsgBox.showError((String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0101"));
                return;
            }
            String str = "select bill.CFPurReTypeID purReType,bill.CFStartTrackID startTrack,bill.CFEndTrackID endTrack, et.CFPurOrgUnit purOrgUnit,et.CFPurGroupID purGroup,et.CFTaOut taOut,et.CFPlanPurTime planPurTime from CT_PUR_PurInventoryBill bill  inner join CT_PUR_PurInventoryBillEntry et  on et.fparentid = bill.fid ";
            str = str + "where bill.CFProjectNoID = '" + project.getId().toString() + "'";
            str = str + "and bill.CFAdminOrgUnitID = '" + admininfo.getId().toString() + "' ";
            str = str + "and et.CFMaterialID = '" + material.getId().toString() + "' ";
            str = str + "and bill.fid <> '" + this.editData.getId().toString() + "' order by fcreateTime desc";
            IRowSet ir = SqlExecuteFacadeFactory.getRemoteInstance().executeQuery(str.toString());
            if (!ir.next()) continue;
            if (ir.getString("purReType") != null) {
                ObjectUuidPK purtypepk = new ObjectUuidPK(ir.getString("purReType"));
                PurReTypeInfo purtypeinfo = PurReTypeFactory.getRemoteInstance().getPurReTypeInfo((IObjectPK)purtypepk);
                this.prmtpurReType.setValue((Object)purtypeinfo);
            }
            if (ir.getString("startTrack") != null) {
                ObjectUuidPK startpk = new ObjectUuidPK(ir.getString("startTrack"));
                TrackNumberInfo startinfo = TrackNumberFactory.getRemoteInstance().getTrackNumberInfo((IObjectPK)startpk);
                this.prmtstartTrack.setValue((Object)startinfo);
            }
            if (ir.getString("endTrack") != null) {
                ObjectUuidPK endpk = new ObjectUuidPK(ir.getString("endTrack"));
                TrackNumberInfo endinfo = TrackNumberFactory.getRemoteInstance().getTrackNumberInfo((IObjectPK)endpk);
                this.prmtendTrack.setValue((Object)endinfo);
            }
            if (ir.getString(COL_PURORGUNIT) != null) {
                ObjectUuidPK purOrgUnitPk = new ObjectUuidPK(ir.getString(COL_PURORGUNIT));
                PurchaseOrgUnitInfo purOrgUnitinfo = PurchaseOrgUnitFactory.getRemoteInstance().getPurchaseOrgUnitInfo((IObjectPK)purOrgUnitPk);
                this.kdtEntrys.getCell(i, COL_PURORGUNIT).setValue((Object)purOrgUnitinfo);
            }
            if (ir.getString("purGroup") != null) {
                ObjectUuidPK purGrouppk = new ObjectUuidPK(ir.getString("purGroup"));
                PurchaseGroupInfo groupinfo = PurchaseGroupFactory.getRemoteInstance().getPurchaseGroupInfo((IObjectPK)purGrouppk);
                this.kdtEntrys.getCell(i, "purGroup").setValue((Object)groupinfo);
            }
            BigDecimal taOut = ir.getBigDecimal("taOut");
            BigDecimal qty = (BigDecimal)this.kdtEntrys.getCell(i, "qty").getValue();
            this.kdtEntrys.getCell(i, "taOut").setValue((Object)ir.getBigDecimal("taOut"));
            this.kdtEntrys.getCell(i, "purQty").setValue((Object)taOut.multiply(qty));
            this.kdtEntrys.getCell(i, "planPurTime").setValue((Object)ir.getDate("planPurTime"));
        }
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        IndustryUtils.removeKDTableActionMap((KDTable)this.trackNumber, (String[])new String[]{"AddRow", "RemoveRow", "Delete", "Paste"});
    }

    void setControls() {
        String status = this.getOprtState();
        if (status == "EDIT" && (this.editData.getBaseStatus().getValue() == 1 || this.editData.getBaseStatus().getValue() == 2)) {
            this.kdtEntrys.getColumn("process").getStyleAttributes().setLocked(false);
            this.kdtEntrys.getColumn(COL_PURORGUNIT).getStyleAttributes().setLocked(false);
        }
        if (status == "EDIT" && this.editData.getBaseStatus().getValue() == 4) {
            this.prmtstartTrack.setEnabled(true);
            this.prmtendTrack.setEnabled(true);
            this.prmtpurReType.setEnabled(true);
            this.kdtEntrys.getColumn("taOut").getStyleAttributes().setLocked(false);
            this.kdtEntrys.getColumn("purGroup").getStyleAttributes().setLocked(false);
            this.kdtEntrys.getColumn("planPurTime").getStyleAttributes().setLocked(false);
            this.kdtEntrys.getColumn("material").getStyleAttributes().setLocked(true);
            this.kdtEntrys.getColumn("qty").getStyleAttributes().setLocked(true);
            this.btnImport.setEnabled(true);
            this.btnUpdatePur.setEnabled(true);
        } else {
            this.btnImport.setEnabled(false);
            this.btnUpdatePur.setEnabled(false);
        }
    }

    void btnStatus() {
        this.btnAudit.setEnabled(true);
        this.btnUnAudit.setEnabled(true);
        this.btnEditPur.setVisible(false);
        this.btnAuditPur.setEnabled(true);
        this.btnUnAuditPur.setEnabled(true);
        this.btnTraceDown.setVisible(true);
        this.btnTraceUp.setVisible(true);
        this.btnTAddNewLine.setEnabled(true);
        this.btnTInsertLine.setEnabled(true);
        this.btnTRemoveLines.setEnabled(true);
    }

    private void jbinit() throws BOSException, Exception {
        final KDBizPromptBox kdtEntrys_purGroup_PromptBox = new KDBizPromptBox();
        kdtEntrys_purGroup_PromptBox.setQueryInfo("com.kingdee.eas.basedata.scm.sm.pur.app.PurGroupQuery");
        kdtEntrys_purGroup_PromptBox.setVisible(true);
        kdtEntrys_purGroup_PromptBox.setEditable(true);
        kdtEntrys_purGroup_PromptBox.setDisplayFormat("$number$");
        kdtEntrys_purGroup_PromptBox.setEditFormat("$number$");
        kdtEntrys_purGroup_PromptBox.setCommitFormat("$number$");
        KDTDefaultCellEditor kdtEntrys_purGroup_CellEditor = new KDTDefaultCellEditor((IKDEditor)kdtEntrys_purGroup_PromptBox);
        this.kdtEntrys.getColumn("purGroup").setEditor((ICellEditor)kdtEntrys_purGroup_CellEditor);
        ObjectValueRender kdtEntrys_purGroup_OVR = new ObjectValueRender();
        kdtEntrys_purGroup_OVR.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntrys.getColumn("purGroup").setRenderer((IBasicRender)kdtEntrys_purGroup_OVR);
        KDBizPromptBox kdtEntrys_purOrgUnit_PromptBox = new KDBizPromptBox();
        kdtEntrys_purOrgUnit_PromptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.PurchaseItemQuery");
        kdtEntrys_purOrgUnit_PromptBox.setVisible(true);
        kdtEntrys_purOrgUnit_PromptBox.setEditable(true);
        kdtEntrys_purOrgUnit_PromptBox.setDisplayFormat("$number$");
        kdtEntrys_purOrgUnit_PromptBox.setEditFormat("$number$");
        kdtEntrys_purOrgUnit_PromptBox.setCommitFormat("$number$");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        kdtEntrys_purOrgUnit_PromptBox.setEntityViewInfo(view);
        KDTDefaultCellEditor kdtEntrys_purOrgUnit_CellEditor = new KDTDefaultCellEditor((IKDEditor)kdtEntrys_purOrgUnit_PromptBox);
        this.kdtEntrys.getColumn(COL_PURORGUNIT).setEditor((ICellEditor)kdtEntrys_purOrgUnit_CellEditor);
        ObjectValueRender kdtEntrys_purOrgUnit_OVR = new ObjectValueRender();
        kdtEntrys_purOrgUnit_OVR.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntrys.getColumn(COL_PURORGUNIT).setRenderer((IBasicRender)kdtEntrys_purOrgUnit_OVR);
        this.kdtEntrys.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int[] rows = KDTableUtil.getSelectedRows((KDTable)PurInventoryBillEditUI.this.kdtEntrys);
                PurchaseOrgUnitInfo orginfo = (PurchaseOrgUnitInfo)PurInventoryBillEditUI.this.kdtEntrys.getCell(rows[0], PurInventoryBillEditUI.COL_PURORGUNIT).getValue();
                if (orginfo != null) {
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo flter = new FilterInfo();
                    flter.getFilterItems().add(new FilterItemInfo("purOrg.id", (Object)orginfo.getId().toString(), CompareType.EQUALS));
                    ev.setFilter(flter);
                    kdtEntrys_purGroup_PromptBox.setEntityViewInfo(ev);
                }
            }
        });
        UISettingFactory.getInstance().displayTrackName((CoreUIObject)this);
        int count = this.kdtEntrys.getRowCount();
        for (int i = 0; i < count; ++i) {
            MaterialInfo materialinfo = (MaterialInfo)this.kdtEntrys.getCell(i, "material").getValue();
            if (materialinfo == null) continue;
            this.kdtEntrys.getCell(i, "materialName").setValue((Object)materialinfo.getName());
            MeasureUnitInfo unitinfo = null;
            if (materialinfo.getBaseUnit() != null) {
                unitinfo = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(materialinfo.getBaseUnit().getId()));
            }
            this.kdtEntrys.getCell(i, "unit").setValue(unitinfo);
        }
        this.prmtprojectNo.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    PurInventoryBillEditUI.this.filterTrackNumber();
                }
                catch (Exception exc) {
                    PurInventoryBillEditUI.this.handUIException(exc);
                }
            }
        });
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(10));
        status.add(new Integer(20));
        status.add(new Integer(30));
        status.add(new Integer(40));
        status.add(new Integer(50));
        status.add(new Integer(60));
        status.add(new Integer(70));
        UIHelper.registerTrackNumberF7(null, null, (KDBizPromptBox)this.prmtprojectNo, (KDBizPromptBox)this.prmtstartTrack, status, (boolean)false);
    }

    private void filterTrackNumber() throws BOSException {
        KDBizPromptBox kdtEntrys_trackNumber_PromptBox = new KDBizPromptBox();
        kdtEntrys_trackNumber_PromptBox.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumberQuery");
        kdtEntrys_trackNumber_PromptBox.setVisible(true);
        kdtEntrys_trackNumber_PromptBox.setEditable(true);
        kdtEntrys_trackNumber_PromptBox.setDisplayFormat("$number$");
        kdtEntrys_trackNumber_PromptBox.setEditFormat("$number$");
        kdtEntrys_trackNumber_PromptBox.setCommitFormat("$number$");
        UIHelper.registerTrackNumberF7ForEdit((KDBizPromptBox)this.prmtadminOrgUnit, null, (KDBizPromptBox)this.prmtprojectNo, (KDBizPromptBox)kdtEntrys_trackNumber_PromptBox, (boolean)false);
        KDTDefaultCellEditor kdtEntrys_trackNumber_CellEditor = new KDTDefaultCellEditor((IKDEditor)kdtEntrys_trackNumber_PromptBox);
        this.trackNumber.getColumn("trackNumber").setEditor((ICellEditor)kdtEntrys_trackNumber_CellEditor);
        ObjectValueRender kdtEntrys_trackNumber_OVR = new ObjectValueRender();
        kdtEntrys_trackNumber_OVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.trackNumber.getColumn("trackNumber").setRenderer((IBasicRender)kdtEntrys_trackNumber_OVR);
    }

    @Override
    public void actionEditPur_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionAuditPur_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (this.editData.getId() == null || !BillBaseStatusEnum.AUDITED.equals((Object)this.editData.getBaseStatus())) {
            MsgBox.showWarning((Component)((Object)this), (String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.industry.emm.project.biz.binv.EMMPROJECTBizBinvResource", (String)"PROJECT_BCYSHZT"));
            return;
        }
        list.add(this.editData.getId().toString());
        ((IPurInventoryBill)this.getBizInterface()).auditPur(list);
        this.showSuccessMsg(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0102"));
        this.btnSubmit.setEnabled(false);
        this.btnSave.setEnabled(false);
    }

    @Override
    public void actionUnAuditPur_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.editData.getId().toString());
        ((IPurInventoryBill)this.getBizInterface()).unAuditPur(list);
        this.showSuccessMsg(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0103"));
        this.btnSubmit.setEnabled(true);
        this.btnSave.setEnabled(true);
    }

    protected void btnAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddLine_actionPerformed(e);
    }

    protected void menuItemEnterToNextRow_itemStateChanged(ItemEvent e) throws Exception {
        super.menuItemEnterToNextRow_itemStateChanged(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        int rowCount;
        String strInfo;
        int i;
        if (this.editData.getBaseStatus().getValue() == 4) {
            this.isValue();
        }
        StringBuffer errorDetailSB = new StringBuffer();
        ArrayList<String> trackNumberLs = new ArrayList<String>();
        ArrayList mintrackNumberLs = new ArrayList();
        ArrayList maxtrackNumberLs = new ArrayList();
        if (UIRuleUtil.isNull((Object)this.prmtprojectNo.getData())) {
            errorDetailSB.append(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0104")).append("\n\r");
        }
        if (UIRuleUtil.isNull((Object)this.comVersionNumber.getSelectedItem())) {
            errorDetailSB.append(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0105")).append("\n\r");
        }
        if (UIRuleUtil.isNull((Object)this.prmtadminOrgUnit.getData())) {
            errorDetailSB.append(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0106")).append("\n\r");
        }
        int n = this.kdtEntrys.getRowCount();
        for (i = 0; i < n; ++i) {
            if (!UIRuleUtil.isNull((Object)this.kdtEntrys.getCell(i, "material").getValue())) continue;
            strInfo = com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"WLBMBWK", (Object[])new Object[]{i + 1});
            errorDetailSB.append(strInfo).append("\n\r");
        }
        n = this.kdtEntrys.getRowCount();
        for (i = 0; i < n; ++i) {
            if (!UIRuleUtil.isNull((Object)this.kdtEntrys.getCell(i, "qty").getValue())) continue;
            strInfo = com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"DRBWK", (Object[])new Object[]{i + 1});
            errorDetailSB.append(strInfo).append("\n\r");
        }
        if (UIRuleUtil.isNull((Object)this.prmtapplicant.getData())) {
            errorDetailSB.append(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0107")).append("\n\r");
        }
        if ((rowCount = this.trackNumber.getRowCount()) > 0) {
            ArrayList<String> tracks = new ArrayList<String>();
            int size = rowCount;
            for (int i2 = 0; i2 < size; ++i2) {
                String key;
                IRow row = this.trackNumber.getRow(i2);
                TrackNumberInfo track = (TrackNumberInfo)row.getCell("trackNumber").getValue();
                if (track == null) {
                    String strInfo2 = com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"GZHBWK", (Object[])new Object[]{i2 + 1});
                    errorDetailSB.append(strInfo2).append("\n\r");
                }
                if (tracks.contains(key = track.getNumber())) {
                    String strInfo3 = com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"GZHCF", (Object[])new Object[]{i2 + 1, key});
                    errorDetailSB.append(strInfo3).append("\n\r");
                }
                tracks.add(key);
                trackNumberLs.add(key);
            }
        }
        if (errorDetailSB.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0108"), (String)errorDetailSB.toString(), (int)1);
            SysUtil.abort();
        }
        super.actionSave_actionPerformed(e);
        CoreBaseCollection colls = new CoreBaseCollection();
        if (!trackNumberLs.isEmpty()) {
            int i3;
            Collections.sort(trackNumberLs);
            if (trackNumberLs.contains("PUB")) {
                PurInventoryBillMinMaxTrackInfo minMaxtrackInfo = new PurInventoryBillMinMaxTrackInfo();
                minMaxtrackInfo.setId(BOSUuid.create((BOSObjectType)minMaxtrackInfo.getBOSType()));
                minMaxtrackInfo.setPatent(this.editData.getId().toString());
                minMaxtrackInfo.setMinTrackNumber("PUB");
                minMaxtrackInfo.setMaxTrackNumber("PUB");
                minMaxtrackInfo.setTrackQty(1);
                colls.add((CoreBaseInfo)minMaxtrackInfo);
                trackNumberLs.remove("PUB");
            }
            for (i3 = 0; i3 < trackNumberLs.size(); ++i3) {
                if (i3 == 0) {
                    mintrackNumberLs.add(trackNumberLs.get(0));
                } else if (this.getIntByString((String)trackNumberLs.get(i3)) != this.getIntByString((String)trackNumberLs.get(i3 - 1)) + 1) {
                    mintrackNumberLs.add(trackNumberLs.get(i3));
                    maxtrackNumberLs.add(trackNumberLs.get(i3 - 1));
                }
                if (i3 != trackNumberLs.size() - 1) continue;
                maxtrackNumberLs.add(trackNumberLs.get(i3));
            }
            for (i3 = 0; i3 < mintrackNumberLs.size(); ++i3) {
                PurInventoryBillMinMaxTrackInfo minMaxtrackInfo = new PurInventoryBillMinMaxTrackInfo();
                minMaxtrackInfo.setId(BOSUuid.create((BOSObjectType)minMaxtrackInfo.getBOSType()));
                minMaxtrackInfo.setPatent(this.editData.getId().toString());
                minMaxtrackInfo.setMinTrackNumber(((String)mintrackNumberLs.get(i3)).toString());
                minMaxtrackInfo.setMaxTrackNumber(((String)maxtrackNumberLs.get(i3)).toString());
                minMaxtrackInfo.setTrackQty(this.getIntByString((String)maxtrackNumberLs.get(i3)) - this.getIntByString((String)mintrackNumberLs.get(i3)) + 1);
                colls.add((CoreBaseInfo)minMaxtrackInfo);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("patent", (Object)this.editData.getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            PurInventoryBillMinMaxTrackFactory.getRemoteInstance().delete(filter);
            PurInventoryBillMinMaxTrackFactory.getRemoteInstance().save(colls);
        }
    }

    private int getIntByString(String str) {
        return Integer.valueOf(str.substring(str.length() - 4));
    }

    private void isValue() {
        int count = this.kdtEntrys.getRowCount();
        StringBuffer errorSB = new StringBuffer();
        StringBuffer errorDetailSB = new StringBuffer();
        boolean istaOut = true;
        boolean ispurGroup = true;
        boolean isplanPurTime = true;
        boolean isdate = true;
        for (int i = 0; i < count; ++i) {
            String strInfo;
            if (this.kdtEntrys.getCell(i, "taOut").getValue() == null || this.kdtEntrys.getCell(i, "taOut").getValue().toString().trim() == "") {
                if (istaOut) {
                    errorSB.append(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0109")).append("\n\r");
                    istaOut = false;
                }
                strInfo = com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"CGTLBWK", (Object[])new Object[]{i + 1, this.kdtEntrys.getCell(i, "materialName").getValue()});
                errorDetailSB.append(strInfo).append("\n\r");
            }
            if (this.kdtEntrys.getCell(i, "purGroup").getValue() == null || this.kdtEntrys.getCell(i, "purGroup").getValue().toString().trim() == "") {
                if (ispurGroup) {
                    errorSB.append(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0110")).append("\n\r");
                    ispurGroup = false;
                }
                strInfo = com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"CGZBWK", (Object[])new Object[]{i + 1, this.kdtEntrys.getCell(i, "materialName").getValue()});
                errorDetailSB.append(strInfo).append("\n\r");
            }
            if (this.kdtEntrys.getCell(i, "planPurTime").getValue() == null || this.kdtEntrys.getCell(i, "planPurTime").getValue().toString().trim() == "") {
                if (isplanPurTime) {
                    errorSB.append(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0111")).append("\n\r");
                    isplanPurTime = false;
                }
                strInfo = com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"WLDHQBWK", (Object[])new Object[]{i + 1, this.kdtEntrys.getCell(i, "materialName").getValue()});
                errorDetailSB.append(strInfo).append("\n\r");
            }
            Date date = (Date)this.kdtEntrys.getCell(i, "planPurTime").getValue();
            Date date1 = new Date();
            if (date == null || date.compareTo(date1) >= 0) continue;
            if (isdate) {
                errorSB.append(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0112")).append("\n\r");
                isdate = false;
            }
            String strInfo2 = com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"WLDHRIBZYXTRQ", (Object[])new Object[]{i + 1, this.kdtEntrys.getCell(i, "materialName").getValue()});
            errorDetailSB.append(strInfo2).append("\n\r");
        }
        if (errorSB.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)errorSB.toString(), (String)errorDetailSB.toString(), (int)1);
            SysUtil.abort();
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        int count = this.kdtEntrys.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (this.kdtEntrys.getCell(i, COL_PURORGUNIT).getValue() != null && !this.kdtEntrys.getCell(i, COL_PURORGUNIT).getValue().toString().trim().equals("")) continue;
            String strInfo = com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"CGZZBNWK", (Object[])new Object[]{i + 1});
            MsgBox.showError((String)strInfo);
            SysUtil.abort();
        }
        this.actionSave_actionPerformed(e);
        if (this.editData.getBaseStatus().getValue() == 4) {
            this.isValue();
        }
        super.actionSubmit_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        SysContext context = SysContext.getSysContext();
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        this.editData.setIsNew(false);
        this.editData.setCreator(context.getCurrentUserInfo());
        this.editData.setCreateTime(currentTime);
        this.editData.setLastUpdateTime(currentTime);
        this.editData.setLastUpdateUser(context.getCurrentUserInfo());
        this.editData.setAuditor(null);
        this.editData.setAuditTime(null);
        this.editData.setBaseStatus(BillBaseStatusEnum.ADD);
        this.editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.setEditErr();
        this.filterTrackNumber();
        super.actionEdit_actionPerformed(e);
    }

    public void setEditErr() {
        BillBaseStatusEnum status = this.editData.getBaseStatus();
        if (status.equals((Object)BillBaseStatusEnum.AUDITED) || status.equals((Object)BillBaseStatusEnum.FINISH) || status.equals((Object)BillBaseStatusEnum.CLOSED) || status.equals((Object)BillBaseStatusEnum.FINCLOSED) || status.equals((Object)BillBaseStatusEnum.ALREADYTURN)) {
            MsgBox.showError((String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0113"));
            SysUtil.abort();
        } else {
            this.kdtEntrys.getColumn("process").getStyleAttributes().setLocked(false);
            this.kdtEntrys.getColumn(COL_PURORGUNIT).getStyleAttributes().setLocked(false);
            this.kdtEntrys.getColumn("craftRemark").getStyleAttributes().setLocked(false);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        BillBaseStatusEnum status = this.editData.getBaseStatus();
        if (!status.equals((Object)BillBaseStatusEnum.SUBMITED) && !status.equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
            MsgBox.showInfo((Component)((Object)this), (String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0114"));
            SysUtil.abort();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("patent", (Object)this.editData.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        super.actionRemove_actionPerformed(e);
        PurInventoryBillMinMaxTrackFactory.getRemoteInstance().delete(filter);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    public void actionReset_actionPerformed(ActionEvent e) throws Exception {
        super.actionReset_actionPerformed(e);
    }

    public void actionMsgFormat_actionPerformed(ActionEvent e) throws Exception {
        super.actionMsgFormat_actionPerformed(e);
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
    }

    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyLine_actionPerformed(e);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateFrom_actionPerformed(e);
    }

    public void actionCopyFrom_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyFrom_actionPerformed(e);
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        ArrayList<String> list = new ArrayList<String>();
        if (this.editData.getId() == null || !BillBaseStatusEnum.SUBMITED.equals((Object)this.editData.getBaseStatus())) {
            MsgBox.showWarning((Component)((Object)this), (String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0057"));
            return;
        }
        list.add(this.editData.getId().toString());
        ((IPurInventoryBill)this.getBizInterface()).audit(list);
        this.showSuccessMsg(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0115"));
        this.btnSave.setEnabled(false);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAudit_actionPerformed(e);
        ArrayList<String> list = new ArrayList<String>();
        if (!BillBaseStatusEnum.AUDITED.equals((Object)this.editData.getBaseStatus())) {
            MsgBox.showWarning((Component)((Object)this), (String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0058"));
            return;
        }
        list.add(this.editData.getId().toString());
        ((IPurInventoryBill)this.getBizInterface()).unAudit(list);
        this.showSuccessMsg(com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurIndustryResource", (String)"0EMMSCMPur-0116"));
        this.btnSave.setEnabled(true);
    }

    protected void showSuccessMsg(String msgResource) throws EASBizException, BOSException, Exception {
        this.setMessageText(msgResource);
        this.showMessage();
        this.refreshCurPage();
    }

    protected void refreshCurPage() throws EASBizException, BOSException, Exception {
        if (this.editData.getId() != null) {
            ObjectUuidPK iObjectPk = new ObjectUuidPK(this.editData.getId());
            IObjectValue iObjectValue = this.getValue((IObjectPK)iObjectPk);
            this.setDataObject(iObjectValue);
            this.loadFields();
            this.setSave(true);
        }
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceUp_actionPerformed(e);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionViewSubmitProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewSubmitProccess_actionPerformed(e);
    }

    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDoProccess_actionPerformed(e);
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiapprove_actionPerformed(e);
    }

    public void actionNextPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionNextPerson_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionWorkFlowG_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkFlowG_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionSendingMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendingMessage_actionPerformed(e);
    }

    public void actionSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionSignature_actionPerformed(e);
    }

    public void actionWorkflowList_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkflowList_actionPerformed(e);
    }

    public void actionViewSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewSignature_actionPerformed(e);
    }

    public void actionSendMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMail_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionNumberSign_actionPerformed(ActionEvent e) throws Exception {
        super.actionNumberSign_actionPerformed(e);
    }

    @Override
    public void actionTAddNewLine_actionPerformed(ActionEvent e) throws Exception {
        this.prmtstartTrack.setDataBySelector();
        Object[] Infos = null;
        Object o = this.prmtstartTrack.getData();
        if (o instanceof Object[]) {
            Infos = (Object[])o;
        }
        this.trackNumber.removeRows();
        if (Infos != null) {
            for (int i = 0; i < Infos.length; ++i) {
                TrackNumberInfo info = (TrackNumberInfo)Infos[i];
                IRow row = this.trackNumber.addRow();
                row.getCell("trackNumber").setValue((Object)info);
            }
        }
        this.autoCalculat();
    }

    private void autoCalculat() {
        int rowCount = this.trackNumber.getRowCount();
        int entryRowCount = this.kdtEntrys.getRowCount();
        for (int i = 0; i < entryRowCount; ++i) {
            this.kdtEntrys.getRow(i).getCell("taOut").setValue((Object)BigDecimal.valueOf(rowCount));
            BigDecimal qty = this.kdtEntrys.getRow(i).getCell("qty").getValue() == null ? BigDecimal.ZERO : (BigDecimal)this.kdtEntrys.getRow(i).getCell("qty").getValue();
            this.kdtEntrys.getRow(i).getCell("purQty").setValue((Object)qty.multiply(BigDecimal.valueOf(rowCount)));
        }
    }

    @Override
    public void actionTInsertLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        this.prmtstartTrack.setDataBySelector();
        Object[] Infos = null;
        Object o = this.prmtstartTrack.getData();
        if (o instanceof Object[]) {
            Infos = (Object[])o;
        }
        if (Infos != null) {
            for (int i = 0; i < Infos.length; ++i) {
                TrackNumberInfo info = (TrackNumberInfo)Infos[i];
                if (this.trackNumber.getSelectManager().size() > 0) {
                    int top = this.trackNumber.getSelectManager().get().getTop();
                    row = this.isTableColumnSelected(this.trackNumber) ? this.trackNumber.addRow() : this.trackNumber.addRow(top + 1 + i);
                } else {
                    row = this.trackNumber.addRow();
                }
                row.getCell("trackNumber").setValue((Object)info);
            }
        }
        this.autoCalculat();
    }

    @Override
    public void actionTRemovLines_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.trackNumber);
        this.autoCalculat();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PurInventoryBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        PurInventoryBillInfo objectValue = new PurInventoryBillInfo();
        if (SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Purchase")) != null && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Purchase")).getBoolean("isBizUnit")) {
            objectValue.put("purchaseOrg", SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Purchase")));
        }
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        return objectValue;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
    }

    @Override
    public void kdtEntrys_Changed(int rowIndex, int colIndex) throws Exception {
        if ("material".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey())) {
            this.kdtEntrys.getCell(rowIndex, "materialName").setValue((Object)UIRuleUtil.getString((Object)UIRuleUtil.getProperty((IObjectValue)((IObjectValue)this.kdtEntrys.getCell(rowIndex, "material").getValue()), (String)"name")));
        }
        if ("material".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey())) {
            this.kdtEntrys.getCell(rowIndex, "model").setValue((Object)UIRuleUtil.getString((Object)UIRuleUtil.getProperty((IObjectValue)((IObjectValue)this.kdtEntrys.getCell(rowIndex, "material").getValue()), (String)"model")));
        }
        if ("material".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey())) {
            this.kdtEntrys.getCell(rowIndex, "unit").setValue(UIRuleUtil.getProperty((IObjectValue)((IObjectValue)this.kdtEntrys.getCell(rowIndex, "material").getValue()), (String)"baseUnit.name"));
        }
        if ("material".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey())) {
            this.kdtEntrys.getCell(rowIndex, "mapNo").setValue(UIRuleUtil.getProperty((IObjectValue)((IObjectValue)this.kdtEntrys.getCell(rowIndex, "material").getValue()), (String)"pictureNumber"));
        }
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.getEnum((String)"ControlUnit");
    }

    @Override
    protected void beforeStoreFields(ActionEvent arg0) throws Exception {
        int i;
        if (UIRuleUtil.isNull((Object)this.prmtprojectNo.getData())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"0EMMSCMInv-0013")});
        }
        if (UIRuleUtil.isNull((Object)this.comVersionNumber.getSelectedItem())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.sm.EMMSCMSMResource", (String)"0EMMSCMSM-0208")});
        }
        if (UIRuleUtil.isNull((Object)this.prmtadminOrgUnit.getData())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpReportResource", (String)"Department")});
        }
        int n = this.kdtEntrys.getRowCount();
        for (i = 0; i < n; ++i) {
            if (!UIRuleUtil.isNull((Object)this.kdtEntrys.getCell(i, "material").getValue())) continue;
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.scm.common.EMMSCMCommonResource", (String)"0EMMSCMCommon-0004")});
        }
        n = this.kdtEntrys.getRowCount();
        for (i = 0; i < n; ++i) {
            if (!UIRuleUtil.isNull((Object)this.kdtEntrys.getCell(i, "qty").getValue())) continue;
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.EMMEMAnalyResource", (String)"TCSL_NAME")});
        }
        if (UIRuleUtil.isNull((Object)this.prmtapplicant.getData())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0082")});
        }
    }
}

