/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.wms.inBill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.clientUtil.ComponentUtil;
import com.kingdee.eas.clientUtil.F7Util;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.wms.inBill.QCBizTypeEnum;
import com.kingdee.eas.industry.emm.wms.inBill.QCStatusEnum;
import com.kingdee.eas.industry.emm.wms.inBill.QcBillFactory;
import com.kingdee.eas.industry.emm.wms.inBill.QcBillInfo;
import com.kingdee.eas.industry.emm.wms.inBill.client.AbstractQcBillEditUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class QcBillEditUI
extends AbstractQcBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(QcBillEditUI.class);
    String RESOURCE_NAME = "com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource";
    protected KDTEditListener kdtTablelistener;
    protected DataChangeListener f7DataChangeListener = null;
    protected PreChangeListener f7PreChangeListener = null;
    protected SelectorListener f7SelectorListener = null;

    public QcBillEditUI() throws Exception {
        this.comboQCBizType.setEnabled(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return QcBillFactory.getRemoteInstance();
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtStorageOrgUnit;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    public String getOprtState() {
        if (this.oprtState == null) {
            this.oprtState = "ADDNEW";
        }
        return this.oprtState;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnAttachment.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnWorkFlowG.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.btnMaterialView.setVisible(false);
        this.btnReservationQuery.setVisible(false);
        this.btnAudit.setVisible(false);
        this.btnUnAudit.setVisible(false);
        this.btnCopy.setVisible(false);
        if (this.uiWindow instanceof JFrame) {
            ((JFrame)this.uiWindow).setExtendedState(6);
        }
    }

    @Override
    public void loadFields() {
        this.removeListener();
        this.kdtEntrySerial.checkParsed();
        super.loadFields();
        this.addListener();
        this.comboQCBizType.setEnabled(false);
        this.kdtEntrysSetRender();
        this.kdtEntrysSetEditor();
        this.lockedTable();
        this.initbtnEnable();
        this.comboQCBizType.setEnabled(false);
    }

    protected void kdtEntrysSetRender() {
        ObjectValueRender ovrNumber = new ObjectValueRender();
        ovrNumber.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntry.getColumn("material.number").setRenderer((IBasicRender)ovrNumber);
        this.kdtEntrySerial.getColumn("material.number").setRenderer((IBasicRender)ovrNumber);
    }

    protected void kdtEntrysSetEditor() {
    }

    protected void removeListener() {
        if (this.kdtTablelistener != null) {
            this.kdtEntry.removeKDTEditListener((com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener)this.kdtTablelistener);
            this.kdtEntrySerial.removeKDTEditListener((com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener)this.kdtTablelistener);
        }
        if (this.f7DataChangeListener != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.f7DataChangeListener);
            this.prmtWarehouse.removeDataChangeListener(this.f7DataChangeListener);
        }
        if (this.f7PreChangeListener != null) {
            this.prmtWarehouse.removePreChangeListener(this.f7PreChangeListener);
        }
        if (this.f7SelectorListener != null) {
            this.prmtWarehouse.removeSelectorListener(this.f7SelectorListener);
        }
    }

    protected void addListener() {
        if (this.kdtTablelistener == null) {
            this.kdtTablelistener = new KDTEditListener();
        }
        this.kdtEntry.addKDTEditListener((com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener)this.kdtTablelistener);
        this.kdtEntrySerial.addKDTEditListener((com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener)this.kdtTablelistener);
        if (this.f7DataChangeListener == null) {
            this.f7DataChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        QcBillEditUI.this.f7DataChange(e);
                    }
                    catch (Exception exc) {
                        QcBillEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtStorageOrgUnit.addDataChangeListener(this.f7DataChangeListener);
        this.prmtWarehouse.addDataChangeListener(this.f7DataChangeListener);
        if (this.f7PreChangeListener == null) {
            this.f7PreChangeListener = new PreChangeListener(){

                public void preChange(PreChangeEvent e) {
                    try {
                        QcBillEditUI.this.f7PreChange(e);
                    }
                    catch (Exception exc) {
                        QcBillEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtWarehouse.addPreChangeListener(this.f7PreChangeListener);
        if (this.f7SelectorListener == null) {
            this.f7SelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    try {
                        QcBillEditUI.this.f7WillShow(e);
                    }
                    catch (Exception exc) {
                        QcBillEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtWarehouse.addSelectorListener(this.f7SelectorListener);
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemAudit});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemUnAudit});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemCopy});
    }

    public void onLoad() throws Exception {
        if (this.getOprtState() == null) {
            this.setOprtState(OprtState.ADDNEW);
        }
        super.onLoad();
        this.kdtEntry.getActionMap().remove("AddRow");
        this.kdtEntry.getActionMap().remove("RemoveRow");
        this.kdtEntry.getActionMap().remove("Delete");
        this.kdtEntry.getActionMap().remove("Paste");
        this.kdtEntrySerial.getActionMap().remove("AddRow");
        this.kdtEntrySerial.getActionMap().remove("RemoveRow");
        this.kdtEntrySerial.getActionMap().remove("Delete");
        this.kdtEntrySerial.getActionMap().remove("Paste");
        this.kdtEntry.getSelectManager().setSelectMode(10);
        this.kdtEntrySerial.getSelectManager().setSelectMode(10);
        this.prmtStorageOrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
        this.prmtStorageOrgUnit.setEditFormat("$number$");
        this.prmtStorageOrgUnit.setDisplayFormat("$name$");
        this.prmtStorageOrgUnit.setCommitFormat("$number$");
        this.prmtStorageOrgUnit.setEditable(false);
        this.prmtStorageOrgUnit.setEnabledMultiSelection(false);
        this.lockedTable();
        this.initbtnEnable();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public void table_kdtEntry_valueChange(KDTEditEvent e) {
        int colIdx = e.getColIndex();
        int rowindex = e.getRowIndex();
        IRow row = null;
        BigDecimal fqty = new BigDecimal(0);
        BigDecimal fpassqty = new BigDecimal(0);
        BigDecimal fnopassqty = new BigDecimal(0);
        try {
            if (this.kdtEntry.getColumnIndex("qty") == colIdx) {
                row = this.kdtEntry.getRow(rowindex);
                if (row.getCell("qty").getValue() != null) {
                    fqty = new BigDecimal(row.getCell("qty").getValue().toString());
                }
                if (fqty.compareTo(BigDecimal.ZERO) <= 0) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0028"));
                    return;
                }
            }
            if (this.kdtEntry.getColumnIndex("passqty") == colIdx) {
                row = this.kdtEntry.getRow(rowindex);
                if (row.getCell("qty").getValue() != null) {
                    fqty = new BigDecimal(row.getCell("qty").getValue().toString());
                }
                if (row.getCell("passqty").getValue() != null) {
                    fpassqty = new BigDecimal(row.getCell("passqty").getValue().toString());
                }
                if (fpassqty.compareTo(BigDecimal.ZERO) < 0) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0029"));
                    row.getCell("passqty").setValue((Object)BigDecimal.ZERO);
                    return;
                }
                if (fpassqty.compareTo(fqty) > 0) {
                    String strInfo = EASResource.getString((String)this.RESOURCE_NAME, (String)"HGPSLBNZJSL", (Object[])new Object[]{fpassqty, fqty});
                    MsgBox.showInfo((String)strInfo);
                    row.getCell("passqty").setValue((Object)BigDecimal.ZERO);
                    return;
                }
                row.getCell("nopassqty").setValue((Object)fqty.subtract(fpassqty));
            }
            if (this.kdtEntry.getColumnIndex("nopassqty") == colIdx) {
                row = this.kdtEntry.getRow(rowindex);
                if (row.getCell("qty").getValue() != null) {
                    fqty = new BigDecimal(row.getCell("qty").getValue().toString());
                }
                if (row.getCell("nopassqty").getValue() != null) {
                    fnopassqty = new BigDecimal(row.getCell("nopassqty").getValue().toString());
                }
                if (fnopassqty.compareTo(BigDecimal.ZERO) < 0) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0030"));
                    row.getCell("nopassqty").setValue((Object)BigDecimal.ZERO);
                    return;
                }
                if (fnopassqty.compareTo(fqty) > 0) {
                    String strInfo = EASResource.getString((String)this.RESOURCE_NAME, (String)"BHGPSLBNZJSL", (Object[])new Object[]{fnopassqty, fqty});
                    MsgBox.showInfo((String)strInfo);
                    row.getCell("nopassqty").setValue((Object)BigDecimal.ZERO);
                    return;
                }
                row.getCell("passqty").setValue((Object)fqty.subtract(fnopassqty));
            }
        }
        catch (NumberFormatException ex) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0031"));
            this.kdtEntry.getCell(rowindex, colIdx).setValue(null);
        }
    }

    protected IObjectValue createNewData() {
        QcBillInfo info = new QcBillInfo();
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        info.setStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg());
        if (info.getStorageOrgUnit() == null) {
            info.setStorageOrgUnit(SysContext.getSysContext().getCurrentStorageUnit());
        }
        info.setBizDate(new Date());
        info.setQCBizType(QCBizTypeEnum.INWAREHSQC);
        info.setQCStatus(QCStatusEnum.QC_NO);
        return info;
    }

    @Override
    public void actionBeginQc_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanQC("Begin");
        HashMap dataMap = new HashMap();
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.editData.getId().toString());
        dataMap.put("idList", idList);
        String error = QcBillFactory.getRemoteInstance().updateBeginQCInfo(dataMap);
        if (error != null && error.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0032"), (String)error, (int)2);
        } else {
            this.refreshCurPage();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0033"));
        }
    }

    @Override
    public void actionEndQc_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.checkCanQC("End");
        HashMap<String, QcBillInfo> dataMap = new HashMap<String, QcBillInfo>();
        dataMap.put("info", this.editData);
        String error = QcBillFactory.getRemoteInstance().updateEndQCInfo(dataMap);
        if (error != null && error.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0034"), (String)error, (int)2);
        } else {
            this.refreshCurPage();
        }
    }

    @Override
    public void actionUnQc_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanQC("UnQc");
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.editData.getId().toString());
        String error = QcBillFactory.getRemoteInstance().unQC(idList);
        if (error != null && error.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0035"), (String)error, (int)2);
        } else {
            this.refreshCurPage();
        }
    }

    @Override
    public void actionBatchSetPass_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanQC("BatchSet");
        ArrayList<String> idList = new ArrayList<String>();
        int selectIDMode = -1;
        int size = 0;
        if (this.kDTabbedPane1.getSelectedIndex() == 0) {
            size = this.kdtEntry.getSelectManager().size();
            if (size > 0) {
                selectIDMode = 1;
                for (int i = 0; i < size; ++i) {
                    KDTSelectBlock block = this.kdtEntry.getSelectManager().get(i);
                    for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                        IRow curRow = this.kdtEntry.getRow(j);
                        if (curRow.getCell("id") == null || curRow.getCell("id").getValue() == null) {
                            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0036"));
                            SysUtil.abort();
                            continue;
                        }
                        idList.add(curRow.getCell("id").getValue().toString());
                    }
                }
            } else {
                idList.add(this.editData.getId().toString());
                selectIDMode = 0;
            }
        } else if (this.kDTabbedPane1.getSelectedIndex() == 2) {
            size = this.kdtEntrySerial.getSelectManager().size();
            if (size > 0) {
                selectIDMode = 2;
                for (int i = 0; i < size; ++i) {
                    KDTSelectBlock block = this.kdtEntrySerial.getSelectManager().get(i);
                    for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                        IRow curRow = this.kdtEntrySerial.getRow(j);
                        if (curRow.getCell("id") == null || curRow.getCell("id").getValue() == null) {
                            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0036"));
                            SysUtil.abort();
                            continue;
                        }
                        idList.add(curRow.getCell("id").getValue().toString());
                    }
                }
            } else {
                idList.add(this.editData.getId().toString());
                selectIDMode = 0;
            }
        } else {
            idList.add(this.editData.getId().toString());
            selectIDMode = 0;
        }
        if (selectIDMode == 0) {
            if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0037")) == 2) {
                return;
            }
        } else if (selectIDMode == 1) {
            if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0038")) == 2) {
                return;
            }
        } else if (selectIDMode == 1) {
            if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0039")) == 2) {
                return;
            }
        } else {
            return;
        }
        QcBillFactory.getRemoteInstance().batchSetPassOrNotPass(idList, 1);
        this.refreshCurPage();
    }

    @Override
    public void actionBatchSetUnPass_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanQC("BatchSet");
        ArrayList<String> idList = new ArrayList<String>();
        int selectIDMode = -1;
        int size = 0;
        if (this.kDTabbedPane1.getSelectedIndex() == 0) {
            size = this.kdtEntry.getSelectManager().size();
            if (size > 0) {
                selectIDMode = 1;
                for (int i = 0; i < size; ++i) {
                    KDTSelectBlock block = this.kdtEntry.getSelectManager().get(i);
                    for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                        IRow curRow = this.kdtEntry.getRow(j);
                        if (curRow.getCell("id") == null || curRow.getCell("id").getValue() == null) {
                            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0036"));
                            SysUtil.abort();
                            continue;
                        }
                        idList.add(curRow.getCell("id").getValue().toString());
                    }
                }
            } else {
                idList.add(this.editData.getId().toString());
                selectIDMode = 0;
            }
        } else if (this.kDTabbedPane1.getSelectedIndex() == 2) {
            size = this.kdtEntrySerial.getSelectManager().size();
            if (size > 0) {
                selectIDMode = 2;
                for (int i = 0; i < size; ++i) {
                    KDTSelectBlock block = this.kdtEntrySerial.getSelectManager().get(i);
                    for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                        IRow curRow = this.kdtEntrySerial.getRow(j);
                        if (curRow.getCell("id") == null || curRow.getCell("id").getValue() == null) {
                            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0036"));
                            SysUtil.abort();
                            continue;
                        }
                        idList.add(curRow.getCell("id").getValue().toString());
                    }
                }
            } else {
                idList.add(this.editData.getId().toString());
                selectIDMode = 0;
            }
        } else {
            idList.add(this.editData.getId().toString());
            selectIDMode = 0;
        }
        if (selectIDMode == 0) {
            if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0040")) == 2) {
                return;
            }
        } else if (selectIDMode == 1) {
            if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0041")) == 2) {
                return;
            }
        } else if (selectIDMode == 1) {
            if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0042")) == 2) {
                return;
            }
        } else {
            return;
        }
        QcBillFactory.getRemoteInstance().batchSetPassOrNotPass(idList, 0);
        this.refreshCurPage();
    }

    protected void f7DataChange(DataChangeEvent e) throws BOSException {
        QCBizTypeEnum qcBizTypeEnum;
        if (e.getSource() == null || !(e.getSource() instanceof KDBizPromptBox)) {
            return;
        }
        String name = ((KDBizPromptBox)e.getSource()).getName();
        Object[] newValues = null;
        Object[] oldValues = null;
        Object newInfo = null;
        if (e.getNewValue() instanceof Object[]) {
            newValues = (Object[])e.getNewValue();
        } else if (e.getNewValue() instanceof Object) {
            newValues = new Object[]{e.getNewValue()};
        }
        if (e.getOldValue() instanceof Object[]) {
            oldValues = (Object[])e.getOldValue();
        } else if (e.getOldValue() instanceof Object) {
            oldValues = new Object[]{e.getOldValue()};
        }
        if (newValues == null && oldValues == null) {
            this.addListener();
            return;
        }
        if (newValues == null && oldValues != null) {
            if (oldValues.length > 0 && oldValues[0] == null) {
                this.addListener();
                return;
            }
        } else if (newValues != null && oldValues == null) {
            if (newValues.length > 0 && newValues[0] == null) {
                this.addListener();
                return;
            }
        } else if (newValues != null && oldValues != null) {
            if (newValues.length > 0 && oldValues.length > 0 && newValues[0] == null && oldValues[0] == null) {
                this.addListener();
                return;
            }
            if (newValues.length > 0 && oldValues.length > 0 && newValues[0] != null && oldValues[0] != null && newValues[0].toString().equals(oldValues[0].toString())) {
                this.addListener();
                return;
            }
        }
        if (newValues != null && newValues.length > 0 && newValues[0] != null) {
            newInfo = newValues[0];
        }
        if (oldValues == null || oldValues.length <= 0 || oldValues[0] != null) {
            // empty if block
        }
        if (name.equals(this.prmtStorageOrgUnit.getName())) {
            this.setEntityView();
            this.prmtWarehouse.setValue(null);
            this.kdtEntry.removeRows();
            this.kdtEntrySerial.removeRows();
        }
        if (name.equals(this.prmtWarehouse.getName()) && this.comboQCBizType.getSelectedItem() != null && (qcBizTypeEnum = (QCBizTypeEnum)((Object)this.comboQCBizType.getSelectedItem())).getValue() == 2) {
            this.kdtEntry.removeRows();
            this.kdtEntrySerial.removeRows();
        }
    }

    protected void initbtnEnable() {
        if (this.editData == null || this.editData.getId() == null) {
            this.btnBeginQC.setEnabled(false);
            this.btnEndQC.setEnabled(false);
            this.btnUnQC.setEnabled(false);
            this.btnBatchSetPass.setEnabled(false);
            this.btnBatchSetunPass.setEnabled(false);
            this.kdtEntry.getColumn("qty").getStyleAttributes().setLocked(false);
            this.kdtEntry.getColumn("passqty").getStyleAttributes().setLocked(true);
            this.kdtEntry.getColumn("nopassqty").getStyleAttributes().setLocked(true);
        } else if (this.editData.getBaseStatus() != null && this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED) || this.editData.getQCStatus() != null && this.editData.getQCStatus().equals((Object)QCStatusEnum.QC_END)) {
            this.btnBeginQC.setEnabled(false);
            this.btnEndQC.setEnabled(false);
            this.btnUnQC.setEnabled(true);
            this.btnBatchSetPass.setEnabled(false);
            this.btnBatchSetunPass.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.btnAddLine.setEnabled(false);
            this.btnInsertLine.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
            this.kdtEntry.getColumn("qty").getStyleAttributes().setLocked(true);
            this.kdtEntry.getColumn("passqty").getStyleAttributes().setLocked(true);
            this.kdtEntry.getColumn("nopassqty").getStyleAttributes().setLocked(true);
        } else {
            if (this.editData.getQCStatus() != null && this.editData.getQCStatus().equals((Object)QCStatusEnum.QC_ING)) {
                this.btnBeginQC.setEnabled(false);
                this.btnEndQC.setEnabled(true);
                this.btnUnQC.setEnabled(false);
                this.btnBatchSetPass.setEnabled(true);
                this.btnBatchSetunPass.setEnabled(true);
                this.btnEdit.setEnabled(true);
                this.btnSave.setEnabled(false);
                this.btnSubmit.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.btnAddLine.setEnabled(false);
                this.btnInsertLine.setEnabled(false);
                this.btnRemoveLine.setEnabled(false);
                this.kdtEntry.getColumn("qty").getStyleAttributes().setLocked(true);
                this.kdtEntry.getColumn("passqty").getStyleAttributes().setLocked(false);
                this.kdtEntry.getColumn("nopassqty").getStyleAttributes().setLocked(false);
            }
            if (this.editData.getQCStatus() == null || this.editData.getQCStatus().equals((Object)QCStatusEnum.QC_NO)) {
                this.btnBeginQC.setEnabled(true);
                this.btnEndQC.setEnabled(false);
                this.btnUnQC.setEnabled(false);
                this.btnBatchSetPass.setEnabled(false);
                this.btnBatchSetunPass.setEnabled(false);
                this.btnEdit.setEnabled(true);
                this.btnSave.setEnabled(true);
                this.btnSubmit.setEnabled(true);
                this.btnRemove.setEnabled(true);
                this.btnAddLine.setEnabled(true);
                this.btnInsertLine.setEnabled(true);
                this.btnRemoveLine.setEnabled(true);
                this.kdtEntry.getColumn("qty").getStyleAttributes().setLocked(false);
                this.kdtEntry.getColumn("passqty").getStyleAttributes().setLocked(true);
                this.kdtEntry.getColumn("nopassqty").getStyleAttributes().setLocked(true);
            }
        }
        if (this.comboQCBizType.getSelectedItem() != null) {
            QCBizTypeEnum qcBizTypeEnum = (QCBizTypeEnum)((Object)this.comboQCBizType.getSelectedItem());
            if (qcBizTypeEnum.getValue() == 3) {
                this.btnAddLine.setEnabled(false);
                this.btnInsertLine.setEnabled(false);
                this.btnRemoveLine.setEnabled(false);
                this.kdtEntry.getColumn("qty").getStyleAttributes().setLocked(true);
            } else if (qcBizTypeEnum.getValue() == 1) {
                this.btnAddLine.setEnabled(false);
                this.btnInsertLine.setEnabled(false);
            }
        }
    }

    protected void lockedTable() {
        QCBizTypeEnum qcBizTypeEnum;
        this.kdtEntry.getColumn("material.number").getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("unit.name").getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("sourcebillnumber").getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("tracknumber.number").getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("project.number").getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("qty").getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("passqty").getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("nopassqty").getStyleAttributes().setLocked(true);
        this.kdtEntrySerial.getColumn("serialNumber").getStyleAttributes().setLocked(true);
        this.kdtEntrySerial.getColumn("material.number").getStyleAttributes().setLocked(true);
        this.kdtEntrySerial.getColumn("unit.name").getStyleAttributes().setLocked(true);
        this.kdtEntrySerial.getColumn("qty").getStyleAttributes().setLocked(true);
        this.kdtEntrySerial.getColumn("passqty").getStyleAttributes().setLocked(true);
        this.kdtEntrySerial.getColumn("nopassqty").getStyleAttributes().setLocked(true);
        if (this.comboQCBizType.getSelectedItem() != null && (qcBizTypeEnum = (QCBizTypeEnum)((Object)this.comboQCBizType.getSelectedItem())).getValue() != 2 && this.kdtEntry.getRowCount() > 0) {
            String coreBillEntryID = null;
            for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
                if (this.kdtEntry.getCell(i, "coreBillEntryID") != null && this.kdtEntry.getCell(i, "coreBillEntryID").getValue() != null) {
                    coreBillEntryID = this.kdtEntry.getCell(i, "coreBillEntryID").getValue().toString();
                } else if (this.kdtEntry.getCell(i, "sourcebillentryid") != null && this.kdtEntry.getCell(i, "sourcebillentryid").getValue() != null) {
                    coreBillEntryID = this.kdtEntry.getCell(i, "sourcebillentryid").getValue().toString();
                }
                if (!this.isSourceFromStandPurRecvBillEntry(coreBillEntryID)) continue;
                this.kdtEntry.getColumn("qty").getStyleAttributes().setLocked(true);
            }
        }
    }

    protected void f7PreChange(PreChangeEvent e) throws BOSException {
        if (e.getSource() == null || !(e.getSource() instanceof KDBizPromptBox)) {
            e.setResult(0);
            return;
        }
        String name = ((KDBizPromptBox)e.getSource()).getName();
        String storageOrgUnitID = null;
        if (name.equals(this.prmtWarehouse.getName())) {
            if (this.prmtStorageOrgUnit.getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0043"));
                e.setResult(0);
                return;
            }
            if (this.prmtStorageOrgUnit.getValue() != null && this.prmtStorageOrgUnit.getValue() instanceof StorageOrgUnitInfo && ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId() != null) {
                storageOrgUnitID = ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString();
            }
            if (storageOrgUnitID == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0043"));
                e.setResult(0);
                return;
            }
            this.setEntityView();
        }
        e.setResult(1);
    }

    protected void f7WillShow(SelectorEvent e) {
        if (e.getSource() == null || !(e.getSource() instanceof KDBizPromptBox)) {
            e.setCanceled(true);
            return;
        }
        String name = ((KDBizPromptBox)e.getSource()).getName();
        String storageOrgUnitID = null;
        if (name.equals(this.prmtWarehouse.getName())) {
            if (this.prmtStorageOrgUnit.getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0044"));
                e.setCanceled(true);
                return;
            }
            if (this.prmtStorageOrgUnit.getValue() != null && this.prmtStorageOrgUnit.getValue() instanceof StorageOrgUnitInfo && ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId() != null) {
                storageOrgUnitID = ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString();
            }
            if (storageOrgUnitID == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0044"));
                e.setCanceled(true);
                return;
            }
            this.setEntityView();
        }
    }

    protected void setEntityView() {
        String storageOrgUnitID = null;
        Object sql = null;
        if (this.prmtStorageOrgUnit.getValue() != null && this.prmtStorageOrgUnit.getValue() instanceof StorageOrgUnitInfo && ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId() != null) {
            storageOrgUnitID = ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (storageOrgUnitID != null && storageOrgUnitID.trim().length() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)storageOrgUnitID, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("whState", (Object)"1", CompareType.EQUALS));
            view.setFilter(filterInfo);
        }
        this.prmtWarehouse.setEntityViewInfo(view);
        this.prmtWarehouse.getQueryAgent().resetRuntimeEntityView();
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanAddOrRemoveEntryData();
        IRow startRow = null;
        int size = this.kdtEntry.getRowCount();
        if (size > 0) {
            startRow = this.kdtEntry.getRow(size - 1);
        }
        int startSeq = 0;
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                if (this.kdtEntry.getCell(i, "seq") == null || this.kdtEntry.getCell(i, "seq").getValue() == null || Integer.parseInt(this.kdtEntry.getCell(i, "seq").getValue().toString()) <= startSeq) continue;
                startSeq = Integer.parseInt(this.kdtEntry.getCell(i, "seq").getValue().toString());
            }
        }
        this.addDateInsertTable(startRow, startSeq);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addDateInsertTable(IRow startRow, int startSeq) {
        if (this.comboQCBizType.getSelectedItem() == null) return;
        QCBizTypeEnum qcBizTypeEnum = (QCBizTypeEnum)((Object)this.comboQCBizType.getSelectedItem());
        if (qcBizTypeEnum.getValue() == 2) {
            WarehouseInfo whInfo = null;
            StorageOrgUnitInfo orgInfo = null;
            if (this.prmtWarehouse.getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0045"));
                SysUtil.abort();
            } else {
                whInfo = (WarehouseInfo)this.prmtWarehouse.getValue();
            }
            if (this.prmtStorageOrgUnit.getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0044"));
                SysUtil.abort();
            } else {
                orgInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            }
            if (orgInfo == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0044"));
                SysUtil.abort();
            }
            if (whInfo == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0045"));
                SysUtil.abort();
            }
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("material.id"));
            sic.add(new SelectorItemInfo("material.number"));
            sic.add(new SelectorItemInfo("material.name"));
            sic.add(new SelectorItemInfo("material.model"));
            sic.add(new SelectorItemInfo("curStoreQty"));
            sic.add(new SelectorItemInfo("unit.id"));
            sic.add(new SelectorItemInfo("unit.name"));
            sic.add(new SelectorItemInfo("tracknumber.id"));
            sic.add(new SelectorItemInfo("tracknumber.number"));
            sic.add(new SelectorItemInfo("tracknumber.name"));
            sic.add(new SelectorItemInfo("project.id"));
            sic.add(new SelectorItemInfo("project.number"));
            sic.add(new SelectorItemInfo("project.name"));
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgInfo.getId(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("warehouse.id", (Object)whInfo.getId(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("curStoreQty", (Object)BigDecimal.ZERO, CompareType.GREATER));
            entityViewInfo.setFilter(filterInfo);
            entityViewInfo.setSelector(sic);
            IObjectCollection value = F7Util.showF7((CoreUIObject)this, (String)"com.kingdee.eas.mm.sfc.app.F7InventoryQuery", (EntityViewInfo)entityViewInfo, (boolean)true);
            if (value == null || value.size() == 0) {
                return;
            }
            InventoryInfo inventoryInfo = null;
            IRow newRow = null;
            for (int i = 0; i < value.size(); ++i) {
                inventoryInfo = (InventoryInfo)value.getObject(i);
                if (inventoryInfo == null || this.isExistsInvID(inventoryInfo.getId().toString())) continue;
                newRow = newRow == null ? (startRow == null ? this.kdtEntry.addRow() : this.kdtEntry.addRow(startRow.getRowIndex())) : this.kdtEntry.addRow(newRow.getRowIndex());
                this.addinventoryInfoToTable(inventoryInfo, newRow, ++startSeq);
            }
            return;
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0046"));
            SysUtil.abort();
            return;
        }
    }

    protected void addinventoryInfoToTable(InventoryInfo info, IRow row, int seq) {
        if (info == null) {
            return;
        }
        if (info.getMaterial() == null) {
            return;
        }
        row.getCell("material.number").setValue((Object)info.getMaterial());
        row.getCell("material.name").setValue((Object)info.getMaterial().getName());
        row.getCell("material.model").setValue((Object)info.getMaterial().getModel());
        row.getCell("material.id").setValue((Object)info.getMaterial().getId());
        row.getCell("qty").setValue((Object)info.getCurStoreQty());
        row.getCell("passqty").setValue((Object)new BigDecimal(0));
        row.getCell("nopassqty").setValue((Object)new BigDecimal(0));
        row.getCell("unit.name").setValue((Object)info.getUnit());
        if (info.getUnit() != null) {
            row.getCell("unit.id").setValue((Object)info.getUnit().getId());
        }
        if (this.isSerialNumber(info)) {
            row.getCell("id").setValue((Object)BOSUuid.create((String)"F60669CF"));
        } else {
            row.getCell("id").setValue(null);
        }
        row.getCell("sourcebillid").setValue((Object)info.getId());
        row.getCell("sourcebillentryid").setValue((Object)info.getId());
        row.getCell("coreBillID").setValue((Object)info.getId());
        row.getCell("coreBillEntryID").setValue((Object)info.getId());
        row.getCell("seq").setValue((Object)seq);
        if (info.getTrackNumber() != null) {
            row.getCell("tracknumber.id").setValue((Object)info.getTrackNumber().getId());
            row.getCell("tracknumber.number").setValue((Object)info.getTrackNumber());
            row.getCell("tracknumber.name").setValue((Object)info.getTrackNumber().getName());
        }
        if (info.getProject() != null) {
            row.getCell("project.id").setValue((Object)info.getProject());
            row.getCell("project.number").setValue((Object)info.getProject().getNumber());
            row.getCell("project.name").setValue((Object)info.getProject().getName());
        }
    }

    protected boolean isExistsInvID(String invId) {
        boolean isExists = false;
        if (invId == null || "".equals(invId)) {
            return true;
        }
        if (this.kdtEntry.getRowCount() > 0) {
            for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
                if (this.kdtEntry.getCell(i, "sourcebillid") == null || this.kdtEntry.getCell(i, "sourcebillid").getValue() == null || !this.kdtEntry.getCell(i, "sourcebillid").getValue().toString().equals(invId)) continue;
                isExists = true;
                break;
            }
        }
        return isExists;
    }

    protected boolean isSerialNumber(InventoryInfo info) {
        return false;
    }

    protected void checkCanAddOrRemoveEntryData() {
        if (this.editData != null) {
            if (this.editData.getBaseStatus() != null && this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0047"));
                SysUtil.abort();
                return;
            }
            if (this.editData.getQCStatus() != null && !this.editData.getQCStatus().equals((Object)QCStatusEnum.QC_NO)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0048"));
                SysUtil.abort();
                return;
            }
            if (this.editData.getQCBizType() != null && !this.editData.getQCBizType().equals((Object)QCBizTypeEnum.INWAREHSQC)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0049"));
                SysUtil.abort();
                return;
            }
        }
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanAddOrRemoveEntryData();
        Object startRow = null;
        int size = this.kdtEntry.getRowCount();
        if (this.kdtEntry.getSelectManager().size() > 0) {
            int top = this.kdtEntry.getSelectManager().get().getTop();
            startRow = this.isTableColumnSelected(this.kdtEntry) ? null : this.kdtEntry.getRow(top);
        } else if (size > 0) {
            startRow = this.kdtEntry.getRow(size - 1);
        }
        int startSeq = 0;
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                if (this.kdtEntry.getCell(i, "seq") == null || this.kdtEntry.getCell(i, "seq").getValue() == null || Integer.parseInt(this.kdtEntry.getCell(i, "seq").getValue().toString()) <= startSeq) continue;
                startSeq = Integer.parseInt(this.kdtEntry.getCell(i, "seq").getValue().toString());
            }
        }
        this.addDateInsertTable((IRow)startRow, startSeq);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent arg0) throws Exception {
        this.checkCanAddOrRemoveEntryData();
        super.actionRemoveLine_actionPerformed(arg0);
    }

    public void checkEditData() throws Exception {
        if (this.editData != null) {
            if (this.editData.getBaseStatus() != null && this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0047"));
                SysUtil.abort();
                return;
            }
            if (this.editData.getQCStatus() != null && !this.editData.getQCStatus().equals((Object)QCStatusEnum.QC_NO)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0048"));
                SysUtil.abort();
                return;
            }
        }
    }

    public void checkCanSave() throws Exception {
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0050"));
            SysUtil.abort();
        }
        if (this.kdtEntry.getRowCount() < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0051"));
            SysUtil.abort();
        }
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            if (this.kdtEntry.getCell(i, "material.number") != null && this.kdtEntry.getCell(i, "material.number").getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"WLXXFLDJHWLBWK", (Object[])new Object[]{i + 1}));
                SysUtil.abort();
            }
            if (this.kdtEntry.getCell(i, "qty") == null || this.kdtEntry.getCell(i, "qty").getValue() != null && new BigDecimal(this.kdtEntry.getCell(i, "qty").getValue().toString()).compareTo(BigDecimal.ZERO) > 0) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"WLXXFLDJHZJSLWK", (Object[])new Object[]{i + 1}));
            SysUtil.abort();
        }
    }

    public void checkCanQC(String qcType) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0036"));
            SysUtil.abort();
        }
        if (qcType.equals("Begin")) {
            this.checkCanSave();
            if (this.editData.getBaseStatus() == null || !this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0052"));
                SysUtil.abort();
                return;
            }
            if (this.editData.getQCStatus() != null && !this.editData.getQCStatus().equals((Object)QCStatusEnum.QC_NO)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0053"));
                SysUtil.abort();
                return;
            }
        } else if (qcType.equals("End")) {
            if (this.editData.getQCStatus() == null || !this.editData.getQCStatus().equals((Object)QCStatusEnum.QC_ING)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0054"));
                SysUtil.abort();
                return;
            }
        } else if (qcType.equals("BatchSet")) {
            if (this.editData.getQCStatus() == null || !this.editData.getQCStatus().equals((Object)QCStatusEnum.QC_ING)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0054"));
                SysUtil.abort();
                return;
            }
        } else if (qcType.equals("UnQc") && (this.editData.getQCStatus() == null || !this.editData.getQCStatus().equals((Object)QCStatusEnum.QC_END))) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0055"));
            SysUtil.abort();
            return;
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null) {
            if (this.editData.getBaseStatus() != null && this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0047"));
                SysUtil.abort();
                return;
            }
            if (this.editData.getQCStatus() != null && !this.editData.getQCStatus().equals((Object)QCStatusEnum.QC_NO) && !this.editData.getQCStatus().equals((Object)QCStatusEnum.QC_ING)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0056"));
                SysUtil.abort();
                return;
            }
        }
        super.actionEdit_actionPerformed(e);
        this.comboQCBizType.setEnabled(false);
        this.lockedTable();
        this.initbtnEnable();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkEditData();
        this.checkCanSave();
        super.actionSubmit_actionPerformed(e);
        this.lockedTable();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkEditData();
        super.actionRemove_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkEditData();
        if (this.editData != null && this.editData.getBaseStatus() != null && this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0057"));
            SysUtil.abort();
            return;
        }
        super.actionSave_actionPerformed(e);
        this.lockedTable();
    }

    protected boolean isSourceFromStandPurRecvBillEntry(String fid) {
        if (fid == null || "".equals(fid)) {
            return false;
        }
        return BOSUuid.getBOSObjectType((String)fid, (boolean)true).toString().equals("A8919E76");
    }

    class KDTEditListener
    extends KDTEditAdapter {
        KDTEditListener() {
        }

        public void editStopped(KDTEditEvent kdteditevent) {
            QcBillEditUI.this.table_kdtEntry_valueChange(kdteditevent);
        }
    }
}

