/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.wms.inBill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.clientUtil.ComponentUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.common.utils.IndustryUIUtils;
import com.kingdee.eas.industry.emm.wms.inBill.IQcBill;
import com.kingdee.eas.industry.emm.wms.inBill.QCStatusEnum;
import com.kingdee.eas.industry.emm.wms.inBill.QcBillCollection;
import com.kingdee.eas.industry.emm.wms.inBill.QcBillFactory;
import com.kingdee.eas.industry.emm.wms.inBill.QcBillInfo;
import com.kingdee.eas.industry.emm.wms.inBill.client.AbstractQcBillListUI;
import com.kingdee.eas.industry.emm.wms.inBill.client.QcBillEditUI;
import com.kingdee.eas.industry.emm.wms.inBill.client.QcBillQueryUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class QcBillListUI
extends AbstractQcBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(QcBillListUI.class);
    private QcBillQueryUI filterUI = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        IndustryUIUtils.put((CoreUIObject)this);
        super.onLoad();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnBeginQC.setEnabled(true);
        this.btnEndQC.setEnabled(true);
        this.btnUnQC.setEnabled(true);
        this.btnBatchSetPass.setEnabled(true);
        this.btnBatchSetUnPass.setEnabled(true);
        this.btnAttachment.setVisible(false);
        this.btnDelVoucher.setVisible(false);
        this.btnVoucher.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnLocate.setVisible(false);
        this.btnQueryScheme.setVisible(false);
        this.btnReservationQuery.setVisible(false);
        this.btnAudit.setVisible(false);
        this.btnUnAudit.setVisible(false);
        this.btnSubmit.setVisible(true);
        this.btnSubmit.setEnabled(true);
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemAudit});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemUnAudit});
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemCopyTo});
    }

    protected ICoreBase getBizInterface() throws Exception {
        return QcBillFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return QcBillEditUI.class.getName();
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new QcBillQueryUI();
        }
        return this.filterUI;
    }

    protected String getKeyFieldNmae() {
        return "id";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        return "storageOrgUnit.id";
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    @Override
    public void actionBeginQC_actionPerformed(ActionEvent e) throws Exception {
        super.actionBeginQC_actionPerformed(e);
        this.checkSelected();
        if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0058")) == 2) {
            return;
        }
        HashMap<String, ArrayList> dataMap = new HashMap<String, ArrayList>();
        ArrayList idList = this.getSelectedIdValues();
        dataMap.put("idList", idList);
        String error = QcBillFactory.getRemoteInstance().updateBeginQCInfo(dataMap);
        if (error != null && error.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0059"), (String)error, (int)2);
        }
        this.saveCurrentLocation();
        this.refresh(e);
        this.restoreCurrentLocation();
    }

    @Override
    public void actionEndQC_actionPerformed(ActionEvent e) throws Exception {
        super.actionEndQC_actionPerformed(e);
        this.checkSelected();
        if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0060")) == 2) {
            return;
        }
        HashMap<String, ArrayList> dataMap = new HashMap<String, ArrayList>();
        ArrayList idList = this.getSelectedIdValues();
        dataMap.put("idList", idList);
        String error = QcBillFactory.getRemoteInstance().updateEndQCInfo(dataMap);
        if (error != null && error.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0061"), (String)error, (int)2);
        }
        this.saveCurrentLocation();
        this.refresh(e);
        this.restoreCurrentLocation();
    }

    @Override
    public void actionUnQC_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnQC_actionPerformed(e);
        this.checkSelected();
        if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0062")) == 2) {
            return;
        }
        ArrayList idList = this.getSelectedIdValues();
        String error = QcBillFactory.getRemoteInstance().unQC(idList);
        if (error != null && error.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0061"), (String)error, (int)2);
        }
        this.saveCurrentLocation();
        this.refresh(e);
        this.restoreCurrentLocation();
    }

    @Override
    public void actionBatchSetPass_actionPerformed(ActionEvent e) throws Exception {
        super.actionBatchSetPass_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0063")) == 2) {
            return;
        }
        StringBuffer errors = new StringBuffer();
        int failCount = 0;
        for (int i = 0; i < idList.size(); ++i) {
            try {
                ArrayList newIdList = new ArrayList();
                newIdList.add(idList.get(i));
                QcBillFactory.getRemoteInstance().batchSetPassOrNotPass(newIdList, 1);
                continue;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                errors.append(e2.getMessage());
                ++failCount;
            }
        }
        if (errors.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"label89", (Object[])new Object[]{idList.size() - failCount, failCount}), (String)errors.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"label90", (Object[])new Object[]{idList.size()}));
        }
        this.refreshList();
    }

    @Override
    public void actionBatchSetUnPass_actionPerformed(ActionEvent e) throws Exception {
        super.actionBatchSetUnPass_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0064")) == 2) {
            return;
        }
        StringBuffer errors = new StringBuffer();
        int failCount = 0;
        for (int i = 0; i < idList.size(); ++i) {
            try {
                ArrayList newIdList = new ArrayList();
                newIdList.add(idList.get(i));
                QcBillFactory.getRemoteInstance().batchSetPassOrNotPass(newIdList, 0);
                continue;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                errors.append(e2.getMessage());
                ++failCount;
            }
        }
        if (errors.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"label87", (Object[])new Object[]{idList.size() - failCount, failCount}), (String)errors.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"label88", (Object[])new Object[]{idList.size()}));
        }
        this.refreshList();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList list = this.getSelectedIdValues();
        StringBuffer error = new StringBuffer();
        StringBuffer thisErr = new StringBuffer();
        QcBillCollection coll = new QcBillCollection();
        for (int i = 0; i < list.size(); ++i) {
            thisErr.setLength(0);
            ObjectStringPK pk = new ObjectStringPK(list.get(i).toString());
            QcBillInfo info = ((IQcBill)this.getBizInterface()).getQcBillInfo((IObjectPK)pk);
            thisErr.append(this.checkSubmit(info));
            if (thisErr.length() > 0) {
                error.append(thisErr);
                continue;
            }
            coll.add(info);
        }
        if (coll != null && coll.size() > 0) {
            QcBillFactory.getRemoteInstance().batcnSubmit(coll);
        }
        if (error.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0065"), (String)(EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0066") + error.toString()), (int)2);
        }
        this.saveCurrentLocation();
        this.refresh(e);
        this.restoreCurrentLocation();
    }

    protected StringBuffer checkSubmit(QcBillInfo info) throws BOSException, EASBizException {
        StringBuffer strErr = new StringBuffer();
        StringBuffer thisErr = new StringBuffer();
        if (info.getNumber() == null || "".equals(info.getNumber())) {
            strErr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0067"));
        }
        if (info.getBaseStatus() != null && info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            strErr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"ZJD", (Object[])new Object[]{info.getNumber()})).append(EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0068"));
        }
        if (info.getQCStatus() != null && !info.getQCStatus().equals((Object)QCStatusEnum.QC_NO)) {
            strErr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"ZJD", (Object[])new Object[]{info.getNumber()})).append(EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0069"));
        }
        if (info.getStorageOrgUnit() == null) {
            strErr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"ZJD", (Object[])new Object[]{info.getNumber()})).append(EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0070"));
        }
        if (info.getEntry() == null || info.getEntry().size() < 1) {
            strErr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"ZJD", (Object[])new Object[]{info.getNumber()})).append(EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0071"));
        }
        for (int i = 0; i < info.getEntry().size(); ++i) {
            String msgInfo;
            thisErr.setLength(0);
            if (info.getEntry().get(i).getMaterial() == null) {
                msgInfo = EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"WLWKBXTJ", (Object[])new Object[]{i + 1});
                thisErr.append(msgInfo).append("\r\n");
            }
            if (info.getEntry().get(i).getQty() == null || info.getEntry().get(i).getQty().compareTo(BigDecimal.ZERO) <= 0) {
                msgInfo = EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"ZJSLWKXYBTJ", (Object[])new Object[]{i + 1});
                thisErr.append(msgInfo).append("\r\n");
            }
            if (thisErr.length() <= 0) continue;
            strErr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.wms.inBill.EMMWMSInBillResource", (String)"0EMMWMSInBill-0004")).append("[" + info.getNumber() + "]:\r\n").append(thisErr);
        }
        return strErr;
    }
}

