/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.archives.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.archives.client.AbstractEquipmentLocationTreeFilterUI;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.common.core.filter.CompositeFilterElement;
import com.kingdee.eas.eqm.common.core.filter.IFilterElement;
import com.kingdee.eas.eqm.common.core.filter.IQueryFilterManager;
import com.kingdee.eas.eqm.common.core.filter.SingleFilterElement;
import com.kingdee.eas.eqm.common.core.util.GeneCommonUtils;
import com.kingdee.eas.eqm.common.core.util.GeneEqualsUtils;
import com.kingdee.eas.eqm.common.eqmcore.client.util.ControlledItems;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class EquipmentLocationTreeFilterUI
extends AbstractEquipmentLocationTreeFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(EquipmentLocationTreeFilterUI.class);
    private static final String PROP_FILE = "com.kingdee.eas.eqm.archives.EquipmentLocationTreeResource";
    private DataChangeListener archivesChangeListener = null;
    private DataChangeListener locationChangeListener = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtArchives.setDisplayFormat("$number$");
        this.prmtlocation.setDisplayFormat("$number$");
    }

    public void registerQueryFilterManager(IQueryFilterManager manager) {
        super.registerQueryFilterManager(manager);
        CompositeFilterElement rootElement = this.getFilterManager().getRootElement();
        rootElement.add((IFilterElement)new SingleFilterElement("id", (Component)this.prmtArchives));
        rootElement.add((IFilterElement)new SingleFilterElement("location.id", (Component)this.prmtlocation));
    }

    protected void initListener() {
        super.initListener();
        if (this.archivesChangeListener == null) {
            this.archivesChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    EquipmentLocationTreeFilterUI.this.prmtArchives_dataChanged(e);
                }
            };
        }
        this.prmtArchives.addDataChangeListener(this.archivesChangeListener);
        if (this.locationChangeListener == null) {
            this.locationChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    EquipmentLocationTreeFilterUI.this.prmtlocation_dataChanged(e);
                }
            };
        }
        this.prmtlocation.addDataChangeListener(this.locationChangeListener);
    }

    protected void registerCustomerBindings() {
        super.registerCustomerBindings();
        try {
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtArchives, (String)"com.kingdee.eas.eqm.archives.app.F7EqmSelfQuery", (String[])new String[]{"initial"}, (Object[])new Object[]{Boolean.TRUE}, (CompareType[])new CompareType[]{CompareType.EQUALS}, (boolean)true);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    public boolean isSupportMultiOrgs() {
        return false;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        if (filterInfo == null || GeneCommonUtils.isEmpty((AbstractObjectCollection)filterInfo.getFilterItems())) {
            return filterInfo;
        }
        Iterator iter = filterInfo.getFilterItems().iterator();
        boolean find = false;
        boolean isArchives = false;
        FilterInfo newFilterInfo = new FilterInfo();
        FilterItemInfo locationItemInfo = null;
        while (iter.hasNext()) {
            FilterItemInfo itemInfo = (FilterItemInfo)iter.next();
            if (itemInfo.getPropertyName().equals("id")) {
                newFilterInfo.getFilterItems().add(itemInfo);
                isArchives = true;
                find = true;
                continue;
            }
            if (itemInfo.getPropertyName().equals("location.id")) {
                locationItemInfo = itemInfo;
                find = true;
                continue;
            }
            newFilterInfo.getFilterItems().add(itemInfo);
        }
        if (find && locationItemInfo != null && !isArchives) {
            newFilterInfo.getFilterItems().add(locationItemInfo);
        }
        return newFilterInfo;
    }

    protected void prmtArchives_dataChanged(DataChangeEvent e) {
        EquipmentArchivesInfo info;
        if (null != e && GeneEqualsUtils.equals((Object)e.getNewValue(), (Object)e.getOldValue())) {
            return;
        }
        EquipmentArchivesInfo equipmentArchivesInfo = info = null == e ? (EquipmentArchivesInfo)this.prmtArchives.getValue() : (EquipmentArchivesInfo)e.getNewValue();
        if (null == info) {
            this.archivesName.setText(null);
        } else {
            this.archivesName.setText(info.getName());
            if (info.getLocation() != null) {
                if (this.prmtlocation.getValue() == null) {
                    this.prmtlocation.setValue((Object)info.getLocation());
                    this.locationName.setText(info.getLocation().getName());
                }
            } else {
                this.prmtlocation.setValue(null);
            }
        }
    }

    protected void prmtlocation_dataChanged(DataChangeEvent e) {
        EquipmentLocationInfo info;
        if (null != e && GeneEqualsUtils.equals((Object)e.getNewValue(), (Object)e.getOldValue())) {
            return;
        }
        EquipmentLocationInfo equipmentLocationInfo = info = null == e ? (EquipmentLocationInfo)this.prmtlocation.getValue() : (EquipmentLocationInfo)e.getNewValue();
        if (null == info) {
            this.locationName.setText(null);
            try {
                EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtArchives, (String)"com.kingdee.eas.eqm.archives.app.F7EqmSelfQuery", (String[])new String[]{"initial", "storageOrgUnit.id"}, (Object[])new Object[]{Boolean.TRUE, this.prmtOrgUnit.getValue() == null ? null : ((OrgUnitInfo)this.prmtOrgUnit.getValue()).getId().toString()}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.EQUALS}, (boolean)true);
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        } else {
            if (this.prmtArchives.getValue() != null) {
                EquipmentArchivesInfo archivesInfo = (EquipmentArchivesInfo)this.prmtArchives.getValue();
                if (archivesInfo == null || archivesInfo.getLocation() == null || !GeneEqualsUtils.equals((Object)archivesInfo.getLocation(), (Object)info)) {
                    this.prmtArchives.setValue(null);
                }
            } else {
                this.prmtArchives.setValue(null);
            }
            this.locationName.setText(info.getName());
            try {
                EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtArchives, (String)"com.kingdee.eas.eqm.archives.app.F7EqmSelfQuery", (String[])new String[]{"initial", "location.id"}, (Object[])new Object[]{Boolean.TRUE, info.getId().toString()}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.EQUALS}, (boolean)true);
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        }
    }

    public boolean verify() {
        if (this.prmtArchives.getValue() == null && this.prmtlocation.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.archives.EquipmentLocationTreeResource.CannotNullBoth"));
            SysUtil.abort();
            return false;
        }
        return true;
    }

    public ControlledItems[] getNeedMainOrgControl() {
        return new ControlledItems[]{new ControlledItems(this.prmtlocation), new ControlledItems(this.prmtArchives)};
    }

    protected void afterMainOrgChanged(OrgUnitInfo oldOrg, OrgUnitInfo org) {
        super.afterMainOrgChanged(oldOrg, org);
        this.prmtArchives.setValue(null);
        this.prmtlocation.setValue(null);
    }
}

