/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainGroupTreeInfo;
import com.kingdee.eas.eqm.basedata.client.AbstractEquipmentStandardOperationFilterUI;
import com.kingdee.eas.eqm.common.core.filter.CompositeFilterElement;
import com.kingdee.eas.eqm.common.core.filter.IFilterElement;
import com.kingdee.eas.eqm.common.core.filter.IQueryFilterManager;
import com.kingdee.eas.eqm.common.core.filter.SingleFilterElement;
import com.kingdee.eas.eqm.common.core.util.GeneFilterUtils;
import com.kingdee.eas.eqm.common.core.util.GeneSelectorUtils;
import com.kingdee.eas.eqm.common.eqmcore.client.util.ControlledItems;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.framework.ObjectBaseInfo;
import java.awt.Component;
import java.util.HashMap;

public class EquipmentStandardOperationFilterUI
extends AbstractEquipmentStandardOperationFilterUI {
    private static final String PERMISSION_VIEW = "eqm_equipmentstandardoperation_01view";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void registerQueryFilterManager(IQueryFilterManager manager) {
        super.registerQueryFilterManager(manager);
        CompositeFilterElement rootElement = this.getFilterManager().getRootElement();
        rootElement.add((IFilterElement)new SingleFilterElement("parent.id", (Component)this.prmtParent));
        SingleFilterElement nameElement = new SingleFilterElement("name", (Component)this.txtName);
        nameElement.setCompareType(CompareType.LIKE);
        rootElement.add((IFilterElement)nameElement);
        SingleFilterElement numberElement = new SingleFilterElement("number", (Component)this.txtNumber);
        numberElement.setCompareType(CompareType.LIKE);
        rootElement.add((IFilterElement)numberElement);
        rootElement.add((IFilterElement)new SingleFilterElement("assets.equipmentArchives.id", (Component)this.prmtEquipmentArchives));
        rootElement.add((IFilterElement)new SingleFilterElement("assets.equipmentLocation.id", (Component)this.prmtEquipmentLocation));
        rootElement.add((IFilterElement)new SingleFilterElement("persons.maintainOrgUnit.id", (Component)this.prmtMaintainOrgUnit));
        rootElement.add((IFilterElement)new SingleFilterElement("persons.maintainCrafts.id", (Component)this.prmtMaintainCraft));
        rootElement.add((IFilterElement)new SingleFilterElement("persons.maintainGroup.id", (Component)this.prmtMaintainGroup));
        rootElement.add((IFilterElement)new SingleFilterElement("persons.maintainStaff.id", (Component)this.prmtMaintainStaff));
        rootElement.add((IFilterElement)new SingleFilterElement("materials.material.id", (Component)this.prmtMaterial));
        rootElement.add((IFilterElement)new SingleFilterElement("materials.storageOrgUnit.id", (Component)this.prmtMaterialStorageOrgUnit));
        rootElement.add((IFilterElement)new SingleFilterElement("materials.warehouse.id", (Component)this.prmtMaterialWarehouse));
        rootElement.add((IFilterElement)new SingleFilterElement("tools.tool.id", (Component)this.prmtTool));
        rootElement.add((IFilterElement)new SingleFilterElement("tools.storageOrgUnit.id", (Component)this.prmtToolStorageOrgUnit));
        rootElement.add((IFilterElement)new SingleFilterElement("tools.warehouse.id", (Component)this.prmtToolWarehouse));
        rootElement.add((IFilterElement)new SingleFilterElement("services.purchaseOrgUnit.id", (Component)this.prmpPurchaseOrgUnit));
        rootElement.add((IFilterElement)new SingleFilterElement("services.supplier.id", (Component)this.prmtSupplier));
    }

    protected void registerCustomerBindings() {
        super.registerCustomerBindings();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic, (String[])new String[]{"parent"});
        this.prmtMaintainCraft.setSelectorCollection(sic);
        SelectorItemCollection sic1 = new SelectorItemCollection();
        GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)sic1, (String[])new String[]{"parent"});
        sic1.add("id");
        sic1.add("name");
        sic1.add("number");
        this.prmtMaintainStaff.setSelectorCollection(sic1);
        try {
            EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmpPurchaseOrgUnit, null, (boolean)false, (OrgType)OrgType.Purchase, (boolean)true, (boolean)false);
            EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtToolStorageOrgUnit, null, (boolean)false, (OrgType)OrgType.Storage, (boolean)true, (boolean)false);
            EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtMaterialStorageOrgUnit, null, (boolean)false, (OrgType)OrgType.Storage, (boolean)true, (boolean)false);
            EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtMaintainOrgUnit, null, (boolean)false, (OrgType)OrgType.Storage, (boolean)true, (boolean)false);
            EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmtOrgUnit, (String)PERMISSION_VIEW, (boolean)true, (OrgType)OrgType.Storage, (boolean)true, (boolean)false);
            this.createMaintainGroupPrmt();
            this.createMaintainStaffPrmt();
            this.createMaterialWarehousePrmt();
            this.createToolWarehousePrmt();
            this.createSupplierPrmt();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void createMaintainStaffPrmt() {
        OrgUnitInfo storageOrgUnit = (OrgUnitInfo)this.prmtMaintainOrgUnit.getValue();
        EquipmentMaintainGroupTreeInfo groupInfo = (EquipmentMaintainGroupTreeInfo)this.prmtMaintainGroup.getValue();
        EntityViewInfo view = this.createEntityView();
        String storageId = storageOrgUnit != null ? storageOrgUnit.getId().toString() : "null";
        FilterItemInfo item = null;
        item = storageId.equals("null") ? new FilterItemInfo("id", null, CompareType.IS) : new FilterItemInfo("storageOrgUnit.id", (Object)storageId);
        if (item != null) {
            view.getFilter().getFilterItems().add(item);
        }
        if (groupInfo != null) {
            item = new FilterItemInfo("group.parent.id", (Object)groupInfo.getId().toString());
            view.getFilter().getFilterItems().add(item);
        }
        this.prmtMaintainStaff.setEntityViewInfo(view);
    }

    protected void initListener() {
        super.initListener();
        this.prmpPurchaseOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                EquipmentStandardOperationFilterUI.this.prmtSupplier.setValue(null);
                EquipmentStandardOperationFilterUI.this.createSupplierPrmt();
            }
        });
        this.prmtMaintainOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                EquipmentStandardOperationFilterUI.this.prmtMaintainGroup.setValue(null);
                EquipmentStandardOperationFilterUI.this.prmtMaintainStaff.setValue(null);
                EquipmentStandardOperationFilterUI.this.createMaintainGroupPrmt();
                EquipmentStandardOperationFilterUI.this.createMaintainStaffPrmt();
            }
        });
        this.prmtMaintainGroup.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                EquipmentStandardOperationFilterUI.this.prmtMaintainStaff.setValue(null);
                EquipmentStandardOperationFilterUI.this.createMaintainStaffPrmt();
            }
        });
        this.prmtMaterialStorageOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                EquipmentStandardOperationFilterUI.this.prmtMaterialWarehouse.setValue(null);
                EquipmentStandardOperationFilterUI.this.createMaterialWarehousePrmt();
            }
        });
        this.prmtToolStorageOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                EquipmentStandardOperationFilterUI.this.prmtToolWarehouse.setValue(null);
                EquipmentStandardOperationFilterUI.this.createToolWarehousePrmt();
            }
        });
    }

    public ControlledItems[] getNeedMainOrgControl() {
        return new ControlledItems[0];
    }

    protected void afterMainOrgChanged(OrgUnitInfo oldOrg, OrgUnitInfo org) {
        super.afterMainOrgChanged(oldOrg, org);
        this.prmtEquipmentArchives.setValue(null);
        this.prmtEquipmentLocation.setValue(null);
        try {
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtEquipmentLocation, (String)"com.kingdee.eas.eqm.basedata.app.F7EquipmentLocationQuery", (String[])new String[]{"planOrgUnit.id"}, (Object[])new Object[]{org.getId()});
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtEquipmentArchives, (String)"com.kingdee.eas.eqm.archives.app.F7EquipmentArchivesQuery", (String[])new String[]{"planOrgUnit.id", "bizStatus"}, (Object[])new Object[]{this.getMainOrgInfo().getId(), new Integer(10)});
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtMaterial, (String)"com.kingdee.eas.eqm.archives.app.F7MaterialQuery", (EntityViewInfo)this.getMaterialFilterInfo());
            EQMPromptDialogFactory.createPrmptList((KDBizPromptBox)this.prmtTool, (String)"com.kingdee.eas.eqm.archives.app.F7MaterialQuery", (EntityViewInfo)this.getToolFilterInfo());
            OrgUnitInfo storageOrgUnit = this.getCurrentOrgInfo();
            this.prmtMaterial.setCurrentMainBizOrgUnit(storageOrgUnit, OrgType.Storage);
            this.prmtTool.setCurrentMainBizOrgUnit(storageOrgUnit, OrgType.Storage);
            this.prmtEquipmentArchives.setCurrentMainBizOrgUnit(storageOrgUnit, OrgType.Storage);
            this.prmtEquipmentLocation.setCurrentMainBizOrgUnit(storageOrgUnit, OrgType.Storage);
            this.prmtMaintainCraft.setCurrentMainBizOrgUnit(storageOrgUnit, OrgType.Storage);
            this.prmtMaintainGroup.setCurrentMainBizOrgUnit(storageOrgUnit, OrgType.Storage);
            this.prmtMaintainStaff.setCurrentMainBizOrgUnit(storageOrgUnit, OrgType.Storage);
            this.prmtMaterialStorageOrgUnit.setCurrentMainBizOrgUnit(storageOrgUnit, OrgType.Storage);
            this.prmtMaterialWarehouse.setCurrentMainBizOrgUnit(storageOrgUnit, OrgType.Storage);
            this.prmtSupplier.setCurrentMainBizOrgUnit(storageOrgUnit, OrgType.Storage);
            this.prmtToolStorageOrgUnit.setCurrentMainBizOrgUnit(storageOrgUnit, OrgType.Storage);
            this.prmtToolWarehouse.setCurrentMainBizOrgUnit(storageOrgUnit, OrgType.Storage);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected OrgUnitInfo getCurrentOrgInfo() throws BOSException {
        OrgUnitInfo org = (OrgUnitInfo)this.prmtOrgUnit.getValue();
        if (org == null) {
            org = this.getMainOrgInfo();
        }
        HashMap<BOSUuid, OrgUnitInfo> map = new HashMap<BOSUuid, OrgUnitInfo>();
        if (org.getCU() == null || org.getCU() != null && org.getCU().getNumber() == null || org.getCU() != null && org.getCU().getLongNumber() == null) {
            try {
                if (map.get(org.getId()) == null) {
                    if (org.getCU() == null) {
                        IStorageOrgUnit iStorage = StorageOrgUnitFactory.getRemoteInstance();
                        StorageOrgUnitInfo org1 = iStorage.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(org.getId()), GeneSelectorUtils.getSelector((BOSObjectType)new StorageOrgUnitInfo().getBOSType(), (String)"", (boolean)false, (boolean)true, (boolean)false));
                        org.setCU(org1.getCU());
                        map.put(org.getId(), org);
                    } else {
                        CtrlUnitInfo ctrlUnitInfo = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(org.getCU().getId()));
                        org.setCU(ctrlUnitInfo);
                        map.put(org.getId(), org);
                    }
                } else {
                    org = (OrgUnitInfo)map.get(org.getId());
                }
            }
            catch (EASBizException eASBizException) {
                // empty catch block
            }
        }
        return org;
    }

    private EntityViewInfo getMaterialFilterInfo() throws BOSException {
        EntityViewInfo entityViewInfo1 = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new MaterialInfo().getBOSType(), (String)"", (boolean)false, (boolean)true, (boolean)true));
        sic.add(new SelectorItemInfo("baseUnit.qtyPrecision"));
        entityViewInfo1.setSelector(sic);
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("equipProperty", (Object)new Integer(2), CompareType.NOTEQUALS));
        filter1.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
        filter1.mergeFilter(this.getBaseFilterInfo("4409E7F0"), "and");
        entityViewInfo1.setFilter(filter1);
        return entityViewInfo1;
    }

    private EntityViewInfo getToolFilterInfo() throws BOSException {
        EntityViewInfo entityViewInfo1 = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new MaterialInfo().getBOSType(), (String)"", (boolean)false, (boolean)true, (boolean)true));
        sic.add(new SelectorItemInfo("baseUnit.qtyPrecision"));
        entityViewInfo1.setSelector(sic);
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("equipProperty", (Object)new Integer(2), CompareType.EQUALS));
        filter1.mergeFilter(this.getBaseFilterInfo("4409E7F0"), "and");
        entityViewInfo1.setFilter(filter1);
        return entityViewInfo1;
    }

    protected FilterInfo getBaseFilterInfo(String bosType) throws BOSException {
        OrgUnitInfo org = this.getCurrentOrgInfo();
        String cuid = org != null && org.getCU() != null && org.getCU().getId() != null ? org.getCU().getId().toString() : SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        FilterInfo baseFilter = new FilterInfo();
        baseFilter.setMaskString("#0 or #1");
        baseFilter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuid, CompareType.EQUALS));
        baseFilter.getFilterItems().add(new FilterItemInfo("id", (Object)("SELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE FBOSObjectType = '" + bosType + "' AND FAssignCUID = '" + cuid + "')"), CompareType.INNER));
        return baseFilter;
    }

    public boolean isSupportMultiOrgs() {
        return false;
    }

    private EntityViewInfo createEntityView() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(new FilterInfo());
        return viewInfo;
    }

    private void createMaintainGroupPrmt() {
        OrgUnitInfo storageOrgUnit = (OrgUnitInfo)this.prmtMaintainOrgUnit.getValue();
        String storageId = storageOrgUnit != null ? storageOrgUnit.getId().toString() : "null";
        EntityViewInfo view = this.createEntityView();
        FilterItemInfo item = new FilterItemInfo("storageOrgUnit.id", (Object)storageId);
        view.getFilter().getFilterItems().add(item);
        this.prmtMaintainGroup.setEntityViewInfo(view);
    }

    private void createMaterialWarehousePrmt() {
        OrgUnitInfo storageOrgUnit = (OrgUnitInfo)this.prmtMaterialStorageOrgUnit.getValue();
        String storageOrgId = storageOrgUnit != null ? storageOrgUnit.getId().toString() : "null";
        EntityViewInfo view = this.createEntityView();
        FilterItemInfo item = new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgId);
        view.getFilter().getFilterItems().add(item);
        this.prmtMaterialWarehouse.setEntityViewInfo(view);
    }

    private void createToolWarehousePrmt() {
        OrgUnitInfo storageOrgUnit = (OrgUnitInfo)this.prmtToolStorageOrgUnit.getValue();
        String storageOrgId = storageOrgUnit != null ? storageOrgUnit.getId().toString() : "null";
        EntityViewInfo view = this.createEntityView();
        FilterItemInfo item = new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgId);
        view.getFilter().getFilterItems().add(item);
        this.prmtToolWarehouse.setEntityViewInfo(view);
    }

    private void createSupplierPrmt() {
        OrgUnitInfo purchaseOrgUnitInfo = (OrgUnitInfo)this.prmpPurchaseOrgUnit.getValue();
        String orgId = purchaseOrgUnitInfo != null ? purchaseOrgUnitInfo.getId().toString() : "null";
        EntityViewInfo viewInfo = this.createEntityView();
        FilterItemInfo item = new FilterItemInfo("id in (select FSupplierID from T_BD_SupplierPurchaseInfo t where t.FPurchaseOrgID='" + orgId + "')");
        viewInfo.getFilter().getFilterItems().add(item);
        this.prmtSupplier.setEntityViewInfo(viewInfo);
    }

    public String getViewPermItemName() {
        return PERMISSION_VIEW;
    }

    public FilterInfo getFilterInfo() {
        if (super.getFilterInfo() == null) {
            return null;
        }
        FilterInfo filterInfo = super.getFilterInfo();
        this.reBuildFilterInfo(filterInfo);
        if (this.prmtEquipmentArchives.getValue() == null && this.prmtEquipmentLocation.getValue() != null) {
            GeneFilterUtils.mergeFilter((FilterInfo)filterInfo, (FilterItemInfo)new FilterItemInfo("assets.equipmentArchives.id", null, CompareType.EQUALS));
        }
        return filterInfo;
    }

    private void reBuildFilterInfo(FilterInfo filterInfo) {
        FilterItemCollection filterCol = filterInfo.getFilterItems();
        int count = filterCol.size();
        for (int i = 0; i < count; ++i) {
            FilterItemInfo filterItem = filterCol.get(i);
            if (filterItem.getPropertyName().equals("assets.equipmentArchives.id")) {
                filterCol.removeObject(i);
                filterCol.addObject(i, (IObjectValue)this.getParentIDFilter(this.prmtEquipmentArchives, "SELECT FStandardOperationID FROM T_EQM_SOASSET WHERE FEquipmentArchivesID="));
                continue;
            }
            if (filterItem.getPropertyName().equals("assets.equipmentLocation.id")) {
                filterCol.removeObject(i);
                filterCol.addObject(i, (IObjectValue)this.getParentIDFilter(this.prmtEquipmentLocation, "SELECT FStandardOperationID FROM T_EQM_SOASSET WHERE FEquipmentLocationID="));
                continue;
            }
            if (filterItem.getPropertyName().equals("persons.maintainOrgUnit.id")) {
                filterCol.removeObject(i);
                filterCol.addObject(i, (IObjectValue)this.getParentIDFilter(this.prmtMaintainOrgUnit, "SELECT FStandardOperationID FROM T_EQM_SOPERSON WHERE FMaintainOrgUnitID="));
                continue;
            }
            if (filterItem.getPropertyName().equals("persons.maintainCrafts.id")) {
                filterCol.removeObject(i);
                filterCol.addObject(i, (IObjectValue)this.getParentIDFilter(this.prmtMaintainCraft, "SELECT FStandardOperationID FROM T_EQM_SOPERSON WHERE FMaintainCraftsID="));
                continue;
            }
            if (filterItem.getPropertyName().equals("persons.maintainGroup.id")) {
                filterCol.removeObject(i);
                filterCol.addObject(i, (IObjectValue)this.getParentIDFilter(this.prmtMaintainGroup, "SELECT FStandardOperationID FROM T_EQM_SOPERSON WHERE FMaintainGroupID="));
                continue;
            }
            if (filterItem.getPropertyName().equals("persons.maintainStaff.id")) {
                filterCol.removeObject(i);
                filterCol.addObject(i, (IObjectValue)this.getParentIDFilter(this.prmtMaintainStaff, "SELECT FStandardOperationID FROM T_EQM_SOPERSON WHERE FMaintainStaffID="));
                continue;
            }
            if (filterItem.getPropertyName().equals("materials.material.id")) {
                filterCol.removeObject(i);
                filterCol.addObject(i, (IObjectValue)this.getParentIDFilter(this.prmtMaterial, "SELECT FStandardOperationID FROM T_EQM_SOMATERIAL WHERE FMaterialID="));
                continue;
            }
            if (filterItem.getPropertyName().equals("materials.storageOrgUnit.id")) {
                filterCol.removeObject(i);
                filterCol.addObject(i, (IObjectValue)this.getParentIDFilter(this.prmtMaterialStorageOrgUnit, "SELECT FStandardOperationID FROM T_EQM_SOMATERIAL WHERE FStorageOrgUnitID="));
                continue;
            }
            if (filterItem.getPropertyName().equals("materials.warehouse.id")) {
                filterCol.removeObject(i);
                filterCol.addObject(i, (IObjectValue)this.getParentIDFilter(this.prmtMaterialWarehouse, "SELECT FStandardOperationID FROM T_EQM_SOMATERIAL WHERE FWarehouseID="));
                continue;
            }
            if (filterItem.getPropertyName().equals("tools.tool.id")) {
                filterCol.removeObject(i);
                filterCol.addObject(i, (IObjectValue)this.getParentIDFilter(this.prmtTool, "SELECT FStandardOperationID FROM T_EQM_SOTOOL WHERE FToolID="));
                continue;
            }
            if (filterItem.getPropertyName().equals("tools.storageOrgUnit.id")) {
                filterCol.removeObject(i);
                filterCol.addObject(i, (IObjectValue)this.getParentIDFilter(this.prmtToolStorageOrgUnit, "SELECT FStandardOperationID FROM T_EQM_SOTOOL WHERE FStorageOrgUnitID="));
                continue;
            }
            if (filterItem.getPropertyName().equals("tools.warehouse.id")) {
                filterCol.removeObject(i);
                filterCol.addObject(i, (IObjectValue)this.getParentIDFilter(this.prmtToolWarehouse, "SELECT FStandardOperationID FROM T_EQM_SOTOOL WHERE FWarehouseID="));
                continue;
            }
            if (filterItem.getPropertyName().equals("services.purchaseOrgUnit.id")) {
                filterCol.removeObject(i);
                filterCol.addObject(i, (IObjectValue)this.getParentIDFilter(this.prmpPurchaseOrgUnit, "SELECT FStandardOperationID FROM T_EQM_SOSERVICE WHERE FPurchaseOrgUnitID="));
                continue;
            }
            if (!filterItem.getPropertyName().equals("services.supplier.id")) continue;
            filterCol.removeObject(i);
            filterCol.addObject(i, (IObjectValue)this.getParentIDFilter(this.prmtSupplier, "SELECT FStandardOperationID FROM T_EQM_SOSERVICE WHERE FSupplierID="));
        }
    }

    private FilterItemInfo getParentIDFilter(KDBizPromptBox prmtBox, String sql) {
        ObjectBaseInfo data;
        String dataID = "";
        if (prmtBox.getValue() != null && (data = (ObjectBaseInfo)prmtBox.getData()) != null) {
            dataID = data.getString("id");
        }
        sql = sql + "'" + dataID + "'";
        return new FilterItemInfo("id", (Object)sql, CompareType.INNER);
    }
}

