/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.freechart.chart.ChartFactory;
import com.kingdee.bos.ctrl.freechart.chart.ChartPanel;
import com.kingdee.bos.ctrl.freechart.chart.JFreeChart;
import com.kingdee.bos.ctrl.freechart.chart.axis.CategoryLabelPositions;
import com.kingdee.bos.ctrl.freechart.chart.axis.NumberAxis;
import com.kingdee.bos.ctrl.freechart.chart.labels.CategoryItemLabelGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.CategoryToolTipGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.ItemLabelAnchor;
import com.kingdee.bos.ctrl.freechart.chart.labels.ItemLabelPosition;
import com.kingdee.bos.ctrl.freechart.chart.labels.StandardCategoryItemLabelGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.StandardCategoryToolTipGenerator;
import com.kingdee.bos.ctrl.freechart.chart.plot.CategoryPlot;
import com.kingdee.bos.ctrl.freechart.chart.plot.PlotOrientation;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.BarRenderer3D;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.CategoryItemRenderer;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.LineAndShapeRenderer;
import com.kingdee.bos.ctrl.freechart.data.category.CategoryDataset;
import com.kingdee.bos.ctrl.freechart.data.category.DefaultCategoryDataset;
import com.kingdee.bos.ctrl.freechart.ui.TextAnchor;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentReadingHistoryFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStatusAnalysisFacadeFactory;
import com.kingdee.eas.eqm.basedata.GraphicTypeEnum;
import com.kingdee.eas.eqm.basedata.MeterTypeEnum;
import com.kingdee.eas.eqm.basedata.MontorAccuracyTypeEnum;
import com.kingdee.eas.eqm.basedata.client.AbstractEquipmentStatusAnalysisUI;
import com.kingdee.eas.eqm.basedata.client.GeneBiMultiLayoutPane;
import com.kingdee.eas.eqm.common.core.client.verify.UIControlEmptyVerifyItem;
import com.kingdee.eas.eqm.common.core.filter.IFilterElement;
import com.kingdee.eas.eqm.common.core.filter.IQueryFilterManager;
import com.kingdee.eas.eqm.common.core.filter.QueryFilterManager;
import com.kingdee.eas.eqm.common.core.filter.RangeFilterElement;
import com.kingdee.eas.eqm.common.core.filter.SingleFilterElement;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import com.kingdee.eas.eqm.common.core.util.GeneListenerUtil;
import com.kingdee.eas.eqm.common.core.util.GeneResourceUtil;
import com.kingdee.eas.eqm.common.core.util.KDTableUtils;
import com.kingdee.eas.eqm.common.core.util.QMResourceUtils;
import com.kingdee.eas.eqm.common.core.verify.AbstractVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.common.eqmcore.client.util.ControlledItems;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.util.KDCloseableTabbedPane;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class EquipmentStatusAnalysisUI
extends AbstractEquipmentStatusAnalysisUI {
    private static final Logger logger = CoreUIObject.getLogger(EquipmentStatusAnalysisUI.class);
    private IQueryFilterManager manager = null;
    protected static final String RESOURCE_PATH = "com.kingdee.eas.eqm.basedata.EquipmentStatusAnalysisResource";
    private int maxColumn = 100;
    private KDSplitPane split = null;
    private Object constraints = null;
    private Container parent = null;
    private static int initColumnCount = 4;
    GeneBiMultiLayoutPane graphicPanel = new GeneBiMultiLayoutPane(new KDCloseableTabbedPane.CloseHandler(){

        public void close(Component tabbedComponent, int tabIndex) {
            if (MsgBox.showConfirm2((Component)tabbedComponent, (String)EASResource.getString((String)"com.kingdee.eas.framework.bireport.client.BireportBaseMainUI.ChartCloseConfirm")) == 0) {
                EquipmentStatusAnalysisUI.this.removeChart((JPanel)tabbedComponent);
            }
        }
    });

    protected void removeChart(JPanel chart) {
        this.graphicPanel.removeMultiPartComponent(chart);
        this.graphicPanel.reLayout();
        this.graphicPanel.updateUI();
    }

    protected String getEditUIName() {
        return null;
    }

    public boolean isBizUnitOnly() {
        return true;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EquipmentReadingHistoryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public void onLoad() throws Exception {
        this.tblMain.putBindContents("", new String[0]);
        this.tblMain.checkParsed(true);
        super.onLoad();
        this.constraints = this.kDPanel3.getClientProperty((Object)"KDLayoutConstraints");
        this.graphicPanel.setFrameTitle(this.getUITitle());
        this.graphicPanel.getCloseFrame().addActionListener((ActionListener)((Object)this.actionCloseGraphicFrame));
        this.graphicPanel.getGraphicType().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    if (e.getStateChange() == 1) {
                        EquipmentStatusAnalysisUI.this.actionViewTendencyGraphic_actionPerformed(null);
                    }
                }
                catch (Exception e1) {
                    EquipmentStatusAnalysisUI.this.handleException(e1);
                }
            }
        });
        this.parent = this.kDPanel3.getParent();
    }

    protected void initListener() {
        super.initListener();
        this.prmptArchives.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EquipmentStatusAnalysisUI.this.prmptEquipment_stateChanged(e);
            }
        });
        this.prmptLocation.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EquipmentStatusAnalysisUI.this.prmptLocation_stateChanged(e);
            }
        });
    }

    private void loadDataToTable(IRowSet rs) {
        if (rs == null) {
            return;
        }
        this.initTblColumn(rs);
        this.loadLineData(rs);
    }

    private void loadLineData(IRowSet rs) {
        try {
            if (rs == null) {
                return;
            }
            String meterid = null;
            IRow row = null;
            rs.beforeFirst();
            boolean haveData = false;
            while (rs.next()) {
                String tmpMeterid = rs.getString("FMETERID");
                Timestamp readingDate = rs.getTimestamp("FREADINGDATE");
                String currentValue = rs.getString("FCURRENTVALUE");
                String montorid = rs.getString("FMONTORID");
                int triggerType = rs.getInt("FTRIGGERTYPE");
                int meterType = rs.getInt("FMETERTYPE");
                String columnName = rs.getString("FSEGMENT");
                if (meterid == null || !meterid.equals(tmpMeterid)) {
                    meterid = tmpMeterid;
                    String meterName = rs.getString("FMETERNAME");
                    String meterUnitName = rs.getString("FMETERUNITNAME");
                    row = this.tblMain.addRow();
                    row.getCell("id").setValue((Object)montorid);
                    row.getCell("meter.name").setValue((Object)meterName);
                    row.getCell("meter.unit.name").setValue((Object)meterUnitName);
                    row.getCell("meter.meterType").setValue((Object)MeterTypeEnum.getEnum(meterType));
                    if (!haveData) {
                        haveData = true;
                    }
                }
                row.getCell(columnName).setValue((Object)currentValue);
                this.customerStyle(row, columnName, triggerType);
            }
            if (haveData) {
                this.actionViewTendencyGraphic.setEnabled(true);
                this.actionViewTriggerValue.setEnabled(true);
            }
            this.sortForTable(this.tblMain);
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    private void sortForTable(KDTable tableTest) {
        KDTSortManager sortManager = new KDTSortManager(tableTest);
        sortManager.setSortAuto(true);
        sortManager.setClickCount(1);
        for (int i = 0; i < tableTest.getColumnCount(); ++i) {
            tableTest.getColumn(i).setSortable(true);
        }
    }

    private void customerStyle(IRow row, String columnName, int triggerType) {
        if (triggerType == Integer.parseInt("2") || triggerType == Integer.parseInt("3")) {
            row.getCell(columnName).getStyleAttributes().setBackground(Color.YELLOW);
        } else if (triggerType == Integer.parseInt("1") || triggerType == Integer.parseInt("4") || triggerType == Integer.parseInt("5")) {
            row.getCell(columnName).getStyleAttributes().setBackground(Color.RED);
        }
    }

    private void initTblColumn(IRowSet rs) {
        try {
            if (rs == null) {
                return;
            }
            int i = this.tblMain.getColumnCount();
            ArrayList<String> columnLable = new ArrayList<String>();
            while (rs.next()) {
                String segment = rs.getString("FSEGMENT");
                if (columnLable.contains(segment)) continue;
                columnLable.add(segment);
            }
            Collections.sort(columnLable, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String obj1 = (String)o1;
                    String obj2 = (String)o2;
                    return obj1.compareTo(obj2);
                }
            });
            IRow row = this.tblMain.getHeadRow(0);
            for (int j = 0; j < columnLable.size(); ++j) {
                IColumn col = this.tblMain.addColumn(i);
                col.getStyleAttributes().setLocked(true);
                col.setKey((String)columnLable.get(j));
                col.setWidth(140);
                col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
                ++i;
                row.getCell(col.getColumnIndex()).setValue(columnLable.get(j));
            }
        }
        catch (SQLException e) {
            this.handleException(e);
        }
    }

    protected void prmptLocation_stateChanged(ChangeEvent e) {
        if (this.prmptLocation.getValue() != null) {
            this.txtLocationName.setText(((EquipmentLocationInfo)this.prmptLocation.getValue()).getName());
            ChangeListener[] listeners = GeneListenerUtil.getChangeListener((KDBizPromptBox)this.prmptArchives);
            GeneListenerUtil.removeChangeListener((KDBizPromptBox)this.prmptArchives, (ChangeListener[])listeners);
            this.prmptArchives.setValue(null);
            GeneListenerUtil.addChangeListener((KDBizPromptBox)this.prmptArchives, (ChangeListener[])listeners);
            this.txtArchivesName.setText(null);
        } else {
            this.txtLocationName.setText(null);
        }
        this.tblMain.removeRows(false);
        while (this.tblMain.getColumnCount() != initColumnCount) {
            this.tblMain.removeColumn(this.tblMain.getColumnCount() - 1);
        }
    }

    protected void prmptEquipment_stateChanged(ChangeEvent e) {
        if (this.prmptArchives.getValue() != null) {
            this.txtArchivesName.setText(((EquipmentArchivesInfo)this.prmptArchives.getValue()).getName());
            ChangeListener[] listeners = GeneListenerUtil.getChangeListener((KDBizPromptBox)this.prmptLocation);
            GeneListenerUtil.removeChangeListener((KDBizPromptBox)this.prmptLocation, (ChangeListener[])listeners);
            this.prmptLocation.setValue(null);
            GeneListenerUtil.addChangeListener((KDBizPromptBox)this.prmptLocation, (ChangeListener[])listeners);
            this.txtLocationName.setText(null);
        } else {
            this.txtArchivesName.setText(null);
        }
        this.tblMain.removeRows(false);
        while (this.tblMain.getColumnCount() != initColumnCount) {
            this.tblMain.removeColumn(this.tblMain.getColumnCount() - 1);
        }
    }

    protected void registerCustomerBindings() {
        super.registerCustomerBindings();
        this.cmbAccurate.setSelectedItem((Object)MontorAccuracyTypeEnum.day);
        EQMPromptDialogFactory.createPrmptOrgDialog((KDBizPromptBox)this.prmptOrgUnit, (String)this.getOnloadPermItemName(), (boolean)false, (OrgType)this.getMainBizOrgType(), (boolean)true, (boolean)false);
        this.prmptOrgUnit.setValue((Object)this.getDefaultMainBizOrg());
        try {
            EQMPromptDialogFactory.createPrmptList((Context)this.getMainOrgContext(), (ControlledItems[])new ControlledItems[]{new ControlledItems(this.prmptArchives, "history.orgID"), new ControlledItems(this.prmptLocation, "maintainOrgUnit.id")}, (OrgUnitInfo[])new OrgUnitInfo[]{this.getMainOrgInfo()}, (String)(this.getMainBizOrgField() + ".id"));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (this.manager == null) {
            this.manager = new QueryFilterManager();
            this.registerQueryFilterManager(this.manager);
        }
        this.readingDateStart.setValue((Object)GeneDateUtils.getLastMonth());
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmptOrgUnit;
    }

    protected void initTableParams() {
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void afterMainOrgChanged(String oldOrgId, String newOrgId) {
        if (this.isFirstOnload()) {
            return;
        }
        if (newOrgId == null) {
            newOrgId = oldOrgId;
            for (int i = 0; i < this.mainOrgs.length; ++i) {
                int j;
                if (!this.mainOrgs[i].getId().toString().equals(oldOrgId)) continue;
                this.getUIContext().put(this.getMainBizOrgType(), this.mainOrgs[i]);
                ChangeListener[] changeListeners = this.getMainBizOrg().getChangeListeners();
                for (j = 0; j < changeListeners.length; ++j) {
                    this.getMainBizOrg().removeChangeListener(changeListeners[j]);
                }
                this.getMainBizOrg().setValue((Object)this.mainOrgs[i]);
                for (j = 0; j < changeListeners.length; ++j) {
                    this.getMainBizOrg().addChangeListener(changeListeners[j]);
                }
                return;
            }
        }
        if (!newOrgId.equals(oldOrgId)) {
            String strTemp = GeneResourceUtil.getMsg((String)RESOURCE_PATH, (String)"OrgModifiedMsg", null);
            int ret = MsgBox.showConfirm2((String)strTemp);
            if (ret == 2) {
                return;
            }
        } else {
            return;
        }
        try {
            this.prmptArchives.setValue(null);
            this.txtArchivesName.setText(null);
            this.prmptLocation.setValue(null);
            this.txtLocationName.setText(null);
            EQMPromptDialogFactory.createPrmptList((Context)this.getMainOrgContext(), (ControlledItems[])new ControlledItems[]{new ControlledItems(this.prmptArchives, "history.orgID"), new ControlledItems(this.prmptLocation, "maintainOrgUnit.id")}, (OrgUnitInfo[])new OrgUnitInfo[]{this.getMainOrgInfo()}, (String)(this.getMainBizOrgField() + ".id"));
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
        this.tblMain.removeRows(false);
        if (this.parent == null) {
            return;
        }
        this.graphicPanel.setVisible(false);
        this.changeSplitLayout(false, null);
        while (this.graphicPanel.getMultiPartCount() > 0) {
            this.graphicPanel.removeMultiPartComponent(this.graphicPanel.getMultiPartComponent(0));
        }
        this.split.setDividerLocation(0);
        this.graphicPanel.reLayout(0, this.graphicPanel.isShowAtNewFrame());
        this.updateUI();
    }

    private void registerQueryFilterManager(IQueryFilterManager manager2) {
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.id", (Component)this.prmptOrgUnit);
        OrgUnitInfo defaultMainBizOrg = this.getDefaultMainBizOrg();
        if (defaultMainBizOrg != null) {
            mainOrgElement.setDefaultValue(defaultMainBizOrg.getId().toString());
        }
        this.manager.getRootElement().getVerifyManager().addVerifyItem((IVerifyItem)new UIControlEmptyVerifyItem((CoreUIObject)this));
        this.manager.getRootElement().add((IFilterElement)mainOrgElement);
        this.manager.setMainOrgElement((IFilterElement)mainOrgElement);
        SingleFilterElement archives = new SingleFilterElement("equipment.id", (Component)this.prmptArchives);
        this.manager.getRootElement().add((IFilterElement)archives);
        SingleFilterElement location = new SingleFilterElement("location.id", (Component)this.prmptLocation);
        this.manager.getRootElement().add((IFilterElement)location);
        RangeFilterElement dateElement = new RangeFilterElement("readingDate", (Component)this.readingDateStart, (Component)this.readingDateEnd);
        dateElement.setDefaultValue((Object)new String[]{GeneDateUtils.getLastMonthString(), GeneDateUtils.getDayBeginString()});
        this.manager.getRootElement().add((IFilterElement)dateElement);
        this.manager.getRootElement().getVerifyManager().addVerifyItem((IVerifyItem)new AbstractVerifyItem(){

            public boolean verify() throws EASBizException, BOSException {
                if (EquipmentStatusAnalysisUI.this.readingDateStart.getValue() == null || EquipmentStatusAnalysisUI.this.readingDateEnd.getValue() == null) {
                    return true;
                }
                if (DateTimeUtils.dayBefore((Date)((Date)EquipmentStatusAnalysisUI.this.readingDateEnd.getValue()), (Date)((Date)EquipmentStatusAnalysisUI.this.readingDateStart.getValue()))) {
                    MsgBox.showWarning((String)QMResourceUtils.getMessage((String)"com.kingdee.eas.eqm.basedata.EquipmentReadingEditUIResource", (String)"filter_mustBefore_beginDateAndEndDate"));
                    SysUtil.abort();
                }
                return true;
            }
        });
    }

    @Override
    public void actionQueryMontorValue_actionPerformed(ActionEvent e) throws Exception {
        boolean flag = this.manager.verify();
        if (flag) {
            if (this.prmptArchives.getValue() == null && this.prmptLocation.getValue() == null) {
                String msg = EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentReadingEditUIResource", (String)"EQUIPMENTLOCATIONCANNOTNULL");
                MsgBox.showWarning((String)msg);
                this.prmptArchives.requestFocus();
                SysUtil.abort();
            }
            this.tblMain.removeRows(false);
            while (this.tblMain.getColumnCount() != initColumnCount) {
                this.tblMain.removeColumn(this.tblMain.getColumnCount() - 1);
            }
            this.tblMain_tableDataRequest(e);
            boolean havingData = this.tblMain.getRowCount() > 0;
            this.actionViewTendencyGraphic.setEnabled(havingData);
            this.actionViewTriggerValue.setEnabled(havingData);
        }
    }

    @Override
    public void actionViewTendencyGraphic_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] rows = KDTableUtils.getSelectedRows((KDTable)this.tblMain);
        ArrayList<Integer> checkMeters = new ArrayList<Integer>();
        boolean isSelectFeatureMeter = false;
        boolean isSelectCheckMeter = false;
        for (int i = 0; i < rows.length; ++i) {
            IRow row = this.tblMain.getRow(rows[i]);
            Object obj = row.getCell("meter.meterType").getValue();
            if (!(obj instanceof MeterTypeEnum)) continue;
            if (((MeterTypeEnum)((Object)obj)).getValue() == 30 && !isSelectFeatureMeter) {
                isSelectFeatureMeter = true;
            }
            if (((MeterTypeEnum)((Object)obj)).getValue() != 20) continue;
            if (!isSelectCheckMeter) {
                isSelectCheckMeter = true;
            }
            checkMeters.add(new Integer(rows[i]));
        }
        if (isSelectFeatureMeter && rows.length == 1 || !isSelectCheckMeter) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentReadingEditUIResource", (String)"SELECTDOUBLEMETER"));
            SysUtil.abort();
        }
        super.actionViewTendencyGraphic_actionPerformed(e);
        this.graphicPanel.setVisible(true);
        this.changeSplitLayout(true, checkMeters);
        this.graphicPanel.reLayout(0, this.graphicPanel.isShowAtNewFrame());
        this.updateUI();
    }

    @Override
    public void actionCloseGraphicFrame_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloseGraphicFrame_actionPerformed(e);
        this.graphicPanel.setVisible(false);
        this.changeSplitLayout(false, null);
        while (this.graphicPanel.getMultiPartCount() > 0) {
            this.graphicPanel.removeMultiPartComponent(this.graphicPanel.getMultiPartComponent(0));
        }
        this.split.setDividerLocation(0);
        this.graphicPanel.reLayout(0, this.graphicPanel.isShowAtNewFrame());
        this.updateUI();
    }

    private void changeSplitLayout(boolean showSplit, List checkMeters) {
        if (this.parent == null) {
            return;
        }
        if (this.split == null) {
            this.split = new KDSplitPane(1);
            this.split.add((Component)((Object)this.graphicPanel), (Object)"right");
            this.split.setDividerLocation(this.parent.getWidth() / 2);
        }
        if (showSplit) {
            if (!this.graphicPanel.isShowAtNewFrame()) {
                this.parent.remove((Component)this.kDPanel3);
                this.split.add((Component)this.kDPanel3, (Object)"left");
                this.parent.add((Component)this.split, this.constraints);
                if (this.split.getDividerLocation() == 0) {
                    this.split.setDividerLocation(this.parent.getWidth() / 2);
                } else {
                    this.split.setDividerLocation(this.split.getDividerLocation());
                }
            }
            String title = null;
            if (this.graphicPanel.getMultiPartCount() >= 5) {
                title = this.graphicPanel.getMultiPartComponentTitle(0);
                this.graphicPanel.removeMultiPartComponent(this.graphicPanel.getMultiPartComponent(0));
            }
            if (title == null) {
                title = EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentReadingEditUIResource", (String)"Result") + (this.graphicPanel.getMultiPartCount() + 1);
            }
            String meterName = (String)this.tblMain.getRow(((Integer)checkMeters.get(0)).intValue()).getCell("meter.name").getValue();
            String grapheType = ((GraphicTypeEnum)((Object)this.graphicPanel.getGraphicType().getSelectedItem())).getAlias();
            if (!this.graphicPanel.open(meterName + "_" + grapheType)) {
                this.graphicPanel.addMultiPartComponent(meterName + "_" + grapheType, this.createChart(checkMeters));
            }
        } else {
            this.split.remove((Component)this.kDPanel3);
            this.parent.remove((Component)this.split);
            this.parent.add((Component)this.kDPanel3, this.constraints);
        }
    }

    public JPanel createChart(List checkMeters) {
        CategoryPlot plot;
        JFreeChart chart = null;
        String xRes = EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentReadingEditUIResource", (String)"Date");
        String yRes = EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentReadingEditUIResource", (String)"montorValue");
        if (this.graphicPanel.getGraphicType().getSelectedItem().equals((Object)GraphicTypeEnum.broken)) {
            chart = ChartFactory.createLineChart((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentReadingEditUIResource", (String)"StatusAnalysis"), (String)xRes, (String)yRes, (CategoryDataset)this.contructDataSet(checkMeters), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            plot = (CategoryPlot)chart.getPlot();
            plot.setBackgroundPaint((Paint)Color.lightGray);
            plot.setRangeGridlinePaint((Paint)Color.white);
            plot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
            NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
            DecimalFormat df = new DecimalFormat(PrecisionUtil.getFormatString((int)4));
            rangeAxis.setNumberFormatOverride((NumberFormat)df);
            rangeAxis.setAutoRangeIncludesZero(true);
            LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
            renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator("({0}, {1}) = {2}", (NumberFormat)df));
            renderer.setShapesVisible(true);
            renderer.setShapesFilled(true);
            renderer.setLinesVisible(true);
            float init = 4.0f;
            for (int i = 0; i < checkMeters.size(); ++i) {
                renderer.setSeriesStroke(i, (Stroke)new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{init, 6.0f}, 0.0f));
                init += 4.0f;
            }
            renderer.setItemLabelsVisible(true);
            renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)df));
            renderer.setBaseItemLabelsVisible(true);
        } else if (this.graphicPanel.getGraphicType().getSelectedItem().equals((Object)GraphicTypeEnum.bar)) {
            chart = ChartFactory.createBarChart3D((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentReadingEditUIResource", (String)"StatusAnalysis"), (String)xRes, (String)yRes, (CategoryDataset)this.contructDataSet(checkMeters), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            plot = chart.getCategoryPlot();
            plot.setBackgroundPaint((Paint)Color.white);
            plot.setDomainGridlinePaint((Paint)Color.pink);
            plot.setRangeGridlinePaint((Paint)Color.pink);
            plot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
            BarRenderer3D renderer = new BarRenderer3D();
            DecimalFormat df = new DecimalFormat(PrecisionUtil.getFormatString((int)4));
            renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator("({0}, {1}) = {2}", (NumberFormat)df));
            renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)df));
            renderer.setBaseItemLabelsVisible(true);
            renderer.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_LEFT));
            renderer.setItemLabelAnchorOffset(10.0);
            plot.setRenderer((CategoryItemRenderer)renderer);
        }
        ChartPanel panel = new ChartPanel(chart, false);
        panel.setRangeZoomable(false);
        return panel;
    }

    public DefaultCategoryDataset contructDataSet(List checkMeters) {
        DefaultCategoryDataset dataset = null;
        if (checkMeters != null && checkMeters.size() > 0) {
            int i;
            DefaultCategoryDataset categoryDateSet = new DefaultCategoryDataset();
            ArrayList<Object[]> sortList = new ArrayList<Object[]>();
            for (i = 0; i < checkMeters.size(); ++i) {
                IRow row = this.tblMain.getRow(((Integer)checkMeters.get(i)).intValue());
                String meter = (String)row.getCell("meter.name").getValue();
                for (int j = initColumnCount; j < this.tblMain.getColumnCount(); ++j) {
                    IColumn col = this.tblMain.getColumn(j);
                    Object value = row.getCell(col.getKey()).getValue();
                    if (value == null) continue;
                    Object[] datas = new Object[]{Double.valueOf((String)value), meter, col.getKey()};
                    sortList.add(datas);
                }
            }
            Collections.sort(sortList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Object[] obj1 = (Object[])o1;
                    Object[] obj2 = (Object[])o2;
                    return (obj1[1] + (String)obj1[2]).compareTo(obj2[1] + (String)obj2[2]);
                }
            });
            for (i = 0; i < sortList.size(); ++i) {
                Object[] datas = (Object[])sortList.get(i);
                categoryDateSet.addValue(((Double)datas[0]).doubleValue(), (Comparable)((Object)((String)datas[1])), (Comparable)((Object)((String)datas[2])));
            }
            dataset = categoryDateSet;
        }
        return dataset;
    }

    @Override
    public void actionViewTriggerValue_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewTriggerValue_actionPerformed(e);
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"FROM", (Object)"STATUSANALYSIS");
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.eqm.basedata.client.EquipmentStatusMontorEditUI", (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create("com.kingdee.eas.eqm.basedata.client.EquipmentStatusMontorEditUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void tblMain_tableDataRequest(ActionEvent e) {
        try {
            if (this.manager == null || this.manager.getFilterInfo() == null || this.manager.getFilterInfo().getFilterItems() == null || this.manager.getFilterInfo().getFilterItems().size() <= 0) {
                return;
            }
            IRowSet rs = EquipmentStatusAnalysisFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).analyzeMontorValue((MontorAccuracyTypeEnum)((Object)this.cmbAccurate.getSelectedItem()), this.maxColumn, this.manager.getFilterInfo());
            this.loadDataToTable(rs);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        if (this.tblMain.getRowCount() > 0) {
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                Object obj = row.getCell("meter.meterType").getValue();
                if (!(obj instanceof Integer)) continue;
                row.getCell("meter.meterType").setValue((Object)MeterTypeEnum.getEnum((Integer)obj));
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionQueryMontorValue.setEnabled(true);
        this.actionViewTendencyGraphic.setEnabled(false);
        this.actionViewTriggerValue.setEnabled(false);
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionView.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionAudit.setVisible(false);
        this.actionUnAudit.setVisible(false);
        this.actionLocate.setVisible(false);
        this.actionRefresh.setVisible(false);
        this.actionQuery.setVisible(false);
        this.menuEdit.setVisible(false);
        this.menuView.setVisible(false);
        this.menuBiz.setVisible(false);
    }

    public void clear() {
        this.manager.clearAll();
    }

    protected String getOnloadPermItemName() {
        return "eqm_equipmentstatusanalysis01view";
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

