/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.framework.batch.IBatchExecuteResult;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.attachment.util.UICreator;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.eqm.archives.EquipmentArchivesFactory;
import com.kingdee.eas.eqm.basedata.EquipmentLocationFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStatusMontorFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStatusMontorInfo;
import com.kingdee.eas.eqm.basedata.client.AbstractEquipmentStatusMontorListUI;
import com.kingdee.eas.eqm.basedata.client.EquipmentStatusMontorFilterUI;
import com.kingdee.eas.eqm.common.core.client.GeneBillBaseFilterUI;
import com.kingdee.eas.eqm.common.core.client.action.LongTimeAction;
import com.kingdee.eas.eqm.common.core.util.GeneMenuUtils;
import com.kingdee.eas.eqm.common.core.util.KDTableUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EquipmentStatusMontorListUI
extends AbstractEquipmentStatusMontorListUI {
    private static final Logger logger = CoreUIObject.getLogger(EquipmentStatusMontorListUI.class);
    private static final String RESOURCE = "com.kingdee.eas.eqm.basedata.EquipmentStatusMontorResource";

    public boolean isBizUnitOnly() {
        return true;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"equipment.number", "location.number", "equipment.name", "location.name"};
        return locateNames;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("storageOrgUnit.name").setGroup(true);
        this.tblMain.getColumn("storageOrgUnit.name").setMergeable(true);
        return filter;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return EquipmentStatusMontorFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        EquipmentStatusMontorInfo objectValue = new EquipmentStatusMontorInfo();
        return objectValue;
    }

    protected EntityViewInfo buildEntityViewInfo(EntityViewInfo viewInfo) {
        EntityViewInfo view = super.buildEntityViewInfo(viewInfo);
        SorterItemCollection sorts = new SorterItemCollection();
        sorts.add(new SorterItemInfo("storageOrgUnit.name"));
        sorts.add(new SorterItemInfo("equipment.number"));
        sorts.add(new SorterItemInfo("location.number"));
        view.setSorter(sorts);
        return view;
    }

    public String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected GeneBillBaseFilterUI newInstanceFilterUI() throws Exception {
        EquipmentStatusMontorFilterUI filterUI = new EquipmentStatusMontorFilterUI();
        return filterUI;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.setVisible(false);
        this.actionAudit.setEnabled(false);
        this.actionUnAudit.setVisible(false);
        this.actionUnAudit.setEnabled(false);
        this.actionImportData.setVisible(false);
        this.actionImportData.setEnabled(false);
        this.actionExportData.setVisible(false);
        this.actionExportData.setEnabled(false);
        GeneMenuUtils.hideMenu((KDMenuBar)this.menuBar);
        this.actionInputReading.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_readin"));
    }

    @Override
    public void actionInputReading_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(selectRows[0]);
        String equipmentid = (String)row.getCell("equipment.id").getValue();
        String locationid = (String)row.getCell("location.id").getValue();
        UIContext uictx = new UIContext((Object)this);
        uictx.put((Object)"ENTITYTYPE", (Object)(locationid != null ? new Integer(2) : new Integer(1)));
        uictx.put((Object)"ISMONTOR", (Object)Boolean.TRUE);
        Object value = null;
        if (equipmentid != null) {
            value = EquipmentArchivesFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext()).getEquipmentArchivesInfo((IObjectPK)new ObjectUuidPK(equipmentid));
        } else if (locationid != null) {
            value = EquipmentLocationFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).getEquipmentLocationInfo((IObjectPK)new ObjectUuidPK(locationid));
        }
        if (value == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.client.EquipmentReadingEditUIResource", (String)"MSG_EQUIPMENTLOCATIONCANNOTNULL"));
            SysUtil.abort();
        } else {
            uictx.put((Object)"ENTITYVALUE", value);
            uictx.put((Object)"CURRENTORGVALUE", (Object)this.getMainOrgInfo());
            String uimode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
            UICreator.create((String)"com.kingdee.eas.eqm.basedata.client.EquipmentReadingEditUI", (String)uimode, (UIContext)uictx);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        LongTimeAction audited = new LongTimeAction(){
            List ids = new ArrayList();
            Map mapNumber = new ListUiHelper().getSelectColumnValue(EquipmentStatusMontorListUI.access$000(EquipmentStatusMontorListUI.this), "id", EquipmentStatusMontorListUI.access$100(EquipmentStatusMontorListUI.this));

            protected void afterDoIt(CoreUI ui, ItemAction action, Object value) throws Exception {
                BatchExecuteResult rst = (BatchExecuteResult)value;
                EquipmentStatusMontorListUI.this.handleBatchExcuteResult(ui, EquipmentStatusMontorListUI.this.tblMain, action, this.ids, rst, this.mapNumber);
            }

            protected void beforeDoIt(CoreUI ui, ItemAction e) throws Exception {
                EquipmentStatusMontorListUI.this.checkSelected();
                EquipmentStatusMontorListUI.this.checkPermission("ACTION_DELETE", EquipmentStatusMontorListUI.this.getCUIDFromBizobject(true));
                if (!EquipmentStatusMontorListUI.this.confirmRemove()) {
                    EquipmentStatusMontorListUI.this.abort();
                }
            }

            protected Object actionDoIt(CoreUI ui, ItemAction e) throws Exception {
                this.ids = EquipmentStatusMontorListUI.this.getSelectedIdValues();
                Class[] parameTypes = new Class[]{IObjectPK.class};
                BatchExecuteParamsEntry[] paramEntries = EquipmentStatusMontorListUI.this.prepareParams(this.ids, parameTypes);
                return EquipmentStatusMontorListUI.this.getBizInterface().batchExecute("delete", parameTypes, paramEntries);
            }
        };
        audited.doIt((CoreUI)this, (ItemAction)this.actionRemove);
    }

    private void handleBatchExcuteResult(CoreUI ui, KDTable tblMain, ItemAction e, List ids, BatchExecuteResult rst, Map mapNumber) {
        int size = ids.size();
        int[] rowIndexs = KDTableUtils.getSelectedRows((KDTable)tblMain);
        ArrayList<String> errorMsg = new ArrayList<String>();
        for (int i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            Throwable exp = rst.getException(i);
            if (rst.getBatchResult() != null && rst.getBatchResult() instanceof IBatchExecuteResult && exp == null) {
                exp = ((BatchExecuteResult)rst.getBatchResult()).getException(i);
            }
            int rowIndex = rowIndexs[i] + 1;
            if (exp == null) continue;
            String msg = ExceptionMessageUtility.getMessage((Throwable)exp);
            if (ids.size() == 1) {
                errorMsg.add(msg);
                continue;
            }
            String msgs = EASResource.getString((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"96_EquipmentStatusMontorListUI");
            MessageFormat mf = new MessageFormat(msgs);
            String result = mf.format(new String[]{"" + rowIndex, msg});
            errorMsg.add(result);
        }
        if (errorMsg.size() == 0) {
            EquipmentStatusMontorListUI.showSuccessMessage(ui, e, ids.size());
        } else if (errorMsg.size() == 1 && size == 1) {
            StringBuffer errorDetail = new StringBuffer();
            for (int i = 0; i < errorMsg.size(); ++i) {
                errorDetail.append(errorMsg.get(i));
                errorDetail.append("\n");
            }
            MsgBox.showWarning((Component)ui, (String)errorDetail.toString());
        } else {
            String resPath = "com.kingdee.eas.eqm.common.core.GeneResource";
            String msg = MessageFormat.format(EASResource.getString((String)resPath, (String)"errorTitle"), e.getValue("Name"), new Integer(size - errorMsg.size()), new Integer(errorMsg.size()));
            StringBuffer errorDetail = new StringBuffer();
            for (int i = 0; i < errorMsg.size(); ++i) {
                errorDetail.append(errorMsg.get(i));
                errorDetail.append("\n");
            }
            MsgBox.showDetailAndOK((Component)ui, (String)msg, (String)errorDetail.toString(), (int)2);
        }
        if (size - errorMsg.size() > 0 && tblMain.getSelectManager().get(0) != null) {
            int top = tblMain.getSelectManager().get(0).getTop();
            if (ui instanceof ListUI) {
                ListUI listui = (ListUI)ui;
                CacheServiceFactory.getInstance().discardQuery(listui.getMainQueryPK());
                try {
                    tblMain.refresh();
                }
                catch (Exception e1) {
                    listui.handUIException((Throwable)e1);
                }
            }
            tblMain.getSelectManager().select(top, -1);
        }
    }

    public static void showSuccessMessage(CoreUI ui, ItemAction action, int successCounts) {
        String resPath = "com.kingdee.eas.eqm.common.core.GeneResource";
        String msg = MessageFormat.format(EASResource.getString((String)resPath, (String)"successCounts"), action.getValue("Name"), new Integer(successCounts));
        ui.setMessageText(msg);
        ui.showMessage();
    }

    static /* synthetic */ KDTable access$000(EquipmentStatusMontorListUI x0) {
        return x0.tblMain;
    }

    static /* synthetic */ String access$100(EquipmentStatusMontorListUI x0) {
        return x0.getLable();
    }
}

