/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client.staopr;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprAssetRestrictInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationInfo;
import com.kingdee.eas.eqm.basedata.client.staopr.AbstractRestrictEntryPanel;
import com.kingdee.eas.eqm.basedata.client.staopr.StandardOperationUtils;
import com.kingdee.eas.eqm.common.core.verify.AbstractVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class AssetRestrictEntryPanel
extends AbstractRestrictEntryPanel {
    @Override
    protected IObjectValue createNewData(boolean maxOrderNumber) {
        EquipmentStaOprAssetRestrictInfo restrictInfo = new EquipmentStaOprAssetRestrictInfo();
        restrictInfo.setValid(true);
        if (this.parent.getAssetTable().getSelectManager().get() == null || this.parent.getAssetTable().getSelectManager().get().getBeginRow() < 0 || this.parent.getAssetTable().getSelectManager().get().getBeginRow() >= this.parent.getAssetTable().getRowCount()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource.mustSelectAsset"));
            SysUtil.abort();
        }
        return restrictInfo;
    }

    @Override
    public void initListener() {
        super.initListener();
        this.table.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                try {
                    AssetRestrictEntryPanel.this.entryTable_activeCellChanged(e);
                }
                catch (Exception exc) {
                    AssetRestrictEntryPanel.this.parent.handUIException(exc);
                }
            }
        });
    }

    protected void entryTable_activeCellChanged(KDTActiveCellEvent e) {
        if (e.getRowIndex() == -1) {
            return;
        }
        if (!this.parent.getOprtState().equals(OprtState.VIEW)) {
            IRow row = this.table.getRow(e.getRowIndex());
            if (e.getColumnIndex() == this.table.getColumnIndex("valid")) {
                Boolean oldValue = (Boolean)row.getCell("valid").getValue();
                row.getCell("valid").setValue((Object)new Boolean(oldValue == false));
            }
        }
    }

    @Override
    protected void afterInitLayout() {
        this.detailPanel.setTitle(EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource.assetRestrict"));
        StandardOperationUtils.setEntryTitleStyle(this.detailPanel, 2);
    }

    @Override
    protected void verifyInput(ActionEvent e) throws Exception {
        this.parent.getVerifyManager().addVerifyItem((IVerifyItem)new AbstractVerifyItem(){

            public boolean verify() throws EASBizException, BOSException {
                int index;
                List assetRestrictsList = AssetRestrictEntryPanel.this.getRestricts();
                if (!"ADDNEW".equals(AssetRestrictEntryPanel.this.parent.getOprtState()) && (index = assetRestrictsList.indexOf(AssetRestrictEntryPanel.this.parent.getEditData().getNumber())) > 0) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource.cannotIncludeCurrentSO"));
                    AssetRestrictEntryPanel.this.parent.selectCell(AssetRestrictEntryPanel.this.table, "standardOperation", index);
                    SysUtil.abort();
                }
                Object dupAssetRestrict = StandardOperationUtils.findFirstDupElement(assetRestrictsList);
                int rowIndex = assetRestrictsList.indexOf(dupAssetRestrict);
                if (dupAssetRestrict != null) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource.cannotIncludeDulpSO");
                    msg = MessageFormat.format(msg, dupAssetRestrict);
                    MsgBox.showWarning((String)msg);
                    AssetRestrictEntryPanel.this.parent.selectCell(AssetRestrictEntryPanel.this.table, "standardOperation", rowIndex);
                    SysUtil.abort();
                }
                return true;
            }
        });
    }

    private List getRestricts() {
        ArrayList<String> assetRestrictsList = new ArrayList<String>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            IRow currentRow = this.table.getRow(i);
            assetRestrictsList.add(((EquipmentStandardOperationInfo)currentRow.getCell("standardOperation").getValue()).getNumber());
        }
        return assetRestrictsList;
    }
}

