/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client.staopr;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprMaterialInfo;
import com.kingdee.eas.eqm.basedata.client.staopr.AbstractMaterialEntryPanel;
import com.kingdee.eas.eqm.basedata.client.staopr.IColumnPromptViewInfoModifer;
import com.kingdee.eas.eqm.basedata.client.staopr.StandardOperationUtils;
import com.kingdee.eas.eqm.common.core.util.GeneResourceUtil;
import com.kingdee.eas.eqm.common.core.util.GeneSelectorUtils;
import com.kingdee.eas.eqm.common.core.util.KDTableUtils;
import com.kingdee.eas.eqm.common.eqmcore.EqmMaterialFacadeFactory;
import com.kingdee.eas.eqm.common.eqmcore.IEqmMaterialFacade;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;

public class MaterialEntryPanel
extends AbstractMaterialEntryPanel {
    protected static final String RESOURCE_PATH = "com.kingdee.eas.eqm.maintain.WorkOrderResource";

    @Override
    protected IObjectValue createNewData(boolean maxOrderNumber) {
        EquipmentStaOprMaterialInfo materialInfo = new EquipmentStaOprMaterialInfo();
        materialInfo.setAmount(new BigDecimal("0"));
        materialInfo.setUnitPrice(new BigDecimal("0.00"));
        materialInfo.setLineCost(new BigDecimal("0.00"));
        if (this.getPlanOrgUnit() != null) {
            materialInfo.setCurrency(this.getCurrencyInfo((OrgUnitInfo)this.getPlanOrgUnit()));
        }
        return materialInfo;
    }

    @Override
    public void initListener() {
        super.initListener();
        this.table.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                try {
                    MaterialEntryPanel.this.entryTable_activeCellChanged(e);
                }
                catch (Exception exc) {
                    MaterialEntryPanel.this.parent.handUIException(exc);
                }
            }
        });
        this.table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    MaterialEntryPanel.this.planMaterialEntry_editStarting(e);
                }
                catch (Exception exc) {
                    MaterialEntryPanel.this.parent.handUIException(exc);
                }
            }
        });
    }

    protected void planMaterialEntry_editStarting(KDTEditEvent e) throws Exception {
        ICell cell;
        int rowIndex = e.getRowIndex();
        if (!(e.getColIndex() != this.table.getColumnIndex("storageOrgUnit") && e.getColIndex() != this.table.getColumnIndex("measureUnit") || null != (cell = this.table.getCell(rowIndex, "materail")) && null != cell.getValue())) {
            MsgBox.showInfo((Component)((Object)this.parent), (String)GeneResourceUtil.getMsg((String)RESOURCE_PATH, (String)"MATERIAL_FIRST", null));
            e.setCancel(true);
            this.table.getEditManager().editCellAt(rowIndex, this.table.getColumnIndex("materail"));
            SysUtil.abort();
        }
    }

    protected void entryTable_activeCellChanged(KDTActiveCellEvent e) {
        if (!this.parent.getOprtState().equals(OprtState.VIEW)) {
            IRow row = this.table.getRow(e.getRowIndex());
            if (e.getColumnIndex() == this.table.getColumnIndex("maintainable") && row != null) {
                Boolean oldValue = (Boolean)row.getCell("maintainable").getValue();
                row.getCell("maintainable").setValue((Object)new Boolean(oldValue == false));
            }
        }
    }

    @Override
    protected void afterInitLayout() {
        KDTableUtils.setEntryTitleVisible((DetailPanel)this.detailPanel, (boolean)false);
    }

    @Override
    public void afterMainOrgChanged(String oldOrgId, String newOrgId) {
        super.afterMainOrgChanged(oldOrgId, newOrgId);
        try {
            EQMPromptDialogFactory.createPrmptList((KDTable)this.table, (String)"materail", (String)"com.kingdee.eas.eqm.archives.app.F7MaterialQuery", (EntityViewInfo)this.getMaterialFilterInfo(), (String)"$number$", (String)"$number$");
            KDTDefaultCellEditor partMaterialCell = (KDTDefaultCellEditor)this.table.getColumn("materail").getEditor();
            KDBizPromptBox partMaterial = (KDBizPromptBox)partMaterialCell.getComponent();
            partMaterial.setCurrentMainBizOrgUnit(this.getCurrentOrgInfo(), OrgType.Storage);
        }
        catch (BOSException e) {
            this.parent.handUIException(e);
        }
    }

    private EntityViewInfo getMaterialFilterInfo() throws BOSException {
        EntityViewInfo entityViewInfo1 = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.addObjectCollection((IObjectCollection)GeneSelectorUtils.getSelector((BOSObjectType)new MaterialInfo().getBOSType(), (String)"", (boolean)false, (boolean)true, (boolean)true));
        sic.add(new SelectorItemInfo("baseUnit.qtyPrecision"));
        entityViewInfo1.setSelector(sic);
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("equipProperty", (Object)new Integer(2), CompareType.NOTEQUALS));
        filter1.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
        filter1.mergeFilter(this.getBaseFilterInfo("4409E7F0"), "and");
        entityViewInfo1.setFilter(filter1);
        return entityViewInfo1;
    }

    @Override
    protected void bindColumn() {
    }

    @Override
    protected void bindCell() {
        super.bindCell();
    }

    @Override
    protected void setColumnFormater() {
        super.setColumnFormater();
    }

    @Override
    protected void initColumnPropertyChangeProcessor() {
        this.registerColumnPropertyChangeProcessor(this.getMaterialUnitPriceColumnName(), "caculateLineCost");
        this.registerColumnPropertyChangeProcessor("amount", "caculateLineCost");
    }

    @Override
    public void materailChanged(KDTPropertyChangeEvent e) {
        super.materailChanged(e);
    }

    @Override
    public void caculateLineCost(KDTPropertyChangeEvent e) {
        IRow row = this.table.getRow(e.getRowIndex());
        if (row.getCell("amount").getValue() != null && row.getCell(this.getMaterialUnitPriceColumnName()).getValue() != null) {
            BigDecimal price;
            BigDecimal amount = (BigDecimal)row.getCell("amount").getValue();
            BigDecimal result = amount.multiply(price = (BigDecimal)row.getCell(this.getMaterialUnitPriceColumnName()).getValue());
            if (result.longValue() > 999999999999L) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource", (String)"101_MaterialEntryPanel"));
            }
            CurrencyInfo currency = (CurrencyInfo)row.getCell("currency").getValue();
            int precision = 2;
            if (currency != null) {
                precision = currency.getPrecision();
            }
            row.getCell("lineCost").setValue((Object)StandardOperationUtils.formatMoney(result, precision));
        } else {
            row.getCell("lineCost").setValue(null);
        }
    }

    @Override
    protected void initStandardPrice(IRow row, StorageOrgUnitInfo storageOrgUnitInfo, MaterialInfo materialInfo) {
        BigDecimal standardCost = new BigDecimal("0");
        if (storageOrgUnitInfo == null || materialInfo == null) {
            row.getCell("unitPrice").setValue((Object)standardCost);
            return;
        }
        try {
            IEqmMaterialFacade facade = EqmMaterialFacadeFactory.getRemoteInstance();
            standardCost = facade.getStandardCost(materialInfo.getId().toString(), storageOrgUnitInfo.getId().toString());
            row.getCell("unitPrice").setValue((Object)standardCost);
        }
        catch (Exception e1) {
            this.parent.handUIException(e1);
        }
    }

    @Override
    protected void clearUnitPriceAndLineCost(IRow row) {
        row.getCell(this.getMaterialUnitPriceColumnName()).setValue(null);
        row.getCell("lineCost").setValue(null);
    }

    @Override
    protected String getMaterialColumnName() {
        return "materail";
    }

    @Override
    protected String getMaterialNameColumnName() {
        return "materailName";
    }

    @Override
    protected String getMaterialModelColumnName() {
        return "materailModel";
    }

    @Override
    protected String getMaterialUnitPriceColumnName() {
        return "unitPrice";
    }

    @Override
    public void beforeSubmit() {
        this.setDefaultValueOfMaterialsTable();
    }

    private void setDefaultValueOfMaterialsTable() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            IRow row = this.table.getRow(i);
            this.setAmountNullCellValue(row);
            if (row.getCell("unitPrice").getValue() != null) continue;
            row.getCell("unitPrice").setValue((Object)new BigDecimal("0.00"));
        }
    }

    private final class MaterialViewInfoModifer
    implements IColumnPromptViewInfoModifer {
        private MaterialViewInfoModifer() {
        }

        @Override
        public void modify(KDTable table, String columnName, EntityViewInfo viewInfo) {
            if (MaterialEntryPanel.this.getPlanOrgUnit() != null) {
                KDBizPromptBox materialF7 = (KDBizPromptBox)table.getColumn("materail").getEditor().getComponent();
                materialF7.setCurrentMainBizOrgUnit((OrgUnitInfo)MaterialEntryPanel.this.getPlanOrgUnit(), OrgType.Storage);
                FilterItemInfo item = new FilterItemInfo("id", (Object)("SELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE FBOSObjectType = '4409E7F0' AND FAssignCUID = '" + MaterialEntryPanel.this.getCUId() + "')"), CompareType.INNER);
                viewInfo.getFilter().getFilterItems().add(item);
                item = new FilterItemInfo("equipProperty", (Object)Integer.valueOf("2"), CompareType.NOTEQUALS);
                viewInfo.getFilter().getFilterItems().add(item);
            }
        }
    }
}

