/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client.staopr;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprServiceInfo;
import com.kingdee.eas.eqm.basedata.client.staopr.AbstractTaskRelatedEntryPanel;
import com.kingdee.eas.eqm.basedata.client.staopr.StandardOperationUtils;
import com.kingdee.eas.eqm.common.core.util.KDTableUtils;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;

public class ServiceEntryPanel
extends AbstractTaskRelatedEntryPanel {
    @Override
    public void add(ActionEvent e) {
        if (this.table == null) {
            return;
        }
        IObjectValue detailData = this.createNewData(true);
        IRow row = this.table.addRow();
        this.parent.getUILifeCycleHandler().fireOnAddNewLine((Object)this.table, detailData);
        this.parent.getDataBinder().loadLineFields(this.table, row, detailData);
        this.bindCell();
        if (detailData.get("currency") == null) {
            StandardOperationUtils.setRowNumberEditor(2, this.table, row.getRowIndex(), new String[]{"lineCost"}, StandardOperationUtils.BigDecimal_MaxValue, StandardOperationUtils.BigDecimal_Zero, true);
        }
    }

    @Override
    public void insert(ActionEvent e) {
        if (this.table == null) {
            return;
        }
        IObjectValue detailData = this.createNewData(false);
        IRow row = null;
        if (this.table.getSelectManager().size() > 0) {
            int top = this.table.getSelectManager().get().getTop();
            row = this.parent.isTableSelected(this.table) ? this.table.addRow() : this.table.addRow(top);
        } else {
            row = this.table.addRow();
        }
        this.parent.getUILifeCycleHandler().fireOnAddNewLine((Object)this.table, detailData);
        this.parent.getDataBinder().loadLineFields(this.table, row, detailData);
        this.bindCell();
        if (detailData.get("currency") == null) {
            StandardOperationUtils.setRowNumberEditor(2, this.table, row.getRowIndex(), new String[]{"lineCost"}, StandardOperationUtils.BigDecimal_MaxValue, StandardOperationUtils.BigDecimal_Zero, true);
        }
    }

    @Override
    protected IObjectValue createNewData(boolean maxOrderNumber) {
        EquipmentStaOprServiceInfo serviceInfo = new EquipmentStaOprServiceInfo();
        serviceInfo.setLineCost(new BigDecimal("0.00"));
        if (this.getPlanOrgUnit() != null) {
            serviceInfo.setCurrency(this.getCurrencyInfo((OrgUnitInfo)this.getPlanOrgUnit()));
        }
        return serviceInfo;
    }

    @Override
    protected void afterInitLayout() {
        KDTableUtils.setEntryTitleVisible((DetailPanel)this.detailPanel, (boolean)false);
    }

    @Override
    protected void setColumnFormater() {
        super.setColumnFormater();
    }

    @Override
    protected void bindColumn() {
        super.bindColumn();
        try {
            EQMPromptDialogFactory.createPrmptOrgDialog((KDTable)this.table, (String)"purchaseOrgUnit", (String)"com.kingdee.eas.basedata.org.app.PurchaseOrgUnitQuery", (OrgType)OrgType.Storage, (OrgType)OrgType.Purchase, (OrgUnitInfo)this.parent.getMainOrgInfo());
        }
        catch (Exception e) {
            this.parent.handUIException(e);
        }
    }

    @Override
    public void afterMainOrgChanged(String oldOrgId, String newOrgId) {
        super.afterMainOrgChanged(oldOrgId, newOrgId);
        try {
            EQMPromptDialogFactory.createPrmptOrgDialog((KDTable)this.table, (String)"purchaseOrgUnit", (String)"com.kingdee.eas.basedata.org.app.PurchaseOrgUnitQuery", (OrgType)OrgType.Storage, (OrgType)OrgType.Purchase, (OrgUnitInfo)this.parent.getMainOrgInfo());
        }
        catch (Exception e) {
            this.parent.handUIException(e);
        }
    }

    @Override
    protected void bindCell() {
        for (int rowIndex = 0; rowIndex < this.table.getRowCount(); ++rowIndex) {
            PurchaseOrgUnitInfo purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)this.table.getCell(rowIndex, "purchaseOrgUnit").getValue();
            if (purchaseOrgUnitInfo != null) {
                try {
                    EQMPromptDialogFactory.createPrmptList((KDTable)this.table, (String)"supplier", (String)"com.kingdee.eas.basedata.master.cssp.app.F7SupplierPurchasingQueryWithDefaultStandard", (String[])new String[]{"purChaseOrgUnit.id", "usedStatus"}, (Object[])new Object[]{purchaseOrgUnitInfo.getId().toString(), String.valueOf(UsedStatusEnum.APPROVED.getValue())}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.EQUALS});
                }
                catch (BOSException e1) {
                    this.parent.handUIException(e1);
                }
                continue;
            }
            this.table.getCell(rowIndex, "supplier").setValue(null);
        }
    }

    @Override
    public void beforeSubmit() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            IRow row = this.table.getRow(i);
            if (row.getCell("lineCost").getValue() != null) continue;
            row.getCell("lineCost").setValue((Object)new BigDecimal("0.00"));
        }
    }

    @Override
    protected void tableEditStarting(KDTEditEvent e) {
        if (e.getColIndex() == this.table.getColumnIndex("supplier") && this.table.getRow(e.getRowIndex()).getCell("purchaseOrgUnit").getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource.mustSelectPurchaseAtFirst"));
            e.setCancel(true);
        }
    }

    public void purchaseOrgUnitChanged(KDTPropertyChangeEvent e) {
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)this.table.getCell(e.getRowIndex(), "purchaseOrgUnit").getValue();
        BigDecimal result = (BigDecimal)this.table.getCell(e.getRowIndex(), "lineCost").getValue();
        CurrencyInfo currencyInfo = null;
        int precision = 2;
        if (purchaseOrgUnitInfo != null) {
            try {
                EQMPromptDialogFactory.createPrmptList((KDTable)this.table, (int)this.table.getColumnIndex("supplier"), (int)e.getRowIndex(), (String)"com.kingdee.eas.basedata.master.cssp.app.F7SupplierPurchasingQueryWithDefaultStandard", (String[])new String[]{"purChaseOrgUnit.id", "usedStatus"}, (Object[])new Object[]{purchaseOrgUnitInfo.getId().toString(), String.valueOf(UsedStatusEnum.APPROVED.getValue())}, (CompareType[])new CompareType[]{CompareType.EQUALS, CompareType.EQUALS});
                currencyInfo = this.getCurrencyInfo((OrgUnitInfo)purchaseOrgUnitInfo);
            }
            catch (BOSException e1) {
                this.parent.handUIException(e1);
            }
        } else {
            this.table.getCell(e.getRowIndex(), "supplier").setValue(null);
            currencyInfo = this.getCurrencyInfo((OrgUnitInfo)this.getPlanOrgUnit());
        }
        if (currencyInfo != null) {
            this.table.getCell(e.getRowIndex(), "currency").setValue((Object)currencyInfo);
            precision = currencyInfo.getPrecision();
            this.table.getCell(e.getRowIndex(), "lineCost").setValue((Object)StandardOperationUtils.formatMoney(result, precision));
        } else {
            currencyInfo = this.getCurrencyInfo((OrgUnitInfo)this.getPlanOrgUnit());
            this.table.getCell(e.getRowIndex(), "currency").setValue((Object)currencyInfo);
            if (currencyInfo != null) {
                precision = currencyInfo.getPrecision();
                this.table.getCell(e.getRowIndex(), "lineCost").setValue((Object)StandardOperationUtils.formatMoney(result, precision));
            }
        }
    }
}

