/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.client.staopr;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprTaskInfo;
import com.kingdee.eas.eqm.basedata.client.staopr.AbstractEntryPanel;
import com.kingdee.eas.eqm.basedata.client.staopr.StandardOperationUtils;
import com.kingdee.eas.eqm.common.core.util.KDTableUtils;
import com.kingdee.eas.eqm.common.core.verify.AbstractVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class TaskEntryPanel
extends AbstractEntryPanel {
    private static final String resourceDir = "com.kingdee.eas.eqm.basedata.BASEDATAAutoGenerateResource";

    @Override
    protected IObjectValue createNewData(boolean maxOrderNumber) {
        EquipmentStaOprTaskInfo taskInfo = new EquipmentStaOprTaskInfo();
        int orderNum = StandardOperationUtils.caculateInsertTaskOrderNumber(this.table, "orderNumber", maxOrderNumber);
        taskInfo.setTaskNumber(orderNum + "");
        taskInfo.setOrderNumber(orderNum);
        taskInfo.setDuration(new BigDecimal("0.00"));
        return taskInfo;
    }

    @Override
    public void remove(ActionEvent e) {
        if (this.table == null) {
            return;
        }
        if (this.table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this.parent), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        List materailTaskNums = this.parent.getTaskNumberList(this.parent.materialEntryPanel.getTable());
        List toolTaskNums = this.parent.getTaskNumberList(this.parent.toolEntryPanel.getTable());
        List serviceTaskNums = this.parent.getTaskNumberList(this.parent.serviceEntryPanel.getTable());
        List personTaskNums = this.parent.getTaskNumberList(this.parent.personEntryPanel.getTable());
        if (this.table.getSelectManager().get().getTop() != -1) {
            for (int blockIndex = 0; blockIndex < this.table.getSelectManager().size(); ++blockIndex) {
                int beginRowIndex = this.table.getSelectManager().get(blockIndex).getBeginRow();
                int endRowIndex = this.table.getSelectManager().get(blockIndex).getEndRow();
                for (int i = beginRowIndex; i <= endRowIndex; ++i) {
                    MessageFormat mf;
                    String msg;
                    Object currentNum = this.table.getRow(i).getCell("taskNumber").getValue();
                    if (currentNum == null) continue;
                    if (personTaskNums.contains(currentNum)) {
                        msg = EASResource.getString((String)resourceDir, (String)"106_TaskEntryPanel");
                        mf = new MessageFormat(msg);
                        MsgBox.showWarning((String)mf.format(new String[]{"" + currentNum}));
                        SysUtil.abort();
                    }
                    if (materailTaskNums.contains(currentNum)) {
                        msg = EASResource.getString((String)resourceDir, (String)"107_TaskEntryPanel");
                        mf = new MessageFormat(msg);
                        MsgBox.showWarning((String)mf.format(new String[]{"" + currentNum}));
                        SysUtil.abort();
                    }
                    if (toolTaskNums.contains(currentNum)) {
                        msg = EASResource.getString((String)resourceDir, (String)"108_TaskEntryPanel");
                        mf = new MessageFormat(msg);
                        MsgBox.showWarning((String)mf.format(new String[]{"" + currentNum}));
                        SysUtil.abort();
                    }
                    if (!serviceTaskNums.contains(currentNum)) continue;
                    msg = EASResource.getString((String)resourceDir, (String)"109_TaskEntryPanel");
                    mf = new MessageFormat(msg);
                    MsgBox.showWarning((String)mf.format(new String[]{"" + currentNum}));
                    SysUtil.abort();
                }
            }
        }
        super.remove(e);
    }

    @Override
    protected void afterInitLayout() {
        KDTableUtils.setEntryTitleVisible((DetailPanel)this.detailPanel, (boolean)false);
    }

    @Override
    protected void setColumnFormater() {
        StandardOperationUtils.setColRemarkFormat(this.table, "description");
        StandardOperationUtils.setColRemarkFormat(this.table, "demand");
        StandardOperationUtils.setColHoursFormat(this.table, "duration");
    }

    public void taskNumberChanged(KDTPropertyChangeEvent e) {
        if (e.getOldValue() != null && e.getNewValue() != null) {
            this.parent.refreshTaskNumber(e.getOldValue().toString(), e.getNewValue().toString());
        }
    }

    @Override
    public void afterLoadData() {
        super.afterLoadData();
    }

    @Override
    protected void verifyInput(ActionEvent e) throws Exception {
        this.parent.getVerifyManager().addVerifyItem((IVerifyItem)new NotDupTaskNumberVerifyItem());
    }

    private final class NotDupOrderNumberVerifyItem
    extends AbstractVerifyItem {
        private NotDupOrderNumberVerifyItem() {
        }

        public boolean verify() throws EASBizException, BOSException {
            ArrayList<Integer> tasks = new ArrayList<Integer>();
            for (int i = 0; i < TaskEntryPanel.this.table.getRowCount(); ++i) {
                tasks.add((Integer)TaskEntryPanel.this.table.getRow(i).getCell("orderNumber").getValue());
            }
            Object dup = StandardOperationUtils.findFirstDupElement(tasks);
            if (dup != null) {
                String msg = EASResource.getString((String)TaskEntryPanel.resourceDir, (String)"104_TaskEntryPanel");
                MessageFormat mf = new MessageFormat(msg);
                String result = mf.format(new String[]{"" + dup});
                MsgBox.showWarning((String)result);
                TaskEntryPanel.this.parent.selectCell(TaskEntryPanel.this.table, "orderNumber", tasks.indexOf(dup));
                SysUtil.abort();
            }
            return true;
        }
    }

    private final class NotDupTaskNumberVerifyItem
    extends AbstractVerifyItem {
        private NotDupTaskNumberVerifyItem() {
        }

        public boolean verify() throws EASBizException, BOSException {
            ArrayList<String> tasks = new ArrayList<String>();
            for (int i = 0; i < TaskEntryPanel.this.table.getRowCount(); ++i) {
                tasks.add(((String)TaskEntryPanel.this.table.getRow(i).getCell("taskNumber").getValue()).trim());
            }
            Object dup = StandardOperationUtils.findFirstDupElement(tasks);
            if (dup != null) {
                String msg = EASResource.getString((String)TaskEntryPanel.resourceDir, (String)"103_TaskEntryPanel");
                MessageFormat mf = new MessageFormat(msg);
                String result = mf.format(new String[]{"" + dup});
                MsgBox.showWarning((String)result);
                TaskEntryPanel.this.parent.selectCell(TaskEntryPanel.this.table, "taskNumber", tasks.indexOf(dup));
                SysUtil.abort();
            }
            return true;
        }
    }
}

