/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainCraftsCollection;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainCraftsFactory;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainCraftsInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainCraftsItemCollection;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainCraftsItemFactory;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainGroupCollection;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainGroupFactory;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainGroupTreeCollection;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainGroupTreeFactory;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainGroupTreeInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainStaffCollection;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainStaffFactory;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainStaffInfo;
import com.kingdee.eas.eqm.basedata.EquipmentSkillLevelCollection;
import com.kingdee.eas.eqm.basedata.EquipmentSkillLevelFactory;
import com.kingdee.eas.eqm.basedata.EquipmentSkillLevelInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprPersonFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprPersonInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationInfo;
import com.kingdee.eas.eqm.basedata.datatask.DataImportEqmStaOprTools;
import com.kingdee.eas.eqm.common.datatask.EQMBaseDataTransmission;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;

public class DataImportEqmStaOprPerson
extends EQMBaseDataTransmission {
    private static final int HOURS_PRECISION = 2;
    private static final int RATE_PRECISION = 2;
    private static final int DESCRIPTION_MAX_SIZE = 255;
    private DataImportEqmStaOprTools staOprTools = new DataImportEqmStaOprTools();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EquipmentStaOprPersonFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Hashtable baseData = (Hashtable)hsData.get(new Integer(0));
        EquipmentStaOprPersonInfo excelInfo = new EquipmentStaOprPersonInfo();
        StorageOrgUnitInfo orgInfo = this.staOprTools.getMainStorageOrgUnit(ctx, this.getDataString(baseData, "FParent_storageOrgUnit_number"), this.cache_storageInfo, this._cacheAuthorizedOrgUnits);
        EquipmentStandardOperationInfo staOprInfo = this.staOprTools.getStaOpr(ctx, orgInfo, this.getDataString(baseData, "FParent_number"));
        excelInfo.setStandardOperation(staOprInfo);
        this.staOprTools.virifyEntryTaskNumber(ctx, this.getDataString(baseData, "FTaskNumber"), staOprInfo);
        if (DataImportEqmStaOprTools.isExcelCellValueNull(this.getDataString(baseData, "FTaskNumber"))) {
            excelInfo.setTaskNumber(null);
        } else {
            excelInfo.setTaskNumber(this.getDataString(baseData, "FTaskNumber"));
        }
        EquipmentMaintainCraftsInfo craft = this.getCrafts(ctx, this.getDataString(baseData, "FMaintainCrafts_number"));
        excelInfo.setMaintainCrafts(craft);
        excelInfo.setSkillLevel(this.getSkillLevel(ctx, this.getDataString(baseData, "FSkillLevel_number"), craft));
        StorageOrgUnitInfo maintainOrg = this.getMaintainOrg(ctx, this.getDataString(baseData, "FMaintainOrgUnit_number"));
        excelInfo.setMaintainOrgUnit(maintainOrg);
        EquipmentMaintainGroupTreeInfo maintainGroup = this.getMaintainGroup(ctx, this.getDataString(baseData, "FMaintainGroup_number"), maintainOrg);
        excelInfo.setMaintainGroup(maintainGroup);
        excelInfo.setMaintainStaff(this.getMaintainStaff(ctx, this.getDataString(baseData, "FMaintainStaff_number"), maintainOrg, maintainGroup));
        if (excelInfo.getMaintainStaff() == null) {
            try {
                if (baseData.get("FAmount") == null || "".equals(baseData.get("FAmount").toString().trim())) {
                    excelInfo.setAmount(0);
                }
                if (DataImportEqmTools.getDataint((Hashtable)baseData, (String)"FAmount") < 0) {
                    throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Person_Count_Less_Zero"));
                }
                excelInfo.setAmount(DataImportEqmTools.getDataint((Hashtable)baseData, (String)"FAmount"));
            }
            catch (Exception e) {
                throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Person_Count_Error"));
            }
        } else {
            excelInfo.setAmount(1);
        }
        if (DataImportEqmStaOprTools.isExcelCellValueNull(this.getDataString(baseData, "FHours"))) {
            excelInfo.setHours(new BigDecimal("0"));
        } else {
            excelInfo.setHours(DataImportEqmTools.getNumByPrecision((String)this.getDataString(baseData, "FHours"), (int)2, (String)DataImportEqmStaOprTools.getStaOprResourceMsg("Hours"), (boolean)true));
        }
        if (DataImportEqmStaOprTools.isExcelCellValueNull(this.getDataString(baseData, "FRate"))) {
            excelInfo.setRate(new BigDecimal("0"));
        } else {
            excelInfo.setRate(DataImportEqmTools.getNumByPrecision((String)this.getDataString(baseData, "FRate"), (int)2, (String)DataImportEqmStaOprTools.getStaOprResourceMsg("Rate"), (boolean)true));
        }
        String maintainOrgColName = this.getPropertyAlias(ctx, (AbstractObjectValue)excelInfo, "maintainOrgUnit");
        CurrencyInfo currencyInfo = this.staOprTools.getCurrencyInfo(ctx, (OrgUnitInfo)maintainOrg, (OrgUnitInfo)orgInfo, maintainOrgColName);
        excelInfo.setCurrency(currencyInfo);
        BigDecimal lineCost = DataImportEqmStaOprTools.calculate(new BigDecimal[]{new BigDecimal(excelInfo.getAmount()), excelInfo.getHours(), excelInfo.getRate()});
        lineCost = new BigDecimal(this.staOprTools.getNumByPrecision(lineCost.toString(), currencyInfo.getPrecision()));
        excelInfo.setLineCost(lineCost);
        DataImportEqmStaOprTools.checkOverMaxSize(this.getDataString(baseData, "FRemark"), 255, "Descriptin_Over_Max_Size");
        if (DataImportEqmStaOprTools.isExcelCellValueNull(this.getDataString(baseData, "FRemark"))) {
            excelInfo.setRemark(null);
        } else {
            excelInfo.setRemark(this.getDataString(baseData, "FRemark"));
        }
        this.virifyInfo(excelInfo);
        return excelInfo;
    }

    private void virifyInfo(EquipmentStaOprPersonInfo excelInfo) throws TaskExternalException {
        if (excelInfo.getMaintainCrafts() == null && excelInfo.getMaintainOrgUnit() == null) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Person_MaintainOrg_Craft_Both_Null"));
        }
        if (excelInfo.getMaintainCrafts() != null && excelInfo.getMaintainOrgUnit() != null) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Person_MaintainOrg_Craft_Both_Exist"));
        }
    }

    private EquipmentMaintainStaffInfo getMaintainStaff(Context ctx, String number, StorageOrgUnitInfo maintainOrg, EquipmentMaintainGroupTreeInfo maintainGroup) throws TaskExternalException {
        if (!DataImportEqmStaOprTools.isExcelCellValueNull(number) && maintainOrg == null) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("MaintainOrg_Is_Null"));
        }
        if (DataImportEqmStaOprTools.isExcelCellValueNull(number)) {
            return null;
        }
        EquipmentMaintainStaffCollection maintainStaffs = null;
        try {
            EntityViewInfo view = this.staOprTools.getNumFilterView(number);
            view.getSelector().add(new SelectorItemInfo("maintainOrgUnit.id"));
            view.getSelector().add(new SelectorItemInfo("maintainOrgUnit.name"));
            view.getSelector().add(new SelectorItemInfo("group"));
            view.getSelector().add(new SelectorItemInfo("group.name"));
            maintainStaffs = EquipmentMaintainStaffFactory.getLocalInstance(ctx).getEquipmentMaintainStaffCollection(view);
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("MaintainPerson_Num_Error"));
        }
        if (maintainStaffs != null && maintainStaffs.size() > 0) {
            return this.getStaffRel(ctx, maintainStaffs, maintainOrg, maintainGroup);
        }
        throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("MaintainPerson_Num_Error"));
    }

    private EquipmentMaintainStaffInfo getStaffRel(Context ctx, EquipmentMaintainStaffCollection infos, StorageOrgUnitInfo maintainOrg, EquipmentMaintainGroupTreeInfo maintainGroup) throws TaskExternalException {
        if (maintainGroup != null) {
            EquipmentMaintainGroupCollection groupItem = this.getMaintainGroupItem(ctx, maintainGroup);
            for (int staffIndex = 0; staffIndex < infos.size(); ++staffIndex) {
                for (int i = 0; i < infos.get(staffIndex).getGroup().size(); ++i) {
                    for (int j = 0; j < groupItem.size(); ++j) {
                        if (infos.get(staffIndex).getMaintainOrgUnit() == null || !maintainOrg.getId().toString().equals(infos.get(staffIndex).getMaintainOrgUnit().getId().toString()) || !groupItem.get(j).getId().toString().equals(infos.get(staffIndex).getGroup().get(i).getId().toString())) continue;
                        return infos.get(staffIndex);
                    }
                }
            }
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("MaintainGroup_Not_Contain_MaintainPerson"));
        }
        for (int staffIndex = 0; staffIndex < infos.size(); ++staffIndex) {
            if (!maintainOrg.getId().toString().equals(infos.get(staffIndex).getMaintainOrgUnit().getId().toString())) continue;
            return infos.get(staffIndex);
        }
        throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("MaintainOrg_Not_Contain_MaintainPerson"));
    }

    private EquipmentMaintainGroupCollection getMaintainGroupItem(Context ctx, EquipmentMaintainGroupTreeInfo maintainGroup) throws TaskExternalException {
        EquipmentMaintainGroupCollection groupItems = null;
        try {
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("parent.id", (Object)maintainGroup.getId().toString());
            groupItems = EquipmentMaintainGroupFactory.getLocalInstance(ctx).getEquipmentMaintainGroupCollection(DataImportEqmTools.getViewInfo((FilterInfo)filter));
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("MaintainGroup_Num_Error"));
        }
        if (groupItems == null) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("MaintainGroup_Num_Error"));
        }
        return groupItems;
    }

    private EquipmentMaintainGroupTreeInfo getMaintainGroup(Context ctx, String number, StorageOrgUnitInfo maintainOrg) throws TaskExternalException {
        if (!DataImportEqmStaOprTools.isExcelCellValueNull(number) && maintainOrg == null) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("MaintainOrg_Is_Null"));
        }
        if (DataImportEqmStaOprTools.isExcelCellValueNull(number)) {
            return null;
        }
        EquipmentMaintainGroupTreeCollection maintainGroups = null;
        try {
            EntityViewInfo view = this.staOprTools.getNumFilterView(number);
            view.getSelector().add(new SelectorItemInfo("storageOrgUnit.id"));
            view.getSelector().add(new SelectorItemInfo("storageOrgUnit.name"));
            view.getSelector().add(new SelectorItemInfo("name"));
            maintainGroups = EquipmentMaintainGroupTreeFactory.getLocalInstance(ctx).getEquipmentMaintainGroupTreeCollection(view);
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("MaintainGroup_Num_Error"));
        }
        if (maintainGroups != null && maintainGroups.size() > 0) {
            for (int i = 0; i < maintainGroups.size(); ++i) {
                EquipmentMaintainGroupTreeInfo info = maintainGroups.get(i);
                if (!maintainOrg.getId().toString().equals(info.getMainOrgUnit().getId().toString())) continue;
                return maintainGroups.get(i);
            }
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("MaintainOrg_Not_Contain_MaintainGroup"));
        }
        throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("MaintainGroup_Num_Error"));
    }

    private StorageOrgUnitInfo getMaintainOrg(Context ctx, String number) throws TaskExternalException {
        if (DataImportEqmStaOprTools.isExcelCellValueNull(number)) {
            return null;
        }
        StorageOrgUnitCollection maintainOrgUnits = null;
        try {
            EntityViewInfo view = this.staOprTools.getNumFilterView(number);
            view.getFilter().appendFilterItem("isBizUnit", (Object)new Boolean(true));
            maintainOrgUnits = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(view);
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("MaintainOrg_Num_Error"));
        }
        if (maintainOrgUnits != null && maintainOrgUnits.size() > 0) {
            StorageOrgUnitInfo maintainOrg = maintainOrgUnits.get(0);
            this.virifyMaintainOrg(ctx, maintainOrg);
            return maintainOrg;
        }
        throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("MaintainOrg_Num_Error"));
    }

    private void virifyMaintainOrg(Context ctx, StorageOrgUnitInfo maintainOrg) throws TaskExternalException {
        UserInfo user = (UserInfo)this.getContextParameter("userInfo");
        OrgRangeCollection orgRanges = null;
        try {
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("user.id", (Object)user.getId().toString());
            filter.appendFilterItem("org.id", (Object)maintainOrg.getId().toString());
            orgRanges = OrgRangeFactory.getLocalInstance((Context)ctx).getOrgRangeCollection(DataImportEqmTools.getViewInfo((FilterInfo)filter));
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("MaintainOrg_Num_Error"));
        }
        if (orgRanges == null || orgRanges.size() <= 0) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("User_MaintainOrg_Not_Match"));
        }
    }

    private EquipmentSkillLevelInfo getSkillLevel(Context ctx, String number, EquipmentMaintainCraftsInfo craft) throws TaskExternalException {
        if (!DataImportEqmStaOprTools.isExcelCellValueNull(number) && craft == null) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Craft_Is_Null"));
        }
        if (DataImportEqmStaOprTools.isExcelCellValueNull(number)) {
            return null;
        }
        EquipmentSkillLevelCollection skillLvl = null;
        try {
            EntityViewInfo view = this.staOprTools.getNumFilterView(number);
            skillLvl = EquipmentSkillLevelFactory.getLocalInstance(ctx).getEquipmentSkillLevelCollection(view);
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("SkillLvl_Num_Error"));
        }
        if (skillLvl != null && skillLvl.size() > 0) {
            EquipmentSkillLevelInfo info = skillLvl.get(0);
            this.virifyCraftSkillLvlRel(ctx, craft, info);
            return info;
        }
        throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("SkillLvl_Num_Error"));
    }

    private void virifyCraftSkillLvlRel(Context ctx, EquipmentMaintainCraftsInfo craft, EquipmentSkillLevelInfo skillLvl) throws TaskExternalException {
        EquipmentMaintainCraftsItemCollection craftSkillLvlRel = null;
        try {
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("parent.id", (Object)craft.getId().toString());
            filter.appendFilterItem("skillLevel.id", (Object)skillLvl.getId().toString());
            craftSkillLvlRel = EquipmentMaintainCraftsItemFactory.getLocalInstance(ctx).getEquipmentMaintainCraftsItemCollection(DataImportEqmTools.getViewInfo((FilterInfo)filter));
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("SkillLvl_Num_Error"));
        }
        if (craftSkillLvlRel == null || craftSkillLvlRel.size() <= 0) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Craft_Not_Contain_SkillLvl"));
        }
    }

    private EquipmentMaintainCraftsInfo getCrafts(Context ctx, String number) throws TaskExternalException {
        if (DataImportEqmStaOprTools.isExcelCellValueNull(number)) {
            return null;
        }
        EquipmentMaintainCraftsCollection crafts = null;
        try {
            crafts = EquipmentMaintainCraftsFactory.getLocalInstance(ctx).getEquipmentMaintainCraftsCollection(this.staOprTools.getNumFilterView(number));
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Craft_Num_Error"));
        }
        if (crafts != null && crafts.size() > 0) {
            return crafts.get(0);
        }
        throw new TaskExternalException(DataImportEqmStaOprTools.getStaOprResourceMsg("Craft_Num_Error"));
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            Locale locale = ctx.getLocale();
            if (DataImportEqmStaOprTools.isExcelCellValueNull(rs.getString("maintainCrafts.number")) && DataImportEqmStaOprTools.isExcelCellValueNull(rs.getString("maintainOrgUnit.number"))) {
                return null;
            }
            this.putTable(result, "FParent_storageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FParent_storageOrgUnit_name_" + locale, rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FParent_number", rs.getString("number"));
            this.putTable(result, "FParent_name_" + locale, rs.getString("name"));
            this.putTable(result, "FTaskNumber", rs.getString("persons.taskNumber"));
            this.putTable(result, "FMaintainCrafts_number", rs.getString("maintainCrafts.number"));
            this.putTable(result, "FMaintainCrafts_name_" + locale, rs.getString("maintainCrafts.name"));
            this.putTable(result, "FSkillLevel_number", rs.getString("skillLevel.number"));
            this.putTable(result, "FSkillLevel_name_" + locale, rs.getString("skillLevel.name"));
            this.putTable(result, "FMaintainOrgUnit_number", rs.getString("maintainOrgUnit.number"));
            this.putTable(result, "FMaintainOrgUnit_name_" + locale, rs.getString("maintainOrgUnit.name"));
            this.putTable(result, "FMaintainGroup_number", rs.getString("maintainGroup.number"));
            this.putTable(result, "FMaintainGroup_name_" + locale, rs.getString("maintainGroup.name"));
            this.putTable(result, "FMaintainStaff_number", rs.getString("maintainStaff.number"));
            this.putTable(result, "FMaintainStaff_name_" + locale, rs.getString("maintainStaff.name"));
            this.putTable(result, "FAmount", rs.getString("persons.amount"));
            this.putTable(result, "FHours", DataImportEqmTools.getNumByPrecision((String)rs.getString("persons.hours"), (int)2));
            this.putTable(result, "FRate", DataImportEqmTools.getNumByPrecision((String)rs.getString("persons.rate"), (int)2));
            this.putTable(result, "FLineCost", DataImportEqmTools.getNumByPrecision((String)rs.getString("persons.lineCost"), (int)rs.getInt("currency.precision")));
            this.putTable(result, "FCurrency_name", rs.getString("currency.name"));
            this.putTable(result, "FRemark", rs.getString("persons.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        EntityViewInfo viewInfo = (EntityViewInfo)this.getContextParameter("mainQuery");
        return viewInfo.getFilter();
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.eqm.basedata.app.EquipmentStaOprPersonImExQuery";
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return false;
    }
}

