/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprServiceFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStaOprServiceInfo;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationInfo;
import com.kingdee.eas.eqm.basedata.datatask.DataImportEqmStaOprTools;
import com.kingdee.eas.eqm.common.datatask.EQMBaseDataTransmission;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;

public class DataImportEqmStaOprService
extends EQMBaseDataTransmission {
    private static final int NAMENUMBER_MAX_SIZE = 80;
    private static final int DESCRIPTION_MAX_SIZE = 255;
    private DataImportEqmStaOprTools staOprTools = new DataImportEqmStaOprTools();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EquipmentStaOprServiceFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        PurchaseOrgUnitInfo purOrgUnitInfo;
        StorageOrgUnitInfo orgInfo;
        EquipmentStaOprServiceInfo excelInfo;
        Hashtable baseData;
        block8: {
            baseData = (Hashtable)hsData.get(new Integer(0));
            excelInfo = new EquipmentStaOprServiceInfo();
            orgInfo = this.staOprTools.getMainStorageOrgUnit(ctx, this.getDataString(baseData, "FParent_storageOrgUnit_number"), this.cache_storageInfo, this._cacheAuthorizedOrgUnits);
            EquipmentStandardOperationInfo staOprInfo = this.staOprTools.getStaOpr(ctx, orgInfo, this.getDataString(baseData, "FParent_number"));
            excelInfo.setStandardOperation(staOprInfo);
            this.staOprTools.virifyEntryTaskNumber(ctx, this.getDataString(baseData, "FTaskNumber"), staOprInfo);
            if (DataImportEqmStaOprTools.isExcelCellValueNull(this.getDataString(baseData, "FTaskNumber"))) {
                excelInfo.setTaskNumber(null);
            } else {
                excelInfo.setTaskNumber(this.getDataString(baseData, "FTaskNumber"));
            }
            String serviceName = this.getDataString(baseData, "FServices_name");
            DataImportEqmTools.checkIsNull((Context)ctx, (AbstractObjectValue)excelInfo, (String)serviceName, (String)"name");
            DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)excelInfo, (String)serviceName, (String)"name", (int)80);
            excelInfo.setName(serviceName);
            purOrgUnitInfo = null;
            SupplierInfo supplierInfo = null;
            try {
                String supplierNumber;
                String purOrgUnitNumber = this.getDataString(baseData, "FPurchaseOrgUnit_number");
                if (purOrgUnitNumber != null && purOrgUnitNumber.trim().length() > 0) {
                    purOrgUnitInfo = (PurchaseOrgUnitInfo)this.getPurOrgUnitInfo(ctx, orgInfo.getId().toString(), purOrgUnitNumber);
                    if (purOrgUnitInfo == null) {
                        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource", (String)"PurOrg_NotIn_StorgeDelegated", (Locale)ContextUtils.getLocaleFromEnv()));
                    }
                    excelInfo.setPurchaseOrgUnit(purOrgUnitInfo);
                }
                if ((supplierNumber = this.getDataString(baseData, "FSupplier_number")) == null || supplierNumber.trim().length() <= 0) break block8;
                if (purOrgUnitInfo != null && purOrgUnitInfo.getId() != null) {
                    supplierInfo = this.getSupplierInfo(ctx, purOrgUnitInfo.getId().toString(), supplierNumber);
                    if (supplierInfo == null) {
                        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource", (String)"Supplier_NotIn_PurOrgDesignated", (Locale)ContextUtils.getLocaleFromEnv()));
                    }
                    excelInfo.setSupplier(supplierInfo);
                    break block8;
                }
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.eqm.basedata.EquipmentStandardOperationResource", (String)"Supplier_NotIn_PurOrgDesignated", (Locale)ContextUtils.getLocaleFromEnv()));
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)excelInfo, (String)this.getDataString(baseData, "FContractNumber"), (String)"contractNumber", (int)80);
        excelInfo.setContractNumber(this.getDataString(baseData, "FContractNumber"));
        String purOrgUnitColName = this.getPropertyAlias(ctx, (AbstractObjectValue)excelInfo, "purchaseOrgUnit");
        CurrencyInfo currencyInfo = this.staOprTools.getCurrencyInfo(ctx, (OrgUnitInfo)purOrgUnitInfo, (OrgUnitInfo)orgInfo, purOrgUnitColName);
        excelInfo.setCurrency(currencyInfo);
        BigDecimal lineCost = DataImportEqmTools.getNumByPrecision((String)this.getDataString(baseData, "FLineCost"), (int)currencyInfo.getPrecision(), (String)DataImportEqmStaOprTools.getStaOprResourceMsg("LineCost"), (boolean)true);
        excelInfo.setLineCost(lineCost);
        DataImportEqmStaOprTools.checkOverMaxSize(this.getDataString(baseData, "FRemark"), 255, "Descriptin_Over_Max_Size");
        excelInfo.setRemark(this.getDataString(baseData, "FRemark"));
        return excelInfo;
    }

    private OrgUnitInfo getPurOrgUnitInfo(Context ctx, String storageID, String purOrgNumber) throws TaskExternalException {
        if (DataImportEqmStaOprTools.isExcelCellValueNull(purOrgNumber) || storageID == null) {
            return null;
        }
        String ckey = storageID + purOrgNumber;
        if (this.cache_info.get(ckey) != null) {
            return (OrgUnitInfo)this.cache_info.get(ckey);
        }
        OrgUnitInfo orgInfo = null;
        try {
            IOrgUnitRelation iorgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgCols = iorgRelation.getToUnit(storageID, OrgType.Storage.getValue(), OrgType.Purchase.getValue());
            if (orgCols != null && orgCols.size() == 0) {
                return null;
            }
            Iterator iter = orgCols.iterator();
            while (iter != null && iter.hasNext()) {
                OrgUnitInfo tempInfo = (OrgUnitInfo)iter.next();
                if (!purOrgNumber.equals(tempInfo.getNumber())) continue;
                orgInfo = tempInfo;
                this.cache_info.put(ckey, orgInfo);
                break;
            }
        }
        catch (Exception e1) {
            throw new TaskExternalException(e1.getMessage(), (Throwable)e1);
        }
        return orgInfo;
    }

    private SupplierInfo getSupplierInfo(Context ctx, String purchaseOrgID, String supplierNumber) throws BOSException, TaskExternalException {
        if (DataImportEqmStaOprTools.isExcelCellValueNull(supplierNumber) || purchaseOrgID == null) {
            return null;
        }
        String ckey = purchaseOrgID + supplierNumber;
        if (this.cache_info.get(ckey) != null) {
            return (SupplierInfo)this.cache_info.get(ckey);
        }
        Locale locale = ctx.getLocale();
        StringBuffer sql = new StringBuffer();
        sql.append(" select DISTINCT SUPPLIER.FNumber AS NUMBER, \n");
        sql.append(" SUPPLIER.FID AS ID,\n");
        sql.append(" SUPPLIER.FName_" + locale + " AS NAME \n");
        sql.append(" FROM T_BD_Supplier AS SUPPLIER \n");
        sql.append(" INNER JOIN T_BD_SupplierPurchaseInfo AS SUPPLIERPURCHASING \n");
        sql.append(" ON SUPPLIER.FID = SUPPLIERPURCHASING.FSupplierID \n");
        sql.append(" LEFT OUTER JOIN T_BD_SupplierGroupDetail AS SUPPLIERGROUPDETAILS \n");
        sql.append(" ON SUPPLIER.FID = SUPPLIERGROUPDETAILS.FSupplierID \n");
        sql.append(" LEFT OUTER JOIN T_BD_CSSPGroup AS BROWSEGROUP1 \n");
        sql.append(" ON SUPPLIER.FBrowseGroupID = BROWSEGROUP1.FID \n");
        sql.append(" LEFT OUTER JOIN T_ORG_Company AS INTERNALCOMPANY \n");
        sql.append(" ON SUPPLIER.FInternalCompanyID = INTERNALCOMPANY.FID \n");
        sql.append(" LEFT OUTER JOIN T_ORG_Purchase AS PURCHASEORGUNIT \n");
        sql.append(" ON SUPPLIERPURCHASING.FPurchaseOrgID = PURCHASEORGUNIT.FID \n");
        sql.append(" INNER JOIN T_BD_CSSPGroupStandard AS SUPPLIERGROUPSTANDARD \n");
        sql.append(" ON SUPPLIERGROUPDETAILS.FSupplierGroupStandardID = SUPPLIERGROUPSTANDARD.FID \n");
        sql.append(" INNER JOIN T_BD_CSSPGroup AS BROWSEGROUP \n");
        sql.append(" ON SUPPLIERGROUPDETAILS.FSupplierGroupID = BROWSEGROUP.FID \n");
        sql.append(" WHERE SUPPLIERGROUPSTANDARD.FIsBasic = 1 AND BROWSEGROUP.FDeletedStatus = 1 \n");
        sql.append(" AND PURCHASEORGUNIT.FID = ? AND SUPPLIER.FNumber = ? \n");
        Object[] params = new Object[]{purchaseOrgID, supplierNumber};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        SupplierInfo supplierInfo = null;
        try {
            if (rs.next()) {
                supplierInfo = new SupplierInfo();
                supplierInfo.setId(BOSUuid.read((String)rs.getString("ID")));
                supplierInfo.setNumber(rs.getString("NUMBER"));
                supplierInfo.setName(rs.getString("NAME"));
                this.cache_info.put(ckey, supplierInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql exception!");
        }
        return supplierInfo;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            if (DataImportEqmStaOprTools.isExcelCellValueNull(rs.getString("services.name"))) {
                return null;
            }
            this.putTable(result, "FParent_storageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FParent_storageOrgUnit_name", rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FParent_number", rs.getString("number"));
            this.putTable(result, "FParent_name", rs.getString("name"));
            this.putTable(result, "FTaskNumber", rs.getString("services.taskNumber"));
            this.putTable(result, "FServices_name", rs.getString("services.name"));
            this.putTable(result, "FPurchaseOrgUnit_number", rs.getString("purchaseOrgUnit.number"));
            this.putTable(result, "FPurchaseOrgUnit_name", rs.getString("purchaseOrgUnit.name"));
            this.putTable(result, "FSupplier_number", rs.getString("supplier.number"));
            this.putTable(result, "FSupplier_name", rs.getString("supplier.name"));
            this.putTable(result, "FContractNumber", rs.getString("services.contractNumber"));
            this.putTable(result, "FLineCost", DataImportEqmTools.getNumByPrecision((String)rs.getString("services.lineCost"), (int)rs.getInt("currency.precision")));
            this.putTable(result, "FCurrency_name", rs.getString("currency.name"));
            this.putTable(result, "FRemark", rs.getString("services.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        EntityViewInfo viewInfo = (EntityViewInfo)this.getContextParameter("mainQuery");
        return viewInfo.getFilter();
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.eqm.basedata.app.EquipmentStaOprServiceImExQuery";
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return false;
    }
}

