/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.basedata.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.basedata.EquipmentDangerActionFactory;
import com.kingdee.eas.eqm.basedata.EquipmentDangerActionInfo;
import com.kingdee.eas.eqm.basedata.EquipmentDangerFactory;
import com.kingdee.eas.eqm.common.datatask.EQMBaseDataTransmission;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Hashtable;
import java.util.Locale;

public class EquipmentDangerActionTransmission
extends EQMBaseDataTransmission {
    private static final String RESOURCE_PATH = "com.kingdee.eas.eqm.basedata.EquipmentDangerResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EquipmentDangerActionFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String orgNum;
        String str = null;
        StorageOrgUnitInfo storageInfo = null;
        EquipmentDangerActionInfo equipmentDangerActionInfo = new EquipmentDangerActionInfo();
        Hashtable baseData = hsData;
        String storageOrgNumber = this.getDataString(baseData, "FParent_storageOrgUnit_number");
        if (storageOrgNumber == null || "".equals(storageOrgNumber.trim())) {
            throw new TaskExternalException(this.getResourceMsg("storageOrgUnit_CanNotNull"));
        }
        if (this.isAuthorizedOrgUnit(ctx, storageOrgNumber)) {
            try {
                storageInfo = this.getStorageOrgUnitInfoFromNumber(ctx, storageOrgNumber);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        if (!storageOrgNumber.equals(orgNum = storageInfo.getNumber())) {
            throw new TaskExternalException("");
        }
        String dangerNumber = this.getDataString(baseData, "FParent_number");
        if (dangerNumber == null || "".equals(dangerNumber.trim())) {
            throw new TaskExternalException(this.getResourceMsg("number_CanNotNull"));
        }
        try {
            CoreBaseInfo equipmentDangerInfo = this.getInfoByNumber(ctx, (ICoreBase)EquipmentDangerFactory.getLocalInstance(ctx), dangerNumber, storageOrgNumber, null);
            equipmentDangerInfo.put("storageOrgUnit", (Object)storageInfo);
            equipmentDangerActionInfo.put("parent", equipmentDangerInfo);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        String dangerActionNumber = this.getDataString(baseData, "FNumber");
        DataImportEqmTools.checkIsNull((Context)ctx, (AbstractObjectValue)equipmentDangerActionInfo, (String)dangerActionNumber, (String)"number");
        try {
            CoreBaseInfo entryInfo = this.getEntryInfoByNumber(ctx, this.getController(ctx), dangerNumber, storageOrgNumber, dangerActionNumber, null);
            if (entryInfo != null && dangerActionNumber.equals((String)entryInfo.get("number"))) {
                throw new TaskExternalException(this.getResourceMsg("duplicateActionNumber"));
            }
            DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)equipmentDangerActionInfo, (String)dangerActionNumber, (String)"number", (int)80);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        equipmentDangerActionInfo.setNumber(dangerActionNumber);
        str = this.getDataString(baseData, "FName");
        DataImportEqmTools.checkIsNull((Context)ctx, (AbstractObjectValue)equipmentDangerActionInfo, (String)str, (String)"name");
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)equipmentDangerActionInfo, (String)str, (String)"name", (int)255);
        equipmentDangerActionInfo.setName(str);
        str = this.getDataString(baseData, "FRemark");
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)equipmentDangerActionInfo, (String)str, (String)"remark", (int)255);
        equipmentDangerActionInfo.setRemark(str);
        return equipmentDangerActionInfo;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FParent_storageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FParent_storageOrgUnit_name", rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FParent_number", rs.getString("number"));
            this.putTable(result, "FParent_name", rs.getString("name"));
            this.putTable(result, "FNumber", rs.getString("dangerActionNumber"));
            this.putTable(result, "FName", rs.getString("dangerActionName"));
            this.putTable(result, "FRemark", rs.getString("dangerActionremark"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String getResourceMsg(String key) {
        return ResourceBase.getString((String)RESOURCE_PATH, (String)key, (Locale)ContextUtils.getLocaleFromEnv());
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.eqm.basedata.app.ExpEquipmentDangerActionQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        EntityViewInfo viewInfo = (EntityViewInfo)this.getContextParameter("dangerActionMainQuery");
        FilterInfo filter = viewInfo.getFilter();
        return filter;
    }

    protected String getImportPermItemName() {
        return "eqm_EquipmentDanger_09import";
    }
}

