/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.core.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.eqm.common.core.GeneCheckedStatusEnum;
import com.kingdee.eas.eqm.common.core.GeneCommonFacadeFactory;
import com.kingdee.eas.eqm.common.core.GeneTreeBaseInfo;
import com.kingdee.eas.eqm.common.core.IGeneTreeBase;
import com.kingdee.eas.eqm.common.core.client.AbstractGeneDataBaseTreeEditUI;
import com.kingdee.eas.eqm.common.core.client.ccstrategy.GeneClientControlStrategy;
import com.kingdee.eas.eqm.common.core.client.ccstrategy.GeneClientControlStrategyFactory;
import com.kingdee.eas.eqm.common.core.client.ccstrategy.IGeneClientControlStrategy;
import com.kingdee.eas.eqm.common.core.client.ccstrategy.IGeneControlModeUIProxy;
import com.kingdee.eas.eqm.common.core.client.util.GeneClientUtils;
import com.kingdee.eas.eqm.common.core.client.util.GeneUICompentCreatorFactory;
import com.kingdee.eas.eqm.common.core.client.util.IGeneUIComponentCreator;
import com.kingdee.eas.eqm.common.core.client.verify.UIControlEmptyVerifyItem;
import com.kingdee.eas.eqm.common.core.codingrule.ClientCodingRuleStrategy;
import com.kingdee.eas.eqm.common.core.util.GeneSelectorUtils;
import com.kingdee.eas.eqm.common.core.util.backup.QMSortUtils;
import com.kingdee.eas.eqm.common.core.verify.IVerifyManager;
import com.kingdee.eas.eqm.common.core.verify.VerifyManager;
import com.kingdee.eas.eqm.common.eqmcore.client.util.EQMPromptDialogFactory;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.AbstractEditUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.qm.common.util.backup.FMClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class GeneDataBaseTreeEditUI
extends AbstractGeneDataBaseTreeEditUI
implements IGeneControlModeUIProxy {
    private static final Logger logger = CoreUIObject.getLogger(GeneDataBaseTreeEditUI.class);
    protected IVerifyManager verifyManager = null;
    private OrgUnitInfo[] mainOrgs = null;
    private int idxDefaultMainOrg = -1;
    public static final String OPER_COPY = "COPY";
    private ClientCodingRuleStrategy codingRuleStrategy = null;
    private String controlType = null;
    private IGeneClientControlStrategy ccStrategy = null;
    private IGeneUIComponentCreator creator = null;

    protected Context getMainOrgContext() {
        Context ctx = super.getMainOrgContext();
        if (ctx != null) {
            ctx.put((Object)"PIN", (Object)new Long(System.currentTimeMillis()));
        }
        return ctx;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if ((action instanceof AbstractEditUI.ActionAddNew || action instanceof AbstractEditUI.ActionEdit || action instanceof AbstractEditUI.ActionRemove || action instanceof AbstractEditUI.ActionCopy || action instanceof AbstractEditUI.ActionSave) && this.getControlType() != null && "S1".equalsIgnoreCase(this.getControlType())) {
            this.getDefaultMainBizOrg();
            for (int i = 0; this.mainOrgs != null && i < this.mainOrgs.length; ++i) {
                if (!this.mainOrgs[i].isIsCU() || this.mainOrgs[i].getLevel() != 1) continue;
                return new ObjectUuidPK(this.mainOrgs[i].getId());
            }
        }
        return super.getOrgPK(action);
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        OrgUnitInfo currentMainOrg;
        if (this.idxDefaultMainOrg > -1) {
            OrgUnitInfo currentMainOrg2 = this.getMainOrgInfo();
            if (currentMainOrg2 != null && this.mainOrgs != null && this.mainOrgs.length > 0) {
                for (int i = 0; i < this.mainOrgs.length; ++i) {
                    if (!currentMainOrg2.getId().toString().equals(this.mainOrgs[i].getId().toString())) continue;
                    this.idxDefaultMainOrg = i;
                    return currentMainOrg2;
                }
            }
            OrgUnitInfo lastOrgUnitInfo = this.mainOrgs[this.idxDefaultMainOrg];
            return lastOrgUnitInfo;
        }
        if (this.mainOrgs == null) {
            try {
                String addNewPermItemName = this.getOnloadPermItemName();
                OrgUnitInfo[] orgUnitInfoArray = this.mainOrgs = this.isBizOrgUnit() ? GeneCommonFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).getAuthorizedBizOrgUnits(this.getMainBizOrgType(), addNewPermItemName) : GeneCommonFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).getAuthorizedOrgUnits(this.getMainBizOrgType(), addNewPermItemName);
                if (this.mainOrgs == null || this.mainOrgs.length == 0) {
                    return null;
                }
                if (this.mainOrgs.length > 0) {
                    this.mainOrgs = (OrgUnitInfo[])QMSortUtils.sortDataByNumber((DataBaseInfo[])this.mainOrgs, true);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if ((currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType())) != null && this.mainOrgs != null && this.mainOrgs.length > 0) {
            for (int i = 0; i < this.mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(this.mainOrgs[i].getId().toString())) continue;
                this.idxDefaultMainOrg = i;
                return currentMainOrg;
            }
        }
        if (this.mainOrgs != null && this.mainOrgs.length > 0) {
            this.idxDefaultMainOrg = 0;
            return this.mainOrgs[0];
        }
        return null;
    }

    public boolean isBizOrgUnit() {
        return false;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionUnAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionBlocked.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_freeze"));
        this.actionUnBlocked.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.btnCancel.setVisible(false);
        this.btnCancel.setEnabled(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCancelCancel.setEnabled(false);
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        this.setTitle();
    }

    protected void setTitle() {
        GeneClientUtils.updateUITitle((CoreUIObject)this, this.resHelper.getString("this.title"));
    }

    public IVerifyManager getVerifyManager() {
        if (this.verifyManager == null) {
            this.verifyManager = new VerifyManager();
        }
        return this.verifyManager;
    }

    protected IObjectValue createNewData() {
        IObjectValue data = this.doCreateNewData();
        return data;
    }

    public void onLoad() throws Exception {
        this.initStrategy();
        super.onLoad();
        this.registerCustomerBindings();
        UIControlEmptyVerifyItem verifyItem = new UIControlEmptyVerifyItem((CoreUIObject)this);
        this.getVerifyManager().addVerifyItem(verifyItem);
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    protected KDBizPromptBox getParentPrompt() {
        return null;
    }

    public void registerCustomerBindings() {
        if (this.getParentPrompt() != null) {
            try {
                EQMPromptDialogFactory.createParentDialog(this.getParentPrompt(), this.editData);
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        GeneTreeBaseInfo info = (GeneTreeBaseInfo)this.getDataObject();
        if (this.isSupportAudit()) {
            boolean canAudit = info.getCheckedStatus() != GeneCheckedStatusEnum.AUDITED && info.getEffectedStatus() == EffectedStatusEnum.EFFECTED;
            boolean canUnAudit = info.getCheckedStatus() == GeneCheckedStatusEnum.AUDITED && info.getEffectedStatus() == EffectedStatusEnum.EFFECTED;
            this.actionAudit.setEnabled(canAudit);
            this.actionAudit.setVisible(canAudit);
            this.actionUnAudit.setEnabled(canUnAudit);
            this.actionUnAudit.setVisible(canUnAudit);
        } else {
            this.actionAudit.setEnabled(false);
            this.actionAudit.setVisible(false);
            this.actionUnAudit.setEnabled(false);
            this.actionUnAudit.setVisible(false);
        }
        if (this.isSupportCancel()) {
            boolean canCancel = info.getDeletedStatus() != DeletedStatusEnum.DELETED && info.getEffectedStatus() == EffectedStatusEnum.EFFECTED;
            boolean canCancelCancel = info.getDeletedStatus() == DeletedStatusEnum.DELETED && info.getEffectedStatus() == EffectedStatusEnum.EFFECTED;
            this.actionCancel.setEnabled(canCancel);
            this.actionCancel.setVisible(canCancel);
            this.actionCancelCancel.setEnabled(canCancelCancel);
            this.actionCancelCancel.setVisible(canCancelCancel);
        } else {
            this.actionCancel.setEnabled(false);
            this.actionCancel.setVisible(false);
            this.actionCancelCancel.setEnabled(false);
            this.actionCancelCancel.setVisible(false);
        }
        if (this.isSupportBlock()) {
            boolean canBlock = info.getBlockedStatus() != BlockedStatusEnum.BLOCKED && info.getEffectedStatus() == EffectedStatusEnum.EFFECTED;
            boolean canUnBlock = info.getBlockedStatus() == BlockedStatusEnum.BLOCKED && info.getEffectedStatus() == EffectedStatusEnum.EFFECTED;
            this.actionBlocked.setEnabled(canBlock);
            this.actionBlocked.setVisible(canBlock);
            this.actionUnBlocked.setEnabled(canUnBlock);
            this.actionUnBlocked.setVisible(canUnBlock);
        } else {
            this.actionBlocked.setEnabled(false);
            this.actionBlocked.setVisible(false);
            this.actionUnBlocked.setEnabled(false);
            this.actionUnBlocked.setVisible(false);
        }
        this.initActionStatus();
    }

    protected boolean isSupportBlock() {
        return false;
    }

    protected boolean isSupportCancel() {
        return false;
    }

    protected boolean isSupportAudit() {
        return false;
    }

    protected void initActionStatus() {
        this.actionSave.setEnabled(false);
        this.actionSave.setVisible(false);
    }

    protected void initContextOrg() {
        OrgUnitInfo orgUnitInfo = this.getMainOrgInfo();
        if (orgUnitInfo == null) {
            orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        }
        this.initUIMainOrgContext(orgUnitInfo.getId().toString());
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        if ("ADDNEW".equals(this.getOprtState())) {
            dataObject.put("parent", this.getUIContext().get("ParentNode"));
        }
        super.setDataObject(dataObject);
        GeneTreeBaseInfo info = (GeneTreeBaseInfo)dataObject;
        if (info != null && info.innerGetParent() != null) {
            this.getUIContext().put("ParentNode", info.innerGetParent());
        }
    }

    protected IObjectValue doCreateNewData() {
        Map map = this.getUIContext();
        String actionCopy = (String)map.get(OPER_COPY);
        String id = null;
        if (map.get("ID") != null) {
            id = map.get("ID").toString();
        }
        GeneTreeBaseInfo data = null;
        try {
            if (actionCopy != null && id != null && actionCopy.equals(OPER_COPY)) {
                GeneTreeBaseInfo oldInfo = (GeneTreeBaseInfo)this.getValue((IObjectPK)new ObjectUuidPK(id));
                data = (GeneTreeBaseInfo)oldInfo.copy();
                map.remove(OPER_COPY);
            } else {
                data = (GeneTreeBaseInfo)this.newInstanceData();
            }
            KDTextField txtNumber = this.getNumTextField();
            String orgId = this.getMainOrgInfo().getId().toString();
            this.getCodingRuleStrategy().processCodingRuleNumber(this.getMainOrgContext(), txtNumber, data, orgId);
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.applyBillDefaultValue(data);
        return data;
    }

    protected void applyBillDefaultValue(GeneTreeBaseInfo vo) {
        GeneTreeBaseInfo billInfo = vo;
        billInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        Date today = new Date();
        billInfo.setCreateTime(new Timestamp(today.getTime()));
        billInfo.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        billInfo.setLastUpdateTime(null);
    }

    public abstract KDTextField getNumTextField();

    public ClientCodingRuleStrategy getCodingRuleStrategy() {
        if (this.codingRuleStrategy == null) {
            this.codingRuleStrategy = new ClientCodingRuleStrategy();
        }
        return this.codingRuleStrategy;
    }

    protected abstract IObjectValue newInstanceData();

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.getVerifyManager().verify();
    }

    @Override
    public abstract SelectorItemCollection getSelectors();

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_AUDIT", null);
        super.actionAudit_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IGeneTreeBase biz = (IGeneTreeBase)this.getBizInterface();
        biz.audit((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.setOprtState("VIEW");
        this.afterDoAction(e, (IObjectPK)pk);
    }

    private void afterDoAction(ActionEvent e, IObjectPK pk) throws Exception {
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_UNAUDIT", null);
        super.actionUnAudit_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IGeneTreeBase biz = (IGeneTreeBase)this.getBizInterface();
        biz.unAudit((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(e, (IObjectPK)pk);
    }

    @Override
    public void actionBlocked_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_BLOCK", null);
        super.actionBlocked_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IGeneTreeBase biz = (IGeneTreeBase)this.getBizInterface();
        biz.blocked((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(e, (IObjectPK)pk);
    }

    @Override
    public void actionUnBlocked_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_UNBLOCK", null);
        super.actionUnBlocked_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IGeneTreeBase biz = (IGeneTreeBase)this.getBizInterface();
        biz.unBlocked((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(e, (IObjectPK)pk);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_CANCEL", null);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IGeneTreeBase biz = (IGeneTreeBase)this.getBizInterface();
        biz.cancel((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(e, (IObjectPK)pk);
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_CANCELCANCEL", null);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IGeneTreeBase biz = (IGeneTreeBase)this.getBizInterface();
        biz.cancelCancel((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        this.afterDoAction(e, (IObjectPK)pk);
    }

    @Override
    public BOSObjectType getBizObjectType() {
        try {
            BOSObjectType currentBOSObjectType = this.getBizType();
            return currentBOSObjectType;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public ICoreBase getBizInterface1() throws Exception {
        return this.getBizInterface();
    }

    public String getControlType() {
        if (this.controlType == null) {
            this.controlType = "";
            try {
                if (this.getBizInterface() == null) {
                    return this.controlType;
                }
                EntityObjectInfo eoi = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(this.getBizType());
                if (eoi.containsExtendedPropertyKey("controlType")) {
                    this.controlType = eoi.getExtendedProperty("controlType");
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                SysUtil.abort();
            }
        }
        return this.controlType;
    }

    protected IGeneClientControlStrategy getClientControlStrategy() {
        if (this.ccStrategy != null) {
            return this.ccStrategy;
        }
        String controlType = this.getControlType();
        this.ccStrategy = GeneClientControlStrategyFactory.create(controlType, this);
        return this.ccStrategy;
    }

    private void initStrategy() {
        if (this.ccStrategy == null) {
            this.ccStrategy = this.getClientControlStrategy();
        }
    }

    private void checkPermission(String action, String cuID) throws Exception {
        IGeneClientControlStrategy stategy = this.getClientControlStrategy();
        if (stategy instanceof GeneClientControlStrategy) {
            ((GeneClientControlStrategy)stategy).checkPermission(action, cuID);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_ADDNEW", null);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_COPY", null);
        GeneTreeBaseInfo info = (GeneTreeBaseInfo)this.editData;
        if (info.get(info.getParentProperty()) == null) {
            this.getUIContext().put("ParentNode", null);
        }
        super.actionCopy_actionPerformed(e);
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_MODIFY", null);
        String tempOprState = this.getOprtState();
        this.setSave(false);
        this.setOprtState("EDIT");
        IObjectValue val = (IObjectValue)this.getUIContext().get("CURRENT.VO");
        this.getUIContext().put("CURRENT.VO", null);
        try {
            this.setDataObject(val);
        }
        catch (Exception ex) {
            this.setOprtState(tempOprState);
            this.getUIContext().put("CURRENT.VO", val);
            throw ex;
        }
        this.unLockUI();
        this.showMessageForStatus();
        this.initDataStatus();
        this.setDefaultFocused();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("ACTION_DELETE", null);
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        if (this.confirmRemove()) {
            boolean bool = UtilRequest.isPrepare((String)"ActionRemove", (CoreUIObject)this);
            if (bool) {
                this.prepareRomove(null).callHandler();
            }
            this.removeByPK((IObjectPK)pk);
        }
    }

    public void setParentGroupFilter(KDBizPromptBox prmt) {
        if (prmt == null) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        GeneTreeBaseInfo treeBaseInfo = (GeneTreeBaseInfo)this.editData;
        if (treeBaseInfo != null) {
            String longNumber = treeBaseInfo.getLongNumber();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.NOTLIKE));
            filter.setMaskString("#0 and #1");
        }
        ev.setFilter(filter);
        prmt.setEntityViewInfo(ev);
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        newData.setString("number", null);
    }

    public Component getComponentByName(CoreUIObject ui, String name) {
        return GeneClientUtils.getComponentByName((CoreUIObject)this, name);
    }

    public IGeneUIComponentCreator getBoxCreatorFacotry() {
        if (this.creator == null) {
            this.creator = GeneUICompentCreatorFactory.getInstance();
        }
        return this.creator;
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.setScrollButtons();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.setScrollButtons();
    }

    protected void setScrollButtons() {
        int currentIndex = this.idList.getCurrentIndex();
        int nextIndex = currentIndex + 1;
        String nextId = this.idList.getID(nextIndex);
        if (nextId == null) {
            this.actionNext.setEnabled(false);
            this.actionLast.setEnabled(false);
        }
    }

    protected abstract String getMainBizOrgField();

    public SelectorItemCollection getInnerSelectors() {
        try {
            return GeneSelectorUtils.getSelector(this.getBizType(), "", true, true, false);
        }
        catch (Exception e) {
            this.handleException(e);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            GeneSelectorUtils.addSelectorWithIDAndNumberAndName(sic, this.getMainBizOrgField());
            return sic;
        }
    }

    public String getResourceName() {
        return this.getMetaDataPK().getFullName() + "Resource";
    }
}

