/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.core.client.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.MutiOrgPermParam;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.client.action.IUIContextAction;
import com.kingdee.eas.eqm.common.core.client.action.IUIContextManager;
import com.kingdee.eas.eqm.common.core.util.GeneEqualsUtils;
import com.kingdee.eas.framework.FrameWorkUtils;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public final class UIContextManager
implements IUIContextManager {
    private static Logger logger = Logger.getLogger(UIContextManager.class);
    private CoreUIObject owner;
    private List actionList = new ArrayList();
    private boolean enabled = true;
    private String type = "MainOrgUnit";

    public UIContextManager(CoreUIObject owner) {
        this.owner = owner;
    }

    @Override
    public void registerAction(IUIContextAction data) {
        this.actionList.add(data);
    }

    @Override
    public void changeUIContext(Context context) {
        if (context == null) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        for (int i = 0; i < this.actionList.size(); ++i) {
            IUIContextAction a = (IUIContextAction)this.actionList.get(i);
            if (!a.isEnabled()) continue;
            logger.debug((Object)("perform action:" + a.getClass().getName()));
            try {
                a.changeUIContext(this.owner, context);
                continue;
            }
            catch (BOSException e) {
                this.owner.handUIException((Throwable)e);
                return;
            }
            catch (EASBizException e) {
                this.owner.handUIException((Throwable)e);
                return;
            }
        }
    }

    @Override
    public void registerMainBizOrgF7(KDBizPromptBox bizOrgUnitBox, OrgType orgType, String permissionItem, boolean isSupportMultiOrgs) {
        if (orgType == null) {
            throw new NullPointerException("orgType can not null");
        }
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(orgType);
        bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        NewOrgViewF7PromptDialog modelF7 = iProducer.getModel();
        modelF7.setShowAssistantOrg(false);
        modelF7.setIsCUFilter(false);
        modelF7.setShowVirtual(false);
        modelF7.setDefaultChkVirtual(false);
        modelF7.setShowAssistantOrg(true);
        modelF7.setIsCUFilter(false);
        modelF7.setShowSub(true);
        if (permissionItem != null) {
            modelF7.setPermissionItem(permissionItem);
        }
        modelF7.setMultiSelect(isSupportMultiOrgs);
        bizOrgUnitBox.setSelector((KDPromptSelector)modelF7);
        bizOrgUnitBox.setCommitFormat("$number$");
        bizOrgUnitBox.setDisplayFormat("$name$");
        bizOrgUnitBox.setEditFormat("$number$");
        bizOrgUnitBox.setEnabledMultiSelection(isSupportMultiOrgs);
    }

    @Override
    public void registerActions(List actionList) {
        for (int i = 0; i < actionList.size(); ++i) {
            Object a = actionList.get(i);
            this.registerAction((IUIContextAction)a);
        }
    }

    @Override
    public void removeAction(IUIContextAction action) {
        this.actionList.remove(action);
    }

    @Override
    public void removeAction(Class actionName) {
        for (int i = this.actionList.size() - 1; i >= 0; --i) {
            IUIContextAction a = (IUIContextAction)this.actionList.get(i);
            if (!a.getClass().equals(actionName)) continue;
            this.actionList.remove(a);
        }
    }

    @Override
    public List getActions(Class actionName) {
        ArrayList<IUIContextAction> list = new ArrayList<IUIContextAction>();
        for (int i = this.actionList.size() - 1; i >= 0; --i) {
            IUIContextAction a = (IUIContextAction)this.actionList.get(i);
            if (!a.getClass().equals(actionName)) continue;
            list.add(a);
        }
        return list;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void addChangeListener(JComponent comp) {
        if (comp instanceof KDBizPromptBox) {
            KDBizPromptBox biz = (KDBizPromptBox)comp;
            biz.addDataChangeListener(new DataChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void dataChanged(DataChangeEvent e) {
                    try {
                        UIContextManager.this.bizPromptBox_dataChange(e);
                    }
                    catch (Exception exc) {
                        UIContextManager.this.owner.handUIException((Throwable)exc);
                    }
                }
            });
        } else if (comp instanceof KDTable) {
            KDTable kdtEntrys = (KDTable)comp;
            kdtEntrys.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

                public void propertyChange(KDTPropertyChangeEvent e) {
                    try {
                        UIContextManager.this.tblDetail_dataChange(e);
                    }
                    catch (Exception exc) {
                        UIContextManager.this.owner.handUIException((Throwable)exc);
                    }
                }
            });
        } else if (comp instanceof KDComboBox) {
            KDComboBox kdtEntrys = (KDComboBox)comp;
            kdtEntrys.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        UIContextManager.this.cbo_itemStateChanged(e);
                    }
                    catch (Exception exc) {
                        UIContextManager.this.owner.handUIException((Throwable)exc);
                    }
                }
            });
        } else if (comp instanceof KDDatePicker) {
            KDDatePicker kdtEntrys = (KDDatePicker)comp;
            kdtEntrys.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        UIContextManager.this.dp_itemStateChanged(e);
                    }
                    catch (Exception exc) {
                        UIContextManager.this.owner.handUIException((Throwable)exc);
                    }
                }
            });
        }
    }

    private void dp_itemStateChanged(DataChangeEvent e) {
        Context delegatMainOrgContext = new Context();
        Object newValue = e.getNewValue();
        delegatMainOrgContext.put((Object)"NewValue", newValue);
        delegatMainOrgContext.put((Object)"event", (Object)e);
        this.changeUIContext(delegatMainOrgContext);
    }

    private void cbo_itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        Context delegatMainOrgContext = new Context();
        Object newValue = e.getItem();
        delegatMainOrgContext.put((Object)"NewValue", newValue);
        delegatMainOrgContext.put((Object)"event", (Object)e);
        this.changeUIContext(delegatMainOrgContext);
    }

    private void tblDetail_dataChange(KDTPropertyChangeEvent e) {
        if (GeneEqualsUtils.equals(e.getNewValue(), e.getOldValue())) {
            return;
        }
        Context delegatMainOrgContext = new Context();
        Object newValue = e.getNewValue();
        delegatMainOrgContext.put((Object)"NewValue", newValue);
        delegatMainOrgContext.put((Object)"event", (Object)e);
        this.changeUIContext(delegatMainOrgContext);
    }

    private void bizPromptBox_dataChange(DataChangeEvent e) throws Exception {
        Object[] no;
        if (GeneEqualsUtils.equals(e.getNewValue(), e.getOldValue())) {
            return;
        }
        Object o = e.getNewValue();
        Context delegatMainOrgContext = new Context();
        delegatMainOrgContext.put((Object)"NewValue", o);
        delegatMainOrgContext.put((Object)"event", (Object)e);
        if (o instanceof OrgUnitInfo) {
            OrgUnitInfo org = (OrgUnitInfo)o;
            if (org == null) {
                this.changeUIContext(delegatMainOrgContext);
                return;
            }
            FrameWorkUtils.switchOrg((Context)delegatMainOrgContext, (String)org.getId().toString());
            this.changeUIContext(delegatMainOrgContext);
            return;
        }
        if (o instanceof Object[] && (no = (Object[])o).length > 0 && no[0] instanceof OrgUnitInfo) {
            OrgUnitInfo org;
            ArrayList<String> coll = new ArrayList<String>();
            for (int i = 0; i < no.length; ++i) {
                org = (OrgUnitInfo)no[i];
                coll.add(org.getId().toString());
            }
            MutiOrgPermParam mutiOrgParam = new MutiOrgPermParam();
            org = (OrgUnitInfo)no[0];
            if (org instanceof StorageOrgUnitInfo) {
                mutiOrgParam.setOrgType(OrgType.Storage);
            }
            mutiOrgParam.setOrgIdList(coll);
            FrameWorkUtils.switchOrg((Context)delegatMainOrgContext, (String)org.getId().toString());
            delegatMainOrgContext.put((Object)"MUTI_ORG_INFO", (Object)mutiOrgParam);
            this.changeUIContext(delegatMainOrgContext);
            return;
        }
        this.changeUIContext(delegatMainOrgContext);
    }

    @Override
    public void addChangeListener(KDTable kdtEntrys, String colName) {
        final int idex = kdtEntrys.getColumnIndex(colName);
        kdtEntrys.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent e) {
                try {
                    if (e.getColIndex() == idex) {
                        UIContextManager.this.tblDetail_dataChange(e);
                    }
                }
                catch (Exception exc) {
                    UIContextManager.this.owner.handUIException((Throwable)exc);
                }
            }
        });
    }

    @Override
    public void addKDTSelectListener(KDTable kdtEntrys) {
        kdtEntrys.addKDTSelectListener(new KDTSelectListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    UIContextManager.this.kdtEntrys_tableSelectChanged(e);
                }
                catch (Exception exc) {
                    UIContextManager.this.owner.handUIException((Throwable)exc);
                }
            }
        });
    }

    @Override
    public void addChangeListener(final KDTabbedPane comp, final KDPanel panel) {
        comp.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    if (comp.getSelectedComponent() == panel) {
                        UIContextManager.this.paneBIZ_stateChanged(e);
                    }
                }
                catch (Exception exc) {
                    UIContextManager.this.owner.handUIException((Throwable)exc);
                }
            }
        });
    }

    protected void paneBIZ_stateChanged(ChangeEvent e) throws Exception {
        Context delegatMainOrgContext = new Context();
        delegatMainOrgContext.put((Object)"event", (Object)e);
        this.changeUIContext(delegatMainOrgContext);
    }

    protected void kdtEntrys_tableSelectChanged(KDTSelectEvent e) throws Exception {
        Context delegatMainOrgContext = new Context();
        KDTSelectBlock newValue = e.getSelectBlock();
        delegatMainOrgContext.put((Object)"NewValue", (Object)newValue);
        delegatMainOrgContext.put((Object)"event", (Object)e);
        this.changeUIContext(delegatMainOrgContext);
    }

    @Override
    public void addChangeListener(final KDTable kdtEntrys, final String[] colNames) {
        kdtEntrys.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent e) {
                try {
                    for (int i = 0; i < colNames.length; ++i) {
                        int idex = kdtEntrys.getColumnIndex(colNames[i]);
                        if (e.getColIndex() != idex) continue;
                        UIContextManager.this.tblDetail_dataChange(e);
                    }
                }
                catch (Exception exc) {
                    UIContextManager.this.owner.handUIException((Throwable)exc);
                }
            }
        });
    }

    @Override
    public void addRowLoadedListener(KDTable kdtEntrys, DataBinder dataBinder) {
        PropertyChangeListener propertyLsn = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                UIContextManager.this.tblDetail_loadLine(evt);
            }
        };
        dataBinder.addPropertyChangeListener("loadLine", propertyLsn);
    }

    @Override
    public void addRowStoredListener(KDTable kdtEntrys, DataBinder dataBinder) {
        PropertyChangeListener propertyLsn = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                UIContextManager.this.tblDetail_storeLine(evt);
            }
        };
        dataBinder.addPropertyChangeListener("storeLine", propertyLsn);
    }

    private void tblDetail_loadLine(PropertyChangeEvent e) {
        Context delegatMainOrgContext = new Context();
        Object newValue = e.getNewValue();
        delegatMainOrgContext.put((Object)"NewValue", newValue);
        delegatMainOrgContext.put((Object)"event", (Object)e);
        this.changeUIContext(delegatMainOrgContext);
    }

    private void tblDetail_storeLine(PropertyChangeEvent e) {
        Context delegatMainOrgContext = new Context();
        Object newValue = e.getNewValue();
        delegatMainOrgContext.put((Object)"NewValue", newValue);
        delegatMainOrgContext.put((Object)"event", (Object)e);
        this.changeUIContext(delegatMainOrgContext);
    }
}

