/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.core.client.listener;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.eas.eqm.common.core.client.listener.GeneTableColumnListener;
import com.kingdee.eas.eqm.common.core.util.GeneEqualsUtils;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;

public class GeneKDTable {
    private KDTable table;
    private KDTEditAdapter innerStopAdapter = null;

    public GeneKDTable(KDTable table) {
        this.table = table;
        this.initListener();
    }

    private void initListener() {
        if (this.innerStopAdapter == null) {
            this.innerStopAdapter = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        GeneKDTable.this.fireTableColumnChangeListener(this, e);
                    }
                    catch (Exception exc) {
                        ExceptionHandler.handle((Component)GeneKDTable.this.table, (Throwable)exc);
                    }
                }
            };
        }
        this.table.addKDTEditListener((KDTEditListener)this.innerStopAdapter);
    }

    protected void fireTableColumnChangeListener(KDTEditAdapter editAdapter, KDTEditEvent e) {
        Object[] listeners = this.table.getListenerList().getListenerList();
        boolean isEquals = GeneEqualsUtils.equals(e.getOldValue(), e.getValue());
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            GeneTableColumnListener tableColumnListener;
            if (listeners[i] != GeneTableColumnListener.class || !(tableColumnListener = (GeneTableColumnListener)listeners[i + 1]).isEnabled() || !tableColumnListener.getColumnName().equalsIgnoreCase(this.table.getColumn(e.getColIndex()).getKey()) || (!tableColumnListener.isTriggerOnNoChange() || !isEquals) && isEquals) continue;
            tableColumnListener.tableColumnChanged(e);
        }
    }

    public void addTableColumnListener(GeneTableColumnListener l) {
        this.table.getListenerList().add(GeneTableColumnListener.class, l);
    }

    public void removeTableColumnListener(GeneTableColumnListener l) {
        this.table.getListenerList().remove(GeneTableColumnListener.class, l);
    }

    public void disableTableColumnListener(String columnName) {
        this.activeTableColumnListener(false, columnName);
    }

    private void activeTableColumnListener(boolean enabled, String columnName) {
        Object[] listeners = this.table.getListenerList().getListenerList();
        int n = listeners.length;
        for (int i = 0; i < n; ++i) {
            GeneTableColumnListener tableColumnListener;
            if (listeners[i] != GeneTableColumnListener.class || !(tableColumnListener = (GeneTableColumnListener)listeners[i + 1]).getColumnName().equalsIgnoreCase(columnName)) continue;
            tableColumnListener.setEnabled(enabled);
        }
    }

    public void enabledTableColumnListener(String columnName) {
        this.activeTableColumnListener(true, columnName);
    }
}

