/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.core.client.tree;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.eqm.common.core.IGeneCoreTreeBaseInfo;
import com.kingdee.eas.eqm.common.core.client.tree.IGeneLNTreeNodeCtrl;
import com.kingdee.eas.eqm.common.core.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class GeneLNTreeBuilder
implements ITreeBuilder {
    private IGeneLNTreeNodeCtrl ctrl;
    private int initalLevel;
    private int expandLevel;
    private FilterInfo filter;
    private SelectorItemCollection selector;
    private FilterInfo defaultFilter;

    public GeneLNTreeBuilder(IGeneLNTreeNodeCtrl ctrl, int initalLevel, int expandLevel) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
    }

    public GeneLNTreeBuilder(IGeneLNTreeNodeCtrl ctrl, int initalLevel, int expandLevel, FilterInfo filter, FilterInfo defaultFilter) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
        this.filter = filter;
        this.defaultFilter = defaultFilter;
    }

    public GeneLNTreeBuilder(IGeneLNTreeNodeCtrl ctrl, int initalLevel, int expandLevel, FilterInfo filter, SelectorItemCollection selector, FilterInfo defaultFilter) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
        this.filter = filter;
        this.selector = selector;
        this.defaultFilter = defaultFilter;
    }

    @Override
    public void setExpandLevel(int expandLevel) {
        this.expandLevel = expandLevel;
    }

    @Override
    public KDTree buildTree(KDTree tree) throws Exception {
        TreeSelectionListener[] selectionListeners;
        TreeExpansionListener[] listeners;
        if (tree == null) {
            tree = new KDTree(false);
        }
        if ((listeners = tree.getTreeExpansionListeners()) != null && listeners.length > 0) {
            for (int i = 0; i < listeners.length; ++i) {
            }
        }
        if ((selectionListeners = tree.getTreeSelectionListeners()) != null && selectionListeners.length > 0) {
            for (int i = 0; i < selectionListeners.length; ++i) {
                tree.removeTreeSelectionListener(selectionListeners[i]);
            }
        }
        KDTreeNode rootNode = null;
        if (tree.getModel() != null && tree.getModel().getRoot() != null && tree.getModel().getRoot() instanceof KDTreeNode) {
            rootNode = (KDTreeNode)tree.getModel().getRoot();
        } else {
            rootNode = new KDTreeNode(null);
            tree.setRootVisible(false);
        }
        AbstractObjectCollection col = rootNode.getUserObject() != null && rootNode.getUserObject() instanceof IGeneCoreTreeBaseInfo ? this.ctrl.getChildren((IGeneCoreTreeBaseInfo)rootNode.getUserObject(), this.initalLevel, this.filter, this.selector) : this.ctrl.getChildren(null, this.initalLevel, this.filter, this.selector);
        tree.setShowsRootHandles(true);
        this.buildChildren(tree, rootNode, col, this.initalLevel);
        ((DefaultTreeModel)tree.getModel()).setRoot((TreeNode)rootNode);
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTree tree = (KDTree)event.getSource();
                try {
                    KDTreeNode treeNode = (KDTreeNode)event.getPath().getLastPathComponent();
                    if (GeneLNTreeBuilder.this.defaultFilter != null) {
                        GeneLNTreeBuilder.this.getChildren(tree, treeNode, GeneLNTreeBuilder.this.defaultFilter);
                    } else {
                        GeneLNTreeBuilder.this.getChildren(tree, treeNode);
                    }
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                KDTree tree = (KDTree)e.getSource();
                try {
                    KDTreeNode treeNode = (KDTreeNode)e.getPath().getLastPathComponent();
                    if (GeneLNTreeBuilder.this.defaultFilter != null) {
                        GeneLNTreeBuilder.this.getChildren(tree, treeNode, GeneLNTreeBuilder.this.defaultFilter);
                    } else {
                        GeneLNTreeBuilder.this.getChildren(tree, treeNode);
                    }
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        return tree;
    }

    @Override
    public void getChildren(KDTree tree, KDTreeNode treeNode) throws Exception {
        if (treeNode.isVirtual()) {
            IGeneCoreTreeBaseInfo treeNodeInfo = null;
            if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof IGeneCoreTreeBaseInfo) {
                treeNodeInfo = (IGeneCoreTreeBaseInfo)treeNode.getUserObject();
            }
            treeNode.setVirtual(false);
            tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
            AbstractObjectCollection col = this.ctrl.getChildren(treeNodeInfo, this.expandLevel);
            this.buildChildren(tree, treeNode, col, this.expandLevel);
        }
    }

    private void buildChildren(KDTree tree, KDTreeNode parentNode, AbstractObjectCollection col, int level) {
        KDTreeNode beforeTreeNode = parentNode;
        IGeneCoreTreeBaseInfo parentNodeInfo = null;
        if (parentNode.getUserObject() instanceof IGeneCoreTreeBaseInfo) {
            parentNodeInfo = (IGeneCoreTreeBaseInfo)parentNode.getUserObject();
        }
        for (IGeneCoreTreeBaseInfo treeNodeInfo : col) {
            if (parentNodeInfo != null && treeNodeInfo.getLongNumber().equals(parentNodeInfo.getLongNumber())) {
                parentNode.setUserObject((Object)treeNodeInfo);
                continue;
            }
            KDTreeNode treeNode = new KDTreeNode((Object)treeNodeInfo);
            if (treeNodeInfo.isIsLeaf()) {
                treeNode.setVirtual(false);
            } else {
                treeNode.setVirtual(true);
                treeNode.add((MutableTreeNode)new DefaultMutableTreeNode());
            }
            if (beforeTreeNode.getLevel() == 0) {
                int index = beforeTreeNode.getChildCount();
                tree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode, index);
            } else {
                int curLevel = treeNodeInfo.getLevel();
                for (int beforeLevel = ((IGeneCoreTreeBaseInfo)beforeTreeNode.getUserObject()).getLevel(); beforeLevel >= curLevel && beforeTreeNode.getParent() != null; --beforeLevel) {
                    beforeTreeNode = (KDTreeNode)beforeTreeNode.getParent();
                }
                int index = beforeTreeNode.getChildCount();
                tree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode, index);
            }
            beforeTreeNode = treeNode;
        }
    }

    @Override
    public void refreshTreeNode(KDTree tree, KDTreeNode treeNode) throws Exception {
        treeNode.setVirtual(true);
        this.getChildren(tree, treeNode);
    }

    @Override
    public void refreshTreeNode(KDTree tree, KDTreeNode treeNode, FilterInfo filter) throws Exception {
        treeNode.setVirtual(true);
        this.getChildren(tree, treeNode, filter);
    }

    @Override
    public void getChildren(KDTree tree, KDTreeNode treeNode, FilterInfo filter) throws Exception {
        if (treeNode.isVirtual()) {
            IGeneCoreTreeBaseInfo treeNodeInfo = null;
            if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof IGeneCoreTreeBaseInfo) {
                treeNodeInfo = (IGeneCoreTreeBaseInfo)treeNode.getUserObject();
            }
            treeNode.setVirtual(false);
            tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
            AbstractObjectCollection col = this.ctrl.getChildren(treeNodeInfo, this.expandLevel, filter);
            this.buildChildren(tree, treeNode, col, this.expandLevel);
        }
    }

    @Override
    public KDTree buildTree(KDTree tree, FilterInfo filter) throws Exception {
        this.filter = filter;
        return this.buildTree(tree);
    }

    @Override
    public void setFilter(FilterInfo filter) {
        this.filter = filter;
    }

    @Override
    public FilterInfo getFilter() {
        return this.filter;
    }

    @Override
    public KDTree buildTree(KDTree tree, FilterInfo filter, CoreUI ui) throws Exception {
        return null;
    }
}

