/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.core.client.tree;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.eqm.common.core.IGeneCoreTreeBaseInfo;
import com.kingdee.eas.eqm.common.core.client.tree.GeneLNTreeBuilder;
import com.kingdee.eas.eqm.common.core.client.tree.GeneLNTreeNodeCtrl;
import com.kingdee.eas.eqm.common.core.client.tree.GeneMoveTreeEvent;
import com.kingdee.eas.eqm.common.core.client.tree.GeneTreeObject;
import com.kingdee.eas.eqm.common.core.client.tree.IGeneLNTreeNodeCtrl;
import com.kingdee.eas.eqm.common.core.client.tree.IGeneMoveTreeListener;
import com.kingdee.eas.eqm.common.core.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.util.StringUtility;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class GeneMoveTree
extends KDDialog {
    protected Logger logger;
    protected ResourceBundleHelper resHelper = null;
    protected KDTree treeMain;
    protected KDTreeView treeView;
    protected KDButton btnSelect;
    protected KDButton btnCancel;
    private String title = "";
    private String RootName = "";
    private Frame parentFrame = null;
    protected EntityViewInfo mainQuery = null;
    private IGeneCoreTreeBaseInfo sourceTree = null;
    private boolean isMoveTree = false;
    private FilterInfo treeFilter;
    private FilterInfo defaultFilter;
    private Set listeners = new HashSet();
    private TreeSelectionListener treeSelectionListener;
    protected ITreeBuilder treeBuilder;
    private ICoreBase itree;

    public GeneMoveTree(Frame comp, String title, String RootName, ICoreBase iTreeBase, IGeneCoreTreeBaseInfo sourceTree, boolean isMoveTree, FilterInfo treeFilter, FilterInfo defaultFilter) throws Exception {
        super(comp, title, true);
        this.initDialog(title, RootName, iTreeBase, sourceTree, isMoveTree, treeFilter, defaultFilter);
    }

    public GeneMoveTree(Dialog comp, String title, String RootName, ICoreBase iTreeBase, IGeneCoreTreeBaseInfo sourceTree, boolean isMoveTree, FilterInfo treeFilter, FilterInfo defaultFilter) throws Exception {
        super(comp, title, true);
        this.initDialog(title, RootName, iTreeBase, sourceTree, isMoveTree, treeFilter, defaultFilter);
    }

    public GeneMoveTree(Component comp, String title, String RootName, ICoreBase iTreeBase, IGeneCoreTreeBaseInfo sourceTree, boolean isMoveTree, FilterInfo treeFilter, FilterInfo defaultFilter) throws Exception {
        super((Frame)ComponentUtil.getOwnerWindow((Component)comp), title, true);
        this.initDialog(title, RootName, iTreeBase, sourceTree, isMoveTree, treeFilter, defaultFilter);
    }

    private void initDialog(String title, String RootName, ICoreBase iTreeBase, IGeneCoreTreeBaseInfo sourceTree, boolean isMoveTree, FilterInfo treeFilter, FilterInfo defaultFilter) throws Exception {
        this.title = title;
        this.RootName = RootName;
        this.itree = iTreeBase;
        this.sourceTree = sourceTree;
        this.isMoveTree = isMoveTree;
        this.treeFilter = treeFilter;
        this.sourceTree = sourceTree;
        this.defaultFilter = defaultFilter;
        this.logger = Logger.getLogger(GeneMoveTree.class);
        this.jbInit();
        this.initUIContentLayout();
        this.initListener();
        this.initTree();
        this.treeMain.setSelectionRow(0);
    }

    private void jbInit() throws Exception {
        MetaDataPK meta = new MetaDataPK("com.kingdee.eas.eqm.common.core.client.tree", "GeneMoveTree");
        this.resHelper = new ResourceBundleHelper(meta.getFullName());
        if (this.title.trim().equals("")) {
            this.setTitle(this.resHelper.getString("this.title"));
        } else {
            this.setTitle(this.title);
        }
        this.treeMain = new KDTree();
        this.treeView = new KDTreeView();
        this.btnSelect = new KDButton();
        this.btnCancel = new KDButton();
        this.treeMain.setName("treeMain");
        this.treeView.setName("treeView");
        this.btnSelect.setName("btnSelect");
        this.btnCancel.setName("btnCancel");
        this.setName("MoveTree");
        this.treeView.setShowControlPanel(false);
        this.btnSelect.setText(this.resHelper.getString("btnSelect.text"));
        this.btnCancel.setText(this.resHelper.getString("btnCancel.text"));
    }

    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 300, 420));
        this.getContentPane().setLayout(null);
        this.treeView.setBounds(new Rectangle(10, 10, 280, 352));
        this.treeView.setPreferredSize(new Dimension(280, 352));
        this.getContentPane().add((Component)this.treeView, null);
        this.btnSelect.setBounds(new Rectangle(137, 369, 73, 21));
        this.getContentPane().add((Component)this.btnSelect, null);
        this.btnCancel.setBounds(new Rectangle(217, 369, 73, 21));
        this.getContentPane().add((Component)this.btnCancel, null);
        this.treeView.setTree(this.treeMain);
        this.treeMain.setVisible(true);
        this.setResizable(false);
    }

    public void initListener() {
        this.getRootPane().setDefaultButton((JButton)this.btnSelect);
        this.btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneMoveTree.this.fireSelectTree();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneMoveTree.this.fireCancel();
                GeneMoveTree.this.dispose();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMoveTreeListener(IGeneMoveTreeListener moveTreeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(moveTreeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSelectTree() {
        Iterator iterator;
        Set set = this.listeners;
        synchronized (set) {
            iterator = new HashSet(this.listeners).iterator();
        }
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.eqm.common.core.GeneResource", (String)"Msg_MustSelectNode"));
            return;
        }
        GeneTreeObject content = new GeneTreeObject();
        if (!(treeNode.getUserObject() instanceof IGeneCoreTreeBaseInfo)) {
            content.setTargetTreeBaseInfo(null);
        } else {
            content.setTargetTreeBaseInfo((IGeneCoreTreeBaseInfo)treeNode.getUserObject());
        }
        content.setTargetNode(this.getSelectedTreeNode());
        content.setSourceTreeBaseInfo(this.sourceTree);
        if (content.getSourceTreeBaseInfo() != null && content.getTargetTreeBaseInfo() != null && content.getTargetTreeBaseInfo().getLongNumber().length() > content.getSourceTreeBaseInfo().getLongNumber().length() && this.isMoveTree && StringUtility.isMatch((String)content.getTargetTreeBaseInfo().getLongNumber().substring(0, content.getSourceTreeBaseInfo().getLongNumber().length()), (String)content.getSourceTreeBaseInfo().getLongNumber(), (boolean)true) && content.getTargetTreeBaseInfo().getLongNumber().toLowerCase().startsWith(content.getSourceTreeBaseInfo().getLongNumber().toLowerCase() + "!")) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.", (String)"Msg_ParentCanNotMoveChild"));
            return;
        }
        GeneMoveTreeEvent moveTreeEvent = new GeneMoveTreeEvent((Object)this, content);
        while (iterator.hasNext()) {
            IGeneMoveTreeListener moveTreeListener = (IGeneMoveTreeListener)iterator.next();
            moveTreeListener.SelectTreeNode(moveTreeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCancel() {
        Iterator iterator;
        Set set = this.listeners;
        synchronized (set) {
            iterator = new HashSet(this.listeners).iterator();
        }
        GeneTreeObject content = new GeneTreeObject();
        GeneMoveTreeEvent moveTreeEvent = new GeneMoveTreeEvent((Object)this, content);
        while (iterator.hasNext()) {
            IGeneMoveTreeListener moveTreeListener = (IGeneMoveTreeListener)iterator.next();
            moveTreeListener.SelectTreeCancel(moveTreeEvent);
        }
    }

    public void setDataObject(IObjectValue dataObject) {
    }

    protected void initTree() throws Exception {
        this.treeBuilder = this.createTreeBuilder(this.getLNTreeNodeCtrl(), this.getTreeInitialLevel(), this.getTreeExpandLevel(), this.treeFilter, null, this.defaultFilter);
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode(this.getRootObject());
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot((TreeNode)rootNode);
        } else {
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
        }
        this.treeBuilder.buildTree(this.treeMain);
    }

    public ITreeBuilder createTreeBuilder(IGeneLNTreeNodeCtrl ctrl, int initialLevel, int expandLevel, FilterInfo filter, SelectorItemCollection selector, FilterInfo defaultFilter) {
        GeneLNTreeBuilder treeBuilder = null;
        treeBuilder = new GeneLNTreeBuilder(ctrl, initialLevel, expandLevel, filter, selector, defaultFilter);
        return treeBuilder;
    }

    protected IGeneLNTreeNodeCtrl getLNTreeNodeCtrl() throws Exception {
        return new GeneLNTreeNodeCtrl(this.getTreeInterface());
    }

    protected int getTreeInitialLevel() {
        return 3;
    }

    protected int getTreeExpandLevel() {
        return 3;
    }

    protected String getRootName() {
        return this.RootName;
    }

    protected Object getRootObject() {
        return this.getRootName();
    }

    protected ICoreBase getTreeInterface() throws Exception {
        return this.itree;
    }

    public KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
    }

    protected String getLongNumberFieldName() {
        return "longNumber";
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        return sic;
    }
}

