/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.IPayRequestBill;
import com.kingdee.eas.fi.ap.IPayRequestBillEntry;
import com.kingdee.eas.fi.ap.IPayRequestSumEntry;
import com.kingdee.eas.fi.ap.OtherBillDisposer;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.PayRequestBillBizException;
import com.kingdee.eas.fi.ap.PayRequestBillEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryFactory;
import com.kingdee.eas.fi.ap.PayRequestBillEntryInfo;
import com.kingdee.eas.fi.ap.PayRequestBillFactory;
import com.kingdee.eas.fi.ap.PayRequestSumEntryFactory;
import com.kingdee.eas.fi.ap.PayRequestSumEntryInfo;
import com.kingdee.eas.fi.ap.app.util.ApServerUtils;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.util.RecPayServiceUtil;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApBillReverseHelper;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.arap.util.ArApSelectorFactory;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.sm.pur.IPurContractEntry;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.PurContractEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.sc.ISubContractOrderEntry;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryFactory;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PayRequestBillDisposer
implements IPaymentDisposer {
    private static Logger logger = Logger.getLogger(PayRequestBillDisposer.class);
    private static final String RESOURCE = "com.kingdee.eas.fi.arap.ARAPAutoGenerateResource";
    public static final String CTRL = "\r\n";

    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        DisposerActionEnum actionType = action.getActionType();
        PaymentBillInfo info = (PaymentBillInfo)action.getDestBill();
        if (DisposerActionEnum.PAY.equals((Object)actionType)) {
            this.dispose4Pay(ctx, info);
        } else if (DisposerActionEnum.CANCEL_PAY.equals((Object)actionType)) {
            this.dispose4CancelPay(ctx, info);
        } else if (DisposerActionEnum.ReqPay_SAVE.equals((Object)actionType)) {
            this.dispose4Save(ctx, info);
        } else if (DisposerActionEnum.ReqPay_SUBMIT.equals((Object)actionType)) {
            this.dispose4Submit(ctx, info);
        } else if (DisposerActionEnum.ReqPay_DELETE.equals((Object)actionType)) {
            this.dispose4Delete(ctx, info);
        } else if (DisposerActionEnum.SAVE.equals((Object)actionType)) {
            this.dispose4addNew(ctx, info);
        }
    }

    public void dispose4addNew(Context ctx, PaymentBillInfo payBillInfo) throws BOSException, EASBizException {
        if (com.kingdee.eas.fi.cas.BillStatusEnum.PAYED.equals((Object)payBillInfo.getBillStatus())) {
            ArApBillReverseHelper.reverseLockAmt(ctx, (RecPayBillInfo)payBillInfo, BOTBillOperStateEnum.ADDNEW);
        }
    }

    public void dispose4Save(Context ctx, PaymentBillInfo payBillInfo) throws BOSException, EASBizException {
        RecPayServiceUtil.reversePayAmountFields((Context)ctx, (PaymentBillInfo)payBillInfo, (BatchActionEnum)BatchActionEnum.SAVE);
    }

    public void dispose4Submit(Context ctx, PaymentBillInfo payBillInfo) throws BOSException, EASBizException {
        RecPayServiceUtil.reversePayAmountFields((Context)ctx, (PaymentBillInfo)payBillInfo, (BatchActionEnum)BatchActionEnum.SUBMIT);
    }

    public void dispose4Delete(Context ctx, PaymentBillInfo payBillInfo) throws BOSException, EASBizException {
        ArApBillReverseHelper.reverseLockAmt(ctx, (RecPayBillInfo)payBillInfo, BOTBillOperStateEnum.DELETE);
    }

    public void dispose4Pay(Context ctx, PaymentBillInfo payBillInfo) throws BOSException, EASBizException {
        PaymentBillEntryCollection payEntryCol = payBillInfo.getEntries();
        PayRequestBillEntryInfo payrequestEntry = null;
        IPayRequestBillEntry iPayReqEntry = PayRequestBillEntryFactory.getLocalInstance(ctx);
        PayRequestSumEntryInfo payRequestSumEntry = null;
        IPayRequestBill iPayRequestBill = PayRequestBillFactory.getLocalInstance(ctx);
        IPayRequestSumEntry iPayRequestSumEntry = PayRequestSumEntryFactory.getLocalInstance(ctx);
        String paymentBillID = payBillInfo.getId().toString();
        String coreBillId = null;
        boolean coreBillIsPurOrder = false;
        boolean coreBillIsTransOrder = false;
        String payReqEnrySourceBillId = null;
        StringBuilder coreBillIdBuf = new StringBuilder(100);
        String disposerName = null;
        String sourceBillID = null;
        String sourceBillEntryID = null;
        HashSet<String> srcBillIdSet = new HashSet<String>();
        boolean isFromPayReqSumEntry = false;
        BigDecimal payEntryAmt = BigDecimal.ZERO;
        BigDecimal entryUnPaidAmt = BigDecimal.ZERO;
        HashMap<String, BigDecimal> purConSrcEntryWriteOffAmtMap = new HashMap<String, BigDecimal>();
        IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance((Context)ctx);
        ISubContractOrderEntry iSubContractOrderEntry = SubContractOrderEntryFactory.getLocalInstance((Context)ctx);
        boolean orderPayment = ArApParamHelper.isPrePayAmoutCanOverOrderPrepayAmt(ctx, payBillInfo.getCompany().getId().toString());
        boolean purContractPayment = ArApParamHelper.isPrePayAmtCanOverPurContractAmt(ctx, payBillInfo.getCompany().getId().toString());
        PayRequestBillEntryInfo groupRequestEntry = null;
        HashSet<String> entryIdSet = new HashSet<String>();
        for (int i = 0; i < payEntryCol.size(); ++i) {
            PaymentBillEntryInfo payEntryInfo = payEntryCol.get(i);
            payEntryAmt = payEntryInfo.getAmount();
            sourceBillID = payEntryInfo.getSourceBillId();
            sourceBillEntryID = payEntryInfo.getSourceBillEntryId();
            if (sourceBillID == null || sourceBillEntryID == null) continue;
            srcBillIdSet.add(sourceBillID);
            CoreBaseCollection updatePayRequestBillEntryColl = new CoreBaseCollection();
            CoreBaseCollection updatePurOrderEntryColl = new CoreBaseCollection();
            CoreBaseCollection updateSubContractOrderEntryColl = new CoreBaseCollection();
            if (ApServerUtils.isPayReqSumEntry((String)sourceBillEntryID)) {
                isFromPayReqSumEntry = true;
                payRequestSumEntry = iPayRequestSumEntry.getPayRequestSumEntryInfo((IObjectPK)new ObjectUuidPK(sourceBillEntryID));
                if (payRequestSumEntry.getAuditAmount().abs().compareTo(payEntryAmt.abs().add(payRequestSumEntry.getPayedAmt().abs())) < 0) {
                    throw new EASBizException(new NumericExceptionSubItem("603", ResourceBase.getString((String)RESOURCE, (String)"44_PayRequestBillDisposer", (Locale)ctx.getLocale())));
                }
                payRequestSumEntry.setPayedAmt(payEntryAmt.add(payRequestSumEntry.getPayedAmt()));
                if (payRequestSumEntry.getUnpayAmount().abs().subtract(payEntryAmt.abs()).compareTo(BigDecimal.ZERO) < 0) {
                    throw new EASBizException(new NumericExceptionSubItem("603", ResourceBase.getString((String)RESOURCE, (String)"45_PayRequestBillDisposer", (Locale)ctx.getLocale())));
                }
                payRequestSumEntry.setUnpayAmount(payRequestSumEntry.getUnpayAmount().subtract(payEntryAmt));
                iPayRequestSumEntry.update((IObjectPK)new ObjectUuidPK(sourceBillEntryID), payRequestSumEntry);
                PayRequestBillEntryCollection payRequestBillEntry = this.getPayReqEntryCollBySumEntryID(iPayReqEntry, payRequestSumEntry.getId().toString());
                HashSet<String> sumRelEntryId = new HashSet<String>();
                for (int j = 0; j < payRequestBillEntry.size(); ++j) {
                    sumRelEntryId.add(payRequestBillEntry.get(j).getId().toString());
                }
                ArApServerUtils.addSQLLock((Context)ctx, sumRelEntryId);
                Iterator reqEntryIterator = payRequestBillEntry.iterator();
                String sourceBillId = null;
                BigDecimal rowAllowanceAmt = BigDecimal.ZERO;
                String entryId = null;
                String reqSourceBillEntryId = null;
                while (reqEntryIterator.hasNext()) {
                    SubContractOrderEntryInfo subContractOrderEntryInfo;
                    groupRequestEntry = (PayRequestBillEntryInfo)reqEntryIterator.next();
                    entryId = groupRequestEntry.getId().toString();
                    sourceBillId = groupRequestEntry.getSourceBillId();
                    reqSourceBillEntryId = groupRequestEntry.getSourceBillEntryId();
                    entryUnPaidAmt = groupRequestEntry.getUnpayAmount();
                    if (payEntryAmt.compareTo(entryUnPaidAmt) <= 0) {
                        groupRequestEntry.setUnpayAmount(groupRequestEntry.getUnpayAmount().subtract(payEntryAmt));
                        groupRequestEntry.setTotalPayAmt(groupRequestEntry.getTotalPayAmt().add(payEntryAmt));
                        rowAllowanceAmt = payEntryAmt;
                    } else {
                        groupRequestEntry.setUnpayAmount(BigDecimal.ZERO);
                        groupRequestEntry.setTotalPayAmt(groupRequestEntry.getTotalPayAmt().add(entryUnPaidAmt));
                        rowAllowanceAmt = entryUnPaidAmt;
                    }
                    if (groupRequestEntry.isIsManualClose()) {
                        throw new PayRequestBillBizException(PayRequestBillBizException.PAY_HASCLOSE_UNCLOASE_FIRST);
                    }
                    if (groupRequestEntry.getTotalPayAmt().compareTo(groupRequestEntry.getAuditAmount()) == 0) {
                        entryIdSet.add(entryId);
                        groupRequestEntry.setEntryStatus(BillStatusEnum.COLSED);
                    }
                    if (sourceBillId != null && BOSUuid.read((String)sourceBillId).getType().toString().equals("78B50853")) {
                        if (purConSrcEntryWriteOffAmtMap.get(reqSourceBillEntryId) != null) {
                            purConSrcEntryWriteOffAmtMap.put(reqSourceBillEntryId, ((BigDecimal)purConSrcEntryWriteOffAmtMap.get(reqSourceBillEntryId)).add(rowAllowanceAmt));
                        } else {
                            purConSrcEntryWriteOffAmtMap.put(reqSourceBillEntryId, rowAllowanceAmt);
                        }
                    }
                    updatePayRequestBillEntryColl.add((CoreBaseInfo)groupRequestEntry);
                    payEntryAmt = payEntryAmt.subtract(rowAllowanceAmt);
                    coreBillId = groupRequestEntry.getCoreBillId();
                    String coreBillEntryId = groupRequestEntry.getCoreBillEntryId();
                    if (StringUtils.isEmpty((String)coreBillId) || StringUtils.isEmpty((String)coreBillEntryId)) continue;
                    coreBillIdBuf.append("'").append(coreBillId).append("',");
                    if ("3171BFAD".equals(BOSUuid.read((String)coreBillId).getType().toString())) {
                        PurOrderEntryInfo purOrderEntryInfo = this.writingBackPurOrderEntry(ctx, iPurOrderEntry, payBillInfo.getPayBillType().isPrePay(), rowAllowanceAmt, coreBillEntryId, orderPayment, true);
                        if (null != purOrderEntryInfo) {
                            coreBillIsPurOrder = true;
                            updatePurOrderEntryColl.add((CoreBaseInfo)purOrderEntryInfo);
                        }
                    } else if ("F99EE589".equals(BOSUuid.read((String)coreBillId).getType().toString()) && null != (subContractOrderEntryInfo = this.writingBackSubContractOrderEntry(ctx, iSubContractOrderEntry, rowAllowanceAmt, coreBillEntryId, true))) {
                        coreBillIsTransOrder = true;
                        updateSubContractOrderEntryColl.add((CoreBaseInfo)subContractOrderEntryInfo);
                    }
                    if (payEntryAmt.compareTo(BigDecimal.ZERO) > 0) continue;
                    break;
                }
                if (disposerName == null) {
                    payReqEnrySourceBillId = sourceBillId;
                }
                iPayReqEntry.update(updatePayRequestBillEntryColl);
            } else {
                SubContractOrderEntryInfo subContractOrderEntryInfo;
                ArApServerUtils.addSQLLock((Context)ctx, (Object)sourceBillEntryID);
                payrequestEntry = iPayReqEntry.getPayRequestBillEntryInfo((IObjectPK)new ObjectUuidPK(sourceBillEntryID));
                if (payrequestEntry.getAuditAmount().abs().compareTo(payEntryInfo.getAmount().abs().add(payrequestEntry.getTotalPayAmt().abs())) < 0) {
                    throw new EASBizException(new NumericExceptionSubItem("603", ResourceBase.getString((String)RESOURCE, (String)"44_PayRequestBillDisposer", (Locale)ctx.getLocale())));
                }
                payrequestEntry.setTotalPayAmt(payEntryInfo.getAmount().add(payrequestEntry.getTotalPayAmt()));
                if (payrequestEntry.getUnpayAmount().abs().subtract(payEntryInfo.getAmount().abs()).compareTo(BigDecimal.ZERO) < 0) {
                    throw new EASBizException(new NumericExceptionSubItem("603", ResourceBase.getString((String)RESOURCE, (String)"45_PayRequestBillDisposer", (Locale)ctx.getLocale())));
                }
                payrequestEntry.setUnpayAmount(payrequestEntry.getUnpayAmount().subtract(payEntryInfo.getAmount()));
                if (payrequestEntry.isIsManualClose()) {
                    throw new PayRequestBillBizException(PayRequestBillBizException.PAY_HASCLOSE_UNCLOASE_FIRST);
                }
                if (payrequestEntry.getTotalPayAmt().compareTo(payrequestEntry.getAuditAmount()) == 0) {
                    payrequestEntry.setEntryStatus(BillStatusEnum.COLSED);
                    entryIdSet.add(payrequestEntry.getId().toString());
                }
                iPayReqEntry.update((IObjectPK)new ObjectUuidPK(sourceBillEntryID), (CoreBaseInfo)payrequestEntry);
                String sourceBillId = payrequestEntry.getSourceBillId();
                String sourceBillentryId = payrequestEntry.getSourceBillEntryid();
                if (disposerName == null) {
                    disposerName = this.getDisposerBySourceBillID(payBillInfo, payrequestEntry.getSourceBillId());
                }
                if (disposerName != null) {
                    payEntryInfo.setSourceBillId(sourceBillId);
                    payEntryInfo.setSourceBillEntryId(sourceBillentryId);
                    payBillInfo.setSourceBillId(payrequestEntry.getParent().getId().toString());
                }
                Object contractEntryInfo = null;
                if (sourceBillId != null && sourceBillentryId != null && "78B50853".equals(BOSUuid.read((String)sourceBillId).getType().toString())) {
                    if (purConSrcEntryWriteOffAmtMap.get(sourceBillentryId) == null) {
                        purConSrcEntryWriteOffAmtMap.put(sourceBillentryId, payEntryInfo.getAmount());
                    } else {
                        purConSrcEntryWriteOffAmtMap.put(sourceBillentryId, ((BigDecimal)purConSrcEntryWriteOffAmtMap.get(sourceBillentryId)).add(payEntryInfo.getAmount()));
                    }
                }
                coreBillId = payrequestEntry.getCoreBillId();
                String coreBillEntryId = payrequestEntry.getCoreBillEntryId();
                if (StringUtils.isEmpty((String)coreBillId) || StringUtils.isEmpty((String)coreBillEntryId)) continue;
                coreBillIdBuf.append("'").append(coreBillId).append("',");
                if ("3171BFAD".equals(BOSUuid.read((String)coreBillId).getType().toString())) {
                    PurOrderEntryInfo purOrderEntryInfo = this.writingBackPurOrderEntry(ctx, iPurOrderEntry, payBillInfo.getPayBillType().isPrePay(), payEntryInfo.getAmount(), coreBillEntryId, orderPayment, true);
                    if (null != purOrderEntryInfo) {
                        coreBillIsPurOrder = true;
                        updatePurOrderEntryColl.add((CoreBaseInfo)purOrderEntryInfo);
                    }
                } else if ("F99EE589".equals(BOSUuid.read((String)coreBillId).getType().toString()) && null != (subContractOrderEntryInfo = this.writingBackSubContractOrderEntry(ctx, iSubContractOrderEntry, payEntryInfo.getAmount(), coreBillEntryId, true))) {
                    coreBillIsTransOrder = true;
                    updateSubContractOrderEntryColl.add((CoreBaseInfo)subContractOrderEntryInfo);
                }
            }
            if (coreBillIsPurOrder) {
                iPurOrderEntry.update(updatePurOrderEntryColl);
            }
            if (coreBillIsTransOrder) {
                iSubContractOrderEntry.update(updateSubContractOrderEntryColl);
            }
            if (disposerName != null) continue;
            disposerName = this.getDisposerBySourceBillID(payBillInfo, payReqEnrySourceBillId);
        }
        iPayRequestBill.updateBillStatus(entryIdSet, true);
        this.writeBackPurContract(ctx, purConSrcEntryWriteOffAmtMap, DisposerActionEnum.PAY, purContractPayment);
        if (!isFromPayReqSumEntry) {
            ArApBillReverseHelper.writeBackSumEntry(iPayRequestBill, iPayRequestSumEntry, srcBillIdSet);
        }
        String coreBillIds = null;
        if (coreBillIdBuf.length() > 0) {
            coreBillIds = coreBillIdBuf.substring(0, coreBillIdBuf.length() - 1);
            coreBillIdBuf = null;
        }
        if (coreBillIsPurOrder && !StringUtils.isEmpty(coreBillIds)) {
            this.handleOrderHeadingWritingBack(ctx, paymentBillID, coreBillIds, true);
        }
        if (coreBillIsTransOrder && !StringUtils.isEmpty(coreBillIds)) {
            this.handleSubContractOrderWritingBack(ctx, paymentBillID, coreBillIds, true);
        }
        if (disposerName != null) {
            OtherBillDisposer disposer = null;
            try {
                disposer = (OtherBillDisposer)Class.forName(disposerName).newInstance();
            }
            catch (Exception e) {
                logger.info((Object)e.getMessage());
                disposer = null;
            }
            if (disposer != null) {
                disposer.dispose4Pay(ctx, payBillInfo);
            }
        }
    }

    private String getDisposerBySourceBillID(PaymentBillInfo payBillInfo, String sourceBillID) {
        String disposerName = null;
        if (!StringUtils.isEmpty((String)sourceBillID) && null != payBillInfo) {
            boolean isFromRefund;
            boolean bl = isFromRefund = null == payBillInfo.get("isFromRefund") ? false : Boolean.valueOf(payBillInfo.get("isFromRefund").toString());
            if (!isFromRefund && "48DA3A71".equals(BOSUuid.read((String)sourceBillID).getType().toString())) {
                disposerName = "com.kingdee.eas.fi.ap.OtherBillDisposer";
            }
        }
        return disposerName;
    }

    private PayRequestBillEntryCollection getPayReqEntryCollBySumEntryID(IPayRequestBillEntry iPayReqEntry, String payRequestSumEntryID) throws BOSException {
        PayRequestBillEntryCollection payReqEntryColl = null;
        if (null == iPayReqEntry || StringUtils.isEmpty((String)payRequestSumEntryID)) {
            return payReqEntryColl;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sumEntryID", (Object)payRequestSumEntryID, CompareType.EQUALS));
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.setFilter(filter);
        entityView.setSelector(ArApSelectorFactory.getPayRequestBillEntrySelector(""));
        SorterItemInfo sorterItemInfo = new SorterItemInfo();
        sorterItemInfo.setPropertyName("seq");
        sorterItemInfo.setSortType(SortType.ASCEND);
        entityView.getSorter().add(sorterItemInfo);
        payReqEntryColl = iPayReqEntry.getPayRequestBillEntryCollection(entityView);
        return payReqEntryColl;
    }

    private BigDecimal defaultValue(BigDecimal value) {
        return null == value ? BigDecimal.ZERO : value;
    }

    private PurOrderEntryInfo writingBackPurOrderEntry(Context ctx, IPurOrderEntry iPurOrderEntry, boolean isPrePay, BigDecimal entryPayAmt, String entryId, boolean orderPayment, boolean isPayment) throws EASBizException, BOSException {
        PurOrderEntryInfo purOrderEntryInfo = null;
        if (null != iPurOrderEntry && isPrePay && null != entryPayAmt && entryPayAmt.compareTo(BigDecimal.ZERO) > 0 && !StringUtils.isEmpty((String)entryId)) {
            ArApServerUtils.addSQLLock((Context)ctx, (Object)entryId);
            purOrderEntryInfo = iPurOrderEntry.getPurOrderEntryInfo((IObjectPK)new ObjectUuidPK(entryId));
            if (null != purOrderEntryInfo) {
                BigDecimal preReceived = this.defaultValue(purOrderEntryInfo.getPreReceived());
                BigDecimal prepaidAmount = this.defaultValue(purOrderEntryInfo.getPrepaidAmount());
                BigDecimal prepayment = this.defaultValue(purOrderEntryInfo.getPrepayment());
                BigDecimal unPrereceivedAmt = this.defaultValue(purOrderEntryInfo.getUnPrereceivedAm());
                if (isPayment) {
                    if (!orderPayment && preReceived.add(entryPayAmt).compareTo(prepayment) > 0) {
                        throw new EASBizException(new NumericExceptionSubItem("603", ResourceBase.getString((String)RESOURCE, (String)"47_PayRequestBillDisposer", (Locale)ctx.getLocale())));
                    }
                    purOrderEntryInfo.setPrepaidAmount(prepaidAmount.add(entryPayAmt));
                    purOrderEntryInfo.setUnPrereceivedAm(unPrereceivedAmt.subtract(entryPayAmt));
                    purOrderEntryInfo.setPreReceived(preReceived.add(entryPayAmt));
                } else {
                    purOrderEntryInfo.setPrepaidAmount(prepaidAmount.subtract(entryPayAmt));
                    purOrderEntryInfo.setUnPrereceivedAm(unPrereceivedAmt.add(entryPayAmt));
                    purOrderEntryInfo.setPreReceived(preReceived.subtract(entryPayAmt));
                }
            }
        }
        return purOrderEntryInfo;
    }

    private SubContractOrderEntryInfo writingBackSubContractOrderEntry(Context ctx, ISubContractOrderEntry iSubContractOrderEntry, BigDecimal entryPayAmt, String entryId, boolean isPayment) throws EASBizException, BOSException {
        SubContractOrderEntryInfo subContractOrderEntryInfo = null;
        if (null != iSubContractOrderEntry && null != entryPayAmt && entryPayAmt.compareTo(BigDecimal.ZERO) > 0 && !StringUtils.isEmpty((String)entryId)) {
            ArApServerUtils.addSQLLock((Context)ctx, (Object)entryId);
            subContractOrderEntryInfo = iSubContractOrderEntry.getSubContractOrderEntryInfo((IObjectPK)new ObjectUuidPK(entryId));
            if (null != subContractOrderEntryInfo) {
                BigDecimal prepaidAmount = this.defaultValue(subContractOrderEntryInfo.getPrepaidAmount());
                BigDecimal unPrepaidAmount = this.defaultValue(subContractOrderEntryInfo.getUnPrepaidAmount());
                if (isPayment) {
                    subContractOrderEntryInfo.setPrepaidAmount(prepaidAmount.add(entryPayAmt));
                    subContractOrderEntryInfo.setUnPrepaidAmount(unPrepaidAmount.subtract(entryPayAmt));
                } else {
                    subContractOrderEntryInfo.setPrepaidAmount(prepaidAmount.subtract(entryPayAmt));
                    subContractOrderEntryInfo.setUnPrepaidAmount(unPrepaidAmount.add(entryPayAmt));
                }
            }
        }
        return subContractOrderEntryInfo;
    }

    private void handleOrderHeadingWritingBack(Context ctx, String paymentBillID, String purOrderId, boolean isPayment) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String plusOrMinus = null;
        plusOrMinus = isPayment ? "+" : "-";
        sql.append("update t_sm_purorder set ( fprepaid,FUnPrepaidAmount  ) =  (select t_sm_purorder.fprepaid ").append(plusOrMinus).append(" b.amt").append(",t_sm_purorder.FPrepayment-(t_sm_purorder.fprepaid ").append(plusOrMinus).append(" b.amt) from").append(" (select  FCoreBillID as FCoreBillID,sum(IsNull(famount,0)) as amt from  t_cas_paymentbillentry").append(" where  FCoreBillID in (").append(purOrderId).append(") and FPaymentBillID='").append(paymentBillID).append("' group by FCoreBillID) b where b.FCoreBillID = t_sm_purorder.fid )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void handleSubContractOrderWritingBack(Context ctx, String paymentBillID, String coreBillIds, boolean isPayment) throws BOSException {
        if (StringUtils.isEmpty((String)paymentBillID) || StringUtils.isEmpty((String)coreBillIds)) {
            return;
        }
        String plusOrMinus = null;
        plusOrMinus = isPayment ? "+" : "-";
        StringBuilder buf = new StringBuilder(200);
        buf.append("UPDATE T_SM_SUBCONTRACTORDER SET (FTOTALPAIDPREPAYMENT) =").append(CTRL).append(" (SELECT T_SM_SUBCONTRACTORDER.FTOTALPAIDPREPAYMENT ").append(plusOrMinus).append(" TCP.FAMOUNT AS FTOTALPAIDPREPAYMENT").append(CTRL).append("    FROM (SELECT FCOREBILLID AS FCOREBILLID, ISNULL(SUM(T.FAMOUNT),0) AS FAMOUNT").append(CTRL).append("            FROM T_CAS_PAYMENTBILLENTRY T").append(CTRL).append("           WHERE T.FCOREBILLID IN (").append(coreBillIds).append(")").append(CTRL).append("             AND T.FPAYMENTBILLID ='").append(paymentBillID).append("'").append(CTRL).append("        GROUP BY T.FCOREBILLID ").append(CTRL).append("         ) TCP").append(" WHERE TCP.FCOREBILLID = T_SM_SUBCONTRACTORDER.FID").append(" )");
        DbUtil.execute((Context)ctx, (String)buf.toString());
    }

    public void dispose4CancelPay(Context ctx, PaymentBillInfo payBillInfo) throws BOSException, EASBizException {
        PaymentBillEntryCollection payEntryCol = payBillInfo.getEntries();
        PayRequestBillEntryInfo payrequestEntry = null;
        IPayRequestBillEntry iPayReqEntry = PayRequestBillEntryFactory.getLocalInstance(ctx);
        PayRequestSumEntryInfo payRequestSumEntry = null;
        IPayRequestSumEntry iPayRequestSumEntry = PayRequestSumEntryFactory.getLocalInstance(ctx);
        IPayRequestBill iPayRequestBill = PayRequestBillFactory.getLocalInstance(ctx);
        String coreBillId = null;
        boolean coreBillIsPurOrder = false;
        boolean coreBillIsTransOrder = false;
        String paymentBillID = payBillInfo.getId().toString();
        StringBuilder coreBillIdBuf = new StringBuilder(100);
        boolean isFromPayReqSumEntry = false;
        BigDecimal payEntryAmt = BigDecimal.ZERO;
        PayRequestBillEntryInfo groupRequestEntry = null;
        BigDecimal entryPaidAmt = BigDecimal.ZERO;
        HashSet<String> srcBillIdSet = new HashSet<String>();
        IPurContractEntry iPurContractEntry = PurContractEntryFactory.getLocalInstance((Context)ctx);
        IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance((Context)ctx);
        ISubContractOrderEntry iSubContractOrderEntry = SubContractOrderEntryFactory.getLocalInstance((Context)ctx);
        HashMap<String, BigDecimal> purConSrcEntryWriteOffAmtMap = new HashMap<String, BigDecimal>();
        HashSet<String> entryIdSet = new HashSet<String>();
        for (int i = 0; i < payEntryCol.size(); ++i) {
            PaymentBillEntryInfo payEntryInfo = payEntryCol.get(i);
            payEntryAmt = payEntryInfo.getAmount();
            String sourceBillID = payEntryInfo.getSourceBillId();
            String sourceBillEntryID = payEntryInfo.getSourceBillEntryId();
            if (sourceBillID == null || sourceBillEntryID == null) continue;
            srcBillIdSet.add(sourceBillID);
            CoreBaseCollection updatePayRequestBillEntryColl = new CoreBaseCollection();
            CoreBaseCollection updatePurOrderEntryColl = new CoreBaseCollection();
            CoreBaseCollection updateSubContractOrderEntryColl = new CoreBaseCollection();
            if (ApServerUtils.isPayReqSumEntry((String)sourceBillEntryID)) {
                isFromPayReqSumEntry = true;
                payRequestSumEntry = iPayRequestSumEntry.getPayRequestSumEntryInfo((IObjectPK)new ObjectUuidPK(sourceBillEntryID));
                payRequestSumEntry.setPayedAmt(payRequestSumEntry.getPayedAmt().subtract(payEntryAmt));
                payRequestSumEntry.setUnpayAmount(payRequestSumEntry.getUnpayAmount().add(payEntryAmt));
                iPayRequestSumEntry.update((IObjectPK)new ObjectUuidPK(sourceBillEntryID), payRequestSumEntry);
                PayRequestBillEntryCollection payRequestBillEntry = this.getPayReqEntryCollBySumEntryID(iPayReqEntry, payRequestSumEntry.getId().toString());
                HashSet<String> sumRelEntryId = new HashSet<String>();
                for (int j = 0; j < payRequestBillEntry.size(); ++j) {
                    sumRelEntryId.add(payRequestBillEntry.get(j).getId().toString());
                }
                ArApServerUtils.addSQLLock((Context)ctx, sumRelEntryId);
                Iterator reqEntryIterator = payRequestBillEntry.iterator();
                BigDecimal rowAllowanceAmt = BigDecimal.ZERO;
                String reqSourceEntryId = null;
                String reqSourceBillId = null;
                while (reqEntryIterator.hasNext()) {
                    SubContractOrderEntryInfo subContractOrderEntryInfo;
                    groupRequestEntry = (PayRequestBillEntryInfo)reqEntryIterator.next();
                    entryPaidAmt = groupRequestEntry.getTotalPayAmt();
                    reqSourceEntryId = groupRequestEntry.getSourceBillEntryId();
                    reqSourceBillId = groupRequestEntry.getSourceBillId();
                    if (payEntryAmt.compareTo(entryPaidAmt) <= 0) {
                        groupRequestEntry.setUnpayAmount(groupRequestEntry.getUnpayAmount().add(payEntryAmt));
                        groupRequestEntry.setTotalPayAmt(groupRequestEntry.getTotalPayAmt().subtract(payEntryAmt));
                        rowAllowanceAmt = payEntryAmt;
                    } else {
                        groupRequestEntry.setUnpayAmount(groupRequestEntry.getUnpayAmount().add(entryPaidAmt));
                        groupRequestEntry.setTotalPayAmt(BigDecimal.ZERO);
                        rowAllowanceAmt = entryPaidAmt;
                    }
                    if (groupRequestEntry.isIsManualClose()) {
                        throw new PayRequestBillBizException(PayRequestBillBizException.PAY_HASCLOSE_UNCLOASE_FIRST);
                    }
                    if (groupRequestEntry.getTotalPayAmt().compareTo(groupRequestEntry.getAuditAmount()) != 0) {
                        entryIdSet.add(groupRequestEntry.getId().toString());
                        groupRequestEntry.setEntryStatus(BillStatusEnum.AUDITED);
                    }
                    if (reqSourceBillId != null && BOSUuid.read((String)reqSourceBillId).getType().toString().equals("78B50853")) {
                        if (purConSrcEntryWriteOffAmtMap.get(reqSourceEntryId) != null) {
                            purConSrcEntryWriteOffAmtMap.put(reqSourceEntryId, ((BigDecimal)purConSrcEntryWriteOffAmtMap.get(reqSourceEntryId)).add(rowAllowanceAmt));
                        } else {
                            purConSrcEntryWriteOffAmtMap.put(reqSourceEntryId, rowAllowanceAmt);
                        }
                    }
                    updatePayRequestBillEntryColl.add((CoreBaseInfo)groupRequestEntry);
                    payEntryAmt = payEntryAmt.subtract(rowAllowanceAmt);
                    coreBillId = groupRequestEntry.getCoreBillId();
                    String coreBillEntryId = groupRequestEntry.getCoreBillEntryId();
                    if (coreBillId == null || coreBillEntryId == null) continue;
                    coreBillIdBuf.append("'").append(coreBillId).append("',");
                    if ("3171BFAD".equals(BOSUuid.read((String)coreBillId).getType().toString())) {
                        PurOrderEntryInfo purOrderEntryInfo = this.writingBackPurOrderEntry(ctx, iPurOrderEntry, payBillInfo.getPayBillType().isPrePay(), rowAllowanceAmt, coreBillEntryId, false, false);
                        if (null != purOrderEntryInfo) {
                            coreBillIsPurOrder = true;
                            updatePurOrderEntryColl.add((CoreBaseInfo)purOrderEntryInfo);
                        }
                    } else if ("F99EE589".equals(BOSUuid.read((String)coreBillId).getType().toString()) && null != (subContractOrderEntryInfo = this.writingBackSubContractOrderEntry(ctx, iSubContractOrderEntry, rowAllowanceAmt, coreBillEntryId, false))) {
                        coreBillIsTransOrder = true;
                        updateSubContractOrderEntryColl.add((CoreBaseInfo)subContractOrderEntryInfo);
                    }
                    if (payEntryAmt.compareTo(BigDecimal.ZERO) > 0) continue;
                    break;
                }
                iPayReqEntry.update(updatePayRequestBillEntryColl);
            } else {
                SubContractOrderEntryInfo subContractOrderEntryInfo;
                ArApServerUtils.addSQLLock((Context)ctx, (Object)sourceBillEntryID);
                payrequestEntry = iPayReqEntry.getPayRequestBillEntryInfo((IObjectPK)new ObjectUuidPK(sourceBillEntryID));
                payrequestEntry.setTotalPayAmt(payrequestEntry.getTotalPayAmt().subtract(payEntryInfo.getAmount()));
                payrequestEntry.setUnpayAmount(payrequestEntry.getUnpayAmount().add(payEntryInfo.getAmount()));
                if (payrequestEntry.isIsManualClose()) {
                    throw new PayRequestBillBizException(PayRequestBillBizException.PAY_HASCLOSE_UNCLOASE_FIRST);
                }
                if (payrequestEntry.getTotalPayAmt().compareTo(payrequestEntry.getAuditAmount()) != 0) {
                    entryIdSet.add(payrequestEntry.getId().toString());
                    payrequestEntry.setEntryStatus(BillStatusEnum.AUDITED);
                }
                iPayReqEntry.update((IObjectPK)new ObjectUuidPK(payrequestEntry.getId()), (CoreBaseInfo)payrequestEntry);
                String sourceBillId = payrequestEntry.getSourceBillId();
                String sourceBillentryId = payrequestEntry.getSourceBillEntryid();
                Object contractEntryInfo = null;
                if (sourceBillId != null && sourceBillentryId != null && "78B50853".equals(BOSUuid.read((String)sourceBillId).getType().toString())) {
                    if (purConSrcEntryWriteOffAmtMap.get(sourceBillentryId) == null) {
                        purConSrcEntryWriteOffAmtMap.put(sourceBillentryId, payEntryInfo.getAmount());
                    } else {
                        purConSrcEntryWriteOffAmtMap.put(sourceBillentryId, payEntryInfo.getAmount().add((BigDecimal)purConSrcEntryWriteOffAmtMap.get(sourceBillentryId)));
                    }
                }
                coreBillId = payrequestEntry.getCoreBillId();
                String coreBillEntryId = payrequestEntry.getCoreBillEntryId();
                if (coreBillId == null || coreBillEntryId == null) continue;
                coreBillIdBuf.append("'").append(coreBillId).append("',");
                if ("3171BFAD".equals(BOSUuid.read((String)coreBillId).getType().toString())) {
                    PurOrderEntryInfo purOrderEntryInfo = this.writingBackPurOrderEntry(ctx, iPurOrderEntry, payBillInfo.getPayBillType().isPrePay(), payEntryInfo.getAmount(), coreBillEntryId, false, false);
                    if (null != purOrderEntryInfo) {
                        coreBillIsPurOrder = true;
                        updatePurOrderEntryColl.add((CoreBaseInfo)purOrderEntryInfo);
                    }
                } else if ("F99EE589".equals(BOSUuid.read((String)coreBillId).getType().toString()) && null != (subContractOrderEntryInfo = this.writingBackSubContractOrderEntry(ctx, iSubContractOrderEntry, payEntryInfo.getAmount(), coreBillEntryId, false))) {
                    coreBillIsTransOrder = true;
                    updateSubContractOrderEntryColl.add((CoreBaseInfo)subContractOrderEntryInfo);
                }
            }
            if (coreBillIsPurOrder) {
                iPurOrderEntry.update(updatePurOrderEntryColl);
            }
            if (!coreBillIsTransOrder) continue;
            iSubContractOrderEntry.update(updateSubContractOrderEntryColl);
        }
        iPayRequestBill.updateBillStatus(entryIdSet, false);
        this.writeBackPurContract(ctx, purConSrcEntryWriteOffAmtMap, DisposerActionEnum.CANCEL_PAY, false);
        if (!isFromPayReqSumEntry) {
            ArApBillReverseHelper.writeBackSumEntry(iPayRequestBill, iPayRequestSumEntry, srcBillIdSet);
        }
        String coreBillIds = null;
        if (coreBillIdBuf.length() > 0) {
            coreBillIds = coreBillIdBuf.substring(0, coreBillIdBuf.length() - 1);
            coreBillIdBuf = null;
        }
        if (coreBillIsPurOrder && !StringUtils.isEmpty(coreBillIds)) {
            this.handleOrderHeadingWritingBack(ctx, paymentBillID, coreBillIds, false);
        }
        if (coreBillIsTransOrder && !StringUtils.isEmpty(coreBillIds)) {
            this.handleSubContractOrderWritingBack(ctx, paymentBillID, coreBillIds, false);
        }
    }

    private void writeBackPurContract(Context ctx, Map<String, BigDecimal> entryWriteOffAmtMap, DisposerActionEnum actionType, Boolean purContractPayment) throws BOSException, EASBizException {
        if (entryWriteOffAmtMap.isEmpty()) {
            return;
        }
        String plus = "+";
        if (DisposerActionEnum.PAY == actionType) {
            plus = "+";
        } else if (DisposerActionEnum.CANCEL_PAY == actionType) {
            plus = "-";
        } else {
            return;
        }
        HashSet<String> purContEntryIdSet = new HashSet<String>();
        StringBuffer updatePurContSql = new StringBuffer();
        updatePurContSql.append(" UPDATE T_SM_PurContractEntry SET ");
        updatePurContSql.append(" FPreReceived = isnull(FPreReceived,0) ").append(plus).append(" ? ");
        updatePurContSql.append(" ,FUnPrereceivedAm = isnull(FPrepayment,0) - (isnull(FPreReceived,0) ").append(plus).append(" ? )");
        updatePurContSql.append("WHERE FID = ?;");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (Map.Entry<String, BigDecimal> entry : entryWriteOffAmtMap.entrySet()) {
            paramsList.add(new Object[]{entry.getValue(), entry.getValue(), entry.getKey()});
            purContEntryIdSet.add(entry.getKey());
        }
        DbUtil.executeBatch((Context)ctx, (String)updatePurContSql.toString(), paramsList);
        if ("+".equals(plus) && !purContractPayment.booleanValue()) {
            String checkSql = "SELECT FID  FROM T_SM_PurContractEntry where FPreReceived > FPrepayment and fid in(" + ArApBillHelper.ids2SqlString(purContEntryIdSet) + ")";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)checkSql);
            try {
                if (rowSet.next()) {
                    throw new EASBizException(new NumericExceptionSubItem("603", ResourceBase.getString((String)RESOURCE, (String)"FPreReceivedBiggerPreAmount", (Locale)ctx.getLocale())));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public BigDecimal getCashRebate(OtherBillInfo otherBillInfo, Date billDate, BigDecimal apAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }

    public BigDecimal getCashRebate(Date billDate, BigDecimal apAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }
}

