/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.IPayRequestBill;
import com.kingdee.eas.fi.ap.IPayRequestBillEntry;
import com.kingdee.eas.fi.ap.IPayRequestSumEntry;
import com.kingdee.eas.fi.ap.PayRequestBillEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryFactory;
import com.kingdee.eas.fi.ap.PayRequestBillEntryInfo;
import com.kingdee.eas.fi.ap.PayRequestBillFactory;
import com.kingdee.eas.fi.ap.PayRequestSumEntryFactory;
import com.kingdee.eas.fi.ap.PayRequestSumEntryInfo;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.arap.util.ArApSelectorFactory;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fm.pp.IPPBillDisposer;
import com.kingdee.eas.fm.pp.PayPlanBillInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;

public class PayRequestBillDisposer4PP
implements IPPBillDisposer {
    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        DisposerActionEnum actionType = action.getActionType();
        PayPlanBillInfo info = (PayPlanBillInfo)action.getDestBill();
        if (DisposerActionEnum.SAVE.equals((Object)actionType)) {
            this.dispose4Save(ctx, info);
        } else if (DisposerActionEnum.ANTI_AUDIT.equals((Object)actionType)) {
            this.dispose4BackTo(ctx, info);
        }
    }

    public void dispose4Save(Context ctx, PayPlanBillInfo payPlanBillInfo) throws BOSException, EASBizException {
        int size;
        String srcBillEntryId = payPlanBillInfo.getSrcBillHeadID();
        String srcBillId = payPlanBillInfo.getSourceBillId();
        if (StringUtils.isEmpty((String)srcBillEntryId) || StringUtils.isEmpty((String)srcBillId)) {
            return;
        }
        BigDecimal applyPayAmount = null == payPlanBillInfo.getApplyPayAmount() ? BigDecimal.ZERO : payPlanBillInfo.getApplyPayAmount();
        BigDecimal applyPayLocAmt = this.calApplyLocAmt(ctx, payPlanBillInfo, srcBillEntryId, applyPayAmount);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("UPDATE T_ap_payrequestsumentry SET FLOCKAMOUNT = isnull(FLOCKAMOUNT, 0) + ?,");
        sqlBuilder.append(" FLOCKAMOUNTLOC = isnull(FLOCKAMOUNTLOC, 0) + ?,");
        sqlBuilder.append(" FUNLOCKAMOUNT = isnull(FUNLOCKAMOUNT, 0) - ?,");
        sqlBuilder.append(" FUNLOCKAMOUNTLOC = isnull(FUNLOCKAMOUNTLOC, 0) - ?,");
        sqlBuilder.append(" FISPAYPLANCREATED = ?");
        sqlBuilder.append(" WHERE FID = ?");
        Object[] params = new Object[]{applyPayAmount, applyPayLocAmt, applyPayAmount, applyPayLocAmt, 1, srcBillEntryId};
        DbUtil.execute((Context)ctx, (String)sqlBuilder.toString(), (Object[])params);
        IPayRequestBillEntry iPayRequestBillEntry = PayRequestBillEntryFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(ArApSelectorFactory.getPayRequestBillEntrySelector(""));
        FilterInfo entryFilter1 = new FilterInfo();
        entryFilter1.getFilterItems().add(new FilterItemInfo("sumEntryID", (Object)srcBillEntryId, CompareType.EQUALS));
        view.setFilter(entryFilter1);
        PayRequestBillEntryCollection entryColl = iPayRequestBillEntry.getPayRequestBillEntryCollection(view);
        if (null == entryColl || entryColl.size() == 0) {
            return;
        }
        Iterator entryCollIterator = entryColl.iterator();
        PayRequestBillEntryInfo entryInfo = null;
        BigDecimal unLockAmt = BigDecimal.ZERO;
        BigDecimal unLockAmtLoc = BigDecimal.ZERO;
        BigDecimal rowAllanceAmt = BigDecimal.ZERO;
        BigDecimal rowAllanceAmtLoc = BigDecimal.ZERO;
        CoreBaseCollection needUpdateColl = new CoreBaseCollection();
        while (entryCollIterator.hasNext()) {
            entryInfo = (PayRequestBillEntryInfo)entryCollIterator.next();
            unLockAmt = entryInfo.getUnLockAmount();
            unLockAmtLoc = entryInfo.getUnLockAmountLoc();
            if (unLockAmt.doubleValue() == 0.0) continue;
            if (unLockAmt.compareTo(applyPayAmount) < 0) {
                rowAllanceAmt = unLockAmt;
                rowAllanceAmtLoc = unLockAmtLoc;
            } else {
                rowAllanceAmt = applyPayAmount;
                rowAllanceAmtLoc = applyPayLocAmt;
            }
            entryInfo.setUnLockAmount(unLockAmt.subtract(rowAllanceAmt));
            entryInfo.setUnLockAmountLoc(unLockAmtLoc.subtract(rowAllanceAmtLoc));
            entryInfo.setLockAmount(entryInfo.getLockAmount().add(rowAllanceAmt));
            entryInfo.setLockAmountLoc(entryInfo.getLockAmountLoc().add(rowAllanceAmtLoc));
            entryInfo.setIsPayPlanCreated(true);
            applyPayAmount = applyPayAmount.subtract(rowAllanceAmt);
            applyPayLocAmt = applyPayLocAmt.subtract(rowAllanceAmtLoc);
            needUpdateColl.add((CoreBaseInfo)entryInfo);
            if (applyPayAmount.doubleValue() != 0.0) continue;
        }
        if ((size = needUpdateColl.size()) > 0) {
            iPayRequestBillEntry.update(needUpdateColl);
        }
    }

    public void dispose4BackTo(Context ctx, PayPlanBillInfo payPlanBillInfo) throws BOSException, EASBizException {
        String srcBillEntryId = payPlanBillInfo.getSrcBillHeadID();
        String srcBillId = payPlanBillInfo.getSourceBillId();
        if (StringUtils.isEmpty((String)srcBillEntryId) || StringUtils.isEmpty((String)srcBillId)) {
            return;
        }
        BigDecimal applyPayAmount = null == payPlanBillInfo.getApplyPayAmount() ? BigDecimal.ZERO : payPlanBillInfo.getApplyPayAmount();
        BigDecimal applyPayLocAmt = this.calApplyLocAmt(ctx, payPlanBillInfo, srcBillEntryId, applyPayAmount);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("UPDATE T_ap_payrequestsumentry SET FLOCKAMOUNT = isnull(FLOCKAMOUNT, 0) - ?,");
        sqlBuilder.append(" FLOCKAMOUNTLOC = isnull(FLOCKAMOUNTLOC, 0) - ?,");
        sqlBuilder.append(" FUNLOCKAMOUNT = isnull(FUNLOCKAMOUNT, 0) + ?,");
        sqlBuilder.append(" FUNLOCKAMOUNTLOC = isnull(FUNLOCKAMOUNTLOC, 0) + ?,");
        sqlBuilder.append(" FISPAYPLANCREATED = ?");
        sqlBuilder.append(" WHERE FID = ?");
        Object[] params = new Object[]{applyPayAmount, applyPayLocAmt, applyPayAmount, applyPayLocAmt, 0, srcBillEntryId};
        DbUtil.execute((Context)ctx, (String)sqlBuilder.toString(), (Object[])params);
        IPayRequestBillEntry iPayRequestBillEntry = PayRequestBillEntryFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(ArApSelectorFactory.getPayRequestBillEntrySelector(""));
        FilterInfo entryFilter1 = new FilterInfo();
        entryFilter1.getFilterItems().add(new FilterItemInfo("sumEntryID", (Object)srcBillEntryId, CompareType.EQUALS));
        view.setFilter(entryFilter1);
        PayRequestBillEntryCollection entryColl = iPayRequestBillEntry.getPayRequestBillEntryCollection(view);
        if (null == entryColl || entryColl.size() == 0) {
            return;
        }
        Iterator entryCollIterator = entryColl.iterator();
        PayRequestBillEntryInfo entryInfo = null;
        BigDecimal LockAmt = BigDecimal.ZERO;
        BigDecimal LockAmtLoc = BigDecimal.ZERO;
        BigDecimal rowAllanceAmt = BigDecimal.ZERO;
        BigDecimal rowAllanceAmtLoc = BigDecimal.ZERO;
        CoreBaseCollection needUpdateColl = new CoreBaseCollection();
        while (entryCollIterator.hasNext()) {
            entryInfo = (PayRequestBillEntryInfo)entryCollIterator.next();
            LockAmt = entryInfo.getLockAmount();
            LockAmtLoc = entryInfo.getLockAmountLoc();
            if (LockAmt.doubleValue() == 0.0) continue;
            if (LockAmt.compareTo(applyPayAmount) < 0) {
                rowAllanceAmt = LockAmt;
                rowAllanceAmtLoc = LockAmtLoc;
            } else {
                rowAllanceAmt = applyPayAmount;
                rowAllanceAmtLoc = applyPayLocAmt;
            }
            entryInfo.setUnLockAmount(entryInfo.getUnLockAmount().add(rowAllanceAmt));
            entryInfo.setUnLockAmountLoc(entryInfo.getUnLockAmountLoc().add(rowAllanceAmtLoc));
            entryInfo.setLockAmount(LockAmt.subtract(rowAllanceAmt));
            entryInfo.setLockAmountLoc(LockAmtLoc.subtract(rowAllanceAmtLoc));
            if (entryInfo.getLockAmount().doubleValue() == 0.0) {
                entryInfo.setIsPayPlanCreated(false);
            }
            applyPayAmount = applyPayAmount.subtract(rowAllanceAmt);
            applyPayLocAmt = applyPayLocAmt.subtract(rowAllanceAmtLoc);
            needUpdateColl.add((CoreBaseInfo)entryInfo);
            if (applyPayAmount.doubleValue() != 0.0) continue;
        }
        if (needUpdateColl.size() > 0) {
            iPayRequestBillEntry.update(needUpdateColl);
        }
        IPayRequestBill iPayRequestBill = PayRequestBillFactory.getLocalInstance(ctx);
        iPayRequestBill.backTo4PP((IObjectPK)new ObjectUuidPK(srcBillId), "bakcTo");
    }

    protected BigDecimal calApplyLocAmt(Context ctx, PayPlanBillInfo payPlanBillInfo, String srcBillId, BigDecimal applyPayAmount) throws BOSException, EASBizException {
        BigDecimal applyPayLocAmt;
        IPayRequestSumEntry iPayRequestSumEntry = PayRequestSumEntryFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.exchange_rate"));
        sic.add(new SelectorItemInfo("parent.currency.id"));
        sic.add(new SelectorItemInfo("parent.company.id"));
        sic.add(new SelectorItemInfo("parent.company.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("parent.bizDate"));
        sic.add(new SelectorItemInfo("lockAmount"));
        sic.add(new SelectorItemInfo("lockAmountLoc"));
        sic.add(new SelectorItemInfo("unLockAmount"));
        sic.add(new SelectorItemInfo("unLockAmountLoc"));
        sic.add(new SelectorItemInfo("auditAmount"));
        sic.add(new SelectorItemInfo("auditAmountLoc"));
        PayRequestSumEntryInfo sumInfo = iPayRequestSumEntry.getPayRequestSumEntryInfo((IObjectPK)new ObjectUuidPK(srcBillId), sic);
        BigDecimal bigDecimal = applyPayLocAmt = null == payPlanBillInfo.getApplyPayLocAmt() ? BigDecimal.ZERO : payPlanBillInfo.getApplyPayLocAmt();
        if (null == sumInfo) {
            return applyPayLocAmt;
        }
        BigDecimal srcAuditAmount = sumInfo.getAuditAmount();
        if (applyPayAmount.compareTo(srcAuditAmount) != 0) {
            BigDecimal unLockAmount = sumInfo.getUnLockAmount();
            BigDecimal unLockAmountLoc = sumInfo.getUnLockAmountLoc();
            if (unLockAmount != null && unLockAmount.compareTo(applyPayAmount) == 0) {
                applyPayLocAmt = unLockAmountLoc;
            } else {
                boolean isDirectExchangeRate = BaseDataUtil.isDirectExchangeRate((ExchangeRateInfo)BaseDataUtil.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)sumInfo.getParent().getCompany(), (CurrencyInfo)sumInfo.getParent().getCurrency(), (Date)sumInfo.getParent().getBizDate()));
                BigDecimal exchangeRate = sumInfo.getParent().getExchange_rate();
                int precision = sumInfo.getParent().getCompany().getBaseCurrency().getPrecision();
                applyPayLocAmt = BaseDataUtil.caculateLocalAmount((BigDecimal)applyPayAmount, (BigDecimal)exchangeRate, (boolean)isDirectExchangeRate, (int)precision);
            }
        }
        return applyPayLocAmt;
    }
}

