/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ap.client.AbstractApBalanceToGLUI;
import com.kingdee.eas.fi.ap.client.util.ApClientUtils;
import com.kingdee.eas.fi.ar.IManageAccount;
import com.kingdee.eas.fi.ar.ManageAccountFactory;
import com.kingdee.eas.fi.ar.NoVoucherEntryException;
import com.kingdee.eas.fi.ar.client.util.ArClientUtils;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Vector;

public class ApBalanceToGLUI
extends AbstractApBalanceToGLUI {
    private Vector balanceResult = null;
    private String innerType = "COMMON";

    private boolean showBalanceResults(Vector value) {
        return CommonClientUtils.showBalanceResults(this.balanceResultTable, value);
    }

    public ApBalanceToGLUI() throws Exception {
        this.checkConditin();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.innerType = (String)this.getUIContext().get("TYPE");
        if (this.innerType == null) {
            this.innerType = "COMMON";
        }
        this.balanceResultTable.checkParsed();
        this.balanceResultTable.getColumn("begin").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.balanceResultTable.getColumn("yearDebit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.balanceResultTable.getColumn("yearCredit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.balanceResultTable.getColumn("glBegin").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.balanceResultTable.getColumn("glYearDebit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.balanceResultTable.getColumn("glYearCredit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.balanceResultTable.getColumn("balanceBegin").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.balanceResultTable.getColumn("balanceYearDebit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.balanceResultTable.getColumn("balanceYearCredit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        PeriodInfo currentPeriod = ApClientUtils.getApCurrentPeriod(SysContext.getSysContext().getCurrentFIUnit());
        this.periodText.setText(currentPeriod.toString());
        try {
            IManageAccount manageAccount = ManageAccountFactory.getRemoteInstance();
            this.balanceResult = ManageAccountFactory.getRemoteInstance().balanceAPToGL(this.innerType);
        }
        catch (NoVoucherEntryException e) {
            String formatString = ArClientUtils.getArStringResource("NoVoucherEntry");
            MessageFormat format = new MessageFormat(formatString);
            Object[] parameters = new Object[]{e.getBillCode()};
            MsgBox.showInfo((String)format.format(parameters));
            this.abort();
        }
        this.showBalanceResults(this.balanceResult);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean isBalance() {
        if (this.balanceResult == null) {
            throw new IllegalArgumentException("Have no balance result!");
        }
        return this.balanceResult.size() <= 0;
    }

    public static boolean showApBalanceToGLUI(Object owner) throws UIException {
        try {
            boolean relatedAccount = ApClientUtils.apIsRelatedAccount(SysContext.getSysContext().getCurrentFIUnit());
            if (relatedAccount) {
                return true;
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        UIContext cntxt = new UIContext(owner);
        cntxt.put((Object)"TYPE", (Object)"RELATEGL");
        String className = ApBalanceToGLUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)cntxt);
        ApBalanceToGLUI uiObject = (ApBalanceToGLUI)uiWindow.getUIObject();
        boolean balance = uiObject.isBalance();
        if (!balance) {
            uiWindow.show();
        }
        return balance;
    }

    @Override
    protected void okButton_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private void checkConditin() throws Exception {
        PeriodInfo startPeriod = ApClientUtils.getApStartPeriod(SysContext.getSysContext().getCurrentFIUnit());
        if (startPeriod == null) {
            MsgBox.showInfo((Component)((Object)this), (String)ArClientUtils.getArStringResource("SystemIsNotStart"));
            this.abort();
        }
        try {
            boolean glIsStart = CommonClientUtils.glIsStart(SysContext.getSysContext().getCurrentFIUnit());
            if (!glIsStart) {
                MsgBox.showInfo((Component)((Object)this), (String)ArClientUtils.getArStringResource("GLIsNotStart"));
                this.abort();
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            this.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            this.abort();
        }
    }
}

