/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ap.ApInvoiceEntryInfo;
import com.kingdee.eas.fi.ap.ApInvoiceFactory;
import com.kingdee.eas.fi.ap.ApInvoiceInfo;
import com.kingdee.eas.fi.ap.OtherBillentryFactory;
import com.kingdee.eas.fi.ap.client.AbstractApInvoiceNormalEditUI;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.IArApBillEntryBase;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.arap.InvoiceInfo;
import com.kingdee.eas.fi.arap.InvoiceTypeEnum;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class ApInvoiceNormalEditUI
extends AbstractApInvoiceNormalEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ApInvoiceNormalEditUI.class);

    public ApInvoiceNormalEditUI() throws Exception {
        this.txtAreaRemark.setMaxLength(255);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSPAYABLE;
    }

    @Override
    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "fi_ap_InvoiceAddNew";
        }
        if ("VIEW".equals(status)) {
            return "fi_ap_InvoiceQuery";
        }
        return null;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.actionGTaxExport.setVisible(false);
        this.actionGTaxExport.setEnabled(false);
    }

    protected IObjectValue createNewData() {
        ApInvoiceInfo info = new ApInvoiceInfo();
        info.setCompany(this.companyInfo);
        info.setCU(this.companyInfo.getCU());
        UserInfo currentUser = SysContext.getSysContext().getCurrentUserInfo();
        PersonInfo currPerson = currentUser.getPerson();
        info.setInvPerson(currPerson);
        info.setAuditPerson(currPerson);
        info.setCurrency(this.companyInfo.getBaseCurrency());
        info.setType(InvoiceTypeEnum.GENERAL);
        info.setBillDate((Date)this.pkbillDate.getValue());
        info.setBillStatus(BillStatusEnum.SAVE);
        return info;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        ApInvoiceEntryInfo info = new ApInvoiceEntryInfo();
        return info;
    }

    @Override
    public void loadFields() {
        super.beforeLoadFields();
        super.loadFields();
        try {
            this.initFetchData();
            this.startPeriod = this.fetchData.getStartPeriod();
            if (this.startPeriod == null) {
                throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.companyInfo.getName() + this.getSystemEnumForOA().getAlias()});
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.pkbillDate.setMinimumDate(this.startPeriod.getBeginDate());
        this.editData.setSyncOldValue(true);
        this.afterLoadFields();
        this.editData.setSyncOldValue(false);
        this.setNumCtrlStatus();
    }

    @Override
    protected void afterLoadFields() {
        super.afterLoadFields();
    }

    @Override
    protected void setCustomerData2UI(CustomerInfo cussAcctInfo, boolean isChange) {
        super.setCustomerData2UI(cussAcctInfo, isChange);
        try {
            if (this.prmtCussType.getData() != null) {
                AsstActTypeInfo typeInfo = (AsstActTypeInfo)this.prmtCussType.getData();
                ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtCusAcct, typeInfo, this.companyInfo, false, this.fetchData.getF7DisplayMode());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void setSupplierData2UI(SupplierInfo cussAcctInfo, boolean isChange) {
        super.setSupplierData2UI(cussAcctInfo, isChange);
        try {
            if (this.prmtCussType.getData() != null) {
                AsstActTypeInfo typeInfo = (AsstActTypeInfo)this.prmtCussType.getData();
                ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtCusAcct, typeInfo, this.companyInfo, false, this.fetchData.getF7DisplayMode());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setSyncOldValue(true);
        ApInvoiceInfo info = (ApInvoiceInfo)this.getEditData();
        info.setType(InvoiceTypeEnum.GENERAL);
        this.storeAssActData(info);
        this.setDataObject((IObjectValue)info);
        this.editData.setSyncOldValue(false);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ApInvoiceFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("type");
        sic.add("billStatus");
        sic.add("asstActName");
        sic.add("currency.precision");
        sic.add("cussAcctBank");
        return sic;
    }

    @Override
    protected IArApBillEntryBase getSourceEntryInterface() throws BOSException {
        return OtherBillentryFactory.getRemoteInstance();
    }

    @Override
    protected IMetaDataPK getPrintQueryPK() {
        return APPRINT_QRY;
    }

    @Override
    protected String getPrintMetaPath() {
        return "/FI/AP/ApInvoice";
    }

    @Override
    protected void setEditComponentsStatus(boolean fEdit) {
        super.setEditComponentsStatus(fEdit);
        this.prmtCusAcct.setEnabled(fEdit);
        this.prmtCusAcct.setEditable(fEdit);
        this.txtApDrawer.setEnabled(fEdit);
    }

    @Override
    protected void verifyInfo(InvoiceInfo invInfo) throws Exception {
        super.verifyInfo(invInfo);
        ApInvoiceInfo info = (ApInvoiceInfo)invInfo;
        if (StringUtils.isEmpty((String)info.getDrawer())) {
            this.txtApDrawer.requestFocus();
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{this.lblcontDrawer.getBoundLabelText()});
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionSubmit_actionPerformed(e);
        }
        catch (Exception e2) {
            this.setNumCtrlStatus();
            if (e2.getMessage() != null && !"".equals(e2.getMessage())) {
                MsgBox.showWarning((Component)((Object)this), (String)e2.getMessage());
            }
            SysUtil.abort();
        }
    }
}

