/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ap.client.AbstractOtherBillPlanQueryUI;
import com.kingdee.eas.fi.ap.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.ComBoxInfo;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApQueryUIUtil;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class OtherBillPlanQueryUI
extends AbstractOtherBillPlanQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(OtherBillPlanQueryUI.class);
    private static final String PERMISSION = "fi_ap_ApOtherBill_View";
    protected ArApSysParamInfo cache = null;
    protected IArApBillFacade iBillFacade;
    protected HashMap uiParam = null;
    private AsstActTypeInfo asstActTypeInfo = null;

    public OtherBillPlanQueryUI() throws Exception {
        this.initDefaultUIParam();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.iBillFacade == null) {
            this.iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
        }
        if (this.cache == null || this.cache.getCompany() == null) {
            this.cache = this.iBillFacade.getSysParams(null, this.getUIParam());
        }
        this.kDBizPrCompany.setValue((Object)this.cache.getCompany());
        this.setCompanyF7();
        ArApBillUIUtil.makeAsstActType(this.kdComAsstActType, this.cache, true);
        this.kDBizCurrency.setVisible(true);
        this.kDBizCurrency.setEditable(true);
        this.kDBizCurrency.setDisplayFormat("$name$");
        this.kDBizCurrency.setEditFormat("$number$");
        this.kDBizCurrency.setCommitFormat("$number$");
        this.kDBizCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CurrencyQuery");
        this.kdComBillType.removeAllItems();
        this.kdComBillType.addItem((Object)EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"itemAll"));
        this.kdComBillType.addItem((Object)OtherBillType.OtherPay);
        this.kdComBillType.addItem((Object)OtherBillType.ExpenseInvoice);
        this.kdComBillType.addItem((Object)OtherBillType.InvoiceBill);
        this.kdComBillType.addItem((Object)OtherBillType.DebitAdjust);
        this.setNumber(this.kDBizBillNumFrom, this.cache.getCompanyId());
        this.setNumber(this.kDBizBillNumTo, this.cache.getCompanyId());
    }

    protected void setNumber(KDBizPromptBox kDBizBillNum, String companyId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        viewInfo.setFilter(filter);
        kDBizBillNum.setEntityViewInfo(viewInfo);
        kDBizBillNum.setVisible(true);
        kDBizBillNum.setEditFormat("$number$");
        kDBizBillNum.setDisplayFormat("$number$");
        kDBizBillNum.setCommitFormat("$number$");
        kDBizBillNum.setQueryInfo("com.kingdee.eas.fi.ap.app.OtherBillPlanQuery");
    }

    protected void setCompanyF7() {
        this.kDBizPrCompany.setRequired(true);
        this.kDBizPrCompany.setEnabled(true);
        this.kDBizPrCompany.setEditFormat("$number$");
        this.kDBizPrCompany.setDisplayFormat("$name$");
        this.kDBizPrCompany.setCommitFormat("$number$");
        this.kDBizPrCompany.setEditable(true);
        this.kDBizPrCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, PERMISSION);
        this.kDBizPrCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
    }

    protected void initDefaultUIParam() throws BOSException {
        this.cache = new ArApSysParamInfo();
        this.iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("sysEnum", SystemEnum.ACCOUNTSPAYABLE);
        map.put("isSCM", Boolean.FALSE);
        map.put("permissionItem", PERMISSION);
        this.uiParam = map;
    }

    protected HashMap getUIParam() {
        return this.uiParam;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void kDBizPrCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.kDBizPrCompany_dataChanged(e);
    }

    @Override
    protected void kdComBillType_itemStateChanged(ItemEvent e) throws Exception {
        super.kdComBillType_itemStateChanged(e);
    }

    @Override
    protected void kdComAsstActType_itemStateChanged(ItemEvent e) throws Exception {
        this.prmtAcctCussentFrom.setValue(null);
        this.prmtAcctCussentTo.setValue(null);
        Object obj = this.kdComAsstActType.getSelectedItem();
        if (this.kdComAsstActType.getItemCount() == 0 || obj == null || ComBoxInfo.ITEM_ALL.equals(obj)) {
            this.prmtAcctCussentFrom.setEnabled(false);
            this.prmtAcctCussentTo.setEnabled(false);
            return;
        }
        this.asstActTypeInfo = (AsstActTypeInfo)obj;
        if (this.asstActTypeInfo == null) {
            this.prmtAcctCussentFrom.setEnabled(false);
            this.prmtAcctCussentTo.setEnabled(false);
            return;
        }
        ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtAcctCussentFrom, (Object)this.asstActTypeInfo, this.cache, false, true);
        ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtAcctCussentTo, (Object)this.asstActTypeInfo, this.cache, false, true);
        this.prmtAcctCussentFrom.setEnabled(true);
        this.prmtAcctCussentTo.setEnabled(true);
        super.kdComAsstActType_itemStateChanged(e);
    }

    @Override
    protected void radAudit_itemStateChanged(ItemEvent e) throws Exception {
        super.radAudit_itemStateChanged(e);
    }

    @Override
    protected void radAudit_mouseClicked(MouseEvent e) throws Exception {
        super.radAudit_mouseClicked(e);
    }

    @Override
    protected void radAudit_actionPerformed(ActionEvent e) throws Exception {
        super.radAudit_actionPerformed(e);
    }

    @Override
    protected void radUnAudit_itemStateChanged(ItemEvent e) throws Exception {
        super.radUnAudit_itemStateChanged(e);
    }

    @Override
    protected void radUnAudit_mouseClicked(MouseEvent e) throws Exception {
        super.radUnAudit_mouseClicked(e);
    }

    @Override
    protected void radAuditAll_itemStateChanged(ItemEvent e) throws Exception {
        super.radAuditAll_itemStateChanged(e);
    }

    @Override
    protected void radAuditAll_mouseClicked(MouseEvent e) throws Exception {
        super.radAuditAll_mouseClicked(e);
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo filterAudit;
        String strNumber;
        FilterItemInfo toNumberFilter;
        FilterItemInfo fromNumberFilter;
        String asstActNumber;
        this.filterInfo = new FilterInfo();
        Object obj = null;
        if (this.kDBizPrCompany.getValue() != null) {
            FilterItemInfo companyFilter = null;
            companyFilter = this.kDBizPrCompany.getValue() instanceof CompanyOrgUnitInfo ? new FilterItemInfo("company.id", (Object)((CompanyOrgUnitInfo)this.kDBizPrCompany.getValue()).getId().toString(), CompareType.EQUALS) : new FilterItemInfo("company.id", (Object)((FullOrgUnitInfo)this.kDBizPrCompany.getValue()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(companyFilter);
        }
        if ((obj = this.kdComBillType.getSelectedItem()) != null && !ComBoxInfo.ITEM_ALL.equals(obj)) {
            OtherBillType billType = (OtherBillType)this.kdComBillType.getSelectedItem();
            FilterItemInfo billTypeFilter = new FilterItemInfo("billType", (Object)Integer.valueOf(String.valueOf(billType.getValue())), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(billTypeFilter);
        }
        if (this.kdApDateFrom.getTimestamp() != null) {
            FilterItemInfo fromEntryBillDateFilter = new FilterItemInfo("payPlan.recievePayDate", (Object)BaseDataUtil.downTimestamp(this.kdApDateFrom.getTimestamp()), CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(fromEntryBillDateFilter);
        }
        if (this.kdApDateTo.getTimestamp() != null) {
            FilterItemInfo toEntryBillDateFilter = new FilterItemInfo("payPlan.recievePayDate", (Object)BaseDataUtil.upTimestamp(this.kdApDateTo.getTimestamp()), CompareType.LESS);
            this.filterInfo.getFilterItems().add(toEntryBillDateFilter);
        }
        if (this.kDBizCurrency.getData() != null) {
            String currencyId = ((CurrencyInfo)this.kDBizCurrency.getData()).getId().toString();
            FilterItemInfo currencyFilter = new FilterItemInfo("currency.id", (Object)currencyId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(currencyFilter);
        }
        if ((obj = this.kdComAsstActType.getSelectedItem()) != null && !ComBoxInfo.ITEM_ALL.equals(obj)) {
            String assActTypeId = ((AsstActTypeInfo)this.kdComAsstActType.getSelectedItem()).getId().toString();
            FilterItemInfo asstActTypeFiter = new FilterItemInfo("asstActType.id", (Object)assActTypeId, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(asstActTypeFiter);
        }
        if (this.prmtAcctCussentFrom.getData() != null) {
            asstActNumber = ArApBillUIUtil.getNumberValue(this.prmtAcctCussentFrom);
            fromNumberFilter = new FilterItemInfo("asstActNumber", (Object)asstActNumber, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.prmtAcctCussentTo.getData() != null) {
            asstActNumber = ArApBillUIUtil.getNumberValue(this.prmtAcctCussentTo);
            toNumberFilter = new FilterItemInfo("asstActNumber", (Object)asstActNumber, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(toNumberFilter);
        }
        if (this.kDBizBillNumFrom.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.kDBizBillNumFrom);
            fromNumberFilter = new FilterItemInfo("number", (Object)strNumber, CompareType.GREATER_EQUALS);
            this.filterInfo.getFilterItems().add(fromNumberFilter);
        }
        if (this.kDBizBillNumTo.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.kDBizBillNumTo);
            toNumberFilter = new FilterItemInfo("number", (Object)strNumber, CompareType.LESS_EQUALS);
            this.filterInfo.getFilterItems().add(toNumberFilter);
        }
        if (this.kDBizFundProperty.getData() != null) {
            strNumber = ArApBillUIUtil.getNumberValue(this.kDBizFundProperty);
            FilterItemInfo itemInfo = new FilterItemInfo("payPlan.fundProperty.number", (Object)strNumber, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(itemInfo);
        }
        if (this.radAudit.isSelected()) {
            filterAudit = new FilterItemInfo("billStatus", (Object)new Integer(3), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterAudit);
        } else if (this.radUnAudit.isSelected()) {
            filterAudit = new FilterItemInfo("billStatus", (Object)new Integer(3), CompareType.NOTEQUALS);
            this.filterInfo.getFilterItems().add(filterAudit);
        }
        return this.filterInfo;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.kDBizPrCompany;
    }

    public void loadData(EntityViewInfo ev) {
        this.clear();
        FilterItemCollection filters = ev.getFilter().getFilterItems();
        Object obj = ArApBillUIUtil.getCompareValue(filters, "company.id", CompareType.EQUALS);
        if (obj != null) {
            CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
            companyInfo.setId(BOSUuid.read((String)obj.toString()));
            try {
                if (!ArApBillHelper.idEquals((CoreBaseInfo)this.cache.getCompany(), (CoreBaseInfo)companyInfo)) {
                    this.cache = this.iBillFacade.getSysParams(companyInfo, this.getUIParam());
                }
                ArApQueryUIUtil.setBizCompanyData(this.kDBizPrCompany, obj.toString());
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((obj = ArApBillUIUtil.getCompareValue(filters, "currency.id", CompareType.EQUALS)) != null) {
            this.setBizPromptData(this.kDBizCurrency, obj.toString());
        } else {
            this.kDBizCurrency.setValue(null);
        }
        obj = ArApBillUIUtil.getCompareValue(filters, "payPlan.recievePayDate", CompareType.GREATER_EQUALS);
        if (obj != null) {
            this.kdApDateFrom.setValue((Object)new Date(((Timestamp)obj).getTime()));
        } else {
            this.kdApDateFrom.setValue(null);
        }
        obj = ArApBillUIUtil.getCompareValue(filters, "payPlan.recievePayDate", CompareType.LESS);
        if (obj != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)obj);
            calendar.add(5, -1);
            this.kdApDateTo.setValue((Object)calendar.getTime());
        } else {
            this.kdApDateTo.setValue(null);
        }
        obj = ArApBillUIUtil.getCompareValue(filters, "number", CompareType.GREATER_EQUALS);
        this.kDBizBillNumFrom.setValue(obj);
        obj = ArApBillUIUtil.getCompareValue(filters, "number", CompareType.LESS_EQUALS);
        this.kDBizBillNumTo.setValue(obj);
        obj = ArApBillUIUtil.getCompareValue(filters, "billType", null);
        if (obj != null) {
            int itemCount = this.kdComBillType.getItemCount();
            for (int j = 0; j < itemCount; ++j) {
                OtherBillType billType;
                if (!(this.kdComBillType.getItemAt(j) instanceof OtherBillType) || (billType = (OtherBillType)this.kdComBillType.getItemAt(j)).getValue() != Integer.parseInt(obj.toString())) continue;
                this.kdComBillType.setSelectedIndex(j);
            }
        }
        if ((obj = ArApBillUIUtil.getCompareValue(filters, "asstActType.id", null)) != null) {
            int itemCount = this.kdComAsstActType.getItemCount();
            for (int j = 0; j < itemCount; ++j) {
                String assActTypeId;
                if (this.kdComAsstActType.getItemAt(j).equals(ComBoxInfo.ITEM_ALL) || !(assActTypeId = ((AsstActTypeInfo)this.kdComAsstActType.getItemAt(j)).getId().toString()).equals(obj.toString())) continue;
                this.kdComAsstActType.setSelectedIndex(j);
                break;
            }
        }
        obj = ArApBillUIUtil.getCompareValue(filters, "asstActNumber", CompareType.GREATER_EQUALS);
        this.prmtAcctCussentFrom.setValue(obj);
        obj = ArApBillUIUtil.getCompareValue(filters, "asstActNumber", CompareType.LESS_EQUALS);
        this.prmtAcctCussentTo.setValue(obj);
        obj = ArApBillUIUtil.getCompareValue(filters, "billStatus", CompareType.EQUALS);
        if (obj != null) {
            this.radAudit.setSelected(true);
        }
        if ((obj = ArApBillUIUtil.getCompareValue(filters, "billStatus", CompareType.NOTEQUALS)) != null) {
            this.radUnAudit.setSelected(true);
        }
        if ((obj = ArApBillUIUtil.getCompareValue(filters, "payPlan.fundProperty.number", CompareType.EQUALS)) != null) {
            this.kDBizFundProperty.setValue(obj);
        }
    }

    public void clear() {
        if (this.getUIContext().get("ARAPCOMPANY") != null) {
            this.kDBizPrCompany.setValue(this.getUIContext().get("ARAPCOMPANY"));
            this.kDBizPrCompany.setEnabled(true);
        } else {
            try {
                this.cache = this.iBillFacade.getSysParams(null, this.getUIParam());
                this.kDBizPrCompany.setValue((Object)this.cache.getCompany());
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
        this.kDBizCurrency.setValue(null);
        this.prmtAcctCussentFrom.setValue(null);
        this.prmtAcctCussentTo.setValue(null);
        this.kdApDateTo.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        this.kdApDateFrom.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        this.kDBizBillNumFrom.setValue(null);
        this.kDBizBillNumTo.setValue(null);
        try {
            ArApBillUIUtil.makeAsstActType(this.kdComAsstActType, this.cache, true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.kdComBillType.setSelectedItem((Object)ComBoxInfo.ITEM_ALL);
    }

    private void setBizPromptData(KDBizPromptBox bizPrompt, String id) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            IObjectValue objVal = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk);
            bizPrompt.setData((Object)objVal);
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = new RequestContext();
            this.prepareHandlerParam(request);
            request.setClassName(this.getUIHandlerClassName());
            handler.setRequestContext((Serializable)request);
        }
        return handler;
    }

    private void prepareHandlerParam(RequestContext request) {
        request.put("uiparam", (Object)this.getUIParam());
        request.put("cache", (Object)this.cache);
    }

    private void setFundProperty() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        this.kDBizFundProperty.setEntityViewInfo(viewInfo);
    }
}

