/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillBeforGroupListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.client.ReasonF7Until;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ap.IPayRequestBill;
import com.kingdee.eas.fi.ap.PayRequestBillBizException;
import com.kingdee.eas.fi.ap.PayRequestBillCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryInfo;
import com.kingdee.eas.fi.ap.PayRequestBillFactory;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.ap.client.AbstractPayRequestBillListUI;
import com.kingdee.eas.fi.ap.client.PayRequestBillQueryUI;
import com.kingdee.eas.fi.ap.util.PayReqUtils;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.KDTableUtils;
import com.kingdee.eas.fi.arap.client.util.ArApBatchUtil;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.util.BizOrgEnum;
import com.kingdee.eas.framework.util.DateEnum;
import com.kingdee.eas.scm.common.client.BillOptionsHelper;
import com.kingdee.eas.scm.common.client.PrecisionConfigUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class PayRequestBillListUI
extends AbstractPayRequestBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(PayRequestBillListUI.class);
    private CommonQueryDialog dialog;
    protected PayRequestBillQueryUI userPanel = null;
    public ArApSysParamInfo cache = null;
    protected IArApBillFacade iBillFacade;
    protected boolean isZeroDisplay = false;
    private IUIWindow precisionConfigWindow = null;
    protected int qtyPrecision = 10;
    protected int basePrecision = 2;
    protected int exPrecision = 10;
    protected int taxRatePrecision = 2;
    protected int pricePrecision = 10;
    protected static final String strTakeOutZeroFormat = "%{0.##########}f";
    protected static final String strTaxRateZeroFormat = "%{0.00}f";
    protected String[] PRICE_FIELDS = new String[0];
    public static final String COL_PROCESSNODE = "processNode";
    public static final String PAYMENTBILL_BOS_TYPE = "40284E81";
    protected String[] AMOUNT_FIELDS = new String[]{"entrys.reqPayAmount", "requestAmount", "auditAmount", "entrys.auditAmount0", "entrys.srcPpayUnreqAmt", "entrys.srcUnreqAmt", "entrys.totalPayAmt", "entrys.unpayAmount", "entrys.lockAmount", "entrys.unLockAmount"};
    protected String[] BASEAMOUNT_FIELDS = new String[]{"entrys.auditAmountLoc", "lockAmtLoc", "unLockAmtLoc", "entrys.unLockAmountLoc", "entrys.lockAmountLoc"};
    protected String[] NUBMERFORMAT_COLS = new String[]{"requestAmount", "auditAmount", "entrys.reqPayAmount", "entrys.auditAmount0", "entrys.srcPpayUnreqAmt", "entrys.srcUnreqAmt", "entrys.totalPayAmount", "entrys.unpayAmount", "entrys.auditAmountLoc", "lockAmt", "unLockAmt", "lockAmtLoc", "unLockAmtLoc"};
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public PayRequestBillListUI() throws Exception {
        this.iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
        this.cache = new ArApSysParamInfo();
    }

    protected String[] getQueryShowField() {
        return new String[]{"requestAmount", "auditAmount", "company.name", "number", "billstatus", "bizDate", "entrys.payDay", "entrys.asstActType.name", "entrys.asstActName", "currency", "entrys.payType.name", "entrys.banlanceType.name", "entrys.payBank.name", "entrys.payBankAccount", "entrys.reqPayAmount", "entrys.auditAmount0", "otherPayerAccount.name", "id", "entrys.id"};
    }

    protected String[] getQueryHideField() {
        return new String[]{"company.id"};
    }

    protected boolean isLazyMode() {
        return !Boolean.TRUE.equals(this.getUIContext().get("isFromWorkflowMultiapprove"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        PayRequestBillInfo info = this.getSelectedInfo();
        if (!this.cache.isImportBillModifiable() && info.isIsImportBill()) {
            throw new PayRequestBillBizException(PayRequestBillBizException.IMPORT_BILL_CANNOT_EDIT);
        }
        if (BillStatusEnum.AUDITED.equals((Object)info.getBillStatus())) {
            throw new PayRequestBillBizException(PayRequestBillBizException.AUDITED_BILL_EDIT);
        }
        if (BillStatusEnum.DELETED.equals((Object)info.getBillStatus())) {
            throw new PayRequestBillBizException(PayRequestBillBizException.HASIGNOER_CANNOTDOTHIS);
        }
        Boolean hasColseEntry = false;
        PayRequestBillEntryInfo entry = null;
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            entry = info.getEntrys().get(i);
            if (!BillStatusEnum.COLSED.equals((Object)entry.getEntryStatus())) continue;
            hasColseEntry = true;
            break;
        }
        if (hasColseEntry.booleanValue()) {
            throw new PayRequestBillBizException(PayRequestBillBizException.HASCLOSE_CANNOTDOTHIS);
        }
        super.actionEdit_actionPerformed(e);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.setColumnMoveable(true);
    }

    public boolean isAutoIgnoreZero() {
        return false;
    }

    public void onLoad() throws Exception {
        QuickFilteringSupportItems qfsi = this.getQuickFilteringSupport();
        if (qfsi != null && qfsi.getSystemSolutionItem().getDefaultFilter().size() == 0) {
            qfsi.getSystemSolutionItem().getDefaultFilter().add("company.id", CompareType.EQUALS, (Object)BizOrgEnum.DEFAULTMAINORG).add("bizDate", CompareType.IS, (Object)DateEnum.RECENTONEMONTH);
        }
        this.getMainTable().getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                PayRequestBillListUI.this.tbl_afterDataFill(e);
            }
        });
        this.getMainTable().getDataRequestManager().addDataFillBeforeGroup(new KDTDataFillBeforGroupListener(){

            public void beforeGroupAction(KDTDataRequestEvent e) {
                try {
                    ArApBillUIUtil.tbl_afterDataFillDealProcessNode(PayRequestBillListUI.this.getMainTable(), PayRequestBillListUI.COL_PROCESSNODE, e);
                }
                catch (Exception e1) {
                    PayRequestBillListUI.this.handUIException(e1);
                }
            }
        });
        super.onLoad();
        ArApBillUIUtil.setSysStatusBarTitle((CoreUI)this, this.cache.getCurrentPeriod(this.getSysEnum()));
        this.actionViewImage.setEnabled(true);
        this.ActionTDPrint.setEnabled(true);
        this.ActionTDPrintPreview.setEnabled(true);
        this.ActionBatchSubmit.setEnabled(true);
        this.ActionViewBdgBalance.setEnabled(true);
        this.ActionAudit.setEnabled(true);
        this.ActionAntiAudit.setEnabled(true);
        this.menuItemMultiPrint.setIcon(EASResource.getIcon((String)"imgTbtn_printcontinue"));
        this.menuItemMultiPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_printpreview"));
        this.ActionMultiPrint.setEnabled(true);
        this.ActionMultiPrintPreview.setEnabled(true);
        this.menuItemBatchSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_referbatch"));
        this.btnBatchSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_referbatch"));
        this.actionSetZeroNotDisplay.setEnabled(true);
        this.actionSetDataPrecision.setEnabled(true);
        this.tblMain.getColumn("fundFlowItem").getStyleAttributes().setHided(true);
        this.setDateDisplay();
        this.addHidedUI();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionIgnore_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String confirmMsg = EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"CONFIRM_IGNORE");
        int ok = MsgBox.showConfirm2((Component)((Object)this), (String)confirmMsg);
        if (ok == 2) {
            return;
        }
        ArrayList idList = this.getSelectedIdValues();
        ArApBatchUtil.requestPureMutex(idList);
        Class[] clz = new Class[]{IObjectPK.class};
        ArApBatchUtil.batchOperaction((CoreUI)this, this.getSelectedIdValues(), this.getBizInterface(), this.getBOSEntity().getAlias(), EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"IGNORE"), "ignore", clz);
        ArApBatchUtil.releasePureMutex(idList);
        this.refreshList();
    }

    @Override
    protected void Remove() throws Exception {
        CoreBaseInfo editData = this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())));
        if (editData == null) {
            throw new ObjectNotFoundException(ResourceBase.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"BILL_NOT_FOUND", (Locale)SysContext.getSysContext().getLocale()));
        }
        super.Remove();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PayRequestBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected IObjectValue createNewData() {
        PayRequestBillInfo objectValue = new PayRequestBillInfo();
        return objectValue;
    }

    protected KDTable getDetailTable() {
        return null;
    }

    @Override
    protected PayRequestBillQueryUI getUserPanel() throws Exception {
        if (this.userPanel == null) {
            this.userPanel = new PayRequestBillQueryUI(this.getUIParam());
        }
        return this.userPanel;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            this.getUserPanel().getUIContext().put("ARAPCOMPANY", ((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("ARAPCOMPANY"));
        }
        super.actionQuery_actionPerformed(e);
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected EntityViewInfo getDefaultEntityViewInfo() {
        return super.getDefaultEntityViewInfo();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        if (this.getBOTPViewStatus() == 1) {
            this.getUIContext().put("SumVisible", "true");
        }
        return super.getDefaultFilterForQuery();
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        if (ev == null || ev.getFilter() == null) {
            return;
        }
        this.setListSorter(ev);
        super.beforeExcutQuery(this.beforeExcutQueryCommon(ev));
    }

    protected void setListSorter(EntityViewInfo ev) {
        boolean hasNumberSorter = false;
        boolean hasSeqSorter = false;
        if (ev.getSorter() != null && ev.getSorter().size() > 0 && !ev.getSorter().toString().equals("")) {
            SorterItemCollection sorters = ev.getSorter();
            int sorterSize = sorters.size();
            for (int i = 0; i < sorterSize; ++i) {
                if (sorters.get(i).getPropertyName().equals("number")) {
                    hasNumberSorter = true;
                    continue;
                }
                if (!sorters.get(i).getPropertyName().equals(this.getEntriesName() + ".seq")) continue;
                hasSeqSorter = true;
            }
        }
        if (!hasNumberSorter) {
            SorterItemInfo aSorterItemInfo = new SorterItemInfo("number");
            aSorterItemInfo.setSortType(SortType.DESCEND);
            ev.getSorter().add(aSorterItemInfo);
        }
        if (!hasSeqSorter) {
            SorterItemInfo bSorterItemInfo = new SorterItemInfo(this.getEntriesName() + ".seq");
            bSorterItemInfo.setSortType(SortType.ASCEND);
            ev.getSorter().add(bSorterItemInfo);
        }
    }

    protected EntityViewInfo beforeExcutQueryCommon(EntityViewInfo ev) {
        if (ev == null || ev.getFilter() == null) {
            ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            ev.setFilter(filter);
        }
        FilterInfo oldFilter = ev.getFilter();
        CompanyOrgUnitInfo company = null;
        Map map = (Map)this.getUIContext().get("BTPEDITPARAMETER");
        if (map != null && map.get("ARAPCOMPANY") != null) {
            company = (CompanyOrgUnitInfo)map.get("ARAPCOMPANY");
        } else {
            BOSUuid id = this.getCompanyIdFromFilter(oldFilter);
            if (id != null) {
                company = new CompanyOrgUnitInfo();
                company.setId(id);
            }
            if (company == null && this.getUIContext().get("BTPNAVCTX") == null) {
                try {
                    if (SysContext.getSysContext().getCurrentFIUnit().isIsBizUnit()) {
                        company = SysContext.getSysContext().getCurrentFIUnit();
                    }
                }
                catch (Exception e) {
                    this.handUIExceptionAndAbort(e);
                    SysUtil.abort();
                }
            }
        }
        FilterInfo filter = new FilterInfo();
        int iFilterCounter = 0;
        StringBuffer maskStr = new StringBuffer();
        if (company != null) {
            if (!ArApBillHelper.idEquals((CoreBaseInfo)this.cache.getCompany(), (CoreBaseInfo)company)) {
                try {
                    this.cache = this.iBillFacade.getSysParams(company, this.getUIParam());
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    this.handUIExceptionAndAbort(e);
                }
            }
            if (this.cache != null && this.cache.getBaseCurrency() != null) {
                KDTableUtils.setBigDecimalColumnPrecision(this.tblMain, this.BASEAMOUNT_FIELDS, this.cache.getBaseCurrency().getPrecision());
            }
            FilterItemInfo companyFilter = new FilterItemInfo("company.id", (Object)company.getId(), CompareType.EQUALS);
            filter.getFilterItems().add(companyFilter);
            maskStr.append(" #").append(iFilterCounter++);
        }
        boolean isBtpFiler = null != map && null != map.get("TargetBillType") && "PaymentBill".equals(map.get("TargetBillType"));
        FilterInfo botfilter = new FilterInfo();
        if (isBtpFiler) {
            FilterItemInfo paySchedualFilter = new FilterItemInfo("isPaySchedule", (Object)0, CompareType.EQUALS);
            botfilter.getFilterItems().add(paySchedualFilter);
            FilterItemInfo statusFilter = new FilterItemInfo("billStatus", (Object)3);
            botfilter.getFilterItems().add(statusFilter);
        }
        try {
            if (filter.getFilterItems().size() > 0) {
                oldFilter.mergeFilter(filter, "AND");
            }
            if (oldFilter.getFilterItems().size() > 0) {
                oldFilter.mergeFilter(botfilter, "AND");
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        ev.setFilter(oldFilter);
        int count = ev.getFilter().getFilterItems().size();
        for (int i = 0; i < count; ++i) {
            FilterItemInfo fii = ev.getFilter().getFilterItems().get(i);
            String compareName = fii.getPropertyName();
            if (!compareName.equals("auditDate") && !compareName.equals("createTime") && !compareName.equals("lastUpdateTime")) continue;
            this.getFilterForTime(oldFilter, Calendar.getInstance(), fii, compareName);
        }
        return ev;
    }

    protected BOSUuid getCompanyIdFromFilter(FilterInfo oldFilter) {
        if (oldFilter == null || oldFilter.getFilterItems() == null) {
            return null;
        }
        BOSUuid id = null;
        for (FilterItemInfo filterItem : oldFilter.getFilterItems()) {
            if (!"company.id".equals(filterItem.getPropertyName()) || filterItem.getCompareValue() == null) continue;
            String sCompanyId = filterItem.getCompareValue().toString();
            try {
                id = BOSUuid.read((String)sCompanyId);
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
            break;
        }
        return id;
    }

    public PayRequestBillInfo getSelectedInfo() {
        String selectedID = this.getSelectedKeyValue();
        PayRequestBillInfo info = null;
        try {
            IPayRequestBill iPayReqBll = PayRequestBillFactory.getRemoteInstance();
            info = iPayReqBll.getPayRequestBillInfo((IObjectPK)new ObjectUuidPK(selectedID));
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return info;
    }

    protected void updateInfoByCompany(DataBaseInfo info) throws Exception {
        this.cache = this.iBillFacade.getSysParams(null, this.getUIParam());
    }

    protected void updateUIByCompany(boolean isRequireInitCompany) throws Exception {
        if (isRequireInitCompany) {
            this.initCompany();
        }
    }

    protected void initCompany() throws EASBizException, BOSException {
        if (this.cache.getCompany() == null) {
            this.cache = this.iBillFacade.getSysParams(null, this.getUIParam());
        }
    }

    @Override
    public void actionSetDataPrecision_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        if (this.precisionConfigWindow == null) {
            this.precisionConfigWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.common.client.PrecisionConfigUI", (Map)uiContext, null, OprtState.EDIT);
        }
        PrecisionConfigUI aPrecisionConfigUI = (PrecisionConfigUI)this.precisionConfigWindow.getUIObject();
        this.precisionConfigWindow.show();
        if (!aPrecisionConfigUI.isCancel()) {
            this.qtyPrecision = aPrecisionConfigUI.getQtyPrecision();
            this.pricePrecision = aPrecisionConfigUI.getPricePrecision();
            this.exPrecision = aPrecisionConfigUI.getExPrecision();
            this.taxRatePrecision = aPrecisionConfigUI.getTaxRatePrecision();
            this.setZeroDisplay();
        }
    }

    protected void setZeroDisplay() {
        if (this.isZeroDisplay) {
            this.setCollumnFormat(this.PRICE_FIELDS, strTakeOutZeroFormat);
        } else {
            this.setCollumnFormat(this.PRICE_FIELDS, PrecisionFormatUtils.getFormatString(this.pricePrecision));
        }
    }

    protected void setCollumnFormat(String[] needAdaptCollumn, String strTakeOutZeroFormat) {
        for (int i = 0; i < needAdaptCollumn.length; ++i) {
            this.tblMain.getColumn(needAdaptCollumn[i]).getStyleAttributes().setNumberFormat(strTakeOutZeroFormat);
        }
    }

    @Override
    public void actionSetZeroNotDisplay_actionPerformed(ActionEvent e) throws Exception {
        this.isZeroDisplay = this.menuItemZeroNotDisplay.isSelected();
        this.setZeroDisplay();
    }

    @Override
    public String[] getMergeColumnKeys() {
        return new String[]{"requestAmount", "auditAmount", "id", "company.name", "number", "billstatus", "bizDate", "id", "id", "currency", "creator.name", "createTime", "lastUpdateUser.name", "lastUpdateTime", "auditor.name", "auditDate", "costCenter", COL_PROCESSNODE, "isImportBill"};
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        return sic;
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog commonQueryDialog = super.initCommonQueryDialog();
        commonQueryDialog.getCommonQueryParam().getProcessors().set("isPayReq", (Object)true);
        return commonQueryDialog;
    }

    @Override
    protected String getTDFileName() {
        return "/FI/AP/PayRequestBill";
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = new RequestContext();
            request.put("uiparam", (Object)this.getUIParam());
            request.setClassName(this.getUIHandlerClassName());
            if (this.getUIContext().get("BTPNAVCTX") != null) {
                request.put("BTPNAVCTX", (Object)true);
            }
            request.put("CONFIG_TYPE_VIEW", (Object)BillOptionsHelper.getConfigTypeAllEntityView((String)this.getMetaDataPK().getFullName().toString()));
            request.put("_SCMMAINORGTYPE", (Object)this.getMainBizOrgType());
            request.setMainOrgType(this.getMainBizOrgType());
            handler.setRequestContext((Serializable)request);
        }
        return handler;
    }

    public String getsourceBillEntryId() {
        return "entrys.sourceBillEntryid";
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            Map colMap = null;
            while (rowSet.next()) {
                if (colMap == null) {
                    colMap = SCMClientUtils.getColumnsByRowSet((IRowSet)rowSet);
                }
                SCMClientUtils.iniColumnsPrecision((int)rowSet.getInt("currency.precision"), (String[])this.AMOUNT_FIELDS, (IRowSet)rowSet, (Map)colMap);
            }
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("UI_System", SourceTypeEnum.AP);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length == 0) {
            return;
        }
        String sourceSysType = ListUiHelper.getSelectedKeyValue((int[])selectRows, (KDTable)this.tblMain, (String)"sourceSysType");
        if (this.isCasPayType(sourceSysType)) {
            this.getUIContext().put("UI_System", SourceTypeEnum.CASH);
        }
        super.actionTraceDown_actionPerformed(e);
    }

    private boolean isCasPayType(String sourceSysType) {
        return SourceTypeEnum.CASH.getAlias().equals(sourceSysType);
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.supportExecutionWithoutFilters();
        if (this.cache == null || this.cache.getCompany() == null) {
            try {
                IArApBillFacade iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
                this.cache = iBillFacade.getSysParams(null, this.getUIParam());
                return this.qfsi.supportSingleMainOrg((OrgUnitInfo)this.cache.getCompany());
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
        return this.qfsi;
    }

    protected String getOrgFieldName() {
        return "company.id";
    }

    private void setDateDisplay() {
        String fmt = CtrlFormatUtilities.getDateFormatString();
        String timeFmt = CtrlFormatUtilities.getDateTimeFormatString();
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(fmt);
        this.tblMain.getColumn("entrys.payDay").getStyleAttributes().setNumberFormat(fmt);
        this.tblMain.getColumn("auditDate").getStyleAttributes().setNumberFormat(timeFmt);
    }

    public void tbl_afterDataFill(KDTDataRequestEvent e) {
        if (!(this.NUBMERFORMAT_COLS != null && this.NUBMERFORMAT_COLS.length != 0 || this.NUBMERFORMAT_COLS != null && this.NUBMERFORMAT_COLS.length != 0)) {
            return;
        }
        int from = e.getFirstRow();
        int last = e.getLastRow();
        BigDecimal amout = null;
        for (int i = from; i <= last; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row == null) continue;
            if (this.NUBMERFORMAT_COLS != null && this.NUBMERFORMAT_COLS.length > 0) {
                for (int j = 0; j < this.NUBMERFORMAT_COLS.length; ++j) {
                    Object scaleObj;
                    if (row.getCell(this.NUBMERFORMAT_COLS[j]) == null || (scaleObj = row.getCell(this.NUBMERFORMAT_COLS[j]).getValue()) == null || !(scaleObj instanceof BigDecimal)) continue;
                    amout = (BigDecimal)scaleObj;
                    row.getCell(this.NUBMERFORMAT_COLS[j]).getStyleAttributes().setNumberFormat(PrecisionFormatUtils.getFormatString(amout.scale()));
                }
            }
            if (this.tblMain.getColumn("entrys.asstActType.name") == null || row.getCell("entrys.asstActType.name").getValue() != null) continue;
            row.getCell("entrys.asstActType.name").setValue((Object)FMSysDefinedEnum.OTHER);
        }
    }

    private void getFilterForTime(FilterInfo oldFilter, Calendar curDate, FilterItemInfo fii, String compareName) {
        if (fii.getCompareType().equals((Object)CompareType.EQUALS)) {
            fii.setCompareType(CompareType.GREATER_EQUALS);
            curDate.setTime((Date)fii.getCompareValue());
            curDate.set(curDate.get(1), curDate.get(2), curDate.get(5), 23, 59, 59);
            FilterInfo filter = new FilterInfo();
            FilterItemInfo paymentBillFilter = new FilterItemInfo(compareName, (Object)new Date(curDate.getTimeInMillis()), CompareType.LESS_EQUALS);
            filter.getFilterItems().add(paymentBillFilter);
            try {
                oldFilter.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        if (fii.getCompareType().equals((Object)CompareType.LESS_EQUALS)) {
            curDate.setTime((Date)fii.getCompareValue());
            curDate.set(curDate.get(1), curDate.get(2), curDate.get(5), 23, 59, 59);
            fii.setCompareValue((Object)new Date(curDate.getTimeInMillis()));
        }
        if (fii.getCompareType().equals((Object)CompareType.NOTEQUALS)) {
            Date oldDate = (Date)fii.getCompareValue();
            curDate.setTime((Date)fii.getCompareValue());
            curDate.set(1949, 1, 1, 0, 0, 0);
            fii.setCompareType(CompareType.GREATER_EQUALS);
            fii.setCompareValue((Object)new Timestamp(curDate.getTimeInMillis()));
            Calendar worldTour = Calendar.getInstance();
            worldTour.setTime(oldDate);
            worldTour.add(5, 1);
            Date endDay = worldTour.getTime();
            FilterInfo filter = new FilterInfo();
            FilterItemInfo paymentBillFilter = new FilterItemInfo(compareName, (Object)oldDate, CompareType.LESS);
            filter.getFilterItems().add(paymentBillFilter);
            FilterItemInfo paymentBillFilter1 = new FilterItemInfo(compareName, (Object)endDay, CompareType.GREATER_EQUALS);
            filter.getFilterItems().add(paymentBillFilter1);
            FilterItemInfo paymentBillFilter2 = new FilterItemInfo(compareName, null, CompareType.EQUALS);
            filter.getFilterItems().add(paymentBillFilter2);
            filter.setMaskString(" #0 OR #1 OR #2 ");
            try {
                oldFilter.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            curDate.setTime(oldDate);
        }
        if (fii.getCompareType().equals((Object)CompareType.GREATER)) {
            curDate.setTime((Date)fii.getCompareValue());
            curDate.set(curDate.get(1), curDate.get(2), curDate.get(5), 23, 59, 59);
            fii.setCompareValue((Object)new Timestamp(curDate.getTimeInMillis()));
        }
    }

    @Override
    protected String getBillEntryName() {
        return "entrys";
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.ActionViewBdgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_inquirebudget"));
        this.menuItemClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.menuItemUnClose.setIcon(EASResource.getIcon((String)"imgTbtn_fclose"));
    }

    @Override
    protected CoreUI getListUI() {
        return this;
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        Set ids = this.getSelectedIdSet();
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add(new SelectorItemInfo("isPaySchedule"));
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        try {
            PayRequestBillCollection coll = ((IPayRequestBill)this.getBizInterface()).getPayRequestBillCollection(ev);
            Iterator payReqIterator = coll.iterator();
            while (payReqIterator.hasNext()) {
                IObjectValue payReqInfo = (IObjectValue)payReqIterator.next();
                if (!payReqInfo.getBoolean("isPaySchedule")) continue;
                int k = destBosTypeList.indexOf(PAYMENTBILL_BOS_TYPE);
                if (k != -1) {
                    destBosTypeList.remove(k);
                }
                break;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return destBosTypeList;
    }

    protected void addHidedUI() {
        InputMap imEntry = this.getInputMap(2);
        KeyStroke ctrl_shift_u = KeyStroke.getKeyStroke("shift ctrl U ");
        imEntry.put(ctrl_shift_u, "UPDATE_SUM_ENTRY");
        ActionMap entryActionMap = this.getActionMap();
        entryActionMap.put("UPDATE_SUM_ENTRY", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                    UIContext uiContext = new UIContext((Object)this);
                    IUIWindow wnd = fy.create("com.kingdee.eas.fi.ap.client.PayReqHandleSumEntry", (Map)uiContext);
                    wnd.show();
                }
                catch (UIException ex) {
                    SysUtil.abort((Throwable)ex);
                }
            }
        });
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!PayRequestBillListUI.isSameStatus(this.tblMain, BillStatusEnum.AUDITED)) {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("BILLISNOT_AUDIT_CANNOT"));
            SysUtil.abort();
        }
        this.getUIContext().put("UI_System", SourceTypeEnum.AP);
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length == 0) {
            return;
        }
        String sourceSysType = ListUiHelper.getSelectedKeyValue((int[])selectRows, (KDTable)this.tblMain, (String)"sourceSysType");
        if (this.isCasPayType(sourceSysType)) {
            this.getUIContext().put("UI_System", SourceTypeEnum.CASH);
        }
        super.actionCreateTo_actionPerformed(e);
    }

    public static boolean isSameStatus(KDTable tblMain, BillStatusEnum status) {
        List selectedRows = ArApBillUIUtil.getSelectedRows(tblMain);
        boolean isSameStatus = true;
        for (int i = 0; i < selectedRows.size(); ++i) {
            IRow row = (IRow)selectedRows.get(i);
            BizEnumValueInfo billStatus = (BizEnumValueInfo)row.getCell("billstatus").getValue();
            if (billStatus == null || billStatus.getInt() == status.getValue()) continue;
            isSameStatus = false;
            break;
        }
        return isSameStatus;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    protected ArrayList getImportParam() {
        DatataskCaller task = new DatataskCaller();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "PayRequestBillImport";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"232_PAYREQUEST_BILL");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getExportParam() {
        String solutionName;
        HashSet selectIds = new HashSet(this.getSelectedIdValues());
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "PayRequestBillImport";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"232_PAYREQUEST_BILL");
        if (this.mainQuery != null) {
            EntityViewInfo env = new EntityViewInfo();
            env.setFilter(new FilterInfo());
            if (selectIds.size() > 0) {
                env.getFilter().getFilterItems().add(new FilterItemInfo("id", selectIds, CompareType.INCLUDE));
            } else {
                env.setFilter(this.mainQuery.getFilter());
            }
            if (this.mainQuery.getSorter() != null) {
                env.setSorter(this.mainQuery.getSorter());
            }
            param.putContextParam((Object)"mainQueryPK", (Object)new MetaDataPK("com.kingdee.eas.fi.ap.app.PayRequestBillQuery"));
            param.putContextParam((Object)"mainQuery", (Object)env);
        }
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        task.invoke(para, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        String[] entryIDs = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"entrys.id");
        if (entryIDs == null || entryIDs.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        List<String> idList = Arrays.asList(entryIDs);
        ArApBatchUtil.requestPureMutex(idList);
        try {
            Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showClosedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            if (reasonCodeInfo == null) {
                SysUtil.abort();
            } else {
                Map<String, String> result = PayReqUtils.batchExecute(null, new HashSet<String>(idList), "close", new Object[]{reasonCodeInfo.toString()});
                if (!StringUtils.isEmpty((String)result.get("detailMsg"))) {
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)result.get("summaryMsg"), (String)result.get("detailMsg"), (int)8188);
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)result.get("summaryMsg"));
                }
            }
        }
        finally {
            ArApBatchUtil.releasePureMutex(idList);
        }
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnClose_actionPerformed(ActionEvent e) throws Exception {
        String[] entryIDs = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"entrys.id");
        if (entryIDs == null || entryIDs.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        List<String> idList = Arrays.asList(entryIDs);
        try {
            ArApBatchUtil.requestPureMutex(idList);
            Map<String, String> result = PayReqUtils.batchExecute(null, new HashSet<String>(idList), "unClose", null);
            if (!StringUtils.isEmpty((String)result.get("detailMsg"))) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)result.get("summaryMsg"), (String)result.get("detailMsg"), (int)8188);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)result.get("summaryMsg"));
            }
        }
        finally {
            ArApBatchUtil.releasePureMutex(idList);
        }
        this.refreshList();
    }

    protected List getMainBizOrgs(QuerySolutionInfo solution) {
        ArrayList<Object> mainOrg = new ArrayList<Object>();
        try {
            if (solution != null && solution.getEntityViewInfo() != null) {
                EntityViewInfo ev = new EntityViewInfo(solution.getEntityViewInfo());
                FilterInfo filter = ev.getFilter();
                for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                    FilterItemInfo filterItem = filter.getFilterItems().get(i);
                    if (!"company.id".equals(filterItem.getPropertyName())) continue;
                    mainOrg.add(filterItem.getCompareValue());
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return mainOrg;
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"IDList", null);
        PayRequestBillInfo bill = PayRequestBillFactory.getRemoteInstance().getPayRequestBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (bill.isBotpBill()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"BOTP_BILL_CAN_NOT_DO_THIS"));
            SysUtil.abort();
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.COPYADDNEW);
        uiWindow.show();
        this.setActionEvent(e);
        if (this.isDoRefresh(uiWindow)) {
            if (UtilRequest.isPrepare((String)"ActionRefresh", (CoreUIObject)this)) {
                this.prepareRefresh(null).callHandler();
            }
            this.refresh(e);
            this.setPreSelecteRow();
        }
    }
}

