/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.ArApPaymentTypeEnum;
import com.kingdee.eas.fi.ap.VerificationParams;
import com.kingdee.eas.fi.ap.client.AbstractVerificationQueryUI;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.ComBoxInfo;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.KDBizPromptBoxDecorator;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fm.ps.FundPropertyInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class VerificationQueryUI
extends AbstractVerificationQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(VerificationQueryUI.class);
    private CompanyOrgUnitInfo currentCompany = null;
    protected String verificateType;
    private int topDefaultAsstActTypeIndex = 0;
    private int bottomDefaultAsstActTypeIndex = 0;
    private VerificationParams params = null;
    private HashMap initUIParams = null;
    private boolean firstOnload = true;
    private ItemListener cmbAcctCussTypeToListener = null;
    private ItemListener cmbAcctCussTypeListener = null;
    private boolean isRecPayVeri = false;
    protected ArApSysParamInfo cache = null;
    protected IArApBillFacade iBillFacade;
    private KDBizPromptBoxDecorator prmtMainAcctCussFromAgent;
    private KDBizPromptBoxDecorator prmtSecondAcctCussFromAgent;

    public VerificationQueryUI() throws Exception {
        this.cache = new ArApSysParamInfo();
        this.iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
    }

    public VerificationQueryUI(String clazz) throws Exception {
        this.verificateType = clazz.toLowerCase();
    }

    public VerificationQueryUI(String clazz, HashMap hm) throws Exception {
        this(clazz);
        this.initUIParams = hm;
    }

    public void onLoad() throws Exception {
        this.prmtMainAcctCussFromAgent = new KDBizPromptBoxDecorator(this.prmMainAcctCussFrom);
        this.prmtSecondAcctCussFromAgent = new KDBizPromptBoxDecorator(this.prmSecondAcctCussFrom);
        this.removeListeners();
        try {
            if (this.getUIContext().get("cache") != null) {
                this.cache = (ArApSysParamInfo)this.getUIContext().get("cache");
            }
            this.currentCompany = this.cache.getCompany();
        }
        catch (Exception ex) {
            SysUtil.abort();
        }
        Map uiContext = this.getUIContext();
        if (uiContext != null) {
            this.verificateType = (String)uiContext.get("verificateType");
            this.initUIParams = (HashMap)uiContext.get("initQryHM");
        }
        super.onLoad();
        this.kDBizPromptCompany.setData((Object)this.currentCompany);
        this.kDBizPromptCompany.setEnabled(false);
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        this.dtFrom.setValue((Object)calendar.getTime());
        this.payDateFrom.setValue((Object)calendar.getTime());
        String lowVerificateType = this.verificateType.toLowerCase(Locale.ENGLISH);
        if (lowVerificateType.startsWith("ar") || lowVerificateType.startsWith("prerec") || lowVerificateType.startsWith("prorec")) {
            this.payDateRadio.setText(EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"Ar_payDateRadio_text"));
            ArApBillUIUtil.makeAsstActType(this.cmbAcctCussType, this.cache, false);
            if (lowVerificateType.endsWith("pay") || lowVerificateType.endsWith("ap")) {
                VerificationQueryUI.makeApAsstActType(this.cmbAcctCussTypeTo, this.cache, false);
            } else {
                ArApBillUIUtil.makeAsstActType(this.cmbAcctCussTypeTo, this.cache, false);
            }
        } else {
            VerificationQueryUI.makeApAsstActType(this.cmbAcctCussType, this.cache, false);
            if (lowVerificateType.endsWith("rec") || lowVerificateType.endsWith("ar")) {
                VerificationQueryUI.makeArAsstActType(this.cmbAcctCussTypeTo, this.cache, false);
            } else {
                VerificationQueryUI.makeApAsstActType(this.cmbAcctCussTypeTo, this.cache, false);
            }
        }
        if (lowVerificateType.startsWith("prerec") || lowVerificateType.startsWith("prorec") || lowVerificateType.startsWith("prepay") || lowVerificateType.startsWith("propay")) {
            this.payDateRadio.setVisible(false);
            this.payDatePanel.setVisible(false);
        } else {
            this.payDateRadio.setVisible(true);
            this.payDatePanel.setVisible(true);
        }
        if (lowVerificateType.equals("ap2pay")) {
            this.labPayDateFrom.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"apDate"));
        } else if (lowVerificateType.equals("ar2rec")) {
            this.labPayDateFrom.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"arDate"));
        } else if (lowVerificateType.equals("ar2ap")) {
            this.labPayDateFrom.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"Ar_payDateLabel"));
            this.payDateRadio.setText(EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"Ar_ArApPayDateRadio_text"));
        } else if (lowVerificateType.equals("ap2ar")) {
            this.payDateRadio.setText(EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"Ap_ApArPayDateRadio_text"));
        }
        this.initVeriType();
        if (lowVerificateType.indexOf("ar2rec") < 0 && lowVerificateType.indexOf("ap2pay") < 0) {
            this.kdLabConCoreNumber.setVisible(false);
            this.contContractNum.setVisible(false);
            this.kDLabelContainer7.setVisible(false);
            this.ComboBoxpaymenttype.setVisible(false);
            this.ComboBoxpaymenttype.setSelectedIndex(2);
        } else {
            this.kdLabConCoreNumber.setVisible(true);
            this.contContractNum.setVisible(true);
            this.cbLikeQuery.setVisible(true);
            if (lowVerificateType.indexOf("ar2rec") >= 0) {
                this.contContractNum.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"lbl_SaleContrNum"));
            } else if (lowVerificateType.indexOf("ap2pay") >= 0) {
                this.contContractNum.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)"lbl_PurContrNum"));
            }
        }
        if (this.cmbAcctCussType.getItemCount() == 0) {
            this.prmMainAcctCussFrom.setEnabled(false);
            this.prmMainAcctCussTo.setEnabled(false);
            this.prmSecondAcctCussFrom.setEnabled(false);
            this.prmSecondAcctCussTo.setEnabled(false);
        } else {
            this.topDefaultAsstActTypeIndex = this.cmbAcctCussType.getSelectedIndex();
            this.bottomDefaultAsstActTypeIndex = this.cmbAcctCussTypeTo.getSelectedIndex();
        }
        if (this.initUIParams != null && this.initUIParams.get("currencyTo") != null) {
            if (this.initUIParams.get("isArAp") != null && ((Boolean)this.initUIParams.get("isArAp")).booleanValue()) {
                this.kdBizPromCurrency.setData((Object)((CurrencyInfo)this.initUIParams.get("currencyTo")));
            } else {
                this.kdBizPromCurrency.setData((Object)this.currentCompany.getBaseCurrency());
            }
            if (this.initUIParams.get("isArAp") != null && !((Boolean)this.initUIParams.get("isArAp")).booleanValue()) {
                this.kdBizPromCurrencyTo.setData((Object)((CurrencyInfo)this.initUIParams.get("currencyTo")));
            } else {
                this.kdBizPromCurrencyTo.setData((Object)this.currentCompany.getBaseCurrency());
            }
        } else {
            this.kdBizPromCurrency.setData((Object)this.currentCompany.getBaseCurrency());
            this.kdBizPromCurrencyTo.setData((Object)this.currentCompany.getBaseCurrency());
        }
        this.kdBizPromCurrency.setEditable(true);
        this.kdBizPromCurrency.setDisplayFormat("$name$");
        this.kdBizPromCurrency.setEditFormat("$number$");
        this.kdBizPromCurrency.setCommitFormat("$number$");
        this.kdBizPromCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        this.kdBizPromCurrencyTo.setEditable(true);
        this.kdBizPromCurrencyTo.setDisplayFormat("$name$");
        this.kdBizPromCurrencyTo.setEditFormat("$number$");
        this.kdBizPromCurrencyTo.setCommitFormat("$number$");
        this.kdBizPromCurrencyTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)this.cmbAcctCussType.getSelectedItem();
        AsstActTypeInfo asstActTypeToInfo = (AsstActTypeInfo)this.cmbAcctCussTypeTo.getSelectedItem();
        ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmMainAcctCussFrom, (Object)asstActTypeInfo, this.cache, true, true);
        ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmMainAcctCussTo, (Object)asstActTypeInfo, this.cache, false, true);
        ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmSecondAcctCussFrom, (Object)asstActTypeToInfo, this.cache, true, true);
        ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmSecondAcctCussTo, (Object)asstActTypeToInfo, this.cache, false, true);
        if (this.firstOnload) {
            this.firstOnload = false;
            MyDataChangeListener listener = new MyDataChangeListener();
            this.cbSecondSameMain.addItemListener((ItemListener)listener);
            this.kdBizPromCurrency.addDataChangeListener((DataChangeListener)listener);
            this.prmMainAcctCussFrom.addDataChangeListener((DataChangeListener)listener);
            this.prmMainAcctCussTo.addDataChangeListener((DataChangeListener)listener);
            this.prmSecondAcctCussFrom.addDataChangeListener((DataChangeListener)listener);
            this.initUIByInitHM();
            if (this.initUIParams != null) {
                this.isRecPayVeri = true;
            }
        }
        this.lazyAddListeners();
        this.kdBizPromCurrency.setEnabledMultiSelection(true);
        this.kdBizPromCurrencyTo.setEnabledMultiSelection(true);
        this.setFundProperty();
        this.setDatePanel(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public static void makeArAsstActType(KDComboBox comboAsstActType, ArApSysParamInfo paramInfo, boolean isIncludeAll) {
        if (paramInfo.getArAsstActTypeColl() == null) {
            return;
        }
        AsstActTypeCollection typeInfos = paramInfo.getArAsstActTypeColl();
        if (comboAsstActType.getItemCount() != typeInfos.size()) {
            comboAsstActType.removeAllItems();
            if (isIncludeAll) {
                comboAsstActType.addItem((Object)ComBoxInfo.ITEM_ALL);
            }
            comboAsstActType.addItems(typeInfos.toArray());
            return;
        }
        boolean isSame = true;
        for (int i = 0; i < comboAsstActType.getItemCount(); ++i) {
            AsstActTypeInfo item = (AsstActTypeInfo)comboAsstActType.getItemAt(i);
            if (typeInfos.contains(item)) continue;
            isSame = false;
        }
        if (!isSame) {
            comboAsstActType.removeAllItems();
            if (isIncludeAll) {
                comboAsstActType.addItem((Object)ComBoxInfo.ITEM_ALL);
            }
            comboAsstActType.addItems(typeInfos.toArray());
        }
    }

    public static void makeApAsstActType(KDComboBox comboAsstActType, ArApSysParamInfo paramInfo, boolean isIncludeAll) {
        if (paramInfo.getApAsstActTypeColl() == null) {
            return;
        }
        AsstActTypeCollection typeInfos = paramInfo.getApAsstActTypeColl();
        if (comboAsstActType.getItemCount() != typeInfos.size()) {
            comboAsstActType.removeAllItems();
            if (isIncludeAll) {
                comboAsstActType.addItem((Object)ComBoxInfo.ITEM_ALL);
            }
            comboAsstActType.addItems(typeInfos.toArray());
            return;
        }
        boolean isSame = true;
        for (int i = 0; i < comboAsstActType.getItemCount(); ++i) {
            AsstActTypeInfo item = (AsstActTypeInfo)comboAsstActType.getItemAt(i);
            if (typeInfos.contains(item)) continue;
            isSame = false;
        }
        if (!isSame) {
            comboAsstActType.removeAllItems();
            if (isIncludeAll) {
                comboAsstActType.addItem((Object)ComBoxInfo.ITEM_ALL);
            }
            comboAsstActType.addItems(typeInfos.toArray());
        }
    }

    private void lazyAddListeners() {
        this.cmbAcctCussTypeToListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    VerificationQueryUI.this.cmbAcctCussTypeTo_itemStateChanged(e);
                }
                catch (Exception exc) {
                    VerificationQueryUI.this.handUIException(exc);
                }
            }
        };
        this.cmbAcctCussTypeTo.addItemListener(this.cmbAcctCussTypeToListener);
        this.cmbAcctCussTypeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    VerificationQueryUI.this.cmbAcctCussType_itemStateChanged(e);
                }
                catch (Exception exc) {
                    VerificationQueryUI.this.handUIException(exc);
                }
            }
        };
        this.cmbAcctCussType.addItemListener(this.cmbAcctCussTypeListener);
    }

    private void removeListeners() {
        this.cmbAcctCussTypeTo.removeItemListener(this.cmbAcctCussTypeToListener);
        this.cmbAcctCussType.removeItemListener(this.cmbAcctCussTypeListener);
    }

    private void initUIByInitHM() {
        if (this.initUIParams != null && "EDITUI".equals(this.initUIParams.get("VERI_FROM_UI"))) {
            IObjectValue objValue = (IObjectValue)this.initUIParams.get("acctTypeTo");
            int iCount = this.cmbAcctCussTypeTo.getItemCount();
            for (int index = 0; index < iCount; ++index) {
                String cmbAcctCussTypeID;
                String acctCussTypeID = objValue.get("id").toString();
                if (!acctCussTypeID.equals(cmbAcctCussTypeID = ((AsstActTypeInfo)this.cmbAcctCussTypeTo.getItemAt(index)).get("id").toString())) continue;
                this.cmbAcctCussTypeTo.setSelectedIndex(index);
                this.cmbAcctCussType.setSelectedIndex(index);
                break;
            }
            this.txtBillNumberA.setText((String)this.initUIParams.get("number"));
            this.txtBillNumberB.setText((String)this.initUIParams.get("numberTo"));
            this.kdBizPromCurrencyTo.setValue(this.initUIParams.get("currencyTo"));
            this.kdBizPromCurrency.setValue(this.initUIParams.get("currencyTo"));
            if (this.initUIParams.get("acctNumTo") != null) {
                IObjectValue acctCuss = this.getBizObject(this.initUIParams.get("acctNumTo").toString());
                this.prmSecondAcctCussFrom.setValue((Object)acctCuss);
                this.prmMainAcctCussFrom.setValue((Object)acctCuss);
                this.prmSecondAcctCussTo.setValue((Object)acctCuss);
                this.prmMainAcctCussTo.setValue((Object)acctCuss);
            }
            Calendar calendar = Calendar.getInstance();
            if (this.initUIParams.get("date") != null) {
                calendar.setTime((java.util.Date)this.initUIParams.get("date"));
            }
            this.dtTo.setValue((Object)calendar.getTime());
            calendar.add(2, -1);
            this.dtFrom.setValue((Object)calendar.getTime());
        } else if (this.initUIParams != null && "LISTUI".equals(this.initUIParams.get("VERI_FROM_UI"))) {
            this.txtBillNumberB.setText((String)this.initUIParams.get("numberTo"));
        }
    }

    protected void cmbAcctCussType_itemStateChanged(ItemEvent e) throws Exception {
        this.prmMainAcctCussFrom.setValue(null);
        this.prmMainAcctCussTo.setValue(null);
        if (this.cmbAcctCussType.getSelectedItem() == null) {
            return;
        }
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)this.cmbAcctCussType.getSelectedItem();
        if (this.cbSecondSameMain.isSelected() && !this.cmbAcctCussType.getSelectedItem().equals(this.cmbAcctCussTypeTo.getSelectedItem())) {
            this.cmbAcctCussTypeTo.setSelectedItem(this.cmbAcctCussType.getSelectedItem());
        }
        ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmMainAcctCussFrom, (Object)asstActTypeInfo, this.cache, true, true);
        ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmMainAcctCussTo, (Object)asstActTypeInfo, this.cache, false, true);
        this.prmMainAcctCussTo.setEnabled(true);
    }

    protected void cmbAcctCussTypeTo_itemStateChanged(ItemEvent e) throws Exception {
        this.prmSecondAcctCussTo.setValue(null);
        this.prmSecondAcctCussFrom.setValue(null);
        if (this.cmbAcctCussTypeTo.getSelectedItem() == null) {
            return;
        }
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)this.cmbAcctCussTypeTo.getSelectedItem();
        ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmSecondAcctCussFrom, (Object)asstActTypeInfo, this.cache, true, true);
        ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmSecondAcctCussTo, (Object)asstActTypeInfo, this.cache, false, true);
        this.prmSecondAcctCussTo.setEnabled(true);
    }

    public boolean verify() {
        Timestamp dateTo;
        Timestamp dateFrom;
        if (this.billDateRadio.isSelected()) {
            if (this.dtFrom.getValue() == null || this.dtTo.getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getStrResource("billDateRange_Is_Null"));
                SysUtil.abort();
            }
        } else if (this.payDateFrom.getValue() == null || this.payDateTo.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getStrResource("billDateRange_Is_Null"));
            SysUtil.abort();
        }
        if (this.dtFrom.getValue() != null && this.dtTo.getValue() != null && (dateFrom = this.dtFrom.getTimestamp()).after((java.util.Date)(dateTo = this.dtTo.getTimestamp()))) {
            this.dtFrom.requestFocus();
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"204_DateFail"));
            return false;
        }
        if (this.prmMainAcctCussFrom.getValue() == null || this.prmSecondAcctCussFrom.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getStrResource("nullAcctCussent"));
            SysUtil.abort();
        }
        if (this.kdBizPromCurrency.getValue() == null || this.kdBizPromCurrencyTo.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getStrResource("lab_nocurrency"));
            SysUtil.abort();
        }
        return super.verify();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.clear();
        this.initUIByInitHM();
        this.setParamToUI(this.params);
    }

    private IObjectValue getBizObject(String id) {
        try {
            if (id != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                ObjectUuidPK pk = new ObjectUuidPK(id);
                IObjectValue objVal = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk, sic);
                return objVal;
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return null;
    }

    private IObjectValue getCurrencyObj(String id) {
        logger.error((Object)("\u52a0\u8f7d\u65b9\u6848\u65f6\uff1a \u5e01\u522bID\u4e3a-----------" + id));
        if (id == null) {
            return null;
        }
        try {
            BOSUuid.read((String)id);
        }
        catch (Exception e) {
            id = id.replace("[", "").replace("]", "");
            id = id.trim();
            logger.error((Object)("\u6b64ID\u5bfc\u81f4\u5f02\u5e38\uff1a " + e.getMessage()));
            logger.error((Object)("\u5904\u7406\u5f02\u5e38\u540e\u7684id\u4e3a-----------" + id));
        }
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("precision"));
            ObjectUuidPK pk = new ObjectUuidPK(id);
            CurrencyInfo objVal = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)pk, sic);
            return objVal;
        }
        catch (EASBizException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return null;
    }

    public void clear() {
        Calendar calendar = Calendar.getInstance();
        this.dtTo.setValue((Object)calendar.getTime());
        this.payDateTo.setValue((Object)calendar.getTime());
        calendar.add(2, -1);
        this.dtFrom.setValue((Object)calendar.getTime());
        this.payDateFrom.setValue((Object)calendar.getTime());
        this.cbSecondSameMain.setSelected(false);
        this.cmbAcctCussType.setSelectedIndex(this.topDefaultAsstActTypeIndex);
        this.cmbAcctCussTypeTo.setSelectedIndex(this.bottomDefaultAsstActTypeIndex);
        this.prmMainAcctCussFrom.setValue(null);
        this.prmMainAcctCussTo.setValue(null);
        this.prmSecondAcctCussFrom.setValue(null);
        this.prmSecondAcctCussTo.setValue(null);
        this.txtBillNumberA.setText("");
        this.txtBillNumberB.setText("");
        this.cbLikeQuery.setSelected(true);
        this.txtCoreNumber.setText("");
        this.txtContractNum.setText("");
        if (this.isRecPayVeri) {
            this.initUIByInitHM();
        }
    }

    private String getStrResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)key);
    }

    public void setCustomerParams(CustomerParams cp) {
        int i;
        String[] arr;
        ArrayList<String> list;
        if (cp == null) {
            return;
        }
        VerificationParams objParam = new VerificationParams();
        if (cp.getCustomerParam("company") != null) {
            objParam.setObject("company", cp.getCustomerParam("company"));
        }
        if (cp.getCustomerParam("startdate") != null) {
            objParam.setObject("startdate", cp.getCustomerParam("startdate"));
        }
        if (cp.getCustomerParam("enddate") != null) {
            objParam.setObject("enddate", cp.getCustomerParam("enddate"));
        }
        if (cp.getCustomerParam("currency") != null) {
            objParam.setObject("currency", cp.getCustomerParam("currency"));
        }
        if (cp.getCustomerParam("currencyto") != null) {
            objParam.setObject("currencyto", cp.getCustomerParam("currencyto"));
        }
        if (cp.getCustomerParam("asstActType") != null) {
            objParam.setObject("asstActType", cp.getCustomerParam("asstActType"));
        }
        if (cp.getCustomerParam("asstacttypeto") != null) {
            objParam.setObject("asstacttypeto", cp.getCustomerParam("asstacttypeto"));
        }
        if (cp.getCustomerParam("number") != null) {
            objParam.setObject("number", cp.getCustomerParam("number"));
        }
        if (cp.getCustomerParam("numberb") != null) {
            objParam.setObject("numberb", cp.getCustomerParam("numberb"));
        }
        if (cp.getCustomerParam("assactMainFromID") != null) {
            objParam.setObject("assactMainFromID", cp.getCustomerParam("assactMainFromID"));
        }
        if (cp.getCustomerParam("assactMainToID") != null) {
            objParam.setObject("assactMainToID", cp.getCustomerParam("assactMainToID"));
        }
        if (cp.getCustomerParam("prmMainAcctCussFromMultiSelect") != null) {
            objParam.setObject("prmMainAcctCussFromMultiSelect", cp.getCustomerParam("prmMainAcctCussFromMultiSelect"));
        }
        if (cp.getCustomerParam("prmMainAcctCussIds") != null) {
            String prmMainAcctCussIds = cp.getCustomerParam("prmMainAcctCussIds");
            list = new ArrayList<String>();
            arr = prmMainAcctCussIds.split(",");
            for (i = 0; i < arr.length; ++i) {
                list.add(arr[i]);
            }
            objParam.setObject("prmMainAcctCussIds", list);
        }
        if (cp.getCustomerParam("assactSecondFromID") != null) {
            objParam.setObject("assactSecondFromID", cp.getCustomerParam("assactSecondFromID"));
        }
        if (cp.getCustomerParam("assactSecondToID") != null) {
            objParam.setObject("assactSecondToID", cp.getCustomerParam("assactSecondToID"));
        }
        if (cp.getCustomerParam("prmSecondAcctCussFromMultiSelect") != null) {
            objParam.setObject("prmSecondAcctCussFromMultiSelect", cp.getCustomerParam("prmSecondAcctCussFromMultiSelect"));
        }
        if (cp.getCustomerParam("prmSecondAcctCussIds") != null) {
            String prmSecondAcctCussIds = cp.getCustomerParam("prmSecondAcctCussIds");
            list = new ArrayList();
            arr = prmSecondAcctCussIds.split(",");
            for (i = 0; i < arr.length; ++i) {
                list.add(arr[i]);
            }
            objParam.setObject("prmSecondAcctCussIds", list);
        }
        if (cp.getCustomerParam("coreNum") != null) {
            objParam.setObject("coreNum", cp.getCustomerParam("coreNum"));
        }
        if (cp.getCustomerParam("contractNum") != null) {
            objParam.setObject("contractNum", cp.getCustomerParam("contractNum"));
        }
        if (cp.getCustomerParam("likeQuery") != null) {
            objParam.setObject("likeQuery", cp.getCustomerParam("likeQuery"));
        }
        objParam.setBoolean("isSecondSameMain", Boolean.valueOf(cp.getCustomerParam("isSecondSameMain")));
        objParam.setBoolean("isBillDate", "true".equals(cp.getCustomerParam("isBillDate")));
        objParam.setObject("fundProperty", cp.getCustomerParam("fundProperty"));
        this.verificationParamExtend(objParam, cp);
        this.params = objParam;
        try {
            this.prepareInit().callHandler();
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    public CustomerParams getCustomerParams() {
        FundPropertyInfo fundPropertyInfo;
        String number;
        int i;
        int len;
        IObjectValue objValueTo;
        IObjectValue objValueFrom;
        int i2;
        StringBuilder sb;
        IObjectValue[] customers;
        CustomerParams newParams = new CustomerParams();
        CompanyOrgUnitInfo objValue = null;
        Object obj = null;
        objValue = (CompanyOrgUnitInfo)this.kDBizPromptCompany.getValue();
        if (objValue != null) {
            newParams.addCustomerParam("company", objValue.getString("id"));
        }
        String paymenttypeid = null;
        if (this.ComboBoxpaymenttype.getSelectedItem() != null && !ComBoxInfo.ITEM_ALL.equals(this.ComboBoxpaymenttype.getSelectedItem())) {
            paymenttypeid = ((ArApPaymentTypeEnum)((Object)this.ComboBoxpaymenttype.getSelectedItem())).getValue();
        }
        if (paymenttypeid != null) {
            newParams.addCustomerParam("paymenttypeid", paymenttypeid);
        }
        if (this.verificateType.toLowerCase(Locale.ENGLISH).indexOf("ar2rec") >= 0 || this.verificateType.toLowerCase(Locale.ENGLISH).indexOf("ap2pay") >= 0) {
            String contractNum;
            String coreNum = this.txtCoreNumber.getText();
            if (coreNum != null && coreNum.trim().length() > 0) {
                newParams.addCustomerParam("coreNum", coreNum.trim());
            }
            if ((contractNum = this.txtContractNum.getText()) != null && contractNum.trim().length() > 0) {
                newParams.addCustomerParam("contractNum", contractNum.trim());
            }
        }
        newParams.addCustomerParam("likeQuery", String.valueOf(this.cbLikeQuery.isSelected()));
        newParams.addCustomerParam("isSecondSameMain", Boolean.toString(this.cbSecondSameMain.isSelected()));
        if (this.cmbAcctCussType.getSelectedItem() != null) {
            objValue = (AsstActTypeInfo)this.cmbAcctCussType.getSelectedItem();
            newParams.addCustomerParam("asstActType", objValue.getString("id"));
        }
        if (this.prmtMainAcctCussFromAgent.getValue() instanceof IObjectValue[]) {
            customers = (IObjectValue[])this.prmtMainAcctCussFromAgent.getValue();
            sb = new StringBuilder(128);
            for (i2 = 0; i2 < customers.length; ++i2) {
                sb.append("," + customers[i2].getString("id"));
            }
            if (sb.length() > 0) {
                sb.delete(0, 1);
                newParams.addCustomerParam("prmMainAcctCussIds", sb.toString());
            }
            newParams.addCustomerParam("prmMainAcctCussFromMultiSelect", "true");
        } else if (this.prmtMainAcctCussFromAgent.getValue() instanceof IObjectValue) {
            objValueFrom = (IObjectValue)this.prmtMainAcctCussFromAgent.getValue();
            newParams.addCustomerParam("assactMainFrom", objValueFrom.getString("number"));
            newParams.addCustomerParam("assactMainFromID", objValueFrom.getString("id"));
            objValueTo = (IObjectValue)this.prmMainAcctCussTo.getValue();
            if (null != objValueTo) {
                newParams.addCustomerParam("assactMainTo", objValueTo.getString("number"));
                newParams.addCustomerParam("assactMainToID", objValueTo.getString("id"));
            }
        }
        if (this.cmbAcctCussTypeTo.getSelectedItem() != null) {
            objValue = (AsstActTypeInfo)this.cmbAcctCussTypeTo.getSelectedItem();
            newParams.addCustomerParam("asstacttypeto", objValue.getString("id"));
        }
        if (this.prmtSecondAcctCussFromAgent.getValue() instanceof IObjectValue[]) {
            customers = (IObjectValue[])this.prmtSecondAcctCussFromAgent.getValue();
            sb = new StringBuilder(128);
            for (i2 = 0; i2 < customers.length; ++i2) {
                sb.append("," + customers[i2].getString("id"));
            }
            if (sb.length() > 0) {
                sb.delete(0, 1);
                newParams.addCustomerParam("prmSecondAcctCussIds", sb.toString());
            }
            newParams.addCustomerParam("prmSecondAcctCussFromMultiSelect", "true");
        } else if (this.prmtSecondAcctCussFromAgent.getValue() instanceof IObjectValue) {
            objValueFrom = (IObjectValue)this.prmtSecondAcctCussFromAgent.getValue();
            newParams.addCustomerParam("assactSecondFrom", objValueFrom.getString("number"));
            newParams.addCustomerParam("assactSecondFromID", objValueFrom.getString("id"));
            objValueTo = (IObjectValue)this.prmSecondAcctCussTo.getValue();
            if (null != objValueTo) {
                newParams.addCustomerParam("assactSecondTo", objValueTo.getString("number"));
                newParams.addCustomerParam("assactSecondToID", objValueTo.getString("id"));
            }
        }
        CurrencyInfo currencyInfo = null;
        if (this.kdBizPromCurrency.getValue() instanceof CurrencyInfo) {
            currencyInfo = (CurrencyInfo)this.kdBizPromCurrency.getValue();
            if (currencyInfo != null) {
                newParams.addCustomerParam("currency", currencyInfo.getId().toString());
            }
        } else if (this.kdBizPromCurrency.getValue() instanceof Object[]) {
            sb = new StringBuilder(128);
            Object[] arr = (Object[])this.kdBizPromCurrency.getValue();
            len = arr.length;
            for (i = 0; i < len; ++i) {
                currencyInfo = (CurrencyInfo)arr[i];
                sb.append("," + currencyInfo.getId().toString());
            }
            if (sb.length() > 0) {
                sb.delete(0, 1);
                newParams.addCustomerParam("currency", sb.toString());
            }
        }
        if (this.kdBizPromCurrencyTo.getValue() instanceof CurrencyInfo) {
            currencyInfo = (CurrencyInfo)this.kdBizPromCurrencyTo.getValue();
            if (currencyInfo != null) {
                newParams.addCustomerParam("currencyto", currencyInfo.getId().toString());
            }
        } else if (this.kdBizPromCurrencyTo.getValue() instanceof Object[]) {
            sb = new StringBuilder(128);
            Object[] arr = (Object[])this.kdBizPromCurrencyTo.getValue();
            len = arr.length;
            for (i = 0; i < len; ++i) {
                currencyInfo = (CurrencyInfo)arr[i];
                sb.append("," + currencyInfo.getId().toString());
            }
            if (sb.length() > 0) {
                sb.delete(0, 1);
                newParams.addCustomerParam("currencyto", sb.toString());
            }
        }
        if ((number = this.txtBillNumberA.getText()) != null && number.trim().length() > 0) {
            newParams.addCustomerParam("number", number.trim());
        }
        if ((number = this.txtBillNumberB.getText()) != null && number.trim().length() > 0) {
            newParams.addCustomerParam("numberb", number.trim());
        }
        if (this.billDateRadio.isSelected()) {
            newParams.addCustomerParam("isBillDate", "true");
            if (this.dtFrom.getTimestamp() != null) {
                Date startDate = BaseDataUtil.downTimestamp(this.dtFrom.getTimestamp());
                String a = DateTimeUtils.formatDate((java.util.Date)startDate);
                newParams.addCustomerParam("startdate", a);
            }
            if (this.dtTo.getTimestamp() != null) {
                java.util.Date date = (java.util.Date)this.dtTo.getValue();
                java.util.Date endDate = new java.util.Date(DateTimeUtils.truncateDate((java.util.Date)date).getTime());
                String b = DateTimeUtils.formatDate((java.util.Date)endDate);
                newParams.addCustomerParam("enddate", b);
            }
        } else {
            newParams.addCustomerParam("isBillDate", "false");
            if (this.payDateFrom.getTimestamp() != null) {
                Date startDate = BaseDataUtil.downTimestamp(this.payDateFrom.getTimestamp());
                String a = DateTimeUtils.formatDate((java.util.Date)startDate);
                newParams.addCustomerParam("startdate", a);
            }
            if (this.payDateTo.getTimestamp() != null) {
                java.util.Date date = (java.util.Date)this.payDateTo.getValue();
                java.util.Date endDate = new java.util.Date(DateTimeUtils.truncateDate((java.util.Date)date).getTime());
                String b = DateTimeUtils.formatDate((java.util.Date)endDate);
                newParams.addCustomerParam("enddate", b);
            }
        }
        if (this.kdBizFundProperty.getData() != null && (fundPropertyInfo = (FundPropertyInfo)this.kdBizFundProperty.getValue()) != null) {
            newParams.addCustomerParam("fundProperty", fundPropertyInfo.getId().toString());
        }
        this.queryParamExtend(newParams);
        return newParams;
    }

    public CurrencyInfo getTopCurrencyInfo() {
        return (CurrencyInfo)this.kdBizPromCurrency.getValue();
    }

    public CurrencyInfo getBottomCurrencyInfo() {
        return (CurrencyInfo)this.kdBizPromCurrencyTo.getValue();
    }

    private void setParamToUI(VerificationParams param) {
        String cmbAcctCussTypeID;
        String acctCussTypeID;
        int index;
        int i;
        ArrayList<IObjectValue> list;
        IObjectValue objValue = null;
        this.kDBizPromptCompany.setValue((Object)this.currentCompany);
        Object objStart = this.params.getObject("startdate");
        Object objEnd = this.params.getObject("enddate");
        boolean isBillDate = (Boolean)this.params.getObject("isBillDate");
        this.billDateRadio.setSelected(isBillDate);
        this.payDateRadio.setSelected(!isBillDate);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            objStart = df.parse(objStart.toString());
            objEnd = df.parse(objEnd.toString());
            if (isBillDate) {
                this.dtFrom.setValue((Object)((java.util.Date)objStart));
                this.dtTo.setValue((Object)((java.util.Date)objEnd));
            } else {
                this.payDateFrom.setValue((Object)((java.util.Date)objStart));
                this.payDateTo.setValue((Object)((java.util.Date)objEnd));
            }
        }
        catch (ParseException e) {
            this.handUIException(e);
        }
        this.cbSecondSameMain.setSelected(this.params.getBoolean("isSecondSameMain"));
        String currencyId = this.params.getObject("currency").toString();
        String[] arr = currencyId.split(",");
        int len = arr.length;
        if (len == 1) {
            objValue = this.getCurrencyObj(arr[0]);
            this.kdBizPromCurrency.setValue((Object)objValue);
        } else {
            list = new ArrayList<IObjectValue>();
            for (i = 0; i < len; ++i) {
                list.add(this.getCurrencyObj(arr[i]));
            }
            this.kdBizPromCurrency.setValue((Object)list.toArray());
        }
        currencyId = this.params.getObject("currencyto").toString();
        arr = currencyId.split(",");
        len = arr.length;
        if (len == 1) {
            objValue = this.getCurrencyObj(arr[0]);
            this.kdBizPromCurrencyTo.setValue((Object)objValue);
        } else {
            list = new ArrayList();
            for (i = 0; i < len; ++i) {
                list.add(this.getCurrencyObj(arr[i]));
            }
            this.kdBizPromCurrencyTo.setValue((Object)list.toArray());
        }
        objValue = this.getBizObject(this.params.getObject("asstActType").toString());
        int iCount = this.cmbAcctCussType.getItemCount();
        for (index = 0; index < iCount; ++index) {
            acctCussTypeID = objValue.get("id").toString();
            if (!acctCussTypeID.equals(cmbAcctCussTypeID = ((AsstActTypeInfo)this.cmbAcctCussType.getItemAt(index)).get("id").toString())) continue;
            this.cmbAcctCussType.setSelectedIndex(index);
            break;
        }
        iCount = this.cmbAcctCussTypeTo.getItemCount();
        objValue = this.getBizObject(this.params.getObject("asstacttypeto").toString());
        for (index = 0; index < iCount; ++index) {
            acctCussTypeID = objValue.get("id").toString();
            if (!acctCussTypeID.equals(cmbAcctCussTypeID = ((AsstActTypeInfo)this.cmbAcctCussTypeTo.getItemAt(index)).get("id").toString())) continue;
            this.cmbAcctCussTypeTo.setSelectedIndex(index);
            break;
        }
        if (this.params.getObject("number") != null) {
            this.txtBillNumberA.setText((String)this.params.getObject("number"));
        } else {
            this.txtBillNumberA.setText(null);
        }
        if (this.params.getObject("numberb") != null) {
            this.txtBillNumberB.setText((String)this.params.getObject("numberb"));
        } else {
            this.txtBillNumberB.setText(null);
        }
        if (this.params.getObject("coreNum") != null) {
            this.txtCoreNumber.setText((String)this.params.getObject("coreNum"));
        } else {
            this.txtCoreNumber.setText(null);
        }
        if (this.params.getObject("contractNum") != null) {
            this.txtContractNum.setText((String)this.params.getObject("contractNum"));
        } else {
            this.txtContractNum.setText(null);
        }
        this.cbLikeQuery.setSelected(Boolean.valueOf(this.params.getBoolean("likeQuery")).booleanValue());
        boolean prmMainAcctCussFromMultiSelect = this.params.getBoolean("prmMainAcctCussFromMultiSelect");
        if (prmMainAcctCussFromMultiSelect) {
            List list2 = (List)this.params.getObject("prmMainAcctCussIds");
            IObjectValue[] fromArr = new IObjectValue[list2.size()];
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                fromArr[i2] = this.getBizObject((String)list2.get(i2));
            }
            this.prmMainAcctCussFrom.setData((Object)fromArr);
            this.prmMainAcctCussTo.setEnabled(false);
        } else {
            objValue = this.getBizObject((String)this.params.getObject("assactMainFromID"));
            this.prmMainAcctCussFrom.setData((Object)objValue);
            objValue = this.getBizObject((String)this.params.getObject("assactMainToID"));
            this.prmMainAcctCussTo.setData((Object)objValue);
        }
        boolean prmSecondAcctCussFromMultiSelect = this.params.getBoolean("prmSecondAcctCussFromMultiSelect");
        if (prmSecondAcctCussFromMultiSelect) {
            List list3 = (List)this.params.getObject("prmSecondAcctCussIds");
            IObjectValue[] toArr = new IObjectValue[list3.size()];
            for (int i3 = 0; i3 < list3.size(); ++i3) {
                toArr[i3] = this.getBizObject((String)list3.get(i3));
            }
            this.prmSecondAcctCussFrom.setData((Object)toArr);
            this.prmSecondAcctCussTo.setEnabled(false);
        } else {
            objValue = this.getBizObject((String)this.params.getObject("assactSecondFromID"));
            this.prmSecondAcctCussFrom.setValue((Object)objValue);
            objValue = this.getBizObject((String)this.params.getObject("assactSecondToID"));
            this.prmSecondAcctCussTo.setData((Object)objValue);
        }
        objValue = this.getBizObject((String)this.params.getObject("fundProperty"));
        this.kdBizFundProperty.setData((Object)objValue);
        this.setParamToUIExtends(this.params);
    }

    private void initVeriType() {
        this.ComboBoxpaymenttype.removeAllItems();
        this.ComboBoxpaymenttype.addItem((Object)ComBoxInfo.ITEM_ALL);
        this.ComboBoxpaymenttype.setSelectedItem((Object)ComBoxInfo.ITEM_ALL);
        if (this.verificateType.toLowerCase(Locale.ENGLISH).startsWith("ar")) {
            this.ComboBoxpaymenttype.addItem((Object)ArApPaymentTypeEnum.Ar_Sale_Cash);
            this.ComboBoxpaymenttype.addItem((Object)ArApPaymentTypeEnum.AR_Sale);
        } else {
            this.ComboBoxpaymenttype.addItem((Object)ArApPaymentTypeEnum.AP_Pur_cash);
            this.ComboBoxpaymenttype.addItem((Object)ArApPaymentTypeEnum.AP_Pur);
        }
    }

    public void setParamToUIExtends(VerificationParams params) {
    }

    public void verificationParamExtend(VerificationParams objParam, CustomerParams cp) {
    }

    public void queryParamExtend(CustomerParams newParams) {
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null && this.params != null) {
            RequestContext request = new RequestContext();
            request.put("cache", (Object)this.cache);
            if (this.params.getObject("currency") != null) {
                request.put("currencyFromID", (Object)this.params.getObject("currency").toString());
            }
            if (this.params.getObject("currencyto") != null) {
                request.put("currencyToID", (Object)this.params.getObject("currencyto").toString());
            }
            if (this.params.getObject("asstActType") != null) {
                request.put("asstActTypeFromID", (Object)this.params.getObject("asstActType").toString());
            }
            if (this.params.getObject("asstacttypeto") != null) {
                request.put("asstacttypeToID", (Object)this.params.getObject("asstacttypeto").toString());
            }
            if (this.params.getObject("assactMainFromID") != null) {
                request.put("assactMainFromID", (Object)this.params.getObject("assactMainFromID").toString());
            }
            if (this.params.getObject("assactMainToID") != null) {
                request.put("assactMainToID", (Object)this.params.getObject("assactMainToID").toString());
            }
            if (this.params.getObject("assactSecondFromID") != null) {
                request.put("assactSecondFromID", (Object)this.params.getObject("assactSecondFromID").toString());
            }
            if (this.params.getObject("assactSecondToID") != null) {
                request.put("assactSecondToID", (Object)this.params.getObject("assactSecondToID").toString());
            }
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    protected void billDateRadio_stateChanged(ChangeEvent e) throws Exception {
        this.setDatePanel(false);
    }

    @Override
    protected void payDateRadio_stateChanged(ChangeEvent e) throws Exception {
        this.setDatePanel(true);
    }

    private void setDatePanel(boolean isPayDate) {
        this.payDatePanel.setVisible(isPayDate);
        this.billDatePanel.setVisible(!isPayDate);
    }

    private void setFundProperty() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        this.kdBizFundProperty.setEntityViewInfo(viewInfo);
        if (this.verificateType != null && this.verificateType.contains("Ap")) {
            this.labFundProperty.setVisible(false);
        } else {
            this.labFundProperty.setVisible(false);
            this.kdBizFundProperty.setValue(null);
        }
    }

    private class MyDataChangeListener
    implements DataChangeListener,
    ItemListener {
        private MyDataChangeListener() {
        }

        public void dataChanged(DataChangeEvent e) {
            Object source = e.getSource();
            if (source != null) {
                if (source.equals(VerificationQueryUI.this.kdBizPromCurrency)) {
                    if (VerificationQueryUI.this.kdBizPromCurrencyTo.getValue() == null || VerificationQueryUI.this.cbSecondSameMain.isSelected()) {
                        VerificationQueryUI.this.kdBizPromCurrencyTo.setValue(VerificationQueryUI.this.kdBizPromCurrency.getValue());
                    }
                } else {
                    AsstActTypeInfo type1 = (AsstActTypeInfo)VerificationQueryUI.this.cmbAcctCussType.getSelectedItem();
                    AsstActTypeInfo type2 = (AsstActTypeInfo)VerificationQueryUI.this.cmbAcctCussTypeTo.getSelectedItem();
                    if (type1 != null && type2 != null && type1.equals((Object)type2)) {
                        if (source.equals(VerificationQueryUI.this.prmMainAcctCussFrom)) {
                            if (VerificationQueryUI.this.cbSecondSameMain.isSelected()) {
                                VerificationQueryUI.this.prmSecondAcctCussFrom.setValue(VerificationQueryUI.this.prmtMainAcctCussFromAgent.getValue());
                            }
                        } else if (source.equals(VerificationQueryUI.this.prmMainAcctCussTo) && VerificationQueryUI.this.cbSecondSameMain.isSelected()) {
                            VerificationQueryUI.this.prmSecondAcctCussTo.setValue(VerificationQueryUI.this.prmMainAcctCussTo.getValue());
                        }
                    }
                    if (source.equals(VerificationQueryUI.this.prmMainAcctCussFrom)) {
                        if (VerificationQueryUI.this.prmtMainAcctCussFromAgent.getValue() instanceof IObjectValue[]) {
                            VerificationQueryUI.this.prmMainAcctCussTo.setValue(null);
                            VerificationQueryUI.this.prmMainAcctCussTo.setEnabled(false);
                        } else if (VerificationQueryUI.this.prmtMainAcctCussFromAgent.getValue() instanceof IObjectValue) {
                            VerificationQueryUI.this.prmMainAcctCussTo.setValue(VerificationQueryUI.this.prmtMainAcctCussFromAgent.getValue());
                            VerificationQueryUI.this.prmMainAcctCussTo.setEnabled(true);
                        }
                    } else if (source.equals(VerificationQueryUI.this.prmSecondAcctCussFrom)) {
                        if (VerificationQueryUI.this.prmtSecondAcctCussFromAgent.getValue() instanceof IObjectValue[]) {
                            VerificationQueryUI.this.prmSecondAcctCussTo.setValue(null);
                            VerificationQueryUI.this.prmSecondAcctCussTo.setEnabled(false);
                        } else if (VerificationQueryUI.this.prmtSecondAcctCussFromAgent.getValue() instanceof IObjectValue) {
                            VerificationQueryUI.this.prmSecondAcctCussTo.setValue(VerificationQueryUI.this.prmtSecondAcctCussFromAgent.getValue());
                            VerificationQueryUI.this.prmSecondAcctCussTo.setEnabled(true);
                        }
                    }
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source;
            if (e.getItem() != null && (source = e.getSource()).equals(VerificationQueryUI.this.cbSecondSameMain) && VerificationQueryUI.this.cbSecondSameMain.isSelected()) {
                Object selectObj = VerificationQueryUI.this.cmbAcctCussType.getSelectedItem();
                if (!selectObj.equals(VerificationQueryUI.this.cmbAcctCussTypeTo.getSelectedItem())) {
                    VerificationQueryUI.this.cmbAcctCussTypeTo.setSelectedItem(selectObj);
                }
                VerificationQueryUI.this.prmSecondAcctCussFrom.setValue(VerificationQueryUI.this.prmMainAcctCussFrom.getValue());
                VerificationQueryUI.this.prmSecondAcctCussTo.setValue(VerificationQueryUI.this.prmMainAcctCussTo.getValue());
                VerificationQueryUI.this.kdBizPromCurrencyTo.setValue(VerificationQueryUI.this.kdBizPromCurrency.getValue());
            }
        }
    }
}

