/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.ApBalanceFactory;
import com.kingdee.eas.fi.ap.ApBalanceInfo;
import com.kingdee.eas.fi.ap.FinishApInitFacadeFactory;
import com.kingdee.eas.fi.ap.IApBalance;
import com.kingdee.eas.fi.ap.IFinishApInitFacade;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.math.BigDecimal;
import java.util.HashMap;

public class ApClientUtils {
    private static String apResource = "com.kingdee.eas.fi.ap.client.ApResource";
    private static final String VOUCHERTYPE = "2652E01E";

    public static String getApStringResource(String key) {
        return EASResource.getString((String)apResource, (String)key);
    }

    public static SystemStatusCtrolInfo getApStatusCtrolInfo(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmSttsCtrlInf = CommonClientUtils.getSysStatusCtrolInfo(cmpnyOrgUntInfObj, SystemEnum.ACCOUNTSPAYABLE);
        return systmSttsCtrlInf;
    }

    public static boolean apIsStart(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)cmpnyOrgUntInfObj);
    }

    public static PeriodInfo getApRelatedPeriod() throws BOSException, EASBizException {
        CompanyOrgUnitInfo cmpnyOrgUntInfObj = CommonClientUtils.getCurrentCompany();
        return ApClientUtils.getApRelatedPeriod(cmpnyOrgUntInfObj);
    }

    public static PeriodInfo getApRelatedPeriod(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmStsCtrlInf = ApClientUtils.getApStatusCtrolInfo(company);
        if (systmStsCtrlInf != null) {
            return systmStsCtrlInf.getRelatedPeriod();
        }
        return null;
    }

    public static boolean apIsStart() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
        if (company == null) {
            throw new IllegalArgumentException("Current company is null!");
        }
        return ApClientUtils.apIsStart(company);
    }

    public static PeriodInfo getApCurrentPeriod(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)cmpnyOrgUntInfObj);
    }

    public static PeriodInfo getApCurrentPeriod() {
        try {
            CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
            PeriodInfo period = ApClientUtils.getApCurrentPeriod(company);
            return period;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static PeriodInfo getApStartPeriod(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)cmpnyOrgUntInfObj);
    }

    public static PeriodInfo getApStartPeriod() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CommonClientUtils.getCurrentCompany();
        PeriodInfo startPeriod = ApClientUtils.getApStartPeriod(company);
        return startPeriod;
    }

    public static void apStart(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        if (cmpnyOrgUntInfObj == null) {
            throw new IllegalArgumentException();
        }
        CompanyOrgUnitInfo cmpnyOrgUntInf = cmpnyOrgUntInfObj;
        ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getRemoteInstance();
        systemStatusCtrol.start(SystemEnum.ACCOUNTSPAYABLE, cmpnyOrgUntInf, true);
    }

    public static void apReverseStart(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        if (cmpnyOrgUntInfObj == null) {
            throw new IllegalArgumentException();
        }
        CompanyOrgUnitInfo cmpnyOrgUntInf = cmpnyOrgUntInfObj;
        ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getRemoteInstance();
        systemStatusCtrol.start(SystemEnum.ACCOUNTSPAYABLE, cmpnyOrgUntInf, false);
    }

    public static boolean apIsRelatedAccount(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.isRelAccount(null, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)cmpnyOrgUntInfObj);
    }

    public static boolean apIsRelatedAccount() throws BOSException, EASBizException {
        CompanyOrgUnitInfo cmpnyOrgUntInfObj = CommonClientUtils.getCurrentCompany();
        return ApClientUtils.apIsRelatedAccount(cmpnyOrgUntInfObj);
    }

    public static boolean auditPaymentBill(String id) {
        try {
            IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getRemoteInstance();
            HashMap<String, String[]> userContext = new HashMap<String, String[]>();
            String[] ids = new String[]{id};
            userContext.put("ID_LIST", ids);
            return fnshApIntFcd.auditPaymentBill(userContext);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
    }

    public BigDecimal getApEndBalance(int balanceType, CompanyOrgUnitInfo company, AsstActTypeInfo astActTypInf, String astActValue, CurrencyInfo currency, PeriodInfo currentPeriod) {
        try {
            IApBalance apBalance = ApBalanceFactory.getRemoteInstance();
            StringBuffer oqlBuffer = new StringBuffer();
            oqlBuffer.append("select *,company.name Fendbalancefor from T_AP_ApBalance ");
            oqlBuffer.append(" where FcompanyID = \"" + company.getId() + '\"');
            oqlBuffer.append(" and FcurrencyID =  \"" + currency.getId() + '\"');
            oqlBuffer.append(" and FBalType =  " + balanceType);
            oqlBuffer.append(" and FAsstActTypeID = \"" + astActTypInf.getId() + '\"');
            oqlBuffer.append(" and FAsstActID = \"" + astActValue + '\"');
            oqlBuffer.append(" and FPeriodID = \"" + currentPeriod.getId() + '\"');
            CoreBaseCollection apBalColls = apBalance.getCollection(oqlBuffer.toString());
            if (apBalColls != null && apBalColls.size() == 0) {
                return new BigDecimal("0");
            }
            if (apBalColls != null && apBalColls.size() == 1) {
                ApBalanceInfo apBalanceInfo = (ApBalanceInfo)apBalColls.get(0);
                return apBalanceInfo.getEndBalanceFor();
            }
            if (apBalColls != null && apBalColls.size() > 1) {
                ApBalanceInfo apBalanceInfo = (ApBalanceInfo)apBalColls.get(0);
                return apBalanceInfo.getEndBalanceFor();
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static HashMap getCurrencyPrecision() {
        HashMap<BOSUuid, Integer> precisionMap = new HashMap<BOSUuid, Integer>();
        try {
            ICurrency currency = CurrencyFactory.getRemoteInstance();
            StringBuffer oqlBuffer = new StringBuffer();
            oqlBuffer.append("select fid,fprecision from t_bd_currency ");
            String oql = oqlBuffer.toString();
            CurrencyCollection currencyctn = currency.getCurrencyCollection(oql);
            if (currencyctn != null && currencyctn.size() > 0) {
                int size = currencyctn.size();
                for (int i = 0; i < size; ++i) {
                    CurrencyInfo currencyInfo = currencyctn.get(i);
                    if (currencyInfo == null) continue;
                    precisionMap.put(currencyInfo.getId(), new Integer(currencyInfo.getPrecision()));
                }
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return precisionMap;
    }

    public static VoucherInfo getVoucherInfo(String billId) throws EASBizException, BOSException {
        VoucherInfo voucher = null;
        IBOTRelation iBotRelation = BOTRelationFactory.getRemoteInstance();
        IVoucher iVoucher = VoucherFactory.getRemoteInstance();
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer sbMaskString = new StringBuffer();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billId));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)VOUCHERTYPE));
        filter.setMaskString(sbMaskString.toString());
        entityView.setFilter(filter);
        BOTRelationCollection relationCollection = iBotRelation.getCollection(entityView);
        if (relationCollection.size() > 0) {
            for (BOTRelationInfo relationInfo : relationCollection) {
                String voucherId = relationInfo.getDestObjectID();
                voucher = (VoucherInfo)iVoucher.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)voucherId)));
            }
        }
        return voucher;
    }

    public static boolean isPayBillCreateVoucher(String sCompanyId) {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        int checkType = 0;
        try {
            checkType = Integer.parseInt(ParamManager.getParamValue(null, (IObjectPK)pk, (String)"AP_PAYVOUCHER_BILLTYPE"));
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        return checkType != 0;
    }

    public static boolean isCASHPayBillCreateVoucher(String sCompanyId) {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        int checkType = 0;
        try {
            checkType = Integer.parseInt(ParamManager.getParamValue(null, (IObjectPK)pk, (String)"AP_PAYVOUCHER_BILLTYPE_CASH"));
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        return checkType != 0;
    }

    public static PeriodInfo getSCMStartPeriod(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmStsCtrlInf = ApClientUtils.getSCMStatusCtrolInfo(cmpnyOrgUntInfObj);
        if (systmStsCtrlInf != null) {
            return systmStsCtrlInf.getStartPeriod();
        }
        return null;
    }

    public static SystemStatusCtrolInfo getSCMStatusCtrolInfo(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmSttsCtrlInf = CommonClientUtils.getSysStatusCtrolInfo(cmpnyOrgUntInfObj, SystemEnum.INVENTORYMANAGEMENT);
        return systmSttsCtrlInf;
    }

    public static PeriodInfo getSCMCurrentPeriod(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmStsCtrlInf = ApClientUtils.getSCMStatusCtrolInfo(cmpnyOrgUntInfObj);
        if (systmStsCtrlInf != null) {
            return systmStsCtrlInf.getCurrentPeriod();
        }
        return null;
    }

    public static boolean scmIsStart(CompanyOrgUnitInfo cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmStsCtrlInf = ApClientUtils.getSCMStatusCtrolInfo(cmpnyOrgUntInfObj);
        if (systmStsCtrlInf != null) {
            return systmStsCtrlInf.isIsStart();
        }
        return false;
    }

    public static boolean isPrePayAcct(String sCompanyId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        String value = ParamManager.getParamValue(null, (IObjectPK)pk, (String)"AP_IS_PRE_PAY_ACCT");
        return "true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }
}

