/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.vc.IVcScheme;
import com.kingdee.eas.base.vc.VcSchemeCollection;
import com.kingdee.eas.base.vc.VcSchemeFactory;
import com.kingdee.eas.base.vc.VcSchemeInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.IAccountTable;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.auxacct.IAsstActTypeDefault;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.client.util.ComBoxInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class BaseDataUtil {
    public static final BigDecimal ZERO = new BigDecimal("0.0");
    public static final String ASST_ACT_TYPE_ID = "BiCxYAETEADgBRfkCmQUDEc4VZA=";

    public static CompanyOrgUnitInfo getCompanyInfo() throws EASBizException, BOSException {
        CompanyOrgUnitInfo defalutOrgInfo = null;
        ObjectUuidPK compk = BaseDataUtil.getCompanyPK();
        ICompanyOrgUnit comorg = null;
        comorg = CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("accountTable"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("baseCurrency"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseExchangeTable"));
        sic.add(new SelectorItemInfo("CU.*"));
        sic.add(new SelectorItemInfo("invalidDate"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        defalutOrgInfo = comorg.getCompanyOrgUnitInfo((IObjectPK)compk, sic);
        return defalutOrgInfo;
    }

    public static ObjectUuidPK getCompanyPK() throws BOSException {
        CompanyOrgUnitInfo comobj = SysContext.getSysContext().getCurrentFIUnit();
        ObjectUuidPK compk = null;
        if (comobj == null) {
            throw new BOSException(BaseDataUtil.getStrResource("nullCompany"));
        }
        if (comobj.isIsOnlyUnion()) {
            throw new BOSException(BaseDataUtil.getStrResource("lab_company_isempty"));
        }
        compk = new ObjectUuidPK(BOSUuid.read((String)comobj.get("id").toString()));
        return compk;
    }

    public static void makeBillCurrency(KDComboBox comboCurrency) throws EASBizException, BOSException {
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        CurrencyCollection currencyComList = iCurrency.getCurrencyCollection(true);
        if (currencyComList != null) {
            Object[] currList = new ComBoxInfo[currencyComList.size()];
            for (int i = 0; i < currencyComList.size(); ++i) {
                currList[i] = new ComBoxInfo((IObjectValue)currencyComList.get(i), "name");
            }
            comboCurrency.removeAllItems();
            comboCurrency.addItems(currList);
        }
    }

    public static void makeBillAsstActType(KDComboBox comboAsstActType) throws EASBizException, BOSException {
        String cuID = SysContext.getSysContext().getCurrentFIUnit().getCU().getId().toString();
        String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        IAsstActTypeDefault iAsstActType = AsstActTypeDefaultFactory.getRemoteInstance();
        AsstActTypeDefaultCollection asstActTypeColl = iAsstActType.getAsstActTypeDefaultCollection(" where isAccountCussent = 1 and cu.id = '" + cuID + "' and company.id = '" + companyId + "' ");
        Object defaultVal = null;
        int count = asstActTypeColl.size();
        Object[] cbi = new ComBoxInfo[count];
        for (int i = 0; i < count; ++i) {
            AsstActTypeDefaultInfo value = asstActTypeColl.get(i);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)value.getAsstActType().getString("id")));
            AsstActTypeInfo asstInfo = AsstActTypeFactory.getRemoteInstance().getAsstActTypeInfo((IObjectPK)pk);
            cbi[i] = new ComBoxInfo((IObjectValue)asstInfo, asstInfo.getName(), true);
            if (!value.isIsDefaultAccountPayable()) continue;
            defaultVal = cbi[i];
        }
        comboAsstActType.removeAllItems();
        comboAsstActType.addItems(cbi);
        if (defaultVal != null) {
            comboAsstActType.setSelectedItem(defaultVal);
        }
    }

    public static void makeBillAsstActType(KDComboBox comboAsstActType, String cpID, boolean isIncludeAll) throws BOSException, EASBizException {
        IAsstActTypeDefault iAsstActTypeDefault = AsstActTypeDefaultFactory.getRemoteInstance();
        AsstActTypeDefaultCollection asstActTypeColl = iAsstActTypeDefault.getAsstActTypeDefaultCollection(" where isAccountCussent = 1 and company.id = '" + cpID + "' ");
        Object defaultVal = null;
        int count = asstActTypeColl.size();
        Object[] cbi = null;
        cbi = isIncludeAll ? new ComBoxInfo[count + 1] : new ComBoxInfo[count];
        ArrayList<String> list = new ArrayList<String>(count);
        IAsstActType iAsstActType = AsstActTypeFactory.getRemoteInstance();
        for (int i = 0; i < count; ++i) {
            AsstActTypeDefaultInfo value = asstActTypeColl.get(i);
            String asstActTypeID = value.getAsstActType().getString("id");
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)value.getAsstActType().getString("id")));
            if (list.contains(asstActTypeID)) continue;
            list.add(asstActTypeID);
            AsstActTypeInfo asstInfo = iAsstActType.getAsstActTypeInfo((IObjectPK)pk);
            cbi[i] = new ComBoxInfo((IObjectValue)asstInfo, asstInfo.getName(), true);
            if (!value.isIsDefaultAccountPayable()) continue;
            defaultVal = cbi[i];
        }
        if (isIncludeAll) {
            AsstActTypeInfo asstActTypeInfo = new AsstActTypeInfo();
            asstActTypeInfo.setId(BOSUuid.read((String)ASST_ACT_TYPE_ID));
            asstActTypeInfo.setName(ComBoxInfo.ITEM_ALL);
            cbi[count] = new ComBoxInfo((IObjectValue)asstActTypeInfo, asstActTypeInfo.getName(), true);
        }
        comboAsstActType.removeAllItems();
        comboAsstActType.addItems(cbi);
        if (defaultVal != null) {
            comboAsstActType.setSelectedItem(defaultVal);
        }
    }

    public static void makeBillAsstActType(KDComboBox comboAsstActType, String cpID) throws BOSException, EASBizException {
        BaseDataUtil.makeBillAsstActType(comboAsstActType, cpID, false);
    }

    public static AsstActTypeInfo getDefaultAsstActType() throws EASBizException, BOSException {
        AsstActTypeInfo defaultValue = null;
        String cpID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        IAsstActTypeDefault iAsstActType = AsstActTypeDefaultFactory.getRemoteInstance();
        AsstActTypeDefaultCollection asstActTypeColl = iAsstActType.getAsstActTypeDefaultCollection(" where isAccountCussent = 1 and company.id = '" + cpID + "'");
        int count = asstActTypeColl.size();
        for (int i = 0; i < count; ++i) {
            AsstActTypeDefaultInfo value = asstActTypeColl.get(i);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)value.getAsstActType().getString("id")));
            AsstActTypeInfo asstInfo = AsstActTypeFactory.getRemoteInstance().getAsstActTypeInfo((IObjectPK)pk);
            if (!value.isIsDefaultAccountPayable()) continue;
            defaultValue = asstInfo;
        }
        return defaultValue;
    }

    public static AsstActTypeInfo getDefaultAsstActType(String cpID) throws EASBizException, BOSException {
        AsstActTypeInfo defaultValue = null;
        IAsstActTypeDefault iAsstActType = AsstActTypeDefaultFactory.getRemoteInstance();
        AsstActTypeDefaultCollection asstActTypeColl = iAsstActType.getAsstActTypeDefaultCollection(" where isAccountCussent = 1 and company.id = '" + cpID + "'");
        int count = asstActTypeColl.size();
        for (int i = 0; i < count; ++i) {
            AsstActTypeDefaultInfo asstActTypeDefaultInfo;
            AsstActTypeDefaultInfo value = asstActTypeDefaultInfo = asstActTypeColl.get(i);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)value.getAsstActType().getString("id")));
            AsstActTypeInfo asstInfo = AsstActTypeFactory.getRemoteInstance().getAsstActTypeInfo((IObjectPK)pk);
            if (!value.isIsDefaultAccountPayable()) continue;
            defaultValue = asstInfo;
        }
        return defaultValue;
    }

    public static String getCodeRuleClient(BillBaseInfo billInfo) throws CodingRuleException, EASBizException, BOSException {
        String sysNumber = null;
        String companyID = billInfo.getCompany().getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        if (iCodingRuleManager.isExist((IObjectValue)billInfo, companyID)) {
            sysNumber = iCodingRuleManager.isUseIntermitNumber((IObjectValue)billInfo, companyID) ? iCodingRuleManager.readNumber((IObjectValue)billInfo, companyID) : iCodingRuleManager.getNumber((IObjectValue)billInfo, companyID);
        }
        return sysNumber;
    }

    public static Date upTimestamp(Timestamp oldTime) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(oldTime);
        GregorianCalendar calendarUp = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5) + 1);
        Date dateUp = new Date(calendarUp.getTime().getTime());
        return dateUp;
    }

    public static Date downTimestamp(Timestamp oldTime) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(oldTime);
        GregorianCalendar calendarDown = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5));
        Date dateDown = new Date(calendarDown.getTime().getTime());
        return dateDown;
    }

    public static ExchangeRateInfo getExchangeRate(CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCur) throws EASBizException, BOSException {
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK destCurrpk = null;
        if (sourceCur == null) {
            MsgBox.showInfo((String)"SourceCurrency is null");
            return null;
        }
        if (companyOrgUnitInfo == null) {
            companyOrgUnitInfo = BaseDataUtil.getCompanyInfo();
        }
        if (companyOrgUnitInfo.getBaseExchangeTable() == null) {
            MsgBox.showInfo((String)BaseDataUtil.getStrResource("BaseExchangeTable_not_exist"));
            return null;
        }
        excTablepk = new ObjectUuidPK(companyOrgUnitInfo.getBaseExchangeTable().getId());
        CurrencyInfo baseCur = companyOrgUnitInfo.getBaseCurrency();
        if (baseCur != null) {
            if (baseCur.getId().equals((Object)sourceCur.getId())) {
                return null;
            }
        } else {
            MsgBox.showInfo((String)"BaseCurrency is null");
            return null;
        }
        destCurrpk = new ObjectUuidPK(baseCur.getId());
        iexchangRate = ExchangeRateFactory.getRemoteInstance();
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCur.getId());
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, Calendar.getInstance().getTime());
        return erInfo;
    }

    public static String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ap.APResources", (String)resKey);
    }

    public static VcSchemeInfo getVcSchemeInfoByName(String subSysName, String name) {
        VcSchemeInfo info = null;
        try {
            IVcScheme iVcScheme = VcSchemeFactory.getRemoteInstance();
            StringBuffer sb = new StringBuffer(" where ");
            String cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            sb.append("CU.id in ('");
            sb.append(cuId);
            sb.append("','");
            sb.append("00000000-0000-0000-0000-000000000000CCE7AED4");
            sb.append("','");
            sb.append("11111111-1111-1111-1111-111111111111CCE7AED4");
            sb.append("') and isUsing=1");
            if (subSysName != null) {
                sb.append(" and subSysName='");
                sb.append(subSysName);
                sb.append("'");
            }
            sb.append(" and name ='").append(name).append("'");
            VcSchemeCollection schemeColl = iVcScheme.getVcSchemeCollection(sb.toString());
            if (schemeColl.size() > 0) {
                info = schemeColl.get(0);
            } else {
                MsgBox.showInfo((String)BaseDataUtil.getStrResource("lab_novcscheme"));
                SysUtil.abort();
            }
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
        return info;
    }

    public static KDBizPromptBox getF7AccountPromptBox(IUIObject owner, PeriodInfo period, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        String currentAcctTableID = com.kingdee.eas.fi.ar.client.util.BaseDataUtil.getCurrentAccountTableID(2, period, companyInfo);
        AccountTableInfo accountTableInfo = BaseDataUtil.getAccountTable(currentAcctTableID);
        KDBizPromptBox f7AccountPromptBox = new KDBizPromptBox();
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        StringBuffer mask = new StringBuffer("#0 AND #1 AND #2 AND #3 ");
        fic.add(new FilterItemInfo("companyID.id", (Object)companyInfo.getId().toString()));
        fic.add(new FilterItemInfo("isGFreeze", (Object)false));
        fic.add(new FilterItemInfo("isCFreeze", (Object)false));
        fic.add(new FilterItemInfo("isLeaf", (Object)true));
        if (currentAcctTableID != null) {
            fic.add(new FilterItemInfo("accountTableID.id", (Object)currentAcctTableID));
            mask.append(" AND #4");
        }
        fi.setMaskString(mask.toString());
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(fi);
        f7AccountPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        f7AccountPromptBox.setSelector((KDPromptSelector)new AccountPromptBox(owner, accountTableInfo, fi));
        f7AccountPromptBox.setVisible(true);
        f7AccountPromptBox.setEditable(true);
        f7AccountPromptBox.setEnabled(true);
        f7AccountPromptBox.setEditFormat("$number$");
        f7AccountPromptBox.setDisplayFormat("$number$ $name$");
        f7AccountPromptBox.setCommitFormat("$number$");
        f7AccountPromptBox.setEntityViewInfo(viewInfo);
        return f7AccountPromptBox;
    }

    private static AccountTableInfo getAccountTable(String id) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IAccountTable iAccountTable = AccountTableFactory.getRemoteInstance();
        return iAccountTable.getAccountTableInfo((IObjectPK)pk);
    }

    public static AccountTableInfo getCurrentAccountTable() throws EASBizException, BOSException {
        String currentAcctTableID = com.kingdee.eas.fi.ar.client.util.BaseDataUtil.getCurrentAccountTableID(2);
        return BaseDataUtil.getAccountTable(currentAcctTableID);
    }

    public static AccountTableInfo getCurrentAccountTable(int system, PeriodInfo period, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        String currentAcctTableID = com.kingdee.eas.fi.ar.client.util.BaseDataUtil.getCurrentAccountTableID(2, period, companyInfo);
        return BaseDataUtil.getAccountTable(currentAcctTableID);
    }
}

