/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.config;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.fi.ar.client.ArApBillBaseHandler;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.config.RecPayBillCommonHandler;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.client.PaymentFilterUI;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonInfo;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PaymentBillVerifyHandler
extends RecPayBillCommonHandler {
    public String[] getAmountFields() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(super.getAmountFields()));
        list.add("thisVerificateAmt");
        return list.toArray(new String[list.size()]);
    }

    public String getBOSType() {
        return "40284E81";
    }

    public String[][] getDisplayFields() {
        return new String[][]{{"false", "selected", EASResource.getString((String)"com.kingdee.eas.fi.arap.AdvArApRecPayVerifyUIResource", (String)"selected")}, {"false", "company.name", null}, {"false", "payBillType.name", null}, {"false", "paymentType.name", null}, {"false", "number", null}, {"false", "bizDate", null}, {"false", "payeeType.name", null}, {"false", "payeeName", null}, {"false", "adminOrgUnit.name", null}, {"false", "person.name", null}, {"false", "currency.name", null}, {"true", "exchangeRate", null}, {"true", "entries.amount", null}, {"true", "entries.localAmt", null}, {"true", "entries.actualAmt", null}, {"true", "entries.actualLocAmt", null}, {"true", "entries.rebate", null}, {"true", "entries.rebateLocAmt", null}, {"true", "entries.amountVc", null}, {"true", "entries.localAmtVc", null}, {"true", "entries.unVcAmount", null}, {"true", "entries.unVcLocAmount", null}, {"true", "thisVerificateAmt", EASResource.getString((String)"com.kingdee.eas.fi.arap.AdvArApRecPayVerifyUIResource", (String)"thisVerificateAmt")}, {"true", "thisVerificateAmtLoc", EASResource.getString((String)"com.kingdee.eas.fi.arap.AdvArApRecPayVerifyUIResource", (String)"thisVerificateAmtLoc")}, {"false", "description", null}, {"false", "entries.coreBillNumber", null}, {"false", "entries.coreBillEntrySeq", null}, {"false", "entries.contractNum", null}, {"false", "entries.contractEntrySeq", null}, {"false", "voucherType.name", null}, {"false", "voucher.number", null}, {"false", "entries.remark", null}};
    }

    public String getEditUIClassName() {
        return "com.kingdee.eas.fi.cas.client.PaymentBillUI";
    }

    public String[] getHiddenFields() {
        return new String[]{"entries.unLockAmt", "entries.unLockLocAmt", "currency.precision", "baseCurrency.precision", "id", "entries.id", "currency.id", "baseCurrency.id", "company.baseExchangeTable.id", "lastUpdateTime", "payeeID", "paymentType.id", "payBillType.isPurPay", "payBillType.isProxyPay"};
    }

    public String[] getLocalAmountFields() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(super.getLocalAmountFields()));
        list.add("thisVerificateAmtLoc");
        return list.toArray(new String[list.size()]);
    }

    public String[] getModifyFields() {
        return new String[]{"selected", "thisVerificateAmt"};
    }

    public CustomerQueryPanel getQueryUI(String companyId, Map uiContext) throws Exception {
        PaymentFilterUI queryUI = new PaymentFilterUI(false, SourceTypeEnum.AP, companyId, true);
        queryUI.setSize(430, 320);
        return queryUI;
    }

    public String[] getSumFields() {
        return new String[]{"thisVerificateAmt", "thisVerificateAmtLoc"};
    }

    public String[] getUserDefineFields() {
        return new String[]{"selected", "thisVerificateAmt", "thisVerificateAmtLoc"};
    }

    public List getWriteOffList(KDTable table) {
        ArrayList<WriteOffCommonInfo> list = new ArrayList<WriteOffCommonInfo>();
        WriteOffCommonInfo info = null;
        int rowCount = table.getRowCount3();
        for (int i = 0; i < rowCount; ++i) {
            if (!Boolean.TRUE.equals(table.getCell(i, "selected").getValue())) continue;
            info = new WriteOffCommonInfo();
            info.setAmount((BigDecimal)table.getCell(i, "thisVerificateAmt").getValue());
            info.setLocalAmount((BigDecimal)table.getCell(i, "thisVerificateAmtLoc").getValue());
            info.setBillId((String)table.getCell(i, "id").getValue());
            info.setEntryId((String)table.getCell(i, "entries.id").getValue());
            info.setLastUpdateTime((Date)table.getCell(i, "lastUpdateTime").getValue());
            info.setBillNumber((String)table.getCell(i, "number").getValue());
            list.add(info);
        }
        return list;
    }

    public void handleTableEditStopped(KDTEditEvent e) throws Exception {
        ArApBillUIUtil.handleVerifyTableEditStopped(e, "entries.unLockAmt", "entries.unLockLocAmt");
    }

    public void handleTableRowData(IRow row, Object[] rowData, boolean isHeadView) {
        int i;
        row.getCell("selected").setValue((Object)Boolean.FALSE);
        if (row.getCell("billStatus").getValue() != null) {
            row.getCell("billStatus").setValue((Object)BillStatusEnum.getEnum((int)Integer.valueOf(row.getCell("billStatus").getValue().toString())));
        }
        int currencyPrecision = Integer.valueOf(row.getCell("currency.precision").getValue().toString());
        row.getCell("thisVerificateAmt").setEditor((ICellEditor)ArApBillBaseHandler.getNumberCellEditor(currencyPrecision));
        int baseCurrencyPrecision = Integer.valueOf(row.getCell("baseCurrency.precision").getValue().toString());
        row.getCell("thisVerificateAmtLoc").setEditor((ICellEditor)ArApBillBaseHandler.getNumberCellEditor(baseCurrencyPrecision));
        if (isHeadView) {
            row.getCell("entries.unLockAmt").setValue(rowData[rowData.length - 2]);
            row.getCell("entries.unLockLocAmt").setValue(rowData[rowData.length - 1]);
        }
        row.getCell("thisVerificateAmt").setValue(row.getCell("entries.unLockAmt").getValue());
        row.getCell("thisVerificateAmtLoc").setValue(row.getCell("entries.unLockLocAmt").getValue());
        String[] fields = this.getAmountFields();
        String formatString = CasForArApUtil.getFormatString((int)currencyPrecision);
        int len = fields.length;
        for (i = 0; i < len; ++i) {
            if (row.getCell(fields[i]) == null) continue;
            row.getCell(fields[i]).getStyleAttributes().setNumberFormat(formatString);
        }
        fields = this.getLocalAmountFields();
        formatString = CasForArApUtil.getFormatString((int)Integer.valueOf(row.getCell("baseCurrency.precision").getValue().toString()));
        len = fields.length;
        for (i = 0; i < len; ++i) {
            if (row.getCell(fields[i]) == null) continue;
            row.getCell(fields[i]).getStyleAttributes().setNumberFormat(formatString);
        }
    }
}

