/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.util.CtrlCommonConstant;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.ar.client.AbstractAPBalanceListUI;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class APBalanceListUI
extends AbstractAPBalanceListUI {
    private static final Logger logger = CoreUIObject.getLogger(APBalanceListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        CtrlSwingUtilities.appendActionToComponent((JComponent)((Object)this), (int)0, (KeyStroke)CtrlCommonConstant.KEYSTROKE_ESC, (String)"actionExitCurrent", (Action)this.actionExitCurrent);
        this.kdtBal.getActionMap().remove("Copy");
        this.kdtBal.getActionMap().remove("Paste");
        Object apObj = this.getUIContext().get("apMap");
        if (apObj instanceof HashMap) {
            HashMap apMap = (HashMap)apObj;
            Object apBal = apMap.get("Debit");
            Object arBal = apMap.get("Credit");
            Object balance = apMap.get("Balance");
            int precision = 2;
            if (apMap.get("precision") != null) {
                precision = Integer.parseInt(apMap.get("precision").toString());
            }
            this.kdtBal.checkParsed();
            this.kdtBal.addRow();
            this.kdtBal.getRow(0).getCell("arbal").setValue(arBal);
            this.kdtBal.getRow(0).getCell("apbal").setValue(apBal);
            this.kdtBal.getRow(0).getCell("totalAPBalance").setValue(balance);
            this.setNumberFormat(this.kdtBal, "arbal", precision);
            this.setNumberFormat(this.kdtBal, "apbal", precision);
            this.setNumberFormat(this.kdtBal, "totalAPBalance", precision);
            this.kdtBal.getStyleAttributes().setLocked(true);
        }
    }

    public void setNumberFormat(KDTable tblMain, String columnKey, int preCurrency) {
        if (preCurrency == 0) {
            preCurrency = 2;
        }
        String numberFormat = PrecisionFormatUtils.getFormatString(preCurrency);
        StyleAttributes styleAttributes = tblMain.getColumn(columnKey).getStyleAttributes();
        styleAttributes.setNumberFormat(numberFormat);
        styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }
}

