/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.AccountAgeQueryParam;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.ar.client.AbstractAccountAgeQueryUI;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.util.paramconvertor.AccountAgeRptParamConvertor;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class AccountAgeQueryUI
extends AbstractAccountAgeQueryUI {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.client.AccountAgeQueryUI");
    protected static final String CLNT_RES = "com.kingdee.eas.fi.ar.client.ArResource";
    private PeriodInfo startPeriod = null;
    private AccountAgeQueryParam filterParam = null;

    public AccountAgeQueryUI() throws Exception {
    }

    public AccountAgeQueryUI(boolean fHasLocAmt) throws Exception {
        if (!fHasLocAmt) {
            this.chkLocAmt.setVisible(false);
        }
    }

    @Override
    protected void initUICtrls() throws Exception {
        super.initUICtrls();
        this.initTables();
        this.startPeriod = this.getStartPeriod();
        this.pkEndDate.setValue((Object)this.startPeriod.getBeginDate());
        this.pkEndDate.setMinimumDate(this.startPeriod.getBeginDate());
        this.pkEndDate.setValue((Object)new java.util.Date());
        this.prmptAdminOrg.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.prmptSales.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        this.initAdminAndSale();
        this.btnAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnUndueAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnUndueDel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.comboAgeField.removeAllItems();
        this.comboDirection.removeAllItems();
        this.comboAgeField.addItems((Object[])this.getAgeFields());
        this.comboDirection.addItems((Object[])this.getDirections());
    }

    private void initAdminAndSale() throws EASBizException, BOSException {
        ArApBillUIUtil.setAdminAllCUNew((IUIObject)this, this.prmptAdminOrg, false, true, false);
        ArApBillUIUtil.setPersonAllCU((IUIObject)this, this.prmptSales);
    }

    protected PeriodInfo getStartPeriod() throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)this.currentCompany);
    }

    protected String[] getAgeFields() {
        String[] ageFlds = new String[]{EASResource.getString((String)CLNT_RES, (String)"DateFld_Receive"), EASResource.getString((String)CLNT_RES, (String)"DateFld_BillDate")};
        return ageFlds;
    }

    protected String[] getDirections() {
        String[] dirLbls = new String[]{EASResource.getString((String)CLNT_RES, (String)"Dir_Receivable")};
        return dirLbls;
    }

    public void setParam(Object obj) {
        this.filterParam = (AccountAgeQueryParam)((Object)obj);
        this.setParamToUI();
    }

    public void setCustomerParams(CustomerParams cp) {
        this.filterParam = new AccountAgeQueryParam();
        AccountAgeRptParamConvertor convertor = new AccountAgeRptParamConvertor();
        convertor.setRptParam((IReportQueryParam)this.filterParam);
        try {
            convertor.read(null, cp);
        }
        catch (Exception e) {
            logger.error((Object)"exception: parse the customerParams ", (Throwable)e);
        }
    }

    @Override
    public IReportQueryParam getRptParam() {
        AccountAgeQueryParam param = new AccountAgeQueryParam();
        Date endDate = new Date(DateTimeUtils.truncateDate((java.util.Date)this.pkEndDate.getSqlDate()).getTime());
        param.setCompanyId(this.currentCompany.getId().toString());
        param.setCuId(this.currentCompany.getCU().getId().toString());
        param.setEndDate(endDate);
        this.setCurrCussAcct2RptParam(param);
        if (this.prmptAdminOrg.getValue() != null) {
            DataBaseInfo adminInfo = (DataBaseInfo)this.prmptAdminOrg.getValue();
            param.setAdminOrgId(adminInfo.getString("id"));
            param.setAdminOrgName(adminInfo.getName());
            param.setAdminOrgNum(adminInfo.getNumber());
        }
        if (this.prmptSales.getValue() != null) {
            DataBaseInfo salesInfo = (DataBaseInfo)this.prmptSales.getValue();
            param.setSalesId(salesInfo.getString("id"));
            param.setSalesName(salesInfo.getName());
            param.setSalesNum(salesInfo.getNumber());
        }
        param.setDirIndex(this.comboDirection.getSelectedIndex());
        param.setAnalyseObjIndex(this.comboAnalyseObj.getSelectedIndex());
        param.setDateFldIndex(this.comboAgeField.getSelectedIndex());
        param.setHasUnaudited(this.chkUnAudited.isSelected());
        param.setHasLocAmt(this.chkLocAmt.isSelected());
        this.saveDateRanges(param);
        return param;
    }

    private void saveDateRanges(AccountAgeQueryParam param) {
        Integer days;
        Integer day;
        Integer day2;
        Date endDate = new Date(DateTimeUtils.truncateDate((java.util.Date)param.getEndDate()).getTime());
        ArrayList<Date> undueDateLst = new ArrayList<Date>();
        ArrayList<Integer> undueList = new ArrayList<Integer>();
        int n = this.tblUndue.getRowCount();
        for (int i = 0; i < n && (day2 = (Integer)this.tblUndue.getRow(i).getCell(0).getValue()) != null; ++i) {
            int dayDiff = day2;
            Date sqlDate = new Date(endDate.getTime() + (long)dayDiff * 86400000L);
            undueList.add(new Integer(dayDiff));
            undueDateLst.add(sqlDate);
        }
        ArrayList<Date> overdueDateLst = new ArrayList<Date>();
        ArrayList<Integer> overdueList = new ArrayList<Integer>();
        int n2 = this.tblOverdue.getRowCount();
        for (int i = 0; i < n2 && (day = (Integer)this.tblOverdue.getRow(i).getCell(0).getValue()) != null; ++i) {
            int dayDiff = day;
            Date sqlDate = new Date(endDate.getTime() - (long)dayDiff * 86400000L);
            overdueList.add(new Integer(dayDiff));
            overdueDateLst.add(sqlDate);
        }
        int lstSize = undueList.size();
        if (lstSize != 0) {
            Object lastObj = undueList.get(lstSize - 1);
            days = new Integer(Integer.parseInt(lastObj.toString()) + 1);
            undueList.add(days);
            lastObj = undueDateLst.get(lstSize - 1);
            undueDateLst.add((Date)lastObj);
        }
        if ((lstSize = overdueList.size()) != 0) {
            Object lastObj = overdueList.get(lstSize - 1);
            days = new Integer(Integer.parseInt(lastObj.toString()) + 1);
            overdueList.add(days);
            lastObj = overdueDateLst.get(lstSize - 1);
            overdueDateLst.add((Date)lastObj);
        }
        param.setOverdueDateList(overdueDateLst);
        param.setUndueDateList(undueDateLst);
        param.setOverdueList(overdueList);
        param.setUndueList(undueList);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.setParamToUI();
    }

    private void setParamToUI() {
        if (this.filterParam == null) {
            return;
        }
        this.clear();
        this.pkEndDate.setValue((Object)this.filterParam.getEndDate());
        this.loadCurrCussAcctData(this.filterParam);
        if (this.filterParam.getAdminOrgId() != null) {
            AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
            adminInfo.put("id", (Object)this.filterParam.getAdminOrgId());
            adminInfo.setName(this.filterParam.getAdminOrgName());
            adminInfo.setNumber(this.filterParam.getAdminOrgNum());
            this.prmptAdminOrg.setValue((Object)adminInfo);
        }
        if (this.filterParam.getSalesId() != null) {
            PersonInfo salesInfo = new PersonInfo();
            salesInfo.put("id", (Object)this.filterParam.getSalesId());
            salesInfo.setName(this.filterParam.getSalesName());
            salesInfo.setNumber(this.filterParam.getSalesNum());
            this.prmptSales.setValue((Object)salesInfo);
        }
        this.comboDirection.setSelectedIndex(this.filterParam.getDirIndex());
        this.comboAnalyseObj.setSelectedIndex(this.filterParam.getAnalyseObjIndex());
        this.comboAgeField.setSelectedIndex(this.filterParam.getDateFldIndex());
        this.chkUnAudited.setSelected(this.filterParam.isFHasUnaudited());
        this.chkLocAmt.setSelected(this.filterParam.hasLocAmt());
        this.setDateRangesToUI(this.filterParam.getUndueList(), this.tblUndue);
        this.setDateRangesToUI(this.filterParam.getOverdueList(), this.tblOverdue);
    }

    private void setDateRangesToUI(List dayLst, KDTable tbl) {
        if (dayLst != null && dayLst.size() > 0) {
            tbl.removeRows();
            int n = dayLst.size() - 1;
            for (int i = 0; i < n; ++i) {
                IRow row = tbl.addRow();
                row.getCell(0).setValue((Object)new Integer(dayLst.get(i).toString()));
            }
            this.setAllDateLbl(tbl);
        }
    }

    public boolean verify() {
        AsstActTypeInfo typeInfo = (AsstActTypeInfo)this.comboCussType.getSelectedItem();
        if (typeInfo == null || StringUtils.isEmpty((String)typeInfo.getRealtionDataObject()) || StringUtils.isEmpty((String)typeInfo.getDefaultQueryName())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)CLNT_RES, (String)"NoAsstActType"));
            return false;
        }
        return true;
    }

    private void initTables() {
        this.tblOverdue.checkParsed();
        this.tblUndue.checkParsed();
        this.tblOverdue.getIndexColumn().getStyleAttributes().setHided(true);
        this.tblUndue.getIndexColumn().getStyleAttributes().setHided(true);
        this.tblOverdue.setActiveCellStatus(1);
        this.tblUndue.setActiveCellStatus(1);
        KDFormattedTextField txtDay = new KDFormattedTextField(0);
        txtDay.setMinimumValue((Comparable)new Integer("1"));
        txtDay.setMaximumValue((Comparable)new Integer("9999"));
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)txtDay);
        this.tblOverdue.removeRows();
        this.tblOverdue.addRows(3);
        this.tblUndue.removeRows();
        this.tblUndue.addRows(3);
        this.tblOverdue.getColumn(0).setEditor((ICellEditor)cellEditor);
        this.tblUndue.getColumn(0).setEditor((ICellEditor)cellEditor);
        this.tblOverdue.getColumn(1).getStyleAttributes().setLocked(true);
        this.tblUndue.getColumn(1).getStyleAttributes().setLocked(true);
    }

    @Override
    protected void tblOverdue_editStopped(KDTEditEvent e) throws Exception {
        this.setViewContent(e);
    }

    @Override
    protected void tblUndue_editStopped(KDTEditEvent e) throws Exception {
        this.setViewContent(e);
    }

    private void setViewContent(KDTEditEvent e) {
        Object oldVal = e.getOldValue();
        Object val = e.getValue();
        if (oldVal == null && val == null) {
            return;
        }
        if (oldVal != null && val != null && oldVal.equals(val)) {
            return;
        }
        int rowIndex = e.getRowIndex();
        KDTable tbl = (KDTable)e.getSource();
        this.checkDayValid(tbl, rowIndex);
        this.setAllDateLbl(tbl);
    }

    private void checkDayValid(KDTable tbl, int rowIndex) {
        IRow row = tbl.getRow(rowIndex);
        Integer dayNum = (Integer)row.getCell(0).getValue();
        if (dayNum == null) {
            row.getCell(1).setValue(null);
        }
        int hasDateRows = this.getHasDateRowCount(tbl);
        for (int i = 0; i < hasDateRows; ++i) {
            int days = (Integer)tbl.getRow(i).getCell(0).getValue();
            if (i <= 0) continue;
            int preDays = (Integer)tbl.getRow(i - 1).getCell(0).getValue();
            if (days <= preDays) {
                days = preDays + 10;
                tbl.getRow(i).getCell(0).setValue((Object)new Integer(days));
                continue;
            }
            if (days >= preDays || i <= 1) continue;
            int prepDays = (Integer)tbl.getRow(i - 2).getCell(0).getValue();
            preDays = (prepDays + days) / 2;
            tbl.getRow(i - 1).getCell(0).setValue((Object)new Integer(preDays));
        }
    }

    private boolean isDateValid(KDTable tbl, int rowIndex) {
        IRow row = tbl.getRow(rowIndex);
        java.util.Date date = DateTimeUtils.truncateDate((java.util.Date)((java.util.Date)row.getCell(0).getValue()));
        if (date == null) {
            row.getCell(1).setValue(null);
            return false;
        }
        java.util.Date endDate = DateTimeUtils.truncateDate((java.util.Date)((java.util.Date)this.pkEndDate.getValue()));
        java.util.Date preDate = null;
        if (tbl.getName().equals("tblOverdue")) {
            if (!date.before(endDate)) {
                date.setTime(endDate.getTime() - 172800000L);
                row.getCell(0).setValue((Object)date);
                return false;
            }
            if (rowIndex > 0 && (preDate = (java.util.Date)tbl.getRow(rowIndex - 1).getCell(0).getValue()) != null && !date.before(preDate)) {
                date.setTime(preDate.getTime() - 172800000L);
                row.getCell(0).setValue((Object)date);
                return false;
            }
        } else {
            if (!date.after(endDate)) {
                date.setTime(endDate.getTime() + 172800000L);
                row.getCell(0).setValue((Object)date);
                return false;
            }
            if (rowIndex > 0 && (preDate = (java.util.Date)tbl.getRow(rowIndex - 1).getCell(0).getValue()) != null && !date.after(preDate)) {
                date.setTime(preDate.getTime() + 172800000L);
                row.getCell(0).setValue((Object)date);
                return false;
            }
        }
        return true;
    }

    private void setAllDateLbl(KDTable tbl) {
        String resLbl = null;
        resLbl = tbl.getName().equals("tblOverdue") ? "Lbl_FOL" : "Lbl_FUL";
        int dayDiff = 0;
        IRow row = null;
        int hasDateRows = this.getHasDateRowCount(tbl);
        for (int i = 0; i < hasDateRows; ++i) {
            row = tbl.getRow(i);
            dayDiff = (Integer)row.getCell(0).getValue();
            Object[] args = null;
            if (i == 0) {
                args = new String[]{String.valueOf(1), String.valueOf(dayDiff)};
            } else {
                int preDiff = (Integer)tbl.getRow(i - 1).getCell(0).getValue() + 1;
                args = new String[]{String.valueOf(preDiff), String.valueOf(dayDiff)};
            }
            String colTitle = EASResource.getString((String)CLNT_RES, (String)resLbl);
            row.getCell(1).setValue((Object)MessageFormat.format(colTitle, args));
        }
    }

    private int getHasDateRowCount(KDTable tbl) {
        IRow row;
        int hasDateRows = 0;
        int n = tbl.getRowCount();
        for (int i = 0; i < n && (row = tbl.getRow(i)).getCell(0).getValue() != null; ++i) {
            ++hasDateRows;
        }
        return hasDateRows;
    }

    @Override
    protected void comboAgeField_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1) {
            return;
        }
        if (this.comboAgeField.getSelectedIndex() == 1) {
            this.tblUndue.removeRows();
            this.tblUndue.addRows(3);
            this.tblUndue.setEnabled(false);
        } else if (!this.tblUndue.isEnabled()) {
            this.tblUndue.setEnabled(true);
        }
    }

    @Override
    protected void btnAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.addRow(this.tblOverdue);
    }

    @Override
    protected void btnDelRow_actionPerformed(ActionEvent e) throws Exception {
        this.delRow(this.tblOverdue);
    }

    @Override
    protected void btnUndueAddAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.addRow(this.tblUndue);
    }

    @Override
    protected void btnUndueDel_actionPerformed(ActionEvent e) throws Exception {
        this.delRow(this.tblUndue);
    }

    private void addRow(KDTable tbl) throws Exception {
        tbl.addRow();
    }

    private void delRow(KDTable tbl) throws Exception {
        if (tbl.getRowCount() == 0) {
            return;
        }
        if (tbl.getSelectManager().size() > 0) {
            KDTSelectBlock block = tbl.getSelectManager().get();
            if (block != null) {
                tbl.removeRow(block.getTop());
            }
        } else if (tbl.getRowCount() > 0) {
            tbl.removeRow(tbl.getRowCount() - 1);
        }
    }

    @Override
    protected void pkEndDate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.pkEndDate.getSqlDate().before(this.startPeriod.getBeginDate())) {
            this.pkEndDate.setValue((Object)this.startPeriod.getBeginDate());
        }
    }

    @Override
    public void clear() {
        super.clear();
        java.util.Date curDay = new java.util.Date(System.currentTimeMillis());
        curDay = DateTimeUtils.truncateDate((java.util.Date)curDay);
        this.pkEndDate.setValue((Object)curDay);
        this.comboAnalyseObj.setSelectedIndex(0);
        this.comboAgeField.setSelectedIndex(0);
        this.comboDirection.setSelectedIndex(0);
        this.prmptAdminOrg.setValue(null);
        this.prmptSales.setValue(null);
        this.chkLocAmt.setSelected(false);
        this.tblUndue.removeRows();
        this.tblUndue.addRows(3);
        this.tblOverdue.removeRows();
        this.tblOverdue.addRows(3);
    }
}

