/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.client.AbstractAccountBadDebtAsstActAnalysisQueryUI;
import com.kingdee.eas.fi.arap.BaseServiceFacadeFactory;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountBadDebtAsstActAnalysisQueryUI
extends AbstractAccountBadDebtAsstActAnalysisQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountBadDebtAsstActAnalysisQueryUI.class);
    private boolean isPrepareCurrency = false;

    public void onLoad() throws Exception {
        super.onLoad();
        String permItem = "fi_arap_BadAccountPrepare_view";
        OrgUnitInfo[] args = BaseServiceFacadeFactory.getRemoteInstance().getAuthorizedBizOrgUnits(1, permItem);
        List<OrgUnitInfo> orgList = Arrays.asList(args);
        HashSet<String> orgIdSet = new HashSet<String>();
        for (OrgUnitInfo orgInfo : orgList) {
            if (null == orgInfo.getId()) continue;
            orgIdSet.add(orgInfo.getId().toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", orgIdSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        this.prmtCompany.setEntityViewInfo(viewInfo);
        Object companyObj = this.prmtCompany.getData();
        CompanyOrgUnitInfo defaultCompanyInfo = null;
        if (null == companyObj || companyObj instanceof Object[] && null == ((Object[])companyObj)[0]) {
            defaultCompanyInfo = SysContext.getSysContext().getCurrentFIUnit();
            if (!defaultCompanyInfo.isIsBizUnit()) {
                defaultCompanyInfo = (CompanyOrgUnitInfo)args[0];
            } else if (!orgIdSet.contains(defaultCompanyInfo.getId().toString())) {
                defaultCompanyInfo = (CompanyOrgUnitInfo)args[0];
            }
            this.prmtCompany.setData((Object)defaultCompanyInfo);
        } else if (companyObj instanceof IObjectValue) {
            defaultCompanyInfo = (CompanyOrgUnitInfo)companyObj;
        } else if (companyObj instanceof Object[]) {
            defaultCompanyInfo = (CompanyOrgUnitInfo)((Object[])companyObj)[0];
        }
        String needMultiCompany = BaseServiceFacadeFactory.getRemoteInstance().getCommonParamValue("BAD_ACCOUNT_IS_SHOW_MULTI_COMPANY");
        if ("true".equalsIgnoreCase(needMultiCompany)) {
            this.prmtCompany.setEnabled(true);
        } else {
            this.prmtCompany.setEnabled(false);
        }
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
    }

    protected Set resolveCompany(Object companyObj, String type) {
        HashSet<Object> companySet = new HashSet<Object>();
        if (null != companyObj) {
            if (companyObj instanceof IObjectValue) {
                if ("id".equals(type)) {
                    companySet.add(((IObjectValue)companyObj).getString("id"));
                } else {
                    companySet.add(companyObj);
                }
            } else if (companyObj instanceof Object[] && null != ((Object[])companyObj)[0]) {
                Object[] companyObjArr;
                for (Object companyInfo : companyObjArr = (Object[])companyObj) {
                    if ("id".equals(type)) {
                        companySet.add(((IObjectValue)companyInfo).getString("id"));
                        continue;
                    }
                    companySet.add(companyInfo);
                }
            }
        }
        return companySet;
    }

    public FilterInfo getFilterInfo() {
        StringBuffer sbFormula = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        int i = 0;
        Object obj = null;
        obj = this.prmtCompany.getData();
        if (obj != null) {
            Set companyIdSet = this.resolveCompany(obj, "id");
            FilterItemInfo companyFilter = new FilterItemInfo("company.id", (Object)companyIdSet, CompareType.INCLUDE);
            items.add(companyFilter);
            if (i == 0) {
                sbFormula.append("#" + i++);
            } else {
                sbFormula.append(" and #" + i++);
            }
        }
        if (sbFormula.toString().length() != 0) {
            filter.setMaskString(sbFormula.toString());
        }
        return filter;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        if (null == entityViewInfo || null == entityViewInfo.getFilter()) {
            return;
        }
        FilterItemCollection filters = entityViewInfo.getFilter().getFilterItems();
        Object obj = ArApBillUIUtil.getCompareValue(filters, "company.id", CompareType.INCLUDE);
        if (obj != null) {
            Set companyIdSet = (Set)obj;
            try {
                IObjectValue[] companyArr = this.getCompanyArr(companyIdSet);
                this.prmtCompany.setData((Object)companyArr);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    private Set<String> transSqlSet(Set companyIdSet) {
        HashSet<String> sqlSet = new HashSet<String>();
        if (companyIdSet.isEmpty()) {
            return sqlSet;
        }
        for (Object company : companyIdSet) {
            if (company instanceof String) {
                sqlSet.add(new StringBuffer("'").append(company.toString()).append("'").toString());
                continue;
            }
            if (!(company instanceof IObjectValue)) continue;
            sqlSet.add(new StringBuffer("'").append(((IObjectValue)company).get("id")).append("'").toString());
        }
        return sqlSet;
    }

    private IObjectValue[] getCompanyArr(Set companyIdSet) throws BOSException {
        if (companyIdSet.isEmpty()) {
            return null;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyIdSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        ev.setSelector(sic);
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitCollection companyColl = iCompany.getCompanyOrgUnitCollection(ev);
        if (null == companyColl || 0 == companyColl.size()) {
            return null;
        }
        Iterator compIte = companyColl.iterator();
        IObjectValue[] companyArr = new IObjectValue[companyColl.size()];
        int index = 0;
        while (compIte.hasNext()) {
            companyArr[index] = (IObjectValue)compIte.next();
            ++index;
        }
        return companyArr;
    }

    protected Map<String, Object> getFilterMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Object obj = null;
        obj = this.prmtCompany.getData();
        if (obj != null) {
            Set companyIdSet = this.resolveCompany(obj, "id");
            paramMap.put("companyIds", companyIdSet);
        }
        return paramMap;
    }
}

